/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.sa.FundUseMatchSolutionCollection;
import com.kingdee.eas.fm.sa.FundUseMatchSolutionFactory;
import com.kingdee.eas.fm.sa.FundUseMatchSolutionInfo;
import com.kingdee.eas.fm.sa.IFundUseMatchSolution;
import com.kingdee.eas.fm.sa.SAException;
import com.kingdee.eas.fm.sa.StatusEnum;
import com.kingdee.eas.fm.sa.app.AbstractFundUseMatchSolutionWebFacadeControllerBean;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FundUseMatchSolutionWebFacadeControllerBean
extends AbstractFundUseMatchSolutionWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.sa.app.FundUseMatchSolutionWebFacadeControllerBean");
    private static String resource = "com.kingdee.eas.fm.sa.SAResource";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _enable(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyInfo.getId()), (String)"fundUseMatchSolution_enable_05");
        if (!isPermission) {
            throw new SAException(SAException.NOT_ENABLE_PERMISSION, new Object[]{companyInfo.getName()});
        }
        FundUseMatchSolutionCollection colls = this.getFundUseMatchSolutionCollection(ctx, FMHelper.Array2Set((String[])ids));
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        IFundUseMatchSolution iLargeAccessSourceSet = FundUseMatchSolutionFactory.getLocalInstance(ctx);
        for (int i = 0; i < colls.size(); ++i) {
            FundUseMatchSolutionInfo info = colls.get(i);
            boolean b = iMutex.requestObjIDForUpdate(info.getId().toString());
            try {
                if (info.getState() == StatusEnum.enable) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)resource, (String)"Solution_already_enable"));
                }
                if (!b) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)resource, (String)"Solution__lock"));
                }
                info.setState(StatusEnum.enable);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("state");
                iLargeAccessSourceSet.updatePartial(info, selector);
                IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_fundUseMatchSolution_enable");
                LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
                ++success;
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)resource, (String)"Solution__enable_fail", (String[])new String[]{info.getNumber()}) + e.getMessage());
                continue;
            }
            finally {
                if (b) {
                    iMutex.releaseObjIDForUpdate(info.getId().toString());
                }
            }
        }
        summary = success == colls.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)resource, (String)"ALL_ENABLE_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)resource, (String)"ENABLE_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(colls.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _disable(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{ids.length + ""});
        int success = 0;
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyInfo.getId()), (String)"fundUseMatchSolution_disable_06");
        if (!isPermission) {
            throw new SAException(SAException.NOT_DISABLE_PERMISSION, new Object[]{companyInfo.getName()});
        }
        FundUseMatchSolutionCollection colls = this.getFundUseMatchSolutionCollection(ctx, FMHelper.Array2Set((String[])ids));
        IFundUseMatchSolution iLargeAccessSourceSet = FundUseMatchSolutionFactory.getLocalInstance(ctx);
        for (int i = 0; i < colls.size(); ++i) {
            FundUseMatchSolutionInfo info = colls.get(i);
            try {
                if (info.getState() == StatusEnum.disable) {
                    throw new RuntimeException(CASWebUtil.getResource((Context)ctx, (String)resource, (String)"Solution_already_disable"));
                }
                info.setState(StatusEnum.disable);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("state");
                iLargeAccessSourceSet.updatePartial(info, selector);
                IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_fundUseMatchSolution_disable");
                LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
                ++success;
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)resource, (String)"Solution__disable_fail", (String[])new String[]{info.getNumber()}) + e.getMessage());
            }
        }
        summary = success == colls.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)resource, (String)"ALL_DISABLE_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)resource, (String)"DISABLE_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(colls.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    private FundUseMatchSolutionCollection getFundUseMatchSolutionCollection(Context ctx, Set idSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        view.setSelector(sic);
        return FundUseMatchSolutionFactory.getLocalInstance(ctx).getFundUseMatchSolutionCollection(view);
    }
}

