/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.model.BatchExecuteResult;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.sa.FundUseCollection;
import com.kingdee.eas.fm.sa.FundUseFactory;
import com.kingdee.eas.fm.sa.FundUseInfo;
import com.kingdee.eas.fm.sa.IFundUse;
import com.kingdee.eas.fm.sa.ReportContentEnum;
import com.kingdee.eas.fm.sa.app.AbstractFundUseWebFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.util.ExceptionMessageUtility;
import com.kingdee.eas.util.ResourceBase;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FundUseWebFacadeControllerBean
extends AbstractFundUseWebFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.sa.app.FundUseWebFacadeControllerBean");

    @Override
    protected Map _save(Context ctx, FundUseInfo info) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        IFundUse iFundUse = FundUseFactory.getLocalInstance(ctx);
        try {
            if (info.getId() == null || !iFundUse.exists((IObjectPK)new ObjectUuidPK(info.getId().toString()))) {
                iPermission.checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyInfo.getId().toString()), "fundUse_addnew02");
            } else {
                iPermission.checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyInfo.getId().toString()), "fundUse_update03");
            }
            info.setReportType(ReportContentEnum.USE_OF_LARGE_FUNDS);
            IObjectPK pk = iFundUse.save((CoreBaseInfo)info);
            result.put("error", 1);
            result.put("id", pk.toString());
        }
        catch (EASBizException e) {
            e.printStackTrace();
            result.put("error", 0);
            result.put("msg", e.getMessage());
        }
        catch (BOSException e) {
            e.printStackTrace();
            result.put("error", 0);
            result.put("msg", e.getMessage());
        }
        return result;
    }

    @Override
    protected Map _batchDelete(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult results = new BatchExecuteResult();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setSelector(sic);
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set((String[])ids), CompareType.INCLUDE));
        FundUseCollection coll = FundUseFactory.getLocalInstance(ctx).getFundUseCollection(view);
        int success = 0;
        String summary = ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"54_FundUseWebFacadeControllerBean", (Locale)ctx.getLocale()) + ids.length + ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"55_FundUseWebFacadeControllerBean", (Locale)ctx.getLocale());
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyInfo.getId().toString()), "fundUse_delete03");
        for (int i = 0; i < coll.size(); ++i) {
            FundUseInfo info = coll.get(i);
            try {
                FundUseFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(info.getId().toString()));
                ++success;
                continue;
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                results.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"56_FundUseWebFacadeControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"57_FundUseWebFacadeControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
                continue;
            }
            catch (ObjectReferedException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                results.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"56_FundUseWebFacadeControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"57_FundUseWebFacadeControllerBean", (Locale)ctx.getLocale()) + ExceptionMessageUtility.getMessage((Throwable)e));
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                results.getDetailMsgList().add(ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"56_FundUseWebFacadeControllerBean", (Locale)ctx.getLocale()) + info.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"57_FundUseWebFacadeControllerBean", (Locale)ctx.getLocale()) + e.getMessage());
            }
        }
        if (success == ids.length) {
            results.setError(1);
            summary = summary + ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"58_FundUseWebFacadeControllerBean", (Locale)ctx.getLocale());
        } else {
            results.setError(0);
            summary = summary + ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"59_FundUseWebFacadeControllerBean", (Locale)ctx.getLocale()) + success + ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"60_FundUseWebFacadeControllerBean", (Locale)ctx.getLocale()) + (ids.length - success) + ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"61_FundUseWebFacadeControllerBean", (Locale)ctx.getLocale());
        }
        results.setSummaryMsg(summary);
        return results;
    }

    @Override
    protected Map _batchEnable(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult results = new BatchExecuteResult();
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyInfo.getId().toString()), "fundUse_enable04");
        String summary = ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"54_FundUseWebFacadeControllerBean", (Locale)ctx.getLocale()) + ids.length + ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"55_FundUseWebFacadeControllerBean", (Locale)ctx.getLocale());
        FundUseFactory.getLocalInstance(ctx).enable(FMHelper.Array2Set((String[])ids));
        results.setError(1);
        summary = summary + ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"62_FundUseWebFacadeControllerBean", (Locale)ctx.getLocale());
        results.setSummaryMsg(summary);
        return results;
    }

    @Override
    protected Map _batchDisable(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult results = new BatchExecuteResult();
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyInfo.getId().toString()), "fundUse_disable05");
        String summary = ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"54_FundUseWebFacadeControllerBean", (Locale)ctx.getLocale()) + ids.length + ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"55_FundUseWebFacadeControllerBean", (Locale)ctx.getLocale());
        FundUseFactory.getLocalInstance(ctx).disable(FMHelper.Array2Set((String[])ids));
        results.setError(1);
        summary = summary + ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"63_FundUseWebFacadeControllerBean", (Locale)ctx.getLocale());
        results.setSummaryMsg(summary);
        return results;
    }
}

