/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.sa.AutoGenLargeAndDebtDetaillFacadeFactory;
import com.kingdee.eas.fm.sa.BillStatusEnum;
import com.kingdee.eas.fm.sa.LargeDetailBillCollection;
import com.kingdee.eas.fm.sa.LargeDetailBillFactory;
import com.kingdee.eas.fm.sa.LargeDetailBillInfo;
import com.kingdee.eas.fm.sa.SAException;
import com.kingdee.eas.fm.sa.app.AbstractLargeDetailWebFacadeControllerBean;
import com.kingdee.eas.fm.sa.app.util.SAConstants;
import com.kingdee.eas.fm.sa.app.util.ThreadLocalDateUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LargeDetailWebFacadeControllerBean
extends AbstractLargeDetailWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.sa.app.LargeDetailWebFacadeControllerBean");
    private static String resource = "com.kingdee.eas.fm.sa.SAResource";

    @Override
    protected Map _submit(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        LargeDetailBillCollection coll = this.getLargeDetailColls(ctx, ids);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        int success = 0;
        HashSet<String> permissionSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            LargeDetailBillInfo info = coll.get(i);
            try {
                this.checkPermission(ctx, info.getReportOrg(), "largeDetailBill_submit_05", "LargeDetail_NO_SubmitPermission", permissionSet);
                if (info.getBillStatus() != BillStatusEnum.SAVE && info.getBillStatus() != BillStatusEnum.SUBMIT) {
                    throw new SAException(SAException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"Status_Not_Submit")});
                }
                LargeDetailBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
                ++success;
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)resource, (String)"LARGEDETAIL_SUBMIT_FAIL", (String[])new String[]{info.getReportOrg().getName(), info.getNumber()}) + e.getMessage());
            }
        }
        summary = success == coll.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)"ALL_SUBMIT_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)"SUBMIT_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(coll.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _confirm(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        LargeDetailBillCollection coll = this.getLargeDetailColls(ctx, ids);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        int success = 0;
        HashSet<String> permissionSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            LargeDetailBillInfo info = coll.get(i);
            try {
                this.checkPermission(ctx, info.getReportOrg(), "largeDetailBill_confirm_06", "LargeDetail_NO_ConfirmPermission", permissionSet);
                if (info.getBillStatus() != BillStatusEnum.SUBMIT) {
                    throw new SAException(SAException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"Status_Not_Confirm")});
                }
                LargeDetailBillFactory.getLocalInstance(ctx).confirm(info.getId().toString());
                ++success;
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)resource, (String)"LARGEDETAIL_CONFIRM_FAIL", (String[])new String[]{info.getReportOrg().getName(), info.getNumber()}) + e.getMessage());
            }
        }
        summary = success == coll.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)resource, (String)"ALL_CONFIRM_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)resource, (String)"CONFIRM_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(coll.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _unConfirm(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        LargeDetailBillCollection coll = this.getLargeDetailColls(ctx, ids);
        String summary = CASWebUtil.getResource((Context)ctx, (String)"BILLSUM", (String[])new String[]{coll.size() + ""});
        int success = 0;
        HashSet<String> permissionSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            LargeDetailBillInfo info = coll.get(i);
            try {
                this.checkPermission(ctx, info.getReportOrg(), "largeDetailBill_unConfirm_07", "LargeDetail_NO_UnConfirmPermission", permissionSet);
                if (info.getBillStatus() != BillStatusEnum.CONFIRMED) {
                    throw new SAException(SAException.COMMON, new String[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"Status_Not_UnConfirm")});
                }
                LargeDetailBillFactory.getLocalInstance(ctx).unConfirm(info.getId().toString());
                ++success;
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource((Context)ctx, (String)resource, (String)"LARGEDETAIL_UNCONFIRM_FAIL", (String[])new String[]{info.getReportOrg().getName(), info.getNumber()}) + e.getMessage());
            }
        }
        summary = success == coll.size() ? summary + CASWebUtil.getResource((Context)ctx, (String)resource, (String)"ALL_UNCONFIRM_SUCCESS") : summary + CASWebUtil.getResource((Context)ctx, (String)resource, (String)"UNCONFIRM_RESULT", (String[])new String[]{String.valueOf(success), String.valueOf(coll.size() - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _extract(Context ctx, String companyId, Date payDate) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("reportOrg.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("payDate", (Object)payDate));
        filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)4));
        if (LargeDetailBillFactory.getLocalInstance(ctx).exists(filter)) {
            throw new SAException(SAException.EXISTS_REPORTED_DATA, new Object[]{company.getName(), ThreadLocalDateUtil.formatDate(payDate)});
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean b = false;
        try {
            b = iMutex.requestObjIDForUpdate(SAConstants.getSALargeMutexId(companyId, payDate));
            if (!b) {
                throw new SAException(SAException.EXISTS_REPORTING_DATA, new Object[]{company.getName(), ThreadLocalDateUtil.formatDate(payDate)});
            }
            AutoGenLargeAndDebtDetaillFacadeFactory.getLocalInstance(ctx).genLargeDetail(companyId, payDate);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new SAException(SAException.COMMON, new Object[]{e.getMessage()});
        }
        finally {
            if (b) {
                iMutex.releaseObjIDForUpdate(SAConstants.getSALargeMutexId(companyId, payDate));
            }
        }
        result.put((Object)"success", (Object)ResourceBase.getString((String)"com.kingdee.eas.fm.sa.SAAutoGenerateResource", (String)"89_LargeDetailWebFacadeControllerBean", (Locale)ctx.getLocale()));
        return result;
    }

    protected LargeDetailBillCollection getLargeDetailColls(Context ctx, String[] ids) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("reportOrg.id"));
        sic.add(new SelectorItemInfo("reportOrg.name"));
        sic.add(new SelectorItemInfo("reportOrg.number"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set((String[])ids), CompareType.INCLUDE));
        view.setFilter(filter);
        return LargeDetailBillFactory.getLocalInstance(ctx).getLargeDetailBillCollection(view);
    }

    protected void checkPermission(Context ctx, CompanyOrgUnitInfo company, String checkPermissionName, String exceptionResource, Set<String> permissionSet) throws EASBizException, BOSException {
        if (!permissionSet.contains(company.getId().toString())) {
            this.checkPermission(ctx, company, checkPermissionName, exceptionResource);
            permissionSet.add(company.getId().toString());
        }
    }

    protected void checkPermission(Context ctx, CompanyOrgUnitInfo company, String checkPermissionName, String exceptionResource) throws EASBizException, BOSException {
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(company.getId()), (String)checkPermissionName);
        if (!isPermission) {
            throw new SAException(SAException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)exceptionResource, (String[])new String[]{company.getName()})});
        }
    }
}

