/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.sa.BillState;
import com.kingdee.eas.fm.sa.ILargeDetailMergeBill;
import com.kingdee.eas.fm.sa.LargeDetailMergeBillCollection;
import com.kingdee.eas.fm.sa.LargeDetailMergeBillFactory;
import com.kingdee.eas.fm.sa.LargeDetailMergeBillInfo;
import com.kingdee.eas.fm.sa.LargeTotalBillFactory;
import com.kingdee.eas.fm.sa.LargeTotalBillInfo;
import com.kingdee.eas.fm.sa.ReportContentEnum;
import com.kingdee.eas.fm.sa.ReportOrgSolutionSettingInfo;
import com.kingdee.eas.fm.sa.SAException;
import com.kingdee.eas.fm.sa.app.AbstractLargeTotalBillControllerBean;
import com.kingdee.eas.fm.sa.app.service.ILargeTotalCancelReportService;
import com.kingdee.eas.fm.sa.app.service.ILargeTotalReportService;
import com.kingdee.eas.fm.sa.app.service.LargeTotalCancelReportServiceFactory;
import com.kingdee.eas.fm.sa.app.service.LargeTotalReportServiceFactory;
import com.kingdee.eas.fm.sa.app.util.SAConstants;
import com.kingdee.eas.fm.sa.app.util.ThreadLocalDateUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class LargeTotalBillControllerBean
extends AbstractLargeTotalBillControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)LargeTotalBillControllerBean.class.getName());

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LargeTotalBillInfo info = (LargeTotalBillInfo)model;
        if (EmptyUtil.isEmpty((String)info.getNumber()) && FMHelper.hasNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString())) {
            try {
                info.setNumber(FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString()));
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                info.setNumber(this.getDefaultNumber(info));
            }
        } else {
            info.setNumber(this.getDefaultNumber(info));
        }
        return super._addnew(ctx, (IObjectValue)info);
    }

    private String getDefaultNumber(LargeTotalBillInfo info) {
        String number = "DEBS-";
        Date payDate = info.getBizDate();
        number = number + ThreadLocalDateUtil.formatDate(payDate);
        number = number + "-" + beServiceHelper.getSerialNumber((int)1)[0].substring(10, 17);
        return number;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LargeTotalBillInfo info = (LargeTotalBillInfo)model;
        if (!info.getBillstatus().equals((Object)BillState.SAVED) && !info.getBillstatus().equals((Object)BillState.SUBMIT)) {
            throw new SAException(SAException.LARGETOTAL_NOTALLOW_SUBMIT);
        }
        boolean isNeedDispose = false;
        HashSet<String> ids = new HashSet<String>();
        HashSet<String> serialIds = new HashSet<String>();
        if (!info.getBillstatus().equals((Object)BillState.SUBMIT)) {
            BigDecimal LargeTotalAmt = info.getLargeTotalAmt();
            int largeMergeTotalCount = new Integer(0);
            BigDecimal largeMergeTotalAmt = Constants.ZERO;
            BigDecimal amount = Constants.ZERO;
            try {
                StringBuffer sb = new StringBuffer();
                sb.append("select Fid, FLargeTotalAmt, FLargeTotalCount, FSerialId, FAmount from T_SA_LargeDetailMergeBill where FillInCompanyID = ? and FBIZDATE = ?");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{info.getCompany().getId().toString(), info.getBizDate()});
                while (rs.next()) {
                    if (!EmptyUtil.isEmpty((String)rs.getString("FID"))) {
                        ids.add(rs.getString("FID"));
                    }
                    if (!EmptyUtil.isEmpty((String)rs.getString("FSerialId"))) {
                        serialIds.add(rs.getString("FSerialId"));
                    }
                    if (!EmptyUtil.isEmpty((Object)rs.getBigDecimal("FLARGETOTALAMT"))) {
                        largeMergeTotalAmt = largeMergeTotalAmt.add(rs.getBigDecimal("FLARGETOTALAMT"));
                    }
                    if (!EmptyUtil.isEmpty((Object)rs.getBigDecimal("FAmount"))) {
                        amount = amount.add(rs.getBigDecimal("FAmount"));
                    }
                    if (EmptyUtil.isEmpty((Object)rs.getInt("FLARGETOTALCOUNT"))) continue;
                    largeMergeTotalCount += rs.getInt("FLARGETOTALCOUNT");
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            if (!LargeTotalAmt.equals(largeMergeTotalAmt)) {
                throw new SAException(SAException.LARGETOTAL_CHECKCACULATE);
            }
            info.setAmount(amount);
            info.setLargeTotalAmt(LargeTotalAmt);
            info.setLargeTotalCount(largeMergeTotalCount);
            info.setBillstatus(BillState.SUBMIT);
            isNeedDispose = true;
        } else {
            isNeedDispose = false;
        }
        IObjectPK pk = super._submit(ctx, (IObjectValue)info);
        if (isNeedDispose) {
            this.disposeLargeMergeDetailInfo(ctx, ids, serialIds, info);
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_largeTotalBill_submit");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        return pk;
    }

    @Override
    protected void _caculate(Context ctx, LargeTotalBillInfo info) throws BOSException, EASBizException {
        if (!info.getBillstatus().equals((Object)BillState.SAVED)) {
            throw new SAException(SAException.LARGETOTAL_NOTALLOW_CACULATE);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        FilterInfo filter = new FilterInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("serialId"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("largeTotalAmt"));
        sic.add(new SelectorItemInfo("largeTotalCount"));
        sic.add(new SelectorItemInfo("reportCompany.name"));
        filter.getFilterItems().add(new FilterItemInfo("fillInCompany.id", (Object)info.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)info.getBizDate()));
        LargeDetailMergeBillCollection col = LargeDetailMergeBillFactory.getLocalInstance(ctx).getLargeDetailMergeBillCollection(view);
        BigDecimal amount = Constants.ZERO;
        BigDecimal largeMergeTotalAmt = Constants.ZERO;
        int largeMergeTotalCount = new Integer(0);
        HashSet<String> ids = new HashSet<String>();
        HashSet<String> completedIds = new HashSet<String>();
        HashSet<String> serialIds = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < col.size(); ++i) {
            LargeDetailMergeBillInfo detailInfo = col.get(i);
            String id = detailInfo.getId().toString();
            ids.add(id);
            if (BillState.SUBMIT.equals((Object)detailInfo.getState())) {
                completedIds.add(id);
            } else if (i != col.size() - 1) {
                sb.append(detailInfo.getReportCompany().getName()).append(",");
            } else {
                sb.append(detailInfo.getReportCompany().getName());
            }
            if (!EmptyUtil.isEmpty((String)detailInfo.getSerialId())) {
                serialIds.add(detailInfo.getSerialId());
            }
            if (!EmptyUtil.isEmpty((Object)detailInfo.getAmount())) {
                amount = amount.add(detailInfo.getAmount());
            }
            if (!EmptyUtil.isEmpty((Object)detailInfo.getLargeTotalAmt())) {
                largeMergeTotalAmt = largeMergeTotalAmt.add(detailInfo.getLargeTotalAmt());
            }
            if (EmptyUtil.isEmpty((Object)detailInfo.getLargeTotalCount())) continue;
            largeMergeTotalCount += detailInfo.getLargeTotalCount();
        }
        if (ids.size() != completedIds.size()) {
            throw new SAException(SAException.LARGETOTAL_RECACULATE_CHECKDATA, new Object[]{sb.toString(), info.getBizDate()});
        }
        info.setAmount(amount);
        info.setLargeTotalAmt(largeMergeTotalAmt);
        info.setLargeTotalCount(largeMergeTotalCount);
        info.setBillstatus(BillState.SUBMIT);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("amount"));
        selector.add(new SelectorItemInfo("largeTotalAmt"));
        selector.add(new SelectorItemInfo("largeTotalCount"));
        selector.add(new SelectorItemInfo("billstatus"));
        LargeTotalBillFactory.getLocalInstance(ctx).updatePartial(info, selector);
        this.disposeLargeMergeDetailInfo(ctx, completedIds, serialIds, info);
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_largeTotalBill_caculate");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    private void disposeLargeMergeDetailInfo(Context ctx, Set<String> ids, Set<String> mergeBillNumberSet, LargeTotalBillInfo info) throws BOSException {
        if (ids.isEmpty()) {
            return;
        }
        String sql = "update T_SA_LargeDetailMergeBill set FState = ?, FBatchSeqId = ? where FID in " + FMHelper.setTran2String(ids);
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{40, info.getBatchSeqId()});
        sql = "update T_SA_LargeDetailBill set FTotalBillNumber = ? where FMergeBillNumber in " + FMHelper.setTran2String(mergeBillNumberSet);
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getBatchSeqId()});
    }

    @Override
    protected void _confirm(Context ctx, LargeTotalBillInfo info) throws BOSException, EASBizException {
        if (!info.getBillstatus().equals((Object)BillState.SUBMIT)) {
            throw new SAException(SAException.LARGETOTAL_NOTALLOW_CONFIRM);
        }
        info.setBillstatus(BillState.COMFIRED);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("BillStatus"));
        LargeTotalBillFactory.getLocalInstance(ctx).updatePartial(info, selector);
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_largeTotalBill_confirm");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _unConfirm(Context ctx, LargeTotalBillInfo info) throws BOSException, EASBizException {
        if (!info.getBillstatus().equals((Object)BillState.COMFIRED)) {
            throw new SAException(SAException.LARGETOTAL_NOTALLOW_UNCONFIRM);
        }
        info.setBillstatus(BillState.SUBMIT);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("BillStatus"));
        LargeTotalBillFactory.getLocalInstance(ctx).updatePartial(info, selector);
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_largeTotalBill_unConfirm");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _cancel(Context ctx, LargeTotalBillInfo info) throws BOSException, EASBizException {
        if (!info.getBillstatus().equals((Object)BillState.SUBMIT)) {
            throw new SAException(SAException.LARGETOTAL_NOTALLOW_CANCEL);
        }
        info.setBillstatus(BillState.SAVED);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("BillStatus"));
        LargeTotalBillFactory.getLocalInstance(ctx).updatePartial(info, selector);
        String detailMergeSql = "update T_SA_LargeDetailMergeBill set FState = ?, FBatchSeqId = null where FBatchSeqId = ?";
        DbUtil.execute((Context)ctx, (String)detailMergeSql, (Object[])new Object[]{20, info.getBatchSeqId()});
        String detailBillSql = "update T_SA_LargeDetailBill set FTotalBillNumber = null where FTotalBillNumber = ?";
        DbUtil.execute((Context)ctx, (String)detailBillSql, (Object[])new Object[]{info.getBatchSeqId()});
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_largeTotalBill_cancel");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _report(Context ctx, LargeTotalBillInfo info) throws BOSException, EASBizException {
        ILargeTotalReportService laTotalReportService = LargeTotalReportServiceFactory.getLargeTotalReportService(ctx, info);
        laTotalReportService.initService(ctx, info);
        laTotalReportService.beforeReport();
        laTotalReportService.doService();
        laTotalReportService.afterReport(info.getId().toString());
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_largeTotalBill_report");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _cancelReport(Context ctx, LargeTotalBillInfo info) throws BOSException, EASBizException {
        ILargeTotalCancelReportService laTotalUnReportService = LargeTotalCancelReportServiceFactory.getLargeTotalUnReportService(ctx, info);
        laTotalUnReportService.initService(ctx, info);
        laTotalUnReportService.beforeUnReport();
        laTotalUnReportService.doService();
        laTotalUnReportService.afterUnReport(info.getId().toString());
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_largeTotalBill_unReport");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _genLargeDetailTotalBill(Context ctx, ReportOrgSolutionSettingInfo info, Date payDate, String person, ILargeDetailMergeBill iLargeDetailMergeBill) throws BOSException, EASBizException {
        HashSet<String> detailIds = new HashSet<String>();
        HashSet<String> serialIds = new HashSet<String>();
        FilterInfo totalFilter = new FilterInfo();
        totalFilter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)payDate, CompareType.EQUALS));
        totalFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getFillInOrgUnit().getId().toString(), CompareType.EQUALS));
        if (super.exists(ctx, totalFilter)) {
            return;
        }
        LargeTotalBillInfo totalInfo = new LargeTotalBillInfo();
        totalInfo.setReportOrgSolution(info);
        totalInfo.setBizDate(payDate);
        String payDateStr = ThreadLocalDateUtil.formatDate(payDate);
        totalInfo.setYear(payDateStr.split("-")[0].toString());
        totalInfo.setMonth(payDateStr.split("-")[1].toString());
        totalInfo.setDay(payDateStr.split("-")[2].toString());
        totalInfo.setPerson(person);
        totalInfo.setCompany(info.getFillInOrgUnit());
        totalInfo.setFillInOrgGroupName(info.getFillInOrgGroupName());
        totalInfo.setFillInOrgGroupCode(info.getFillInOrgGroupCode());
        totalInfo.setFillInOrgUnitName(info.getFillInOrgUnitName());
        totalInfo.setFillInOrgUnitCode(info.getFillInOrgUnitCode());
        totalInfo.setLargeSelectAmt(this.getLargeSelectAmount(ctx, info.getFillInOrgUnit()));
        totalInfo.setReportedType(ReportContentEnum.USE_OF_LARGE_FUNDS);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        FilterInfo filter = new FilterInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        sic.add(new SelectorItemInfo("*"));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)payDate, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("reportOrgSolution.id", (Object)info.getId().toString(), CompareType.EQUALS));
        LargeDetailMergeBillCollection detailMergeCols = iLargeDetailMergeBill.getLargeDetailMergeBillCollection(view);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)detailMergeCols)) {
            BigDecimal largeTotalAmt = Constants.ZERO;
            BigDecimal amount = Constants.ZERO;
            int largeTotalCount = 0;
            LargeDetailMergeBillCollection completedDetailMergeCols = new LargeDetailMergeBillCollection();
            for (int k = 0; k < detailMergeCols.size(); ++k) {
                LargeDetailMergeBillInfo detailMergeInfo = detailMergeCols.get(k);
                if (!BillState.SUBMIT.equals((Object)detailMergeInfo.getState())) continue;
                largeTotalAmt = largeTotalAmt.add(detailMergeInfo.getLargeTotalAmt());
                amount = amount.add(detailMergeInfo.getAmount());
                completedDetailMergeCols.add(detailMergeInfo);
                largeTotalCount += detailMergeInfo.getLargeTotalCount();
                detailIds.add(detailMergeInfo.getId().toString());
                serialIds.add(detailMergeInfo.getSerialId());
            }
            totalInfo.setLargeTotalAmt(largeTotalAmt);
            totalInfo.setLargeTotalCount(largeTotalCount);
            if (info.getReportOrgEntrys().size() != detailMergeCols.size()) {
                totalInfo.setBillstatus(BillState.SAVED);
                totalInfo.setIsNoReportRecord(true);
            } else if (detailMergeCols.size() == completedDetailMergeCols.size()) {
                totalInfo.setBillstatus(BillState.SUBMIT);
            } else {
                totalInfo.setBillstatus(BillState.SAVED);
            }
            totalInfo.setAmount(amount);
        } else {
            totalInfo.setLargeSelectAmt(Constants.ZERO);
            totalInfo.setLargeTotalAmt(Constants.ZERO);
            totalInfo.setAmount(Constants.ZERO);
            totalInfo.setLargeTotalCount(0);
            totalInfo.setBillstatus(BillState.SAVED);
        }
        totalInfo.setBatchSeqId(beServiceHelper.getSerialNumber((int)1)[0]);
        this._addnew(ctx, (IObjectValue)totalInfo);
        if (BillState.SUBMIT.equals((Object)totalInfo.getBillstatus())) {
            this.disposeLargeMergeDetailInfo(ctx, detailIds, serialIds, totalInfo);
        }
    }

    private BigDecimal getLargeSelectAmount(Context ctx, CompanyOrgUnitInfo companyInfo) throws BOSException {
        BigDecimal largeSelectAmt = SAConstants.MINAMOUNT;
        try {
            String sql = "select FAmount from T_SA_LargeThresholdSetting where Fid in (select FParentID From T_SA_LargeThresholdSetEntry where FCompanyID = ?) ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{companyInfo.getId().toString()});
            if (rs.next()) {
                largeSelectAmt = rs.getBigDecimal("FAmount");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return largeSelectAmt;
    }
}

