/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.sa.LargeAccessSourceSettingFactory;
import com.kingdee.eas.fm.sa.LargeDetailBillFactory;
import com.kingdee.eas.fm.sa.LargeDetailMergeBillFactory;
import com.kingdee.eas.fm.sa.ReportOrgSSEntryContentCollection;
import com.kingdee.eas.fm.sa.ReportOrgSSEntryContentInfo;
import com.kingdee.eas.fm.sa.ReportOrgSSEntryOrgCollection;
import com.kingdee.eas.fm.sa.ReportOrgSSEntryOrgFactory;
import com.kingdee.eas.fm.sa.ReportOrgSSEntryOrgInfo;
import com.kingdee.eas.fm.sa.ReportOrgSolutionSettingInfo;
import com.kingdee.eas.fm.sa.SAException;
import com.kingdee.eas.fm.sa.StatusEnum;
import com.kingdee.eas.fm.sa.app.AbstractReportOrgSolutionSettingControllerBean;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReportOrgSolutionSettingControllerBean
extends AbstractReportOrgSolutionSettingControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.sa.app.ReportOrgSolutionSettingControllerBean");
    private static String resource = "com.kingdee.eas.fm.sa.SAResource";
    private Set<String> reportOrgIdSet = new HashSet<String>();

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ReportOrgSolutionSettingInfo info = (ReportOrgSolutionSettingInfo)model;
        info.setState(StatusEnum.enable);
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_reportOrgSolutionSetting_addnew");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        return super._addnew(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ReportOrgSolutionSettingInfo info = (ReportOrgSolutionSettingInfo)model;
        this.checkNumberDup(ctx, info);
        this.verifyNotNull(ctx, info);
        this.verifyOnlyOrg(ctx, info);
        return super._save(ctx, model);
    }

    public void checkNumberDup(Context ctx, ReportOrgSolutionSettingInfo info) throws BOSException, EASBizException {
        String number = info.getNumber();
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        info.setNumber(info.getNumber().trim());
        FilterInfo filter = NumberRuleUtil.getCheckNumberDupFilter((IObjectValue)info, (boolean)false);
        if (this.exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{info.getNumber(), ""});
        }
    }

    public void verifyNotNull(Context ctx, ReportOrgSolutionSettingInfo info) throws BOSException, EASBizException {
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"name");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"fillInOrgUnit");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"fillInOrgUnitName");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"fillInOrgUnitCode");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"fillInOrgGroup");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"fillInOrgGroupName");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"fillInOrgGroupCode");
        ReportOrgSSEntryOrgCollection reportOrgEntrys = info.getReportOrgEntrys();
        if (reportOrgEntrys == null || reportOrgEntrys.size() == 0) {
            throw new SAException(SAException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"ReportOrgEntrys_Not_Null")});
        }
        HashMap<String, Integer> OrgMap = new HashMap<String, Integer>();
        for (int i = 0; i < reportOrgEntrys.size(); ++i) {
            ReportOrgSSEntryOrgInfo entry = reportOrgEntrys.get(i);
            if (entry.getReportOrg() == null) {
                throw new SAException(SAException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"ReportOrg_Not_Null")});
            }
            String reportOrgId = entry.getReportOrg().getId().toString();
            Integer seq = (Integer)OrgMap.get(reportOrgId);
            if (seq != null) {
                throw new SAException(SAException.REPORTORGREPEAT, new Object[]{seq, i + 1});
            }
            OrgMap.put(reportOrgId, i + 1);
            this.reportOrgIdSet.add(entry.getReportOrg().getId().toString());
        }
        ReportOrgSSEntryContentCollection reportContentEntrys = info.getReportContentEntrys();
        if (reportContentEntrys == null || reportContentEntrys.size() == 0) {
            throw new SAException(SAException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"ReportContentEntrys_Not_Null")});
        }
        HashMap<Integer, Integer> contentMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < reportContentEntrys.size(); ++i) {
            ReportOrgSSEntryContentInfo entry = reportContentEntrys.get(i);
            if (entry.getFillInPerson() == null) {
                throw new SAException(SAException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"FillInPerson_Not_Null")});
            }
            Integer reportContent = entry.getReportContentEnum().getValue();
            Integer seq = (Integer)contentMap.get(reportContent);
            if (seq != null) {
                throw new SAException(SAException.REPORTCONTENTREPEAT, new Object[]{seq, i + 1});
            }
            contentMap.put(reportContent, i + 1);
        }
    }

    public void verifyOnlyOrg(Context ctx, ReportOrgSolutionSettingInfo info) throws BOSException, EASBizException {
        FilterInfo fillInOrgUnitFilter = new FilterInfo();
        fillInOrgUnitFilter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        fillInOrgUnitFilter.getFilterItems().add(new FilterItemInfo("fillInOrgUnit.id", (Object)info.getFillInOrgUnit().getId().toString(), CompareType.EQUALS));
        if (this.exists(ctx, fillInOrgUnitFilter)) {
            throw new SAException(SAException.EXISTS_FILLINORGUNIT, new Object[]{info.getFillInOrgUnit().getName()});
        }
        FilterInfo fillInOrgNameFilter = new FilterInfo();
        fillInOrgNameFilter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        fillInOrgNameFilter.getFilterItems().add(new FilterItemInfo("fillInOrgUnitName", (Object)info.getFillInOrgUnitName(), CompareType.EQUALS));
        if (this.exists(ctx, fillInOrgNameFilter)) {
            throw new SAException(SAException.EXISTS_FILLINORGUNITNAME, new Object[]{info.getFillInOrgUnitName()});
        }
        FilterInfo fillInOrgCodeFilter = new FilterInfo();
        fillInOrgCodeFilter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        fillInOrgCodeFilter.getFilterItems().add(new FilterItemInfo("fillInOrgUnitCode", (Object)info.getFillInOrgUnitCode(), CompareType.EQUALS));
        if (this.exists(ctx, fillInOrgCodeFilter)) {
            throw new SAException(SAException.EXISTS_FILLINORGUNITCODE, new Object[]{info.getFillInOrgUnitCode()});
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo reportOrgFilter = new FilterInfo();
        reportOrgFilter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        reportOrgFilter.getFilterItems().add(new FilterItemInfo("reportOrg.id", this.reportOrgIdSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("parent.*");
        sic.add("reportOrg.id");
        sic.add("reportOrg.name");
        view.setFilter(reportOrgFilter);
        view.setSelector(sic);
        ReportOrgSSEntryOrgCollection entrys = ReportOrgSSEntryOrgFactory.getLocalInstance(ctx).getReportOrgSSEntryOrgCollection(view);
        int i = 0;
        if (i < entrys.size()) {
            ReportOrgSSEntryOrgInfo entry = entrys.get(i);
            throw new SAException(SAException.EXISTS_REPORTORG, new Object[]{entry.getReportOrg().getName(), entry.getParent().getNumber()});
        }
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("fillInOrgUnit.id");
        sic.add("fillInOrgUnit.name");
        sic.add("reportOrgEntrys.reportOrg.id");
        ReportOrgSolutionSettingInfo info = this.getReportOrgSolutionSettingInfo(ctx, pk, sic);
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getFillInOrgUnit().getId()), (String)"reportOrgSolutionSetting_update_03");
        if (!isPermission) {
            throw new SAException(SAException.NOT_UPDATE_PERMISSION, new Object[]{info.getFillInOrgUnit().getName()});
        }
        if (info.getState() == StatusEnum.enable) {
            throw new SAException(SAException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"solution_enable_notUpdate")});
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_reportOrgSolutionSetting_update");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        super._update(ctx, pk, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("fillInOrgUnit.id");
        sic.add("fillInOrgUnit.name");
        sic.add("reportOrgEntrys.reportOrg.id");
        ReportOrgSolutionSettingInfo info = this.getReportOrgSolutionSettingInfo(ctx, pk, sic);
        boolean isPermission = CASWebHelper.hasFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getFillInOrgUnit().getId()), (String)"reportOrgSolutionSetting_delete_04");
        if (!isPermission) {
            throw new SAException(SAException.NOT_DELETE_PERMISSION, new Object[]{info.getFillInOrgUnit().getName()});
        }
        if (info.getState() != StatusEnum.disable) {
            throw new SAException(SAException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"solution_disable_delete")});
        }
        FilterInfo detailFilter = new FilterInfo();
        detailFilter.getFilterItems().add(new FilterItemInfo("fillInOrgUnitName", (Object)info.getFillInOrgUnitName()));
        if (LargeDetailBillFactory.getLocalInstance(ctx).exists(detailFilter)) {
            throw new SAException(SAException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"solution_reference_LargeDetail")});
        }
        FilterInfo totalFilter = new FilterInfo();
        totalFilter.getFilterItems().add(new FilterItemInfo("reportOrgSolution.id", (Object)info.getId().toString()));
        if (LargeDetailMergeBillFactory.getLocalInstance(ctx).exists(totalFilter)) {
            throw new SAException(SAException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"solution_reference_LargeDetailMerge")});
        }
        HashSet<String> reportOrgIdSet = new HashSet<String>();
        ReportOrgSSEntryOrgCollection reportOrgEntrys = info.getReportOrgEntrys();
        for (int i = 0; i < reportOrgEntrys.size(); ++i) {
            reportOrgIdSet.add(reportOrgEntrys.get(i).getReportOrg().getId().toString());
        }
        FilterInfo largeFilter = new FilterInfo();
        largeFilter.getFilterItems().add(new FilterItemInfo("reportOrg.id", reportOrgIdSet, CompareType.INCLUDE));
        if (LargeAccessSourceSettingFactory.getLocalInstance(ctx).exists(largeFilter)) {
            throw new SAException(SAException.COMMON, new Object[]{CASWebUtil.getResource((Context)ctx, (String)resource, (String)"solution_reference_LargeAccessSource")});
        }
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)info.getBOSType(), null, (String)info.getNumber(), (String)"sa_reportOrgSolutionSetting_delete");
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        super._delete(ctx, pk);
    }
}

