/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.fin.FinancingBillTypeEnum;
import com.kingdee.eas.fm.fin.RepaymentCollection;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.sa.AccessSourceEnum;
import com.kingdee.eas.fm.sa.BillStatusEnum;
import com.kingdee.eas.fm.sa.DebtDetailBillCollection;
import com.kingdee.eas.fm.sa.DebtDetailBillFactory;
import com.kingdee.eas.fm.sa.DebtDetailBillInfo;
import com.kingdee.eas.fm.sa.FundUseInfo;
import com.kingdee.eas.fm.sa.ReportContentEnum;
import com.kingdee.eas.fm.sa.ReportOrgSolutionSettingInfo;
import com.kingdee.eas.fm.sa.SAException;
import com.kingdee.eas.fm.sa.app.handler.ITransDebtDetailHandler;
import com.kingdee.eas.fm.sa.app.util.Sequence;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractTransDebtHandler
implements ITransDebtDetailHandler {
    private static Logger logger = Logger.getLogger(AbstractTransDebtHandler.class);
    protected static final String DebtDETAIL_BOSTYPE = new DebtDetailBillInfo().getBOSType().toString();

    @Override
    public Set<String> getSourceBillIdSet(Context ctx, String companyId, Date startDate, AccessSourceEnum source) throws EASBizException, BOSException {
        HashSet<String> sourceBillIdSet = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("reportOrg.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("startDate", (Object)startDate));
        filter.getFilterItems().add(new FilterItemInfo("accessSource", (Object)source.getValue()));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("sourceBillId"));
        view.setFilter(filter);
        view.setSelector(selector);
        DebtDetailBillCollection coll = DebtDetailBillFactory.getLocalInstance(ctx).getDebtDetailBillCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            sourceBillIdSet.add(coll.get(i).getSourceBillId());
        }
        return sourceBillIdSet;
    }

    @Override
    public abstract Set<String> getFilterBillIdSet(Context var1, String var2, Date var3) throws EASBizException, BOSException;

    public Set<String> getRepaySourceIdSet(Context ctx, String companyId, Date startDate, FinancingBillTypeEnum source) throws EASBizException, BOSException {
        HashSet<String> sourceIdSet = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)startDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)DateUtil.getLastDayOfMonth((Date)startDate), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("SourceType", (Object)source.getValue()));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("sourceBillId"));
        view.setSelector(selector);
        view.setFilter(filter);
        RepaymentCollection coll = RepaymentFactory.getLocalInstance((Context)ctx).getRepaymentCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            String sourceBillId = coll.get(i).getSourceBillId();
            sourceIdSet.add(sourceBillId);
        }
        if (sourceIdSet.size() == 0) {
            sourceIdSet.add("1");
        }
        return sourceIdSet;
    }

    @Override
    public Set<String> getBillIdSet(Context ctx, String companyId, Date startDate, AccessSourceEnum source) throws EASBizException, BOSException {
        HashSet<String> idSet = new HashSet<String>();
        Set<String> sourceBillIdSet = this.getSourceBillIdSet(ctx, companyId, startDate, source);
        Set<String> allIdSet = this.getFilterBillIdSet(ctx, companyId, startDate);
        for (String billId : allIdSet) {
            if (sourceBillIdSet.contains(billId)) continue;
            idSet.add(billId);
        }
        return idSet;
    }

    @Override
    public abstract IObjectCollection getBillColl(Context var1, Set<String> var2) throws EASBizException, BOSException;

    @Override
    public void genDebtDetailColl(Context ctx, String companyId, Date startDate, AccessSourceEnum source, ReportOrgSolutionSettingInfo reportOrgSolution, Map<String, FundUseInfo> matchId_fundUseMap) throws EASBizException, BOSException {
        Set<String> billIdSet = this.getBillIdSet(ctx, companyId, startDate, source);
        if (billIdSet.size() == 0) {
            logger.error((Object)("\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684" + source.getAlias() + "\u53bb\u8f6c\u6362\u6210\u5230\u671f\u503a\u52a1\u660e\u7ec6"));
            return;
        }
        IObjectCollection billColl = this.getBillColl(ctx, billIdSet);
        CoreBaseCollection newDebtDetailBillColl = new CoreBaseCollection();
        HashMap<String, String> srcBillId_destIdMap = new HashMap<String, String>();
        for (int i = 0; i < billColl.size(); ++i) {
            DebtDetailBillInfo info = this.transOneDebtDetail(ctx, billColl.getObject(i), reportOrgSolution, matchId_fundUseMap);
            this.addnewVerify(ctx, info);
            newDebtDetailBillColl.add((CoreBaseInfo)info);
            srcBillId_destIdMap.put(info.getSourceBillId(), info.getId().toString());
        }
        DebtDetailBillFactory.getLocalInstance(ctx).addnewBatchData(newDebtDetailBillColl);
        BOTPUtil.saveBOTRelation((Context)ctx, srcBillId_destIdMap);
    }

    @Override
    public DebtDetailBillInfo transOneDebtDetail(Context ctx, IObjectValue bill, ReportOrgSolutionSettingInfo reportOrgSolution, Map<String, FundUseInfo> matchId_fundUseMap) throws BOSException, EASBizException {
        CoreBillBaseCollection sourceBillCollection = new CoreBillBaseCollection();
        sourceBillCollection.add((CoreBillBaseInfo)bill);
        BTPTransformResult btpResult = BTPManagerFactory.getLocalInstance((Context)ctx).transform(sourceBillCollection, DebtDETAIL_BOSTYPE);
        DebtDetailBillCollection DebtColl = (DebtDetailBillCollection)btpResult.getBills();
        if (DebtColl.size() == 0) {
            throw new SAException(SAException.COMMON, new String[]{"\u5230\u671f\u503a\u52a1\u660e\u7ec6botp\u8f6c\u6362\u5931\u8d25"});
        }
        DebtDetailBillInfo info = DebtColl.get(0);
        info.setSourceBillId(bill.getString("id"));
        info.setSourceBillNumber(bill.getString("number"));
        info.setReportedType(ReportContentEnum.MATURECLAIM_AND_REPAYPLAN);
        this.initBillNumber(ctx, info);
        info.setSerialId(Sequence.gen18Sequence());
        info.setFillInOrgUnitName(reportOrgSolution.getFillInOrgUnitName());
        info.setFillInOrgUnitCode(reportOrgSolution.getFillInOrgUnitCode());
        info.setIsExecute(true);
        info.setBillStatus(BillStatusEnum.SAVE);
        if (EmptyUtil.isEmpty((Object)info.getDebtPrinAmt())) {
            info.setDebtPrinAmt(BigDecimal.ZERO);
        }
        if (EmptyUtil.isEmpty((Object)info.getDebtAnnlRate())) {
            info.setDebtAnnlRate(BigDecimal.ZERO);
        }
        if (EmptyUtil.isEmpty((Object)info.getDueAmtMonth())) {
            info.setDueAmtMonth(BigDecimal.ZERO);
        }
        info.setStartDate(DateUtil.getFirstDayOfMonth((Date)new Date()));
        info.setEndDate(DateUtil.getLastDayOfMonth((Date)new Date()));
        info.setCreator(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        this.fillDebtDetail(bill, info, matchId_fundUseMap);
        if (!EmptyUtil.isEmpty((Object)info.getDueDateMonth())) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(info.getDueDateMonth());
            int tempDay = cal.get(5);
            if (tempDay <= 10) {
                info.setIsExecute(true);
            } else {
                info.setIsExecute(false);
            }
        } else {
            info.setIsExecute(false);
        }
        return info;
    }

    @Override
    public abstract void fillDebtDetail(IObjectValue var1, DebtDetailBillInfo var2, Map<String, FundUseInfo> var3) throws BOSException, EASBizException;

    @Override
    public void initBillNumber(Context ctx, DebtDetailBillInfo info) throws BOSException, EASBizException {
        FilterInfo filter;
        int i = 0;
        do {
            String numberSilent = null;
            try {
                numberSilent = NumberRuleUtil.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getReportOrg().getId().toString());
            }
            catch (Exception e) {
                logger.info((Object)e);
                throw new SAException(SAException.COMMON, new String[]{e.getMessage()});
            }
            if (EmptyUtil.isEmpty((String)numberSilent)) {
                return;
            }
            info.setNumber(numberSilent);
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("reportOrg.id", (Object)info.getReportOrg().getId()));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
            ++i;
        } while (DebtDetailBillFactory.getLocalInstance(ctx).exists(filter));
    }

    @Override
    public void addnewVerify(Context ctx, DebtDetailBillInfo info) throws BOSException, EASBizException {
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"reportOrg");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"startDate");
    }

    @Override
    public void addnewDebtDetail(Context ctx, DebtDetailBillInfo info) throws BOSException, EASBizException {
        this.addnewVerify(ctx, info);
        DebtDetailBillFactory.getLocalInstance(ctx).addnew(info);
        this.saveBOTRelation(ctx, info);
    }

    @Override
    public void saveBOTRelation(Context ctx, DebtDetailBillInfo info) throws BOSException, EASBizException {
        ArrayList<String> srcIdList = new ArrayList<String>();
        String sourceBillID = info.getSourceBillId();
        srcIdList.add(sourceBillID);
        BOTPUtil.saveBOTRelation((Context)ctx, srcIdList, (String)info.getId().toString());
    }
}

