/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.sa.ILargeDetailBill;
import com.kingdee.eas.fm.sa.ILargeDetailMergeBill;
import com.kingdee.eas.fm.sa.LargeDetailBillFactory;
import com.kingdee.eas.fm.sa.LargeDetailMergeBillFactory;
import com.kingdee.eas.fm.sa.ReportContentEnum;
import com.kingdee.eas.fm.sa.ReportOrgSSEntryOrgCollection;
import com.kingdee.eas.fm.sa.ReportOrgSSEntryOrgInfo;
import com.kingdee.eas.fm.sa.ReportOrgSolutionSettingInfo;
import com.kingdee.eas.fm.sa.SAException;
import com.kingdee.eas.fm.sa.app.handler.IDetailMergeHandler;
import com.kingdee.eas.fm.sa.app.util.SAConstants;
import com.kingdee.eas.fm.sa.app.util.ThreadLocalDateUtil;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class LargeDetailMergeHandler
implements IDetailMergeHandler {
    private static Logger logger = Logger.getLogger((String)LargeDetailMergeHandler.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dealDetailMergeBillHandler(Context ctx, Date payDate, Map<ReportContentEnum, ReportOrgSSEntryOrgCollection> reportEnum_orgSSEntryColMap, Map<String, ReportOrgSolutionSettingInfo> com_orgSolutionMap) throws BOSException, EASBizException {
        ReportOrgSSEntryOrgCollection orgSSEntryCol = reportEnum_orgSSEntryColMap.get((Object)ReportContentEnum.USE_OF_LARGE_FUNDS);
        if (EmptyUtil.isEmpty((AbstractObjectCollection)orgSSEntryCol)) {
            logger.error((Object)(ReportContentEnum.USE_OF_LARGE_FUNDS.getAlias() + "\u6ca1\u6709\u7b26\u5408\u751f\u6210\u5927\u989d\u8d44\u91d1\u6c47\u603b\u4e0a\u62a5\u6761\u4ef6\u7684\u516c\u53f8"));
            return;
        }
        ILargeDetailBill iLargeDetailBill = LargeDetailBillFactory.getLocalInstance(ctx);
        ILargeDetailMergeBill iLargeDetailMergeBill = LargeDetailMergeBillFactory.getLocalInstance(ctx);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < orgSSEntryCol.size(); ++i) {
            boolean isLocked = false;
            ReportOrgSSEntryOrgInfo orgSSEntryInfo = orgSSEntryCol.get(i);
            ReportOrgSolutionSettingInfo info = com_orgSolutionMap.get(orgSSEntryInfo.getReportOrg().getId().toString());
            String lockId = SAConstants.getSALargeMutexId(orgSSEntryInfo.getReportOrg().getId().toString(), payDate);
            try {
                isLocked = iMutex.requestObjIDForUpdate(lockId);
                if (!isLocked) {
                    throw new SAException(SAException.EXISTS_REPORTING_DETAILDATA, new Object[]{orgSSEntryInfo.getReportOrg().getName(), ThreadLocalDateUtil.formatDate(payDate)});
                }
                iLargeDetailMergeBill.genLargeDetailMergeBill(info, orgSSEntryInfo, payDate, iLargeDetailBill);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            finally {
                if (isLocked) {
                    iMutex.releaseObjIDForUpdate(lockId);
                }
            }
        }
    }
}

