/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fin.FinancingProductsInfo;
import com.kingdee.eas.fm.nt.PayableBillCollection;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.sa.AccessSourceEnum;
import com.kingdee.eas.fm.sa.DebtDetailBillInfo;
import com.kingdee.eas.fm.sa.FundUseInfo;
import com.kingdee.eas.fm.sa.app.handler.AbstractTransDebtHandler;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PayableBillTransDebtHandler
extends AbstractTransDebtHandler {
    @Override
    public Set<String> getFilterBillIdSet(Context ctx, String companyId, Date startDate) throws EASBizException, BOSException {
        HashSet<String> idSet = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)5));
        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)6));
        filter.getFilterItems().add(new FilterItemInfo("IssueDate", (Object)DateUtil.getLastDayOfMonth((Date)startDate), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("RepaymentDate", (Object)startDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("RepaymentDate", (Object)DateUtil.getLastDayOfMonth((Date)startDate), CompareType.LESS_EQUALS));
        filter.setMaskString(" #0 and ( ( (#1 or #2) and #3 ) or ( #4 and #5 and #6 ) )");
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        view.setSelector(selector);
        view.setFilter(filter);
        PayableBillCollection coll = PayableBillFactory.getLocalInstance((Context)ctx).getPayableBillCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            String billId = coll.get(i).getId().toString();
            idSet.add(billId);
        }
        return idSet;
    }

    public PayableBillCollection getBillColl(Context ctx, Set<String> billIdSet) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", billIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("company.name"));
        selector.add(new SelectorItemInfo("ntType.financeType.id"));
        view.setSelector(selector);
        return PayableBillFactory.getLocalInstance((Context)ctx).getPayableBillCollection(view);
    }

    @Override
    public void fillDebtDetail(IObjectValue bill, DebtDetailBillInfo info, Map<String, FundUseInfo> matchId_fundUseMap) throws BOSException, EASBizException {
        PayableBillInfo payableBill = (PayableBillInfo)bill;
        info.setAccessSource(AccessSourceEnum.PayableBill);
        FinancingProductsInfo financeType = payableBill.getNtType().getFinanceType();
        if (!EmptyUtil.isEmpty((CoreBaseInfo)financeType)) {
            info.setFundUse(matchId_fundUseMap.get(financeType.getId().toString()));
        }
        if (payableBill.getExpiredDate().getTime() <= DateUtil.getLastDayOfCurMonth().getTime() && payableBill.getExpiredDate().getTime() >= DateUtil.getFirstDayOfCurMonth().getTime()) {
            info.setDueDateMonth(payableBill.getExpiredDate());
            info.setDueAmtMonth(payableBill.getAmountLocalCur());
        }
    }
}

