/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.fm.sa.ReportContentEnum;
import com.kingdee.eas.fm.sa.app.handler.ITotalHandler;
import com.kingdee.eas.fm.sa.app.handler.LargeTotalHandler;
import com.kingdee.eas.fm.sa.app.handler.MaturedDebtTotalHandler;
import org.apache.log4j.Logger;

public class TotalBillHandlerFacatory {
    private static Logger logger = Logger.getLogger((String)TotalBillHandlerFacatory.class.getName());

    public static ITotalHandler getInstance(ReportContentEnum reportContentEnum) throws BOSException {
        String handlerName = null;
        switch (reportContentEnum.getValue()) {
            case 1: {
                handlerName = LargeTotalHandler.class.getName();
                break;
            }
            case 3: {
                handlerName = MaturedDebtTotalHandler.class.getName();
            }
        }
        if (EmptyUtil.isEmpty(handlerName)) {
            logger.error((Object)(reportContentEnum.getAlias() + "\u6ca1\u6709\u8bbe\u7f6e\u76f8\u5173\u7684\u6c47\u603b\u62a5\u9001\u5904\u7406\u7c7b"));
            return null;
        }
        try {
            return (ITotalHandler)Class.forName(handlerName).newInstance();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }
}

