/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.sa.BillState;
import com.kingdee.eas.fm.sa.DebtDetailBillCollection;
import com.kingdee.eas.fm.sa.DebtDetailBillFactory;
import com.kingdee.eas.fm.sa.MaturedDebtTotalBillFactory;
import com.kingdee.eas.fm.sa.MaturedDebtTotalBillInfo;
import com.kingdee.eas.fm.sa.ReportStatusEnum;
import com.kingdee.eas.fm.sa.ReportStorageSettingWebFacadeFactory;
import com.kingdee.eas.fm.sa.SAException;
import com.kingdee.eas.fm.sa.TotalBillInfo;
import com.kingdee.eas.fm.sa.app.service.ILargeTotalReportService;
import com.kingdee.eas.fm.sa.app.util.MaturedDebtTotalDBUtils;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class MatureDebitTotalReportSerivce
implements ILargeTotalReportService {
    private static Logger logger = Logger.getLogger((String)MatureDebitTotalReportSerivce.class.getName());
    protected Context ctx;
    protected MaturedDebtTotalBillInfo info;
    protected boolean isZeroSendReport;

    @Override
    public void initService(Context ctx, TotalBillInfo info) throws EASBizException, BOSException {
        ReportStorageSettingWebFacadeFactory.getLocalInstance(ctx).testDBOrOthfaceDrive();
        this.info = (MaturedDebtTotalBillInfo)info;
        this.ctx = ctx;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        FilterInfo filter = new FilterInfo();
        view.setSelector(sic);
        view.setFilter(filter);
        sic.add(new SelectorItemInfo("id"));
        filter.getFilterItems().add(new FilterItemInfo("totalBillNumber", (Object)this.info.getBatchSeqId(), CompareType.EQUALS));
        DebtDetailBillCollection detailCol = DebtDetailBillFactory.getLocalInstance(ctx).getDebtDetailBillCollection(view);
        this.isZeroSendReport = EmptyUtil.isEmpty((AbstractObjectCollection)detailCol);
    }

    @Override
    public void beforeReport() throws EASBizException, BOSException {
        if (!this.info.getBillstatus().equals((Object)BillState.COMFIRED)) {
            throw new SAException(SAException.LARGETOTAL_NOTALLOW_REPORT);
        }
    }

    @Override
    public void doService() throws EASBizException, BOSException {
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)this.ctx).getCurrentUser();
        this.info.setPerson(user.getName());
        this.info.setBizTime(new Timestamp(Calendar.getInstance().getTimeInMillis()));
        this.info.setBillstatus(BillState.REPORTED);
        if (this.isZeroSendReport) {
            this.info.setReportStatus(ReportStatusEnum.ZEROREPORTED);
        } else {
            this.info.setReportStatus(ReportStatusEnum.ADDNEW);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("person"));
        selector.add(new SelectorItemInfo("bizTime"));
        selector.add(new SelectorItemInfo("billstatus"));
        selector.add(new SelectorItemInfo("reportStatus"));
        MaturedDebtTotalBillFactory.getLocalInstance(this.ctx).updatePartial(this.info, selector);
        String detailSql = "update T_SA_DebtDetailBill set FillInTime = ? where FTotalBillNumber = ?";
        DbUtil.execute((Context)this.ctx, (String)detailSql, (Object[])new Object[]{this.info.getBizTime(), this.info.getBatchSeqId()});
    }

    @Override
    public void afterReport(String id) throws EASBizException, BOSException {
        MaturedDebtTotalDBUtils dbUtils = new MaturedDebtTotalDBUtils();
        if (!this.isZeroSendReport) {
            dbUtils.addNewMaturedDebtTotalFromDB(this.ctx, this.info, ReportStatusEnum.ADDNEW);
        } else {
            dbUtils.addNewMaturedDebtTotalFromDB(this.ctx, this.info, ReportStatusEnum.ZEROREPORTED);
        }
    }
}

