/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app.util;

import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.fm.be.app.util.DBCPConUtils;
import com.kingdee.eas.fm.be.bean.EReceiptDBInfo;
import com.kingdee.eas.fm.sa.ReportStorageSettingInfo;
import com.kingdee.eas.fm.sa.StorageType;
import com.kingdee.eas.fm.sa.app.util.ITotalJDBCTool;
import com.kingdee.eas.fm.sa.vo.AcctBankBalanceDetailVO;
import com.kingdee.eas.fm.sa.vo.AcctBankBalanceTotalVO;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public class AcctBankBalanceTotalJDBCTool
implements ITotalJDBCTool<AcctBankBalanceTotalVO, AcctBankBalanceDetailVO> {
    private Logger logger = Logger.getLogger((String)AcctBankBalanceTotalJDBCTool.class.getName());
    private static String insertTotalSql = "INSERT INTO zjjg_zhjyebszb (masterTabId, submitUnitCode, submitUnitName, dataYear, dataMonth, dataDate, submitter, submitTime, remark, groupCode, groupName, dataState, dataStatus) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static String insertDetailSql = "INSERT INTO zjjg_zhjyebsmx (detailTabId, masterTabId, acctTit, acctNo, bankBrName, bankType, accttype, acctOpenDate, acctState, acctBal, balanceDate, ifAccmAcct, remark, submitTime, dataStatus) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);";

    @Override
    public void insert(AcctBankBalanceTotalVO totalVo) throws Exception, SQLException {
    }

    @Override
    public void insert(AcctBankBalanceTotalVO totalVo, ReportStorageSettingInfo reportStorageSettingInfo) throws Exception, SQLException {
        if (StorageType.dbStore.equals((Object)reportStorageSettingInfo.getStorageType())) {
            EReceiptDBInfo eReceiptDBInfo = new EReceiptDBInfo();
            eReceiptDBInfo.setDbType(reportStorageSettingInfo.getDbType());
            eReceiptDBInfo.setDbIP(reportStorageSettingInfo.getDbIP());
            eReceiptDBInfo.setDbPort(reportStorageSettingInfo.getDbPort());
            eReceiptDBInfo.setDbName(reportStorageSettingInfo.getDbName());
            eReceiptDBInfo.setDbUserName(reportStorageSettingInfo.getDbUserName());
            eReceiptDBInfo.setDbUserPwd(reportStorageSettingInfo.getDbPwd());
            Statement st = null;
            Statement ps = null;
            Connection conn = null;
            try {
                this.logger.info((Object)"Insert AcctBankBalanceTotalVO begin");
                conn = DBCPConUtils.getConnection((EReceiptDBInfo)eReceiptDBInfo);
                ps = conn.prepareStatement(insertTotalSql);
                ps.setString(1, totalVo.getMasterTabId());
                ps.setString(2, totalVo.getSubmitUnitCode());
                ps.setString(3, totalVo.getSubmitUnitName());
                ps.setString(4, totalVo.getDataYear());
                ps.setString(5, totalVo.getDataMonth());
                ps.setString(6, totalVo.getDataDate());
                ps.setString(7, totalVo.getSubmitter());
                ps.setString(8, totalVo.getSubmitTime());
                ps.setString(9, totalVo.getRemark());
                ps.setString(10, totalVo.getGroupCode());
                ps.setString(11, totalVo.getGroupName());
                ps.setString(12, totalVo.getDataState());
                ps.setString(13, "0");
                ps.addBatch();
                ps.execute();
                conn.commit();
                this.logger.info((Object)"Insert AcctBankBalanceTotalVO success");
            }
            catch (Exception e) {
                e.printStackTrace();
                conn.rollback();
                throw new Exception(e);
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ps = null;
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public void batchInsert(AcctBankBalanceTotalVO totalVo, List<AcctBankBalanceDetailVO> detailList, ReportStorageSettingInfo reportStorageSettingInfo) throws Exception, SQLException {
        if (StorageType.dbStore.equals((Object)reportStorageSettingInfo.getStorageType())) {
            EReceiptDBInfo eReceiptDBInfo = new EReceiptDBInfo();
            eReceiptDBInfo.setDbType(reportStorageSettingInfo.getDbType());
            eReceiptDBInfo.setDbIP(reportStorageSettingInfo.getDbIP());
            eReceiptDBInfo.setDbPort(reportStorageSettingInfo.getDbPort());
            eReceiptDBInfo.setDbName(reportStorageSettingInfo.getDbName());
            eReceiptDBInfo.setDbUserName(reportStorageSettingInfo.getDbUserName());
            eReceiptDBInfo.setDbUserPwd(reportStorageSettingInfo.getDbPwd());
            Statement st = null;
            Statement ps = null;
            Connection conn = null;
            try {
                this.logger.info((Object)"Insert AcctBankBalanceTotalVO and List<AcctBankBalanceDetailVO> begin");
                conn = DBCPConUtils.getConnection((EReceiptDBInfo)eReceiptDBInfo);
                ps = conn.prepareStatement(insertTotalSql);
                ps.setString(1, totalVo.getMasterTabId());
                ps.setString(2, totalVo.getSubmitUnitCode());
                ps.setString(3, totalVo.getSubmitUnitName());
                ps.setString(4, totalVo.getDataYear());
                ps.setString(5, totalVo.getDataMonth());
                ps.setString(6, totalVo.getDataDate());
                ps.setString(7, totalVo.getSubmitter());
                ps.setString(8, totalVo.getSubmitTime());
                ps.setString(9, totalVo.getRemark());
                ps.setString(10, totalVo.getGroupCode());
                ps.setString(11, totalVo.getGroupName());
                ps.setString(12, totalVo.getDataState());
                ps.setString(13, "0");
                ps.addBatch();
                ps.execute();
                if (!EmptyUtil.isEmpty(detailList)) {
                    ps = conn.prepareStatement(insertDetailSql);
                    for (int i = 0; i < detailList.size(); ++i) {
                        AcctBankBalanceDetailVO detailVO = detailList.get(i);
                        ps.setString(1, detailVO.getDetailTabId());
                        ps.setString(2, detailVO.getMasterTabId());
                        ps.setString(3, detailVO.getAcctTit());
                        ps.setString(4, detailVO.getAcctNo());
                        ps.setString(5, detailVO.getBankBrName());
                        ps.setString(6, detailVO.getBankType());
                        ps.setString(7, detailVO.getAcctType());
                        ps.setDate(8, detailVO.getAcctOpenDate());
                        ps.setString(9, detailVO.getAcctState());
                        ps.setBigDecimal(10, detailVO.getAcctBal());
                        ps.setDate(11, detailVO.getBalanceDate());
                        ps.setString(12, detailVO.getIfAccmAcct());
                        ps.setString(13, detailVO.getRemark());
                        ps.setString(14, detailVO.getSubmitTime());
                        ps.setString(15, "0");
                        ps.addBatch();
                    }
                    ps.executeBatch();
                }
                conn.commit();
                this.logger.info((Object)"batchInsert AcctBankBalanceTotalVO and List<AcctBankBalanceDetailVO> success");
            }
            catch (Exception e) {
                e.printStackTrace();
                conn.rollback();
                throw new Exception(e);
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ps = null;
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

