/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app.util;

import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.fm.be.app.util.DBCPConUtils;
import com.kingdee.eas.fm.be.bean.EReceiptDBInfo;
import com.kingdee.eas.fm.sa.ReportStorageSettingInfo;
import com.kingdee.eas.fm.sa.StorageType;
import com.kingdee.eas.fm.sa.app.util.ITotalJDBCTool;
import com.kingdee.eas.fm.sa.vo.LargeDetailVO;
import com.kingdee.eas.fm.sa.vo.LargeTotalVO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public class LargeTotalJDBCTool
implements ITotalJDBCTool<LargeTotalVO, LargeDetailVO> {
    private Logger logger = Logger.getLogger((String)LargeTotalJDBCTool.class.getName());
    private static String insertTotalSql = "INSERT INTO zjjg_dezjsjbszb (masterTabId, submitUnitCode, submitUnitName, dataYear, dataMonth, dataDate, largeFundsLevel, totalPaid, largeTotalPaid, largeFundsRoll, remark, submitTime, submitter, groupCode, groupName, dataState, dataStatus)  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static String insertDetailSql = "INSERT INTO zjjg_dezjsjbsmx (detailTabId, masterTabId, submitUnitCode, payerName, payeeName, payment, fundsUse, useDescript, ifAbroad, payDate, remark, PayNature, isTradeCapital, submitTime) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    @Override
    public void insert(LargeTotalVO largeTotalVO) throws Exception, SQLException {
    }

    @Override
    public void insert(LargeTotalVO largeTotalVo, ReportStorageSettingInfo reportStorageSettingInfo) throws Exception, SQLException {
        if (StorageType.dbStore.equals((Object)reportStorageSettingInfo.getStorageType())) {
            EReceiptDBInfo eReceiptDBInfo = new EReceiptDBInfo();
            eReceiptDBInfo.setDbType(reportStorageSettingInfo.getDbType());
            eReceiptDBInfo.setDbIP(reportStorageSettingInfo.getDbIP());
            eReceiptDBInfo.setDbPort(reportStorageSettingInfo.getDbPort());
            eReceiptDBInfo.setDbName(reportStorageSettingInfo.getDbName());
            eReceiptDBInfo.setDbUserName(reportStorageSettingInfo.getDbUserName());
            eReceiptDBInfo.setDbUserPwd(reportStorageSettingInfo.getDbPwd());
            Statement st = null;
            PreparedStatement ps = null;
            Connection conn = null;
            try {
                conn = DBCPConUtils.getConnection((EReceiptDBInfo)eReceiptDBInfo);
                ps = conn.prepareStatement(insertTotalSql);
                ps.setString(1, largeTotalVo.getMasterTabId());
                ps.setString(2, largeTotalVo.getSubmitUnitCode());
                ps.setString(3, largeTotalVo.getSubmitUnitName());
                ps.setString(4, largeTotalVo.getDataYear());
                ps.setString(5, largeTotalVo.getDataMonth());
                ps.setString(6, largeTotalVo.getDataDate());
                ps.setBigDecimal(7, largeTotalVo.getLargeFundsLevel());
                ps.setBigDecimal(8, largeTotalVo.getTotalPaid());
                ps.setBigDecimal(9, largeTotalVo.getLargeTotalPaid());
                ps.setInt(10, largeTotalVo.getLargeFundsRoll());
                ps.setString(11, largeTotalVo.getRemark());
                ps.setString(12, largeTotalVo.getSubmitTime());
                ps.setString(13, largeTotalVo.getSubmitter());
                ps.setString(14, largeTotalVo.getGroupCode());
                ps.setString(15, largeTotalVo.getGroupName());
                ps.setString(16, largeTotalVo.getDataState());
                ps.setString(17, "0");
                ps.addBatch();
                ps.execute();
                conn.commit();
                this.logger.info((Object)"Insert success");
            }
            catch (Exception e) {
                e.printStackTrace();
                conn.rollback();
                throw new Exception(e);
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ps = null;
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public void batchInsert(LargeTotalVO largeTotalVo, List<LargeDetailVO> detailList, ReportStorageSettingInfo reportStorageSettingInfo) throws Exception, SQLException {
        if (StorageType.dbStore.equals((Object)reportStorageSettingInfo.getStorageType())) {
            EReceiptDBInfo eReceiptDBInfo = new EReceiptDBInfo();
            eReceiptDBInfo.setDbType(reportStorageSettingInfo.getDbType());
            eReceiptDBInfo.setDbIP(reportStorageSettingInfo.getDbIP());
            eReceiptDBInfo.setDbPort(reportStorageSettingInfo.getDbPort());
            eReceiptDBInfo.setDbName(reportStorageSettingInfo.getDbName());
            eReceiptDBInfo.setDbUserName(reportStorageSettingInfo.getDbUserName());
            eReceiptDBInfo.setDbUserPwd(reportStorageSettingInfo.getDbPwd());
            Statement st = null;
            PreparedStatement ps = null;
            Connection conn = null;
            try {
                conn = DBCPConUtils.getConnection((EReceiptDBInfo)eReceiptDBInfo);
                ps = conn.prepareStatement(insertTotalSql);
                ps.setString(1, largeTotalVo.getMasterTabId());
                ps.setString(2, largeTotalVo.getSubmitUnitCode());
                ps.setString(3, largeTotalVo.getSubmitUnitName());
                ps.setString(4, largeTotalVo.getDataYear());
                ps.setString(5, largeTotalVo.getDataMonth());
                ps.setString(6, largeTotalVo.getDataDate());
                ps.setBigDecimal(7, largeTotalVo.getLargeFundsLevel());
                ps.setBigDecimal(8, largeTotalVo.getTotalPaid());
                ps.setBigDecimal(9, largeTotalVo.getLargeTotalPaid());
                ps.setInt(10, largeTotalVo.getLargeFundsRoll());
                ps.setString(11, largeTotalVo.getRemark());
                ps.setString(12, largeTotalVo.getSubmitTime());
                ps.setString(13, largeTotalVo.getSubmitter());
                ps.setString(14, largeTotalVo.getGroupCode());
                ps.setString(15, largeTotalVo.getGroupName());
                ps.setString(16, largeTotalVo.getDataState());
                ps.setString(17, "0");
                ps.addBatch();
                ps.execute();
                if (!EmptyUtil.isEmpty(detailList)) {
                    ps = conn.prepareStatement(insertDetailSql);
                    for (int i = 0; i < detailList.size(); ++i) {
                        LargeDetailVO largeDetailVO = detailList.get(i);
                        ps.setString(1, largeDetailVO.getDetailTabId());
                        ps.setString(2, largeDetailVO.getMasterTabId());
                        ps.setString(3, largeDetailVO.getSubmitUnitCode());
                        ps.setString(4, largeDetailVO.getPayerName());
                        ps.setString(5, largeDetailVO.getPayeeName());
                        ps.setBigDecimal(6, largeDetailVO.getPayment());
                        ps.setString(7, largeDetailVO.getFundsUse());
                        ps.setString(8, largeDetailVO.getUseDescript());
                        ps.setBoolean(9, largeDetailVO.getIfAbroad());
                        ps.setDate(10, largeDetailVO.getPayDate());
                        ps.setString(11, largeDetailVO.getRemark());
                        ps.setString(12, largeDetailVO.getPayNature());
                        ps.setBoolean(13, largeDetailVO.getIsTradeCapital());
                        ps.setString(14, largeDetailVO.getSubmitTime());
                        ps.addBatch();
                    }
                    ps.executeBatch();
                }
                conn.commit();
                this.logger.info((Object)"batchInsert success");
            }
            catch (Exception e) {
                e.printStackTrace();
                conn.rollback();
                throw new Exception(e);
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ps = null;
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

