/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sa.app.util;

import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.fm.be.app.util.DBCPConUtils;
import com.kingdee.eas.fm.be.bean.EReceiptDBInfo;
import com.kingdee.eas.fm.sa.ReportStorageSettingInfo;
import com.kingdee.eas.fm.sa.StorageType;
import com.kingdee.eas.fm.sa.app.util.ITotalJDBCTool;
import com.kingdee.eas.fm.sa.vo.MaturedDebtDetailVO;
import com.kingdee.eas.fm.sa.vo.MaturedDebtTotalVO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;

public class MaturedDebtTotalJDBCTool
implements ITotalJDBCTool<MaturedDebtTotalVO, MaturedDebtDetailVO> {
    private Logger logger = Logger.getLogger((String)MaturedDebtTotalJDBCTool.class.getName());
    private static String insertTotalSql = "INSERT INTO zjjg_dqzwjhkjhzb (masterTabId, submitUnitCode, submitUnitName, dataYear, dataMonth, dataDate, submitter, submitTime, remark, groupCode, groupName, dataState, dataStatus) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static String insertDetailSql = "INSERT INTO zjjg_dqzwjhkjhmx (detailTabId, masterTabId, debtorCode, debtorName, debtType, debteeName, debtPrin, debtAnnlRate, loanDate, dueDate, dueAmtMonth, dueDateMonth, ifExecute, executePhase, remark, submitTime, dataStatus) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    @Override
    public void insert(MaturedDebtTotalVO totalVo) throws Exception, SQLException {
    }

    @Override
    public void insert(MaturedDebtTotalVO totalVo, ReportStorageSettingInfo reportStorageSettingInfo) throws Exception, SQLException {
        if (StorageType.dbStore.equals((Object)reportStorageSettingInfo.getStorageType())) {
            EReceiptDBInfo eReceiptDBInfo = new EReceiptDBInfo();
            eReceiptDBInfo.setDbType(reportStorageSettingInfo.getDbType());
            eReceiptDBInfo.setDbIP(reportStorageSettingInfo.getDbIP());
            eReceiptDBInfo.setDbPort(reportStorageSettingInfo.getDbPort());
            eReceiptDBInfo.setDbName(reportStorageSettingInfo.getDbName());
            eReceiptDBInfo.setDbUserName(reportStorageSettingInfo.getDbUserName());
            eReceiptDBInfo.setDbUserPwd(reportStorageSettingInfo.getDbPwd());
            Statement st = null;
            PreparedStatement ps = null;
            Connection conn = null;
            try {
                conn = DBCPConUtils.getConnection((EReceiptDBInfo)eReceiptDBInfo);
                ps = conn.prepareStatement(insertTotalSql);
                ps.setString(1, totalVo.getMasterTabId());
                ps.setString(2, totalVo.getSubmitUnitCode());
                ps.setString(3, totalVo.getSubmitUnitName());
                ps.setString(4, totalVo.getDataYear());
                ps.setString(5, totalVo.getDataMonth());
                ps.setString(6, totalVo.getDataDate());
                ps.setString(7, totalVo.getSubmitter());
                ps.setString(8, totalVo.getSubmitTime());
                ps.setString(9, totalVo.getRemark());
                ps.setString(10, totalVo.getGroupCode());
                ps.setString(11, totalVo.getGroupName());
                ps.setString(12, totalVo.getDataState());
                ps.setString(13, "0");
                ps.addBatch();
                ps.execute();
                conn.commit();
                this.logger.info((Object)"Insert success");
            }
            catch (Exception e) {
                e.printStackTrace();
                conn.rollback();
                throw new Exception(e);
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ps = null;
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public void batchInsert(MaturedDebtTotalVO totalVo, List<MaturedDebtDetailVO> detailList, ReportStorageSettingInfo reportStorageSettingInfo) throws Exception, SQLException {
        if (StorageType.dbStore.equals((Object)reportStorageSettingInfo.getStorageType())) {
            EReceiptDBInfo eReceiptDBInfo = new EReceiptDBInfo();
            eReceiptDBInfo.setDbType(reportStorageSettingInfo.getDbType());
            eReceiptDBInfo.setDbIP(reportStorageSettingInfo.getDbIP());
            eReceiptDBInfo.setDbPort(reportStorageSettingInfo.getDbPort());
            eReceiptDBInfo.setDbName(reportStorageSettingInfo.getDbName());
            eReceiptDBInfo.setDbUserName(reportStorageSettingInfo.getDbUserName());
            eReceiptDBInfo.setDbUserPwd(reportStorageSettingInfo.getDbPwd());
            Statement st = null;
            PreparedStatement ps = null;
            Connection conn = null;
            try {
                conn = DBCPConUtils.getConnection((EReceiptDBInfo)eReceiptDBInfo);
                ps = conn.prepareStatement(insertTotalSql);
                ps.setString(1, totalVo.getMasterTabId());
                ps.setString(2, totalVo.getSubmitUnitCode());
                ps.setString(3, totalVo.getSubmitUnitName());
                ps.setString(4, totalVo.getDataYear());
                ps.setString(5, totalVo.getDataMonth());
                ps.setString(6, totalVo.getDataDate());
                ps.setString(7, totalVo.getSubmitter());
                ps.setString(8, totalVo.getSubmitTime());
                ps.setString(9, totalVo.getRemark());
                ps.setString(10, totalVo.getGroupCode());
                ps.setString(11, totalVo.getGroupName());
                ps.setString(12, totalVo.getDataState());
                ps.setString(13, "0");
                ps.addBatch();
                ps.execute();
                if (!EmptyUtil.isEmpty(detailList)) {
                    ps = conn.prepareStatement(insertDetailSql);
                    for (int i = 0; i < detailList.size(); ++i) {
                        MaturedDebtDetailVO detailVO = detailList.get(i);
                        ps.setString(1, detailVO.getDetailTabId());
                        ps.setString(2, detailVO.getMasterTabId());
                        ps.setString(3, detailVO.getDebtorCode());
                        ps.setString(4, detailVO.getDebtorName());
                        ps.setString(5, detailVO.getDebtType());
                        ps.setString(6, detailVO.getDebteeName());
                        ps.setBigDecimal(7, detailVO.getDebtPrin());
                        ps.setBigDecimal(8, detailVO.getDebtAnnlRate());
                        ps.setDate(9, detailVO.getLoanDate());
                        ps.setDate(10, detailVO.getDueDate());
                        ps.setBigDecimal(11, detailVO.getDueAmtMonth());
                        ps.setDate(12, detailVO.getDueDateMonth());
                        ps.setString(13, detailVO.getIfExecute());
                        ps.setString(14, detailVO.getExecutePhase());
                        ps.setString(15, detailVO.getRemark());
                        ps.setString(16, detailVO.getSubmitTime());
                        ps.setString(17, "0");
                        ps.addBatch();
                    }
                    ps.executeBatch();
                }
                conn.commit();
                this.logger.info((Object)"batchInsert success");
            }
            catch (Exception e) {
                e.printStackTrace();
                conn.rollback();
                throw new Exception(e);
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ps = null;
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

