/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.sl.LoanContractAdjustCollection;
import com.kingdee.eas.fm.sl.LoanContractAdjustInfo;
import com.kingdee.eas.fm.sl.LoanContractExecuteEntryCollection;
import com.kingdee.eas.fm.sl.LoanContractExecuteEntryFactory;
import com.kingdee.eas.fm.sl.app.AbstractLoanContractAdjustControllerBean;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class LoanContractAdjustControllerBean
extends AbstractLoanContractAdjustControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.sl.app.LoanContractAdjustControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)((BillBaseInfo)model), (AbstractCoreBaseControllerBean)this);
        LoanContractAdjustInfo info = (LoanContractAdjustInfo)model;
        this.checkSameDay(ctx, info);
        this.checkAdjustDate(ctx, info);
        if (!this._exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId()))) {
            info = this.getCurrAdjustSeq(ctx, info);
        }
        String summary = "\u94f6\u56e2\u8d37\u6b3e" + info.getLoanContractNum() + "\u7b2c" + info.getAdjustSeq() + "\u6b21\u8c03\u606f";
        info.setSummary(summary);
        IObjectPK pkReturn = super._submit(ctx, (IObjectValue)info);
        this.createBotpWithLoanContract(ctx, info);
        return pkReturn;
    }

    private LoanContractAdjustInfo getCurrAdjustSeq(Context ctx, LoanContractAdjustInfo info) throws BOSException, EASBizException {
        int newAdjustSeq = 1;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        FilterInfo filter = new FilterInfo();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("adjustSeq"));
        filter.getFilterItems().add(new FilterItemInfo("sourceBillNum", (Object)info.getSourceBillNum().getId().toString()));
        view.setFilter(filter);
        LoanContractAdjustCollection colls = this.getLoanContractAdjustCollection(ctx, view);
        if (colls != null) {
            newAdjustSeq = colls.size() + 1;
        }
        info.setAdjustSeq(newAdjustSeq);
        return info;
    }

    private void checkSameDay(Context ctx, LoanContractAdjustInfo info) throws BOSException, EASBizException {
        String id = info.getSourceBillNum().getId().toString();
        String sql = "select fid from T_SL_LoanContractAdjust where FSourceBillNum = ? and FAdjustDate = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{id, info.getAdjustDate()});
        try {
            if (rs.next() && !(info.getId() + "").equals(rs.getString("fid"))) {
                throw new BEException(BEException.COMMON, new Object[]{"\u501f\u6b3e\u5408\u540c" + info.getSourceBillNum().getNumber() + "\u4e0d\u80fd\u6709\u540c\u4e00\u5929\u7684\u8c03\u606f\u5355"});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void createBotpWithLoanContract(Context ctx, LoanContractAdjustInfo info) throws BOSException, EASBizException {
        FinUtils.addBotRelation((Context)ctx, (String)info.getSourceBillNum().getId().toString(), (String)info.getId().toString());
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanContractAdjustInfo info = (LoanContractAdjustInfo)this.getValue(ctx, pk);
        if (info.isIsUsed()) {
            throw new BEException(BEException.COMMON, new Object[]{"\u672a\u4f7f\u7528\u7684\u5229\u7387\u8c03\u6574\u5355\u5141\u8bb8\u5220\u9664"});
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillNum", (Object)info.getSourceBillNum().getId().toString()));
        view.setFilter(filter);
        view.setSelector(sic);
        SorterItemInfo sorter = new SorterItemInfo("adjustSeq");
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorter.setSortType(SortType.DESCEND);
        sorterColl.add(sorter);
        view.setSorter(sorterColl);
        LoanContractAdjustCollection coll = this.getLoanContractAdjustCollection(ctx, view);
        if (!info.getId().equals((Object)coll.get(0).getId())) {
            throw new BEException(BEException.COMMON, new Object[]{"\u5229\u7387\u8c03\u6574\u5355\u5220\u9664\u5fc5\u987b\u6309\u8c03\u6574\u6b21\u6570\u4ece\u540e\u5f80\u524d\u987a\u5e8f\u5220\u9664"});
        }
        LoanContractAdjustControllerBean.removeBotpWithLoanContract(ctx, info);
        super._delete(ctx, pk);
    }

    public static void removeBotpWithLoanContract(Context ctx, LoanContractAdjustInfo info) throws BOSException, EASBizException {
        if (info == null || info.getId() == null) {
            return;
        }
        Object[] paramList = new Object[]{info.getId().toString()};
        String sql = "delete from T_BOT_Relation where fdestobjectid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])paramList);
    }

    private void checkAdjustDate(Context ctx, LoanContractAdjustInfo info) throws BOSException, EASBizException {
        Date minFetchDate = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("date"));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)info.getSourceBillNum().getId().toString()));
        view.setFilter(filter);
        view.setSelector(sic);
        SorterItemInfo sorter = new SorterItemInfo("date");
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorter.setSortType(SortType.ASCEND);
        sorterColl.add(sorter);
        view.setSorter(sorterColl);
        LoanContractExecuteEntryCollection colls = LoanContractExecuteEntryFactory.getLocalInstance(ctx).getLoanContractExecuteEntryCollection(view);
        if (colls != null && colls.size() > 0) {
            minFetchDate = colls.get(0).getDate();
        }
        if (minFetchDate != null && info.getAdjustDate().before(minFetchDate)) {
            throw new BEException(BEException.COMMON, new Object[]{"\u8c03\u6574\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u9996\u5f20\u63d0\u6b3e\u5355\u7684\u63d0\u6b3e\u65e5\u671f"});
        }
    }

    @Override
    protected Map _adjust(Context ctx, LoanContractAdjustInfo loanContractAdjustInfo) throws BOSException, EASBizException {
        HashMap resMap = new HashMap();
        IObjectPK pk = this._submit(ctx, (IObjectValue)loanContractAdjustInfo);
        HashSet<IObjectPK> createdIdSet = new HashSet<IObjectPK>();
        createdIdSet.add(pk);
        resMap.put("createdIdSet", createdIdSet);
        return resMap;
    }
}

