/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.LoanApplyBillInfo;
import com.kingdee.eas.fm.sl.FsBillStatusEnum;
import com.kingdee.eas.fm.sl.LoanContractExecuteEntryCollection;
import com.kingdee.eas.fm.sl.LoanContractExecuteEntryFactory;
import com.kingdee.eas.fm.sl.LoanContractExecuteEntryInfo;
import com.kingdee.eas.fm.sl.LoanContractInfo;
import com.kingdee.eas.fm.sl.LoanFetchFactory;
import com.kingdee.eas.fm.sl.LoanFetchInfo;
import com.kingdee.eas.fm.sl.LoanSLException;
import com.kingdee.eas.fm.sl.app.AbstractLoanContractControllerBean;
import com.kingdee.eas.fm.sl.app.SLAppUtils;
import com.kingdee.eas.fm.sl.util.SLUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LoanContractControllerBean
extends AbstractLoanContractControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.sl.app.LoanContractControllerBean");

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanContractInfo info = this.getLoanContractInfo(ctx, pk);
        if (info.getStatus() == FsBillStatusEnum.SAVE || info.getStatus() == FsBillStatusEnum.AUDIT) {
            throw new LoanSLException(LoanSLException.BILL_AUDIT_EXCEPTION, new Object[]{info.getNumber()});
        }
        UserInfo currentUser = (UserInfo)ctx.get((Object)"UserInfo");
        info.setAuditor(currentUser);
        info.setAuditorTime(new Timestamp(System.currentTimeMillis()));
        info.setStatus(FsBillStatusEnum.AUDIT);
        this.update(ctx, pk, info);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanContractInfo info = this.getLoanContractInfo(ctx, pk);
        if (info.getStatus() == FsBillStatusEnum.SAVE || info.getStatus() == FsBillStatusEnum.SUBMIT) {
            throw new LoanSLException(LoanSLException.BILL_UNAUDIT_EXCEPTION, new Object[]{info.getNumber()});
        }
        Set descSet = FMHelper.getDestBillIdSet((Context)ctx, (String)info.getId().toString());
        if (descSet.size() > 0) {
            throw new LoanSLException(LoanSLException.BILL_UNAUDIT_EXCEPTION, new Object[]{info.getNumber()});
        }
        info.setAuditor(null);
        info.setAuditorTime(null);
        info.setStatus(FsBillStatusEnum.SAVE);
        this.update(ctx, pk, info);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanContractInfo info = (LoanContractInfo)model;
        this.checkExesitsDBFetchNumber(ctx, info);
        this.isAuditModify(ctx, info);
        info.setStatus(FsBillStatusEnum.SUBMIT);
        this.updateLoanApplyBill(ctx, info, true);
        IObjectPK pk = super._submitOther(ctx, (IObjectValue)info);
        SLAppUtils.removeBotpRelation(ctx, info);
        SLAppUtils.createBotpRelation(ctx, info);
        SLAppUtils.createBotpWithLoanApply(ctx, info);
        return pk;
    }

    private void isAuditModify(Context ctx, LoanContractInfo info) throws BOSException, EASBizException {
        ObjectUuidPK PK = new ObjectUuidPK(info.getId());
        boolean exist = this.exists(ctx, (IObjectPK)PK);
        LoanContractInfo oldInfo = null;
        if (exist) {
            oldInfo = this.getLoanContractInfo(ctx, (IObjectPK)PK);
        }
        if (oldInfo != null && info.getStatus() != oldInfo.getStatus() && oldInfo.getStatus() == FsBillStatusEnum.AUDIT) {
            throw new BEException(BEException.COMMON, new Object[]{"\u5f53\u524d\u8bb0\u5f55\u5df2\u7ecf\u5ba1\u6279\uff0c\u4e0d\u80fd\u63d0\u4ea4"});
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanContractInfo info = this.getLoanContractInfo(ctx, pk);
        this.updateLoanApplyBill(ctx, info, false);
        super._deleteOther(ctx, pk);
        SLAppUtils.removeBotpRelation(ctx, info);
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanContractInfo info = (LoanContractInfo)model;
        this.checkExesitsDBFetchNumber(ctx, info);
        this.isAuditModify(ctx, info);
        return super._saveOther(ctx, (IObjectValue)info);
    }

    private void checkExesitsDBFetchNumber(Context ctx, LoanContractInfo info) throws BOSException, EASBizException {
        if (!info.isHistoryBill()) {
            return;
        }
        CompanyOrgUnitInfo currCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        if (FMHelper.isEmpty((CoreBaseInfo)currCompany)) {
            return;
        }
        String needCheckFetchNumber = "";
        LoanContractExecuteEntryCollection coll = info.getLoanContractExecuteEntry();
        if (!FMHelper.isEmpty((AbstractObjectCollection)coll) && coll.size() > 0) {
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                LoanContractExecuteEntryInfo entryInfo = (LoanContractExecuteEntryInfo)it.next();
                BOSUuid fid = entryInfo.getId();
                String number = entryInfo.getFetchAmountNo();
                if (FMHelper.isEmpty((Object)fid)) {
                    needCheckFetchNumber = needCheckFetchNumber + "'" + number + "',";
                    continue;
                }
                ObjectStringPK pk = new ObjectStringPK(fid.toString());
                LoanContractExecuteEntryInfo existsEntryInfo = this.getLoanContractExecuteEntryInfo(ctx, (IObjectPK)pk);
                if (FMHelper.isEmpty((CoreBaseInfo)existsEntryInfo) || FMHelper.isEmpty((String)number) || number.equals(existsEntryInfo.getFetchAmountNo())) continue;
                needCheckFetchNumber = needCheckFetchNumber + "'" + number + "',";
            }
        }
        LoanFetchFactory.getLocalInstance(ctx).existsFetchNumber(needCheckFetchNumber, currCompany.getId().toString());
    }

    private LoanContractExecuteEntryInfo getLoanContractExecuteEntryInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return LoanContractExecuteEntryFactory.getLocalInstance(ctx).getLoanContractExecuteEntryInfo(pk);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanContractInfo info = (LoanContractInfo)model;
        SLAppUtils.createBotpWithLoanApply(ctx, info);
        IObjectPK pkReturn = super._addnewOther(ctx, model);
        return pkReturn;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._updateOther(ctx, pk, model);
    }

    protected void updateLoanApplyBill(Context ctx, LoanContractInfo info, boolean isCreateToLoan) throws BOSException, EASBizException {
        String sourceBillId = info.getSourceBillId();
        if (sourceBillId == null || "".equals(sourceBillId.trim())) {
            return;
        }
        BOSObjectType bosType = BOSUuid.read((String)sourceBillId).getType();
        if (bosType.equals((Object)new LoanApplyBillInfo().getBOSType())) {
            String updateSQl = "update T_FIN_LoanApplyBill set FIsGenLoanBill = ?  where fid = ?";
            DbUtil.execute((Context)ctx, (String)updateSQl, (Object[])new Object[]{isCreateToLoan, sourceBillId});
        }
    }

    @Override
    protected void _extension(Context ctx, IObjectPK pk, Date extensionTime) throws BOSException, EASBizException {
        LoanContractInfo info = this.getLoanContractInfo(ctx, pk);
        if (FMHelper.isEmpty((CoreBaseInfo)info)) {
            return;
        }
        BigDecimal totalFetchAmount = info.getTotalFetchAmount();
        BigDecimal totalBalance = info.getTotalBalance();
        if (FMHelper.isEmpty((Object)totalFetchAmount) || totalFetchAmount.compareTo(Constants.ZERO) <= 0) {
            throw new LoanSLException(LoanSLException.NOT_FETCH_EXCEPTION, new Object[]{info.getNumber()});
        }
        if (FMHelper.isEmpty((Object)totalBalance) || totalBalance.compareTo(Constants.ZERO) == 0) {
            throw new LoanSLException(LoanSLException.REPAY_ALL_EXCEPTION, new Object[]{info.getNumber()});
        }
        info.setIsExtension(true);
        info.setExtensionDate(info.getExpiredDate());
        info.setExpiredDate(extensionTime);
        this.update(ctx, pk, info);
        LoanFetchFactory.getLocalInstance(ctx).contractExtension(info.getId().toString(), extensionTime, true);
    }

    @Override
    protected void _cancelExtension(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanContractInfo info = this.getLoanContractInfo(ctx, pk);
        if (FMHelper.isEmpty((CoreBaseInfo)info)) {
            return;
        }
        if (!info.isIsExtension()) {
            throw new LoanSLException(LoanSLException.NOT_EXTENDSION_EXCEPTION, new Object[]{info.getNumber()});
        }
        info.setIsExtension(false);
        info.setExpiredDate(info.getExtensionDate());
        info.setExtensionDate(null);
        this.update(ctx, pk, info);
        LoanFetchFactory.getLocalInstance(ctx).contractExtension(info.getId().toString(), null, false);
    }

    @Override
    protected void _fetchForWrite(Context ctx, IObjectValue loanFetchInfo) throws BOSException, EASBizException {
        LoanFetchInfo fetchInfo = (LoanFetchInfo)loanFetchInfo;
        if (FMHelper.isEmpty((Object)loanFetchInfo)) {
            return;
        }
        ObjectUuidPK PK = new ObjectUuidPK(fetchInfo.getId());
        boolean existsFlag = LoanFetchFactory.getLocalInstance(ctx).exists((IObjectPK)PK);
        if (fetchInfo.getStatus() == FsBillStatusEnum.SUBMIT && !existsFlag) {
            throw new BEException(BEException.COMMON, new Object[]{"\u8be5\u8bb0\u5f55\u5df2\u4e0d\u5b58\u5728"});
        }
        LoanFetchInfo oldFetchInfo = null;
        if (existsFlag) {
            oldFetchInfo = LoanFetchFactory.getLocalInstance(ctx).getLoanFetchInfo((IObjectPK)PK);
        }
        ObjectStringPK pk = new ObjectStringPK(fetchInfo.getSourceBillId());
        LoanContractInfo loanContractInfo = this.getLoanContractInfo(ctx, (IObjectPK)pk);
        Map retrunMap = this.getPreviousLoanFetchDeleteData(ctx, fetchInfo, oldFetchInfo);
        Date preFetchDate = (Date)retrunMap.get("preFetchDate");
        Date nextFetchDate = (Date)retrunMap.get("nextFetchDate");
        if (preFetchDate != null && fetchInfo.getIssueDate() != null && fetchInfo.getIssueDate().before(preFetchDate)) {
            throw new BEException(BEException.COMMON, new Object[]{"\u8d77\u59cb\u65e5\u4e0d\u80fd\u5c0f\u4e8e\u4e0a\u4e00\u5f20\u63d0\u6b3e\u5355\u7684\u8d77\u59cb\u65e5"});
        }
        if (nextFetchDate != null && fetchInfo.getIssueDate() != null && nextFetchDate.before(fetchInfo.getIssueDate())) {
            throw new BEException(BEException.COMMON, new Object[]{"\u8d77\u59cb\u65e5\u4e0d\u80fd\u5927\u4e8e\u4e0b\u4e00\u5f20\u63d0\u6b3e\u5355\u7684\u8d77\u59cb\u65e5"});
        }
        int currentSeq = (Integer)retrunMap.get("fetchSeq");
        BigDecimal amount = (BigDecimal)retrunMap.get("notFetchAmount");
        BigDecimal thisAmount = SLAppUtils.getBigDecimalValue(fetchInfo.getAmount());
        if (thisAmount.compareTo(amount) > 0) {
            throw new BEException(BEException.COMMON, new Object[]{"\u672c\u6b21\u63d0\u6b3e\u989d\u4e0d\u80fd\u5927\u4e8e\u5c1a\u672a\u63d0\u6b3e\u989d"});
        }
        BigDecimal fetchAmount = SLAppUtils.getBigDecimalValue(fetchInfo.getAmount());
        BigDecimal oldFetchAmount = oldFetchInfo != null ? SLAppUtils.getBigDecimalValue(oldFetchInfo.getAmount()) : Constants.ZERO;
        BigDecimal notFetchAmount = loanContractInfo.getBalance();
        BigDecimal totalFetchAmount = SLAppUtils.getBigDecimalValue(loanContractInfo.getTotalFetchAmount());
        BigDecimal totalBalance = SLAppUtils.getBigDecimalValue(loanContractInfo.getTotalBalance());
        if (this.isWriteContract(ctx, fetchInfo.getNumber())) {
            loanContractInfo.setBalance(notFetchAmount.add(oldFetchAmount).subtract(fetchAmount));
            loanContractInfo.setTotalFetchAmount(totalFetchAmount.add(fetchAmount).subtract(oldFetchAmount));
            loanContractInfo.setTotalBalance(totalBalance.add(fetchAmount).subtract(oldFetchAmount));
        } else {
            loanContractInfo.setBalance(notFetchAmount.subtract(fetchAmount));
            loanContractInfo.setTotalFetchAmount(totalFetchAmount.add(fetchAmount));
            loanContractInfo.setTotalBalance(totalBalance.add(fetchAmount));
        }
        if (fetchInfo.getFetchSeq() == 1) {
            loanContractInfo.setFirstFetchDate(fetchInfo.getIssueDate());
            int horizon = FMHelper.isEmpty((Object)loanContractInfo.getHorizon()) ? 0 : loanContractInfo.getHorizon().intValue();
            Date expiredDate = SLUtils.addManyMonthDay(fetchInfo.getIssueDate(), horizon);
            loanContractInfo.setExpiredDate(expiredDate);
        }
        fetchInfo.setFetchSeq(currentSeq);
        fetchInfo.setNotFetchAmount(amount);
        this.update(ctx, (IObjectPK)pk, loanContractInfo);
        LoanContractExecuteEntryFactory.getLocalInstance(ctx).updateContractExecuteEntrys(fetchInfo, loanContractInfo);
    }

    private boolean isWriteContract(Context ctx, String fetchNumber) throws BOSException, EASBizException {
        if (fetchNumber == null) {
            return false;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fetchAmountNo", (Object)fetchNumber));
        return LoanContractExecuteEntryFactory.getLocalInstance(ctx).exists(filter);
    }

    private Map getPreviousLoanFetchDeleteData(Context ctx, LoanFetchInfo fetchInfo, LoanFetchInfo oldFetchInfo) throws BOSException, EASBizException {
        HashMap<String, Serializable> valueMap = new HashMap<String, Serializable>();
        Date preFetchDate = null;
        Date nextFetchDate = null;
        int seq = 0;
        if (fetchInfo == null || fetchInfo.getSourceBillId() == null) {
            return valueMap;
        }
        boolean currStauts = this.isWriteContract(ctx, fetchInfo.getNumber());
        BigDecimal loanPromiseAmount = fetchInfo.getLoanPromiseAmount();
        BigDecimal overFetchAmount = Constants.ZERO;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterFetch = new FilterInfo();
        SelectorItemCollection sicFetch = new SelectorItemCollection();
        sicFetch.add(new SelectorItemInfo("fetchAmountSeq"));
        sicFetch.add(new SelectorItemInfo("seq"));
        sicFetch.add(new SelectorItemInfo("amount"));
        sicFetch.add(new SelectorItemInfo("date"));
        filterFetch.getFilterItems().add(new FilterItemInfo("parent.id", (Object)fetchInfo.getSourceBillId()));
        view.setFilter(filterFetch);
        view.setSelector(sicFetch);
        SorterItemInfo sorterFetch = new SorterItemInfo("fetchAmountSeq");
        SorterItemCollection sorterCollFetch = new SorterItemCollection();
        sorterFetch.setSortType(SortType.ASCEND);
        sorterCollFetch.add(sorterFetch);
        view.setSorter(sorterCollFetch);
        LoanContractExecuteEntryCollection colls = LoanContractExecuteEntryFactory.getLocalInstance(ctx).getLoanContractExecuteEntryCollection(view);
        if (colls != null && colls.size() > 0) {
            seq = colls.size();
        }
        int currSeq = 0;
        currSeq = currStauts ? oldFetchInfo.getFetchSeq() : seq + 1;
        int i = 0;
        LoanContractExecuteEntryInfo entryInfo = null;
        Iterator it = colls.iterator();
        while (it.hasNext()) {
            entryInfo = (LoanContractExecuteEntryInfo)it.next();
            if (++i == currSeq - 1) {
                preFetchDate = entryInfo.getDate();
            }
            if (i == currSeq + 1) {
                nextFetchDate = entryInfo.getDate();
            }
            if (currStauts && i >= currSeq) continue;
            overFetchAmount = overFetchAmount.add(entryInfo.getAmount());
        }
        BigDecimal notFetchAmount = loanPromiseAmount.subtract(overFetchAmount);
        valueMap.put("fetchSeq", new Integer(currSeq));
        valueMap.put("notFetchAmount", notFetchAmount);
        valueMap.put("preFetchDate", preFetchDate);
        valueMap.put("nextFetchDate", nextFetchDate);
        return valueMap;
    }
}

