/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.SQLUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.StrikeEnum;
import com.kingdee.eas.fm.im.IntCalTypeEnum;
import com.kingdee.eas.fm.im.util.AbstractIntCalStragety;
import com.kingdee.eas.fm.im.util.IAdjustIntRateCollection;
import com.kingdee.eas.fm.im.util.ILoanInfo;
import com.kingdee.eas.fm.im.util.IRepaymentBillCollection;
import com.kingdee.eas.fm.im.util.IRepaymentBillInfo;
import com.kingdee.eas.fm.im.util.IntCalModel;
import com.kingdee.eas.fm.im.util.LoanInterestEntryCollection;
import com.kingdee.eas.fm.im.util.LoanInterestEntryInfo;
import com.kingdee.eas.fm.im.util.LoanInterestInfo;
import com.kingdee.eas.fm.ivt.CHLoanException;
import com.kingdee.eas.fm.sl.ImLoanContractAdjustIntRateCollection;
import com.kingdee.eas.fm.sl.ImLoanContractExeInfo;
import com.kingdee.eas.fm.sl.ImLoanContractRepayDetailCollection;
import com.kingdee.eas.fm.sl.ImLoanContractRepayDetailInfo;
import com.kingdee.eas.fm.sl.LoanContractAdjustCollection;
import com.kingdee.eas.fm.sl.LoanContractAdjustFactory;
import com.kingdee.eas.fm.sl.LoanContractAdjustInfo;
import com.kingdee.eas.fm.sl.LoanContractExecuteEntryCollection;
import com.kingdee.eas.fm.sl.LoanContractExecuteEntryFactory;
import com.kingdee.eas.fm.sl.LoanContractExecuteEntryInfo;
import com.kingdee.eas.fm.sl.LoanContractFactory;
import com.kingdee.eas.fm.sl.LoanContractInfo;
import com.kingdee.eas.fm.sl.LoanContractInterestCollection;
import com.kingdee.eas.fm.sl.LoanContractInterestEntryCollection;
import com.kingdee.eas.fm.sl.LoanContractInterestEntryInfo;
import com.kingdee.eas.fm.sl.LoanContractInterestFactory;
import com.kingdee.eas.fm.sl.LoanContractInterestInfo;
import com.kingdee.eas.fm.sl.LoanContractRepayCollection;
import com.kingdee.eas.fm.sl.LoanContractRepayDetailCollection;
import com.kingdee.eas.fm.sl.LoanContractRepayDetailFactory;
import com.kingdee.eas.fm.sl.LoanContractRepayDetailInfo;
import com.kingdee.eas.fm.sl.LoanContractRepayFactory;
import com.kingdee.eas.fm.sl.LoanContractRepayInfo;
import com.kingdee.eas.fm.sl.LoanFetchCollection;
import com.kingdee.eas.fm.sl.LoanFetchFactory;
import com.kingdee.eas.fm.sl.LoanFetchInfo;
import com.kingdee.eas.fm.sl.LoanSLException;
import com.kingdee.eas.fm.sl.SLInterestStatusEnum;
import com.kingdee.eas.fm.sl.app.AbstractLoanContractInterestControllerBean;
import com.kingdee.eas.fm.sl.app.SLAppUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgControlFacadeFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class LoanContractInterestControllerBean
extends AbstractLoanContractInterestControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.sl.app.LoanContractInterestControllerBean");
    private Date minBeginDate = null;
    private Date maxEndDate = null;
    private int countDays = 0;
    private int overDays = 0;
    private BigDecimal Principal = Constants.ZERO;
    private BigDecimal rate = Constants.ZERO;
    private BigDecimal punishIntRate = Constants.ZERO;
    private BigDecimal punishInterest = Constants.ZERO;
    private BigDecimal interest = Constants.ZERO;
    private static Map imMap = new HashMap();
    private static Map botpRelationShip = new HashMap();

    @Override
    public IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanContractInterestInfo info = (LoanContractInterestInfo)model;
        IObjectPK pk = super._addnew(ctx, model);
        boolean isRepayCalInt = false;
        boolean isWriteFetchDate = false;
        boolean isWriteCalDate = false;
        if (info.getInterestType() == IntCalTypeEnum.PRE_INT) {
            isWriteFetchDate = true;
        }
        if (info.getInterestType() == IntCalTypeEnum.PAY_INT) {
            isWriteCalDate = true;
        }
        if (info.getInterestType() == IntCalTypeEnum.REPAY_INT) {
            isWriteCalDate = true;
            isRepayCalInt = true;
        }
        LoanContractInterestEntryCollection iCol = info.getEntry();
        for (int i = 0; i < iCol.size(); ++i) {
            LoanContractInterestEntryInfo entryInfo = iCol.get(i);
            if (FMHelper.isEmpty((String)entryInfo.getAdjustId())) continue;
            this.saveBOTPRelationShipLoanContractAdjust(ctx, entryInfo.getAdjustId(), info);
        }
        FinUtils.addBotRelation((Context)ctx, (String)info.getSourceBillNum().getId().toString(), (String)info.getId().toString());
        if (info.getFetchIntMap().size() > 0) {
            Map fetchIntMap = info.getFetchIntMap();
            for (String fetchNumber : fetchIntMap.keySet()) {
                LoanFetchInfo fetchInfo = this.getLoanFetchInfoByFetchNumber(ctx, fetchNumber);
                if (fetchInfo != null) {
                    FinUtils.addBotRelation((Context)ctx, (String)fetchInfo.getId().toString(), (String)info.getId().toString());
                }
                if (!isRepayCalInt) {
                    this.updateLoanFetch(ctx, fetchNumber, info, true, isWriteFetchDate, isWriteCalDate);
                    this.updateLoanContractExecuteEntry(ctx, fetchNumber, info, true, isWriteFetchDate, isWriteCalDate);
                    continue;
                }
                this.updateFetchAndExecuteWithRepayCalInt(ctx, info, true);
            }
        }
        info.setIsGenPayBill(false);
        this.afterLoanContractInterestCreated(ctx, info);
        return pk;
    }

    private void afterLoanContractInterestCreated(Context ctx, LoanContractInterestInfo infoInt) throws EASBizException, BOSException {
        if (infoInt.getInterestType().getValue() == 4) {
            this.recIntStrike(ctx, infoInt);
        } else if (infoInt.getInterestType().getValue() == 0 || infoInt.getInterestType().getValue() == 2) {
            // empty if block
        }
    }

    private void recIntStrike(Context ctx, LoanContractInterestInfo interestInfo) throws BOSException {
        SQLUtil sql1 = new SQLUtil();
        sql1.appendSql("update T_sl_LoanContractInterest set FStrikeStatus=? , FStrikeID=? ");
        sql1.appendSql("where FEndDate<=?  and FInterestType = 0 and FSourceBillNum = ? and (FStatus=0 or FStatus=1) and FStrikeStatus=?");
        sql1.addParams(new Object[]{"striked", interestInfo.getId().toString(), new java.sql.Date(DateUtil.getAfterDay((Date)interestInfo.getEndDate()).getTime()), interestInfo.getSourceBillNum().getId().toString(), "null"});
        sql1.execute(ctx);
    }

    @Override
    protected Map _recInt(Context ctx, Date startDate, Date endDate, LoanContractInfo loanContractInfo) throws BOSException, EASBizException {
        HashMap hm = new HashMap();
        HashSet<IObjectPK> createdIntReceivedID = new HashSet<IObjectPK>();
        LoanContractExecuteEntryCollection colls = this.getLoanContractExecuteEntryCollection(ctx, loanContractInfo);
        if (colls != null && colls.size() == 0) {
            throw new BEException(BEException.COMMON, new Object[]{"\u501f\u6b3e\u5408\u540c\u5df2\u7ecf\u5168\u989d\u8fd8\u6b3e"});
        }
        LoanContractRepayDetailCollection repayDetailCol = null;
        LoanContractAdjustCollection adjustCol = this.getAdjustColl(ctx, loanContractInfo);
        LoanContractRepayInfo[] infos = null;
        LoanInterestInfo imIntInfo = null;
        LinkedHashMap<String, LoanInterestInfo> fetchIntMap = new LinkedHashMap<String, LoanInterestInfo>();
        Date tempStartDate = null;
        Iterator it = colls.iterator();
        while (it.hasNext()) {
            LoanContractExecuteEntryInfo contractExecuteEntryInfo = (LoanContractExecuteEntryInfo)it.next();
            String fetchNumber = contractExecuteEntryInfo.getFetchAmountNo();
            tempStartDate = this.getRecStartDate(startDate, contractExecuteEntryInfo.getLastCalInterestDate());
            repayDetailCol = this.getLoanContractRepayDetailCollection(ctx, null, fetchNumber);
            infos = this.getLoanContractRepayInfos(ctx, repayDetailCol, null);
            if (!endDate.after(tempStartDate)) continue;
            IntCalModel model = this.getIntCalModel(startDate, endDate, loanContractInfo, contractExecuteEntryInfo, adjustCol, repayDetailCol, infos, null, null);
            imIntInfo = AbstractIntCalStragety.getInstance((IntCalTypeEnum)IntCalTypeEnum.PAY_INT).calInt(ctx, model);
            fetchIntMap.put(fetchNumber, imIntInfo);
        }
        if (fetchIntMap.size() == 0) {
            throw new BEException(BEException.COMMON, new Object[]{"\u501f\u6b3e\u5408\u540c\u4e0b\u6240\u6709\u63d0\u6b3e\u5355\u7684\u8ba1\u606f\u5f00\u59cb\u65e5\u90fd\u665a\u4e8e\u8ba1\u606f\u7ed3\u675f\u65e5"});
        }
        LoanContractInterestInfo loanContractInterestInfo = this.transferLoanContractInterestInfo(ctx, fetchIntMap, loanContractInfo, null);
        IObjectPK pk = this._submit(ctx, (IObjectValue)loanContractInterestInfo);
        createdIntReceivedID.add(pk);
        hm.put("createdID", createdIntReceivedID);
        return hm;
    }

    @Override
    protected Map _preInt(Context ctx, Date startDate, Date endDate, LoanContractInfo loanContractInfo) throws BOSException, EASBizException {
        HashMap hm = new HashMap();
        HashSet<IObjectPK> createdIntReceivedID = new HashSet<IObjectPK>();
        LoanContractExecuteEntryCollection colls = this.getLoanContractExecuteEntryCollection(ctx, loanContractInfo);
        if (colls != null && colls.size() == 0) {
            throw new BEException(BEException.COMMON, new Object[]{"\u501f\u6b3e\u5408\u540c\u5df2\u7ecf\u5168\u989d\u8fd8\u6b3e"});
        }
        LoanContractRepayDetailCollection repayDetailCol = null;
        LoanContractAdjustCollection adjustCol = this.getAdjustColl(ctx, loanContractInfo);
        LoanContractRepayInfo[] infos = null;
        LinkedHashMap<String, LoanInterestInfo> fetchIntMap = new LinkedHashMap<String, LoanInterestInfo>();
        LoanInterestInfo imIntInfo = null;
        Date tempStartDate = null;
        Iterator it = colls.iterator();
        while (it.hasNext()) {
            LoanContractExecuteEntryInfo contractExecuteEntryInfo = (LoanContractExecuteEntryInfo)it.next();
            String fetchNumber = contractExecuteEntryInfo.getFetchAmountNo();
            tempStartDate = this.getPreStartDate(startDate, contractExecuteEntryInfo.getLastFetchDate(), contractExecuteEntryInfo.getLastCalInterestDate());
            repayDetailCol = this.getLoanContractRepayDetailCollection(ctx, null, fetchNumber);
            infos = this.getLoanContractRepayInfos(ctx, repayDetailCol, null);
            if (!endDate.after(tempStartDate)) continue;
            IntCalModel model = this.getIntCalModel(startDate, endDate, loanContractInfo, contractExecuteEntryInfo, adjustCol, repayDetailCol, infos, null, null);
            imIntInfo = AbstractIntCalStragety.getInstance((IntCalTypeEnum)IntCalTypeEnum.PRE_INT).calInt(ctx, model);
            fetchIntMap.put(fetchNumber, imIntInfo);
        }
        if (fetchIntMap.size() == 0) {
            throw new BEException(BEException.COMMON, new Object[]{"\u501f\u6b3e\u5408\u540c\u4e0b\u6240\u6709\u63d0\u6b3e\u5355\u7684\u8ba1\u606f\u5f00\u59cb\u65e5\u90fd\u665a\u4e8e\u8ba1\u606f\u7ed3\u675f\u65e5"});
        }
        LoanContractInterestInfo loanContractInterestInfo = this.transferLoanContractInterestInfo(ctx, fetchIntMap, loanContractInfo, null);
        IObjectPK pk = super.save(ctx, (CoreBaseInfo)loanContractInterestInfo);
        createdIntReceivedID.add(pk);
        hm.put("createdID", createdIntReceivedID);
        return hm;
    }

    private void saveBOTPRelationShipLoanContractAdjust(Context ctx, String adjustBillId, LoanContractInterestInfo loanContractInterestInfo) throws BOSException, EASBizException {
        String sql = " update t_sl_loancontractadjust set FIsUsed = 1 where fid = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{adjustBillId});
        FinUtils.addBotRelation((Context)ctx, (String)adjustBillId, (String)loanContractInterestInfo.getId().toString());
    }

    private void updateLoanFetch(Context ctx, String fetchNumber, LoanContractInterestInfo imInfo, boolean isAddNew, boolean isWriteFetchDate, boolean isWriteCalDate) throws BOSException, EASBizException {
        LoanFetchInfo info;
        block5: {
            block6: {
                block4: {
                    Date lastCalDate;
                    info = this.getLoanFetchInfoByFetchNumber(ctx, fetchNumber);
                    if (info == null) {
                        return;
                    }
                    if (!isAddNew) break block4;
                    Date date = lastCalDate = imInfo.getLastCalDateMap().get(fetchNumber) == null ? null : (Date)imInfo.getLastCalDateMap().get(fetchNumber);
                    if (isWriteFetchDate) {
                        info.setOldLastFetchDate(lastCalDate);
                        info.setLastFetchDate(imInfo.getEndDate());
                    }
                    if (!isWriteCalDate) break block5;
                    info.setOldLastCalDate(lastCalDate);
                    info.setLastCalDate(imInfo.getEndDate());
                    break block5;
                }
                if (!imInfo.getInterestType().equals((Object)IntCalTypeEnum.REPAY_INT)) break block6;
                if (!isWriteCalDate) break block5;
                info.setLastCalDate(info.getOldLastCalDate());
                break block5;
            }
            LoanContractInterestEntryCollection coll = imInfo.getEntry();
            for (int i = 0; i < coll.size(); ++i) {
                if (!coll.get(i).getFetchNumer().equals(fetchNumber)) continue;
                Date lastCalDate = coll.get(i).getLastCalIntDate();
                if (isWriteFetchDate) {
                    info.setLastFetchDate(lastCalDate);
                }
                if (!isWriteCalDate) break;
                info.setLastCalDate(lastCalDate);
                break;
            }
        }
        LoanFetchFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId()), info);
    }

    private void updateLoanContractExecuteEntry(Context ctx, String fetchNumber, LoanContractInterestInfo imInfo, boolean isAddNew, boolean isWriteFetchDate, boolean isWriteCalDate) throws BOSException, EASBizException {
        LoanContractExecuteEntryInfo executeEntryInfo;
        block6: {
            block7: {
                block5: {
                    Date lastCalDate;
                    executeEntryInfo = this.getLoanContractExecuteInfo(ctx, fetchNumber);
                    if (executeEntryInfo == null) {
                        return;
                    }
                    if (!isAddNew) break block5;
                    Date date = lastCalDate = imInfo.getLastCalDateMap().get(fetchNumber) == null ? null : (Date)imInfo.getLastCalDateMap().get(fetchNumber);
                    if (!imInfo.getInterestType().equals((Object)IntCalTypeEnum.REPAY_INT)) {
                        lastCalDate = imInfo.getLastIntDate();
                    }
                    if (isWriteFetchDate) {
                        executeEntryInfo.setOldLastFetchDate(lastCalDate);
                        executeEntryInfo.setLastFetchDate(imInfo.getEndDate());
                    }
                    if (!isWriteCalDate) break block6;
                    executeEntryInfo.setOldLastCalInterestDate(lastCalDate);
                    executeEntryInfo.setLastCalInterestDate(imInfo.getEndDate());
                    break block6;
                }
                if (!imInfo.getInterestType().equals((Object)IntCalTypeEnum.REPAY_INT)) break block7;
                if (!isWriteCalDate) break block6;
                executeEntryInfo.setLastCalInterestDate(executeEntryInfo.getOldLastCalInterestDate());
                break block6;
            }
            LoanContractInterestEntryCollection coll = imInfo.getEntry();
            for (int i = 0; i < coll.size(); ++i) {
                if (!coll.get(i).getFetchNumer().equals(fetchNumber)) continue;
                Date lastCalDate = coll.get(i).getLastCalIntDate();
                if (isWriteFetchDate) {
                    executeEntryInfo.setLastFetchDate(lastCalDate);
                }
                if (!isWriteCalDate) break;
                executeEntryInfo.setLastCalInterestDate(lastCalDate);
                break;
            }
        }
        LoanContractExecuteEntryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(executeEntryInfo.getId()), executeEntryInfo);
    }

    private LoanFetchInfo getLoanFetchInfoByFetchNumber(Context ctx, String fetchNumber) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)fetchNumber));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("lastFetchDate"));
        evi.getSelector().add(new SelectorItemInfo("lastCalDate"));
        evi.getSelector().add(new SelectorItemInfo("oldLastFetchDate"));
        evi.getSelector().add(new SelectorItemInfo("oldLastCalDate"));
        LoanFetchCollection coll = LoanFetchFactory.getLocalInstance(ctx).getLoanFetchCollection(evi);
        if (coll != null) {
            return coll.get(0);
        }
        return null;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanContractInterestInfo info = this.getLoanContractInterestInfo(ctx, pk);
        this.deleteCheck(ctx, info);
        this.afterDelete(ctx, info);
        if (info.getInterestType().equals((Object)IntCalTypeEnum.REPAY_INT)) {
            this.updateFetchAndExecuteWithRepayCalInt(ctx, info, false);
        } else {
            HashSet<String> fetchSet = new HashSet<String>();
            boolean isPreInt = info.getInterestType().equals((Object)IntCalTypeEnum.PRE_INT);
            boolean isRecInt = info.getInterestType().equals((Object)IntCalTypeEnum.PAY_INT);
            for (int i = 0; i < info.getEntry().size(); ++i) {
                LoanContractInterestEntryInfo entryInfo = info.getEntry().get(i);
                if (fetchSet.contains(entryInfo.getFetchNumer())) continue;
                this.updateLoanFetch(ctx, entryInfo.getFetchNumer(), info, false, isPreInt, isRecInt);
                this.updateLoanContractExecuteEntry(ctx, entryInfo.getFetchNumer(), info, false, isPreInt, isRecInt);
                fetchSet.add(entryInfo.getFetchNumer());
            }
        }
        Map relMap = this.getAdjustRelation(ctx, info);
        BgControlFacadeFactory.getLocalInstance((Context)ctx).cancelRequestBudget(pk.toString());
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
        super._delete(ctx, pk);
        this.deleteAfterRemoveBotp(ctx, pk);
        this.updateAdjust(ctx, info, relMap);
    }

    private void deleteAfterRemoveBotp(Context ctx, IObjectPK pk) throws BOSException {
        Object[] paramList = new Object[]{pk.toString()};
        String sql = "delete from T_BOT_Relation where fdestobjectid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])paramList);
    }

    private Map getAdjustRelation(Context ctx, LoanContractInterestInfo info) throws BOSException, EASBizException {
        HashMap<String, Object> relMap = new HashMap<String, Object>();
        Connection cn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = " select FSrcEntityID,FDestEntityID,FSrcObjectID from t_bot_relation where FDestObjectID = ? and FSrcEntityID = ? ";
        try {
            cn = this.getConnection(ctx);
            String srcEntityID = null;
            String destEntityID = null;
            String srcObjectID = null;
            pstmt = cn.prepareStatement(sql);
            pstmt.setString(1, info.getId().toString());
            pstmt.setString(2, LoanContractAdjustInfo.BOSTYPE.toString());
            rs = pstmt.executeQuery();
            int number = 0;
            while (rs.next()) {
                srcEntityID = rs.getString(1);
                destEntityID = rs.getString(2);
                srcObjectID = rs.getString(3);
                relMap.put("srcEntityID" + ++number, srcEntityID);
                relMap.put("destEntityID" + number, destEntityID);
                relMap.put("srcObjectID" + number, srcObjectID);
            }
            relMap.put("number", new Integer(number));
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
        return relMap;
    }

    private void updateAdjust(Context ctx, LoanContractInterestInfo info, Map relMap) throws BOSException, EASBizException {
        String sql1 = " select FID from t_bot_relation where FSrcObjectID = ? and FSrcEntityID =? ";
        int number = (Integer)relMap.get("number");
        Connection cn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        cn = this.getConnection(ctx);
        try {
            for (int i = 1; i <= number; ++i) {
                String srcObjectID = relMap.get("srcObjectID" + i).toString();
                String srcEntityID = relMap.get("srcEntityID" + i).toString();
                String fid = null;
                if (pstmt != null) {
                    pstmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
                pstmt = cn.prepareStatement(sql1);
                pstmt.setString(1, srcObjectID);
                pstmt.setString(2, srcEntityID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    fid = rs.getString(1);
                }
                if (fid != null) continue;
                String sql2 = " update T_SL_LoancontractAdjust set FIsUsed = 0 where fid = ?";
                DbUtil.execute((Context)ctx, (String)sql2, (Object[])new Object[]{srcObjectID});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs, pstmt, (Connection)cn);
        }
    }

    private void deleteCheck(Context ctx, LoanContractInterestInfo info) throws EASBizException, BOSException {
        if (info.isFiVouchered()) {
            throw new FinBizException(FinBizException.INT_DELETE_ERROR1);
        }
        this.check(info, ctx);
    }

    private void check(LoanContractInterestInfo info, Context ctx) throws BOSException, EASBizException {
        this.checkIsLastInt(info, ctx);
        if (info.getInterestType().getValue() == 0) {
            this.deletePreIntCheck(info, ctx);
        }
        if (info.getStatus() == SLInterestStatusEnum.AUDIT) {
            throw new FinBizException(FinBizException.INT_DELETE_ERROR5, new Object[]{info.getNumber()});
        }
    }

    private void deletePreIntCheck(LoanContractInterestInfo info, Context ctx) throws BOSException, EASBizException {
        String sql = "select fid from T_SL_LoanContractInterest where fstrikestatus = ? and fid = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{"striked", info.getId().toString()});
        try {
            if (rs.next()) {
                throw new FinBizException(FinBizException.INT_DELETE_ERROR4);
            }
        }
        catch (SQLException e) {
            throw new FinBizException(FinBizException.INT_DELETE_ERROR4);
        }
    }

    private void checkIsLastInt(LoanContractInterestInfo info, Context ctx) throws BOSException, EASBizException {
        if (info.getInterestType() == IntCalTypeEnum.PRE_INT) {
            this.deletePreInt(info, ctx);
        } else {
            this.deleteOther(info, ctx);
        }
    }

    private void deletePreInt(LoanContractInterestInfo info, Context ctx) throws BOSException, CHLoanException {
        if (info.getStatus() != SLInterestStatusEnum.SAVE) {
            String sql = "select max(fenddate) from T_SL_LoanContractInterest where FInterestType = ? and FSourceBillNum = ? and (FStatus = 0 or Fstatus=1)";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(info.getInterestType().getValue()), info.getSourceBillNum().getId().toString()});
            Date billEndDate = DateTimeUtils.truncateDate((Date)info.getEndDate());
            try {
                if (rs.next()) {
                    Date maxEndDate = new Date(rs.getDate(1).getTime());
                    if (billEndDate.compareTo(maxEndDate = DateTimeUtils.truncateDate((Date)maxEndDate)) < 0) {
                        throw new CHLoanException(CHLoanException.INT_DELETE_ERROR3);
                    }
                }
            }
            catch (SQLException e) {
                throw new CHLoanException(CHLoanException.INT_DELETE_ERROR3);
            }
        }
    }

    private void deleteOther(LoanContractInterestInfo info, Context ctx) throws BOSException, EASBizException {
        String sql = "select max(fenddate) from T_SL_LoanContractInterest where (FInterestType = ? or FInterestType=?) and FSourceBillNum = ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{new Integer(2), new Integer(4), info.getSourceBillNum().getId().toString()});
        Date billEndDate = DateTimeUtils.truncateDate((Date)info.getEndDate());
        try {
            if (rs.next()) {
                Date maxEndDate = new Date(rs.getDate(1).getTime());
                if (billEndDate.compareTo(maxEndDate = DateTimeUtils.truncateDate((Date)maxEndDate)) < 0) {
                    throw new CHLoanException(CHLoanException.INT_DELETE_ERROR3);
                }
            }
        }
        catch (SQLException e) {
            throw new CHLoanException(CHLoanException.INT_DELETE_ERROR3);
        }
    }

    private void afterDelete(Context ctx, LoanContractInterestInfo info) throws EASBizException, BOSException {
        if (info.getInterestType().getValue() == 2) {
            String loanContractRepayID = info.getLoanContractRepay() == null ? "" : info.getLoanContractRepay().getId().toString();
            boolean isRepayAllBill = this.isRepayAllBill(ctx, loanContractRepayID);
            if (isRepayAllBill) {
                this.oppositeStrike(ctx, info);
            }
        } else if (info.getInterestType().getValue() == 4) {
            this.oppositeStrike(ctx, info);
        }
    }

    private boolean isRepayAllBill(Context ctx, String repayBillID) throws BOSException {
        boolean isRepayAllBill = false;
        String sql = " select t_sl_loancontractrepay.FTotalAddAmount, t_sl_loancontract.FAmount \tfrom t_sl_loancontractrepay, t_sl_loancontract \twhere t_sl_loancontractrepay.FSourceBillID = t_sl_loancontract.fid \tand t_sl_loancontractrepay.fid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{repayBillID});
        BigDecimal loanAmtTotal = Constants.ZERO;
        BigDecimal repayAmtTotal = Constants.ZERO;
        try {
            if (rs.next()) {
                repayAmtTotal = rs.getBigDecimal(1);
                isRepayAllBill = repayAmtTotal.compareTo(loanAmtTotal = rs.getBigDecimal(2)) == 0;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return isRepayAllBill;
    }

    private void oppositeStrike(Context ctx, LoanContractInterestInfo loanInterestInfo) throws BOSException {
        if (loanInterestInfo.getInterestType() == IntCalTypeEnum.PAY_INT || loanInterestInfo.getInterestType() == IntCalTypeEnum.REPAY_INT) {
            String sql = "update t_sl_loancontractinterest set FStrikeStatus=? where FInterestType=0 and FStrikeID=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{"null", loanInterestInfo.getId().toString()});
        }
    }

    private void checkDelete(Context ctx, LoanContractInterestInfo info) throws BOSException, EASBizException {
        EntityViewInfo viewC = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("RepayAmount"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        filter.getFilterItems().add(new FilterItemInfo("sourceBillNum", (Object)info.getSourceBillNum().getId().toString()));
        viewC.setFilter(filter);
        viewC.setSelector(sic);
        SorterItemInfo sorter = new SorterItemInfo("endDate");
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorter.setSortType(SortType.DESCEND);
        sorterColl.add(sorter);
        viewC.setSorter(sorterColl);
        LoanContractInterestCollection coll = LoanContractInterestFactory.getLocalInstance(ctx).getLoanContractInterestCollection(viewC);
        if (!info.getId().equals((Object)coll.get(0).getId())) {
            throw new BEException(BEException.COMMON, new Object[]{"\u5229\u606f\u5355\u5220\u9664\u53ea\u80fd\u6309\u7ed3\u675f\u65e5\u4ece\u540e\u5f80\u524d\u987a\u5e8f\u5220\u9664"});
        }
    }

    private void updateFetchAndExecuteWithRepayCalInt(Context ctx, LoanContractInterestInfo info, boolean isAddNew) throws BOSException, EASBizException {
        LoanContractRepayInfo repayInfo = null;
        if (isAddNew) {
            repayInfo = info.getLoanContractRepayInfo();
            for (int i = 0; i < repayInfo.getRepayContractDetail().size(); ++i) {
                LoanContractRepayDetailInfo detailInfo = repayInfo.getRepayContractDetail().get(i);
                if (detailInfo == null || detailInfo.getBalance().compareTo(Constants.ZERO) != 0) continue;
                this.updateLoanFetch(ctx, detailInfo.getFetchLoanNm(), info, true, false, true);
                this.updateLoanContractExecuteEntry(ctx, detailInfo.getFetchLoanNm(), info, true, false, true);
            }
        } else {
            repayInfo = info.getLoanContractRepay();
            EntityViewInfo viewC = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("RepayContractDetail.id"));
            sic.add(new SelectorItemInfo("RepayContractDetail.isRepay"));
            sic.add(new SelectorItemInfo("RepayContractDetail.fetchLoanNm"));
            sic.add(new SelectorItemInfo("RepayContractDetail.balance"));
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)repayInfo.getId().toString()));
            viewC.setFilter(filter);
            LoanContractRepayDetailCollection detailCollection = LoanContractRepayDetailFactory.getLocalInstance(ctx).getLoanContractRepayDetailCollection(viewC);
            for (int j = 0; j < detailCollection.size(); ++j) {
                LoanContractRepayDetailInfo detailInfo = detailCollection.get(j);
                if (detailInfo.getBalance().compareTo(Constants.ZERO) != 0) continue;
                this.updateLoanFetch(ctx, detailInfo.getFetchLoanNm(), info, false, false, true);
                this.updateLoanContractExecuteEntry(ctx, detailInfo.getFetchLoanNm(), info, false, false, true);
            }
        }
    }

    private List getLoanContractInterestFetchNumber(Context ctx, String fparentId) throws BOSException, EASBizException {
        ArrayList<String> fetchNumber = new ArrayList<String>();
        String sql = "select max(ffetchnumer)fetchNumber from t_sl_loancontractinterestentry  where fparentid=? group by ffetchnumer ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{fparentId});
        int i = 0;
        try {
            while (rs.next()) {
                fetchNumber.add(i, rs.getString("fetchNumber"));
                ++i;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return fetchNumber;
    }

    private LoanContractExecuteEntryInfo getLoanContractExecuteInfo(Context ctx, String fetchNumber) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fetchAmountNo", (Object)fetchNumber));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("date"));
        evi.getSelector().add(new SelectorItemInfo("amount"));
        evi.getSelector().add(new SelectorItemInfo("fetchAmountNo"));
        evi.getSelector().add(new SelectorItemInfo("loanExtraAmount"));
        evi.getSelector().add(new SelectorItemInfo("lastFetchDate"));
        evi.getSelector().add(new SelectorItemInfo("lastCalInterestDate"));
        evi.getSelector().add(new SelectorItemInfo("oldLastFetchDate"));
        evi.getSelector().add(new SelectorItemInfo("oldLastCalInterestDate"));
        evi.getSorter().add(new SorterItemInfo("date"));
        LoanContractExecuteEntryCollection coll = LoanContractExecuteEntryFactory.getLocalInstance(ctx).getLoanContractExecuteEntryCollection(evi);
        if (coll != null) {
            return coll.get(0);
        }
        return null;
    }

    private LoanContractInterestInfo transferLoanContractInterestInfo(Context ctx, Map fetchMap, LoanContractInfo loanContractInfo, LoanContractRepayInfo repayInfo) throws BOSException, EASBizException {
        LoanContractInterestInfo info = new LoanContractInterestInfo();
        CompanyOrgUnitInfo CURRENT_COMPANY = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        LoanInterestInfo imIntInfo = new LoanInterestInfo();
        LinkedHashMap<String, Date> lastCalDateMap = new LinkedHashMap<String, Date>();
        for (String fetchNumber : fetchMap.keySet()) {
            imIntInfo = (LoanInterestInfo)fetchMap.get(fetchNumber);
            LoanInterestEntryCollection intCol = imIntInfo.getEntries();
            for (int index = 0; index < intCol.size(); ++index) {
                LoanInterestEntryInfo tempEntryInfo = intCol.get(index);
                LoanContractInterestEntryInfo slEntryInfo = new LoanContractInterestEntryInfo();
                slEntryInfo.setSeq(tempEntryInfo.getSeq());
                slEntryInfo.setFetchNumer(fetchNumber);
                slEntryInfo.setBeginDate(tempEntryInfo.getBeginDate());
                slEntryInfo.setEndDate(tempEntryInfo.getEndDate());
                slEntryInfo.setDays(tempEntryInfo.getDays());
                slEntryInfo.setEntryAmount(tempEntryInfo.getPrincipal());
                slEntryInfo.setEntryIntRate(tempEntryInfo.getIntRate());
                slEntryInfo.setEntryInterest(tempEntryInfo.getInterest());
                slEntryInfo.setEntryYearDays(tempEntryInfo.getConvertDays());
                slEntryInfo.setEntryIntRateTypeExpression(tempEntryInfo.getIntRateTypeExp());
                slEntryInfo.setEntryDaysOverdue(tempEntryInfo.getOverdueDays());
                slEntryInfo.setEntryPunishIntRate(tempEntryInfo.getPunishIntRate());
                slEntryInfo.setEntryPunishInterest(tempEntryInfo.getPunishInterest());
                slEntryInfo.setAdjustId(tempEntryInfo.getAdjIntBillId());
                info.getEntry().add(slEntryInfo);
                this.rate = tempEntryInfo.getIntRate();
                this.punishIntRate = tempEntryInfo.getPunishIntRate();
                slEntryInfo.setLastCalIntDate(imIntInfo.getLastIntDate());
                if (index != intCol.size() - 1) continue;
                this.Principal = this.Principal.add(tempEntryInfo.getPrincipal());
            }
            this.operateDate(imIntInfo, true);
            this.operateDate(imIntInfo, false);
            this.punishInterest = this.punishInterest.add(imIntInfo.getPunishInterest());
            this.interest = this.interest.add(imIntInfo.getInterest());
            this.countDays += imIntInfo.getDays();
            this.overDays += imIntInfo.getOverdueDays();
            lastCalDateMap.put(fetchNumber, imIntInfo.getLastIntDate());
            info.setLastCalDateMap(lastCalDateMap);
        }
        info.setProject(loanContractInfo.getProject());
        info.setInterestType(imIntInfo.getIntCalType());
        info.setCompany(CURRENT_COMPANY);
        if (loanContractInfo.getCurrency() != null) {
            info.setCurrency(CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(loanContractInfo.getCurrency().getId())));
        }
        info.setSourceBillNum(loanContractInfo);
        info.setLoancontractNum(loanContractInfo.getContractNum());
        info.setExchange(FinUtils.getCurrencyExRate((Context)ctx, (BOSUuid)CURRENT_COMPANY.getId(), (BOSUuid)loanContractInfo.getCurrency().getId(), (BOSUuid)CURRENT_COMPANY.getBaseCurrency().getId(), (Date)new Date()));
        info.setBizDate(imIntInfo.getBizDate());
        info.setBeginDate(this.minBeginDate);
        info.setEndDate(this.maxEndDate);
        info.setDays(this.countDays);
        info.setAmount(this.Principal);
        info.setIntRate(this.rate);
        info.setDaysOverdue(this.overDays);
        info.setPunishIntType(loanContractInfo.getPenAccrualType());
        info.setPunishIntRate(this.punishIntRate);
        info.setPunishInterest(this.punishInterest);
        info.setRealPunishInterest(this.punishInterest);
        info.setInterest(this.interest);
        info.setRealInterest(this.interest);
        info.setLoanContractRepay(repayInfo);
        info.setLoanContractRepayInfo(repayInfo);
        if (info.getInterestType() == IntCalTypeEnum.PRE_INT) {
            info.setStrikeAmount(Constants.ZERO);
            info.setIntRateTypeExpression(loanContractInfo.getIntRateTypeExpression());
        } else if (info.getInterestType() == IntCalTypeEnum.PAY_INT) {
            info.setStrikeAmount(this.calcStrikeAmount(ctx, info, repayInfo));
            info.setIntRateTypeExpression(loanContractInfo.getIntRateTypeExpression());
        } else if (info.getInterestType() == IntCalTypeEnum.REPAY_INT) {
            info.setPayAcount(repayInfo.getRepayBankAcct());
            info.setIntFeeAcctView(repayInfo.getIntFeeAcct());
            info.setIntRateTypeExpression(repayInfo.getIntRateTypeExpression());
            info.setStrikeAmount(this.calcStrikeAmount(ctx, info, repayInfo));
        }
        info.setFetchIntMap(fetchMap);
        info.setStrikeStatus(StrikeEnum.NULL);
        info.setFiVouchered(false);
        info.setIsGenPayBill(false);
        info.setCreateTime(DateUtil.getTimeStampDayBegin());
        info.setCreator(user);
        info.setLastIntDate(imIntInfo.getLastIntDate());
        info.setStatus(SLInterestStatusEnum.SAVE);
        return info;
    }

    private void operateDate(LoanInterestInfo interestInfo, boolean isMin) {
        if (isMin) {
            if (this.minBeginDate == null) {
                this.minBeginDate = interestInfo.getBeginDate();
            } else if (this.minBeginDate.after(interestInfo.getBeginDate())) {
                this.minBeginDate = interestInfo.getBeginDate();
            }
        } else if (this.maxEndDate == null) {
            this.maxEndDate = interestInfo.getEndDate();
        } else if (this.maxEndDate.before(interestInfo.getEndDate())) {
            this.maxEndDate = interestInfo.getEndDate();
        }
    }

    private Date getPreStartDate(Date startDate, Date lastFetchDate, Date lastCalInterestDate) throws EASBizException {
        Date resDate = null;
        if (lastFetchDate == null) {
            throw new BEException(BEException.COMMON, new Object[]{"\u5408\u540c\u6267\u884c\u60c5\u51b5\u4e0a\u6b21\u9884\u63d0\u65e5\u4e3a\u7a7a"});
        }
        if (lastCalInterestDate == null) {
            throw new BEException(BEException.COMMON, new Object[]{"\u5408\u540c\u6267\u884c\u60c5\u51b5\u4e0a\u6b21\u7ed3\u606f\u65e5\u4e3a\u7a7a"});
        }
        Date addLastFetchDate = DateTimeUtils.truncateDate((Date)DateUtil.getAfterDay((Date)lastFetchDate));
        Date addLastCalInterestDate = DateTimeUtils.truncateDate((Date)DateUtil.getAfterDay((Date)lastCalInterestDate));
        if (startDate == null) {
            resDate = lastFetchDate.compareTo(lastCalInterestDate) >= 0 ? addLastFetchDate : addLastCalInterestDate;
        } else {
            if ((startDate = DateTimeUtils.truncateDate((Date)startDate)).compareTo(addLastFetchDate) >= 0 && startDate.compareTo(addLastCalInterestDate) >= 0) {
                resDate = startDate;
            }
            if (addLastFetchDate.compareTo(startDate) >= 0 && addLastFetchDate.compareTo(startDate) >= 0) {
                resDate = addLastFetchDate;
            }
            if (addLastCalInterestDate.compareTo(startDate) >= 0 && addLastCalInterestDate.compareTo(addLastFetchDate) >= 0) {
                resDate = addLastCalInterestDate;
            }
        }
        return DateTimeUtils.truncateDate((Date)resDate);
    }

    private Date getRecStartDate(Date startDate, Date lastCalInterestDate) throws EASBizException {
        Date resDate = null;
        if (lastCalInterestDate == null) {
            throw new BEException(BEException.COMMON, new Object[]{"\u5408\u540c\u6267\u884c\u60c5\u51b5\u4e0a\u6b21\u7ed3\u606f\u65e5\u4e3a\u7a7a"});
        }
        Date addLastCalInterestDate = DateTimeUtils.truncateDate((Date)DateUtil.getAfterDay((Date)lastCalInterestDate));
        resDate = startDate == null ? addLastCalInterestDate : ((startDate = DateTimeUtils.truncateDate((Date)startDate)).compareTo(addLastCalInterestDate) >= 0 ? startDate : addLastCalInterestDate);
        return resDate;
    }

    private BigDecimal calcStrikeAmount(Context ctx, LoanContractInterestInfo intInfo, LoanContractRepayInfo repayInfo) throws EASBizException, BOSException {
        BigDecimal returnValue = Constants.ZERO;
        if (repayInfo != null && repayInfo.getTotalAddAmount().compareTo(intInfo.getSourceBillNum().getAmount()) != 0) {
            return returnValue;
        }
        returnValue = this._getStrikeAmount(ctx, intInfo);
        return returnValue;
    }

    protected BigDecimal _getStrikeAmount(Context ctx, LoanContractInterestInfo loanContractInterestInfo) throws BOSException, EASBizException {
        StringBuffer sbSQL = new StringBuffer();
        BigDecimal returnValue = Constants.ZERO;
        sbSQL.append("select sum(FRealInterest+FRealPunishInterest) from t_sl_loancontractinterest ");
        sbSQL.append("where FEndDate<=?  and FInterestType=0 and  FStrikeStatus=? and FSourceBillNum = ? and (fstatus=0 or fstatus=1)");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSQL.toString(), (Object[])new Object[]{new java.sql.Date(loanContractInterestInfo.getEndDate().getTime()), "null", loanContractInterestInfo.getSourceBillNum().getId().toString()});
        try {
            if (rs.next()) {
                returnValue = rs.getBigDecimal(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (returnValue == null) {
            returnValue = Constants.ZERO;
        }
        return returnValue;
    }

    private IntCalModel getIntCalModel(Date startDate, Date endDate, LoanContractInfo loanInfo, LoanContractExecuteEntryInfo executeEntryInfo, LoanContractAdjustCollection adjColl, LoanContractRepayDetailCollection repayColl, LoanContractRepayInfo[] repayInfos, LoanContractRepayInfo repayInfo, LoanContractRepayDetailInfo repayDetailInfo) {
        ImLoanContractRepayDetailCollection iRepayColl = new ImLoanContractRepayDetailCollection(repayInfos, repayColl);
        ImLoanContractRepayDetailInfo iRepayInfo = new ImLoanContractRepayDetailInfo(repayInfo, repayDetailInfo);
        ImLoanContractExeInfo iLoanInfo = new ImLoanContractExeInfo(loanInfo, executeEntryInfo);
        ImLoanContractAdjustIntRateCollection iAdjColl = new ImLoanContractAdjustIntRateCollection(adjColl);
        IntCalModel model = new IntCalModel();
        model.setBeginDate(startDate);
        model.setEndDate(endDate);
        model.setLoanInfo((ILoanInfo)iLoanInfo);
        model.setAdjIntRateColl((IAdjustIntRateCollection)iAdjColl);
        model.setRepayColl((IRepaymentBillCollection)iRepayColl);
        model.setRepayInfo((IRepaymentBillInfo)iRepayInfo);
        if (startDate != null) {
            model.setNewRequirement(true);
        } else {
            model.setNewRequirement(false);
        }
        return model;
    }

    private LoanContractRepayDetailCollection getLoanContractRepayDetailCollection(Context ctx, LoanContractRepayDetailCollection repayDetailColls, String fetchLoanNm) throws EASBizException, BOSException {
        LoanContractRepayDetailCollection tempColls = new LoanContractRepayDetailCollection();
        if (repayDetailColls == null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("fetchLoanNm", (Object)fetchLoanNm));
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add(new SelectorItemInfo("*"));
            evi.getSelector().add(new SelectorItemInfo("parent.*"));
            evi.setFilter(filter);
            evi.getSorter().add(new SorterItemInfo("fetchDate"));
            tempColls = LoanContractRepayDetailFactory.getLocalInstance(ctx).getLoanContractRepayDetailCollection(evi);
        } else {
            Iterator it = repayDetailColls.iterator();
            while (it.hasNext()) {
                LoanContractRepayDetailInfo detailInfo = (LoanContractRepayDetailInfo)it.next();
                if (!detailInfo.getFetchLoanNm().equals(fetchLoanNm)) continue;
                tempColls.add(detailInfo);
            }
        }
        return tempColls;
    }

    private LoanContractExecuteEntryInfo getLoanContractExecuteEntryInfo(Context ctx, String id, String fetchLoanNm) throws EASBizException, BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)id));
        filter.getFilterItems().add(new FilterItemInfo("fetchAmountNo", (Object)fetchLoanNm));
        LoanContractExecuteEntryCollection coll = LoanContractExecuteEntryFactory.getLocalInstance(ctx).getLoanContractExecuteEntryCollection(evi);
        if (coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    private LoanContractInfo getLoanContractInfo(Context ctx, String id) throws EASBizException, BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        LoanContractInfo info = LoanContractFactory.getLocalInstance(ctx).getLoanContractInfo((IObjectPK)new ObjectUuidPK(id));
        return info;
    }

    private LoanContractExecuteEntryCollection getLoanContractExecuteEntryCollection(Context ctx, LoanContractInfo info) throws EASBizException, BOSException {
        if (info == null) {
            throw new BEException(BEException.COMMON, new Object[]{"\u8bf7\u9009\u62e9\u501f\u6b3e\u5408\u540c\u540e\u64cd\u4f5c"});
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)info.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("loanExtraAmount", (Object)Constants.ZERO, CompareType.GREATER));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("fetchAmountNo"));
        evi.getSelector().add(new SelectorItemInfo("date"));
        evi.getSelector().add(new SelectorItemInfo("loanExtraAmount"));
        evi.getSelector().add(new SelectorItemInfo("lastFetchDate"));
        evi.getSelector().add(new SelectorItemInfo("lastCalInterestDate"));
        evi.getSorter().add(new SorterItemInfo("date"));
        return LoanContractExecuteEntryFactory.getLocalInstance(ctx).getLoanContractExecuteEntryCollection(evi);
    }

    private LoanContractAdjustCollection getAdjustColl(Context ctx, LoanContractInfo info) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillNum", (Object)info.getId().toString()));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("adjustDate"));
        evi.getSelector().add(new SelectorItemInfo("*"));
        return LoanContractAdjustFactory.getLocalInstance(ctx).getLoanContractAdjustCollection(evi);
    }

    private LoanContractRepayInfo[] getLoanContractRepayInfos(Context ctx, LoanContractRepayDetailCollection repayDetailCol, LoanContractRepayInfo loanContractRepayInfo) throws EASBizException, BOSException {
        LoanContractRepayInfo[] infos = null;
        if (repayDetailCol != null) {
            infos = new LoanContractRepayInfo[repayDetailCol.size()];
            for (int i = 0; i < repayDetailCol.size(); ++i) {
                if (loanContractRepayInfo == null) {
                    LoanContractRepayDetailInfo entryInfo = repayDetailCol.get(i);
                    EntityViewInfo evi = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    evi.getSelector().add(new SelectorItemInfo("*"));
                    evi.getSelector().add(new SelectorItemInfo("parent.id"));
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)entryInfo.getParent().getId()));
                    evi.setFilter(filter);
                    LoanContractRepayCollection colls = LoanContractRepayFactory.getLocalInstance(ctx).getLoanContractRepayCollection(evi);
                    infos[i] = colls.get(0);
                    continue;
                }
                infos[i] = loanContractRepayInfo;
            }
        }
        return infos;
    }

    @Override
    protected LoanContractInterestInfo _calInt(Context ctx, LoanContractRepayInfo loanContractRepayInfo) throws BOSException, EASBizException {
        LoanContractInfo loanContractInfo = this.getLoanContractPassByRepayment(ctx, loanContractRepayInfo);
        for (int i = loanContractRepayInfo.getRepayContractDetail().size() - 1; i >= 0; --i) {
            if (loanContractRepayInfo.getRepayContractDetail().get(i).isIsRepay()) continue;
            loanContractRepayInfo.getRepayContractDetail().removeObject(i);
        }
        LoanInterestInfo imIntInfo = null;
        LoanContractExecuteEntryCollection executeEntryCollection = this.getLoanContractExecuteEntryCollectionByRepayInfo(ctx, loanContractRepayInfo);
        LoanContractAdjustCollection adjustCol = this.getAdjustColl(ctx, loanContractInfo);
        LoanContractRepayDetailCollection repayDetailCol = null;
        LoanContractRepayInfo[] infos = null;
        Date endDate = DateUtil.getBeforeDay((Date)loanContractRepayInfo.getBizDate());
        LinkedHashMap<String, LoanInterestInfo> fetchIntMap = new LinkedHashMap<String, LoanInterestInfo>();
        if (executeEntryCollection != null && executeEntryCollection.size() > 0) {
            for (int j = 0; j < executeEntryCollection.size(); ++j) {
                LoanContractExecuteEntryInfo executeEntryInfo = executeEntryCollection.get(j);
                String fetchNumber = executeEntryInfo.getFetchAmountNo();
                repayDetailCol = this.getLoanContractRepayDetailCollection(ctx, loanContractRepayInfo.getRepayContractDetail(), fetchNumber);
                infos = this.getLoanContractRepayInfos(ctx, repayDetailCol, loanContractRepayInfo);
                if (executeEntryInfo.getLastCalInterestDate() == null) {
                    throw new BEException(BEException.COMMON, new Object[]{"\u5408\u540c\u6267\u884c\u60c5\u51b5\u5206\u5f55\u7684\u4e0a\u6b21\u7ed3\u606f\u65e5\u4e3a\u7a7a"});
                }
                Date startDate = DateUtil.getAfterDay((Date)executeEntryInfo.getLastCalInterestDate());
                LoanContractRepayDetailInfo repayDetailInfo = this.getLoanContractRepayDetailInfoByFetchNumber(repayDetailCol, fetchNumber);
                IntCalModel model = this.getIntCalModel(startDate, endDate, loanContractInfo, executeEntryInfo, adjustCol, repayDetailCol, infos, loanContractRepayInfo, repayDetailInfo);
                imIntInfo = AbstractIntCalStragety.getInstance((IntCalTypeEnum)IntCalTypeEnum.REPAY_INT).calInt(ctx, model);
                fetchIntMap.put(fetchNumber, imIntInfo);
            }
        }
        LoanContractInterestInfo loanContractInterestInfo = this.transferLoanContractInterestInfo(ctx, fetchIntMap, loanContractInfo, loanContractRepayInfo);
        imMap.put("loanContractInterestInfo", loanContractInterestInfo);
        return loanContractInterestInfo;
    }

    private LoanContractRepayDetailInfo getLoanContractRepayDetailInfoByFetchNumber(LoanContractRepayDetailCollection coll, String fetchNumber) {
        LoanContractRepayDetailInfo detailInfo = new LoanContractRepayDetailInfo();
        if (coll == null || coll.size() == 0) {
            return detailInfo;
        }
        for (int i = 0; i < coll.size(); ++i) {
            LoanContractRepayDetailInfo tempDetailInfo = coll.get(i);
            if (tempDetailInfo.getFetchLoanNm() == null || !tempDetailInfo.getFetchLoanNm().equals(fetchNumber)) continue;
            detailInfo = tempDetailInfo;
            break;
        }
        return detailInfo;
    }

    private LoanContractExecuteEntryCollection getLoanContractExecuteEntryCollectionByRepayInfo(Context ctx, LoanContractRepayInfo loanContractRepayInfo) throws BOSException, EASBizException {
        LoanContractExecuteEntryCollection colls = new LoanContractExecuteEntryCollection();
        LoanContractRepayDetailCollection repayEntryCollection = loanContractRepayInfo.getRepayContractDetail();
        for (int i = 0; i < repayEntryCollection.size(); ++i) {
            String fetchNumber = repayEntryCollection.get(i).getFetchLoanNm();
            LoanContractExecuteEntryInfo executeEntryInfo = this.getLoanContractExecuteInfo(ctx, fetchNumber);
            colls.add(executeEntryInfo);
        }
        return colls;
    }

    private LoanContractInfo getLoanContractPassByRepayment(Context ctx, LoanContractRepayInfo loanContractRepayInfo) throws BOSException, EASBizException {
        String id = loanContractRepayInfo.getSourceBillId();
        LoanContractInfo loanContractInfo = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("Currency.precision"));
        loanContractInfo = LoanContractFactory.getLocalInstance(ctx).getLoanContractInfo((IObjectPK)new ObjectUuidPK(id), sic);
        return loanContractInfo;
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanContractInterestInfo info = this.getLoanContractInterestInfo(ctx, pk);
        if (info.getStatus() == SLInterestStatusEnum.AUDIT) {
            throw new LoanSLException(LoanSLException.BILL_AUDIT_EXCEPTION, new Object[]{info.getNumber()});
        }
        UserInfo currentUser = (UserInfo)ctx.get((Object)"UserInfo");
        info.setAuditor(currentUser);
        info.setAuditTime(new Timestamp(System.currentTimeMillis()));
        info.setStatus(SLInterestStatusEnum.AUDIT);
        this.update(ctx, pk, info);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanContractInterestInfo info = this.getLoanContractInterestInfo(ctx, pk);
        if (info.getStatus() == SLInterestStatusEnum.SUBMIT) {
            throw new LoanSLException(LoanSLException.BILL_UNAUDIT_EXCEPTION, new Object[]{info.getNumber()});
        }
        info.setAuditor(null);
        info.setAuditTime(null);
        info.setStatus(SLInterestStatusEnum.SUBMIT);
        this.update(ctx, pk, info);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        LoanContractInterestInfo intInfo = (LoanContractInterestInfo)model;
        boolean isNeedSubmitCheck = true;
        if (SLInterestStatusEnum.SUBMIT.equals((Object)intInfo.getStatus())) {
            isNeedSubmitCheck = false;
        }
        intInfo.setStatus(SLInterestStatusEnum.SUBMIT);
        IObjectPK pk = super._submit(ctx, model);
        if (intInfo.getInterestType() == IntCalTypeEnum.REPAY_INT && isNeedSubmitCheck) {
            this._afterSubmit(ctx, intInfo, pk);
        }
        return pk;
    }

    private void _afterSubmit(Context ctx, LoanContractInterestInfo loanContractInterestInfo, IObjectPK pk) throws EASBizException, BOSException {
        if (loanContractInterestInfo.getInterestType().getValue() != 4 && loanContractInterestInfo.getInterestType().getValue() != 0 && loanContractInterestInfo.getInterestType().getValue() == 2) {
            this.afterRepaySubmit(ctx, loanContractInterestInfo, pk);
        }
    }

    private void afterRepaySubmit(Context ctx, LoanContractInterestInfo loanContractInterestInfo, IObjectPK pk) throws EASBizException, BOSException {
        this.saveRepayBill(loanContractInterestInfo, ctx, pk);
        if (imMap.get("loanContractInterestInfo") != null) {
            LoanContractInterestEntryCollection iCol = ((LoanContractInterestInfo)imMap.get("loanContractInterestInfo")).getEntry();
            for (int i = 0; i < iCol.size(); ++i) {
                LoanContractInterestEntryInfo entryInfo = iCol.get(i);
                if (FMHelper.isEmpty((String)entryInfo.getAdjustId())) continue;
                this.saveBOTPRelationShipLoanContractAdjust(ctx, entryInfo.getAdjustId(), loanContractInterestInfo);
            }
        }
        if (loanContractInterestInfo.getLoanContractRepayInfo().getTotalAddAmount().compareTo(loanContractInterestInfo.getSourceBillNum().getAmount()) == 0) {
            this.updateRepayStrikeStatus(ctx, loanContractInterestInfo);
        }
    }

    private void saveRepayBill(LoanContractInterestInfo intInfo, Context ctx, IObjectPK pkReturn) throws EASBizException, BOSException {
        if (intInfo.getLoanContractRepayInfo() != null) {
            LoanContractRepayInfo info = intInfo.getLoanContractRepayInfo();
            BigDecimal interest = FMHelper.add((BigDecimal)intInfo.getRealInterest(), (BigDecimal)intInfo.getRealPunishInterest());
            interest = SLAppUtils.getBigDecimalValue(interest);
            info.setInterest(interest);
            info.setRepayment(FMHelper.add((BigDecimal)interest, (BigDecimal)info.getRepayAmount()));
            this._saveRepaymentBill(ctx, info);
            this._saveBOTPRelationShip(ctx, intInfo, pkReturn);
        }
    }

    private void _saveRepaymentBill(Context ctx, LoanContractRepayInfo repaymentInfo) throws EASBizException, BOSException {
        LoanContractRepayFactory.getLocalInstance(ctx).submit((CoreBaseInfo)repaymentInfo);
    }

    private void _saveBOTPRelationShip(Context ctx, LoanContractInterestInfo infoInt, IObjectPK pkReturn) throws BOSException {
        botpRelationShip.clear();
        botpRelationShip.put(infoInt.getSourceBillNum().getId().toString(), pkReturn.toString());
        FMHelper.saveBOTRelation((Context)ctx, (Map)botpRelationShip);
        if (infoInt.getLoanContractRepayInfo() != null) {
            botpRelationShip.clear();
            botpRelationShip.put(infoInt.getLoanContractRepayInfo().getId().toString(), pkReturn.toString());
            FMHelper.saveBOTRelation((Context)ctx, (Map)botpRelationShip);
            botpRelationShip.clear();
            botpRelationShip.put(infoInt.getSourceBillNum().getId().toString(), infoInt.getLoanContractRepayInfo().getId().toString());
            FMHelper.saveBOTRelation((Context)ctx, (Map)botpRelationShip);
        }
    }

    private void updateRepayStrikeStatus(Context ctx, LoanContractInterestInfo loanContractInterestInfo) throws BOSException {
        SQLUtil sql1 = new SQLUtil();
        sql1.appendSql("update t_sl_loancontractinterest set FStrikeStatus=?  , FStrikeID=? ");
        sql1.appendSql("where  FEndDate<=?  and FInterestType = 0 and FSourceBillNum = ?  and (fstatus=0 or fstatus=1) and FStrikeStatus=?");
        sql1.addParams(new Object[]{"striked", loanContractInterestInfo.getId().toString(), new java.sql.Date(DateUtil.getAfterDay((Date)loanContractInterestInfo.getEndDate()).getTime()), loanContractInterestInfo.getSourceBillNum().getId().toString(), "null"});
        sql1.execute(ctx);
    }

    @Override
    protected void _deleteRaleted(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fil = new FilterInfo();
        fil.getFilterItems().add(new FilterItemInfo("loanContractRepay.id", (Object)pk));
        fil.getFilterItems().add(new FilterItemInfo("status", (Object)"2", CompareType.NOTEQUALS));
        evi.setFilter(fil);
        LoanContractInterestCollection col = this.getLoanContractInterestCollection(ctx, evi);
        for (int i = 0; i < col.size(); ++i) {
            this._delete(ctx, (IObjectPK)new ObjectUuidPK(col.get(i).getId()));
        }
    }
}

