/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.sl.LoanContractExecuteEntryFactory;
import com.kingdee.eas.fm.sl.LoanContractFactory;
import com.kingdee.eas.fm.sl.LoanContractInfo;
import com.kingdee.eas.fm.sl.LoanContractOfLenderEntryCollection;
import com.kingdee.eas.fm.sl.LoanContractOfLenderEntryInfo;
import com.kingdee.eas.fm.sl.LoanFetchInfo;
import com.kingdee.eas.fm.sl.LoanFetchOfLenderEntryCollection;
import com.kingdee.eas.fm.sl.LoanFetchOfLenderEntryFactory;
import com.kingdee.eas.fm.sl.LoanFetchOfLenderEntryInfo;
import com.kingdee.eas.fm.sl.app.AbstractLoanContractOfLenderEntryControllerBean;
import com.kingdee.eas.fm.sl.app.SLAppUtils;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class LoanContractOfLenderEntryControllerBean
extends AbstractLoanContractOfLenderEntryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.sl.app.LoanContractOfLenderEntryControllerBean");

    @Override
    protected void _updateContractLoanBankEntrys(Context ctx, IObjectValue loanFetchInfo, String type) throws BOSException, EASBizException {
        if (loanFetchInfo == null) {
            return;
        }
        LoanFetchInfo fetchInfo = (LoanFetchInfo)loanFetchInfo;
        String sourceBillId = fetchInfo.getSourceBillId();
        ObjectStringPK pk = new ObjectStringPK(sourceBillId);
        LoanContractInfo contractInfo = LoanContractFactory.getLocalInstance(ctx).getLoanContractInfo((IObjectPK)pk);
        LoanFetchOfLenderEntryCollection fetchLoanBankColl = fetchInfo.getLoanBankEntry();
        for (int i = 0; i < fetchLoanBankColl.size(); ++i) {
            LoanFetchOfLenderEntryInfo fetchEntryInfo = fetchLoanBankColl.get(i);
            ObjectUuidPK PK = new ObjectUuidPK(fetchEntryInfo.getId());
            boolean existsFlag = LoanFetchOfLenderEntryFactory.getLocalInstance(ctx).exists((IObjectPK)PK);
            LoanFetchOfLenderEntryInfo oldFetchEntryInfo = null;
            if (existsFlag) {
                oldFetchEntryInfo = LoanFetchOfLenderEntryFactory.getLocalInstance(ctx).getLoanFetchOfLenderEntryInfo((IObjectPK)PK);
            }
            BigDecimal fetchAmount = SLAppUtils.getBigDecimalValue(fetchEntryInfo.getPromiseLoanAmount());
            BigDecimal oldFetchAmount = oldFetchEntryInfo != null ? SLAppUtils.getBigDecimalValue(oldFetchEntryInfo.getPromiseLoanAmount()) : Constants.ZERO;
            BankInfo bank = fetchEntryInfo.getBank();
            if (bank == null) continue;
            String bankId = bank.getId().toString();
            LoanContractOfLenderEntryInfo loanContractOfLenderEntryInfo = this.getLoanContractEntryInfo(ctx, contractInfo.getId().toString(), bankId);
            if (loanContractOfLenderEntryInfo == null) continue;
            BigDecimal overLoanAmount = SLAppUtils.getBigDecimalValue(loanContractOfLenderEntryInfo.getOverLoanAmount());
            BigDecimal loanBalance = SLAppUtils.getBigDecimalValue(loanContractOfLenderEntryInfo.getLoanBalance());
            if (type.equals("0")) {
                if (this.isWriteContract(ctx, fetchInfo.getNumber())) {
                    loanContractOfLenderEntryInfo.setOverLoanAmount(overLoanAmount.add(fetchAmount).subtract(oldFetchAmount));
                    loanContractOfLenderEntryInfo.setLoanBalance(loanBalance.add(fetchAmount).subtract(oldFetchAmount));
                } else {
                    loanContractOfLenderEntryInfo.setOverLoanAmount(overLoanAmount.add(fetchAmount));
                    loanContractOfLenderEntryInfo.setLoanBalance(loanBalance.add(fetchAmount));
                }
            } else {
                loanContractOfLenderEntryInfo.setOverLoanAmount(overLoanAmount.subtract(fetchAmount));
                loanContractOfLenderEntryInfo.setLoanBalance(loanBalance.subtract(fetchAmount));
            }
            this.update(ctx, (IObjectPK)new ObjectUuidPK(loanContractOfLenderEntryInfo.getId()), loanContractOfLenderEntryInfo);
        }
    }

    private boolean isWriteContract(Context ctx, String fetchNumber) throws BOSException, EASBizException {
        if (fetchNumber == null) {
            return false;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fetchAmountNo", (Object)fetchNumber));
        return LoanContractExecuteEntryFactory.getLocalInstance(ctx).exists(filter);
    }

    private LoanContractOfLenderEntryInfo getLoanContractEntryInfo(Context ctx, String fparentId, String bankId) throws BOSException, EASBizException {
        FilterInfo filterInt = new FilterInfo();
        filterInt.getFilterItems().add(new FilterItemInfo("parent.id", (Object)fparentId));
        filterInt.getFilterItems().add(new FilterItemInfo("Bank.id", (Object)bankId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInt);
        LoanContractOfLenderEntryCollection coll = this.getLoanContractOfLenderEntryCollection(ctx, evi);
        LoanContractOfLenderEntryInfo info = null;
        if (coll != null && coll.size() > 0) {
            info = coll.get(0);
        }
        return info;
    }
}

