/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ctl.AssureBillManagerFacadeFactory;
import com.kingdee.eas.fm.fin.CreditLimitEntryCollection;
import com.kingdee.eas.fm.fin.CreditLimitEntryFactory;
import com.kingdee.eas.fm.fin.CreditLimitEntryInfo;
import com.kingdee.eas.fm.fin.CreditLimitFactory;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.CreditLimitStatusEnum;
import com.kingdee.eas.fm.fin.CreditLimitUsedCollection;
import com.kingdee.eas.fm.fin.CreditLimitUsedFactory;
import com.kingdee.eas.fm.fin.CreditLimitUsedInfo;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.LimitPropertyEnum;
import com.kingdee.eas.fm.fin.app.CreditLimitManagerHelper;
import com.kingdee.eas.fm.sl.FsBillStatusEnum;
import com.kingdee.eas.fm.sl.LoanContractExecuteEntryCollection;
import com.kingdee.eas.fm.sl.LoanContractExecuteEntryFactory;
import com.kingdee.eas.fm.sl.LoanContractExecuteEntryInfo;
import com.kingdee.eas.fm.sl.LoanContractFactory;
import com.kingdee.eas.fm.sl.LoanContractInfo;
import com.kingdee.eas.fm.sl.LoanContractInterestFactory;
import com.kingdee.eas.fm.sl.LoanContractOfLenderEntryInfo;
import com.kingdee.eas.fm.sl.LoanContractRepayCollection;
import com.kingdee.eas.fm.sl.LoanContractRepayDetailInfo;
import com.kingdee.eas.fm.sl.LoanContractRepayFactory;
import com.kingdee.eas.fm.sl.LoanContractRepayInfo;
import com.kingdee.eas.fm.sl.LoanFetchCollection;
import com.kingdee.eas.fm.sl.LoanFetchFactory;
import com.kingdee.eas.fm.sl.LoanFetchInfo;
import com.kingdee.eas.fm.sl.LoanSLException;
import com.kingdee.eas.fm.sl.app.AbstractLoanContractRepayControllerBean;
import com.kingdee.eas.fm.sl.app.SLAppUtils;
import com.kingdee.eas.fm.sl.util.SLUtils;
import com.kingdee.eas.framework.BillEntryBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class LoanContractRepayControllerBean
extends AbstractLoanContractRepayControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.sl.app.LoanContractRepayControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanContractRepayInfo info = (LoanContractRepayInfo)model;
        this.checkLoanContractReapay(ctx, info);
        this.removeTotalRowAndNotCheck(ctx, model);
        info.setStatus(FsBillStatusEnum.SUBMIT);
        for (int i = 0; i < info.getRepayContractDetail().size(); ++i) {
            if (info.getRepayContractDetail().get(i).isIsRepay()) continue;
            info.getRepayContractDetail().removeObject(i);
        }
        this.updateEntryDetail(ctx, model, true);
        this.createBotpWithLoanFetch(ctx, info);
        this.returnQuota(ctx, info, true);
        IObjectPK pk = super._addnew(ctx, model);
        AssureBillManagerFacadeFactory.getLocalInstance((Context)ctx).returnAssure(info.getId());
        return pk;
    }

    private void returnQuota(Context ctx, LoanContractRepayInfo info, boolean isRepay) throws EASBizException, BOSException {
        BillEntryBaseInfo detailInfo;
        int i;
        HashSet<String> numSet = new HashSet<String>();
        HashMap<String, LoanFetchInfo> loanFetchMap = new HashMap<String, LoanFetchInfo>();
        BigDecimal reTotalAmount = Constants.ZERO;
        for (int i2 = 0; i2 < info.getRepayContractDetail().size(); ++i2) {
            LoanContractRepayDetailInfo detailInfo2 = info.getRepayContractDetail().get(i2);
            numSet.add(detailInfo2.getFetchLoanNm());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", numSet, CompareType.INCLUDE));
        LoanFetchCollection colls = LoanFetchFactory.getLocalInstance(ctx).getLoanFetchCollection(view);
        for (int i3 = 0; i3 < colls.size(); ++i3) {
            LoanFetchInfo fetchInfo = colls.get(i3);
            if (fetchInfo.isHistoryBill()) {
                numSet.remove(fetchInfo.getNumber());
                continue;
            }
            loanFetchMap.put(fetchInfo.getNumber(), fetchInfo);
        }
        HashMap<BOSUuid, BigDecimal> rateMap = new HashMap<BOSUuid, BigDecimal>();
        HashMap<BOSUuid, BigDecimal> returnMap = new HashMap<BOSUuid, BigDecimal>();
        HashMap<BOSUuid, CreditLimitInfo> creditMap = new HashMap<BOSUuid, CreditLimitInfo>();
        HashMap<BOSUuid, BigDecimal> creditRateMap = new HashMap<BOSUuid, BigDecimal>();
        for (i = 0; i < info.getLoanBankDetail().size(); ++i) {
            detailInfo = info.getLoanBankDetail().get(i);
            if (FMHelper.isEmpty((CoreBaseInfo)detailInfo.getCreditLimit()) || detailInfo.getCreditLimit().getProperty().equals((Object)LimitPropertyEnum.FIXED_AMOUNT)) continue;
            BOSUuid creditLimitId = detailInfo.getCreditLimit().getId();
            if (rateMap.containsKey(creditLimitId)) {
                BigDecimal rate = (BigDecimal)rateMap.get(creditLimitId);
                BigDecimal returnedQuota = (BigDecimal)returnMap.get(creditLimitId);
                rateMap.put(creditLimitId, rate.add(detailInfo.getPermissionRate()));
                returnMap.put(creditLimitId, returnedQuota.add(detailInfo.getReturnQuota()));
                continue;
            }
            rateMap.put(creditLimitId, detailInfo.getPermissionRate());
            returnMap.put(creditLimitId, detailInfo.getReturnQuota());
            creditMap.put(creditLimitId, detailInfo.getCreditLimit());
            creditRateMap.put(creditLimitId, detailInfo.getCreditRate());
        }
        for (i = 0; i < info.getRepayContractDetail().size(); ++i) {
            detailInfo = info.getRepayContractDetail().get(i);
            reTotalAmount = detailInfo.getRepayAmt();
            if (!loanFetchMap.keySet().contains(detailInfo.getFetchLoanNm())) continue;
            for (BOSUuid creditLimitId : rateMap.keySet()) {
                BigDecimal UserreturnedQuota;
                BigDecimal rate = (BigDecimal)rateMap.get(creditLimitId);
                BigDecimal creditRate = (BigDecimal)creditRateMap.get(creditLimitId);
                BigDecimal returnedQuota = reTotalAmount.multiply(rate).multiply(creditRate).divide(Constants.ONE_HUNDRED, 4);
                BigDecimal relReturnedQuota = returnedQuota.compareTo(UserreturnedQuota = (BigDecimal)returnMap.get(creditLimitId)) > 0 ? UserreturnedQuota : returnedQuota;
                LoanFetchInfo fetchInfo = (LoanFetchInfo)loanFetchMap.get(detailInfo.getFetchLoanNm());
                CreditLimitUsedInfo userInfo = null;
                EntityViewInfo viewUsed = new EntityViewInfo();
                FilterInfo filterUsed = new FilterInfo();
                viewUsed.setFilter(filterUsed);
                filterUsed.getFilterItems().add(new FilterItemInfo("BillId", (Object)fetchInfo.getId().toString()));
                filterUsed.getFilterItems().add(new FilterItemInfo("CreditLimit.id", (Object)creditLimitId));
                viewUsed.getSelector().add(new SelectorItemInfo("id"));
                viewUsed.getSelector().add(new SelectorItemInfo("BillId"));
                viewUsed.getSelector().add(new SelectorItemInfo("UsedQuota"));
                viewUsed.getSelector().add(new SelectorItemInfo("ReturnedQuota"));
                CreditLimitUsedCollection coll = CreditLimitUsedFactory.getLocalInstance((Context)ctx).getCreditLimitUsedCollection(viewUsed);
                if (coll.size() > 0) {
                    userInfo = coll.get(0);
                }
                relReturnedQuota = isRepay ? relReturnedQuota : relReturnedQuota.negate();
                CreditLimitInfo creditLimitInfo = (CreditLimitInfo)creditMap.get(creditLimitId);
                LoanContractRepayControllerBean.checkCreditLimitAmount(relReturnedQuota, creditLimitInfo);
                BigDecimal balance = creditLimitInfo.getBalance().subtract(relReturnedQuota.negate());
                creditLimitInfo.setBalance(balance);
                BigDecimal UsedAmount = creditLimitInfo.getQuotaAmount().subtract(creditLimitInfo.getBalance());
                creditLimitInfo.setUsedAmount(UsedAmount);
                CreditLimitStatusEnum creditStatus = CreditLimitManagerHelper.getCreditLimitStatus((Context)ctx, (String)creditLimitInfo.getId().toString());
                creditLimitInfo.setCreditLimitStat(creditStatus);
                CreditLimitFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(creditLimitInfo.getId()), (CoreBaseInfo)creditLimitInfo);
                CreditLimitEntryInfo shareEntry = this.getOrgEntry(ctx, creditLimitInfo, info.getCompany().getId());
                if (!FMHelper.isEmpty((CoreBaseInfo)shareEntry)) {
                    BigDecimal entryBalance = shareEntry.getBanlance().subtract(relReturnedQuota.negate());
                    shareEntry.setBanlance(entryBalance);
                    CreditLimitEntryFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(shareEntry.getId()), (CoreBaseInfo)shareEntry);
                }
                if (creditLimitInfo == null || !creditLimitInfo.getProperty().equals((Object)LimitPropertyEnum.REVOLVING_AMOUNT) || FMHelper.isEmpty((CoreBaseInfo)userInfo)) continue;
                userInfo.setReturnedQuota(userInfo.getReturnedQuota().add(relReturnedQuota));
                if (userInfo.getReturnedQuota().compareTo(userInfo.getUsedQuota()) > 0) {
                    userInfo.setReturnedQuota(userInfo.getUsedQuota());
                }
                ObjectUuidPK pk = new ObjectUuidPK(userInfo.getId());
                CreditLimitUsedFactory.getLocalInstance((Context)ctx).update((IObjectPK)pk, (CoreBaseInfo)userInfo);
            }
        }
    }

    public CreditLimitEntryInfo getOrgEntry(Context ctx, CreditLimitInfo creditLimit, BOSUuid companyId) throws BOSException {
        CreditLimitEntryInfo entryInfo = null;
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        evi.getSelector().add("ShareOrg.*");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("Parent.id", (Object)creditLimit.getId().toString()));
        CreditLimitEntryCollection cleCollection = CreditLimitEntryFactory.getLocalInstance((Context)ctx).getCreditLimitEntryCollection(evi);
        int n = cleCollection.size();
        for (int i = 0; i < n; ++i) {
            if (!cleCollection.get(i).getShareOrg().getId().equals((Object)companyId)) continue;
            entryInfo = cleCollection.get(i);
        }
        return entryInfo;
    }

    public static void checkCreditLimitAmount(BigDecimal amount, CreditLimitInfo creditLimitInfo) throws EASBizException {
        BigDecimal banlance = creditLimitInfo.getBalance();
        BigDecimal totalAmount = creditLimitInfo.getQuotaAmount();
        if (banlance.compareTo(Constants.ZERO) < 0 || totalAmount.compareTo(amount.add(banlance)) < 0) {
            FinUtils.throwFMCommonException((String)(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"446_FinUtils") + totalAmount.subtract(banlance)));
        }
    }

    private void checkLoanContractReapay(Context ctx, LoanContractRepayInfo info) throws BOSException, EASBizException {
        String sourceBillId = info.getSourceBillId();
        if (sourceBillId == null) {
            return;
        }
        this.checkDeleteLoanFetch(ctx, info);
        this.resetLoanContractRepayInfoByDeleteLoanContractReapy(ctx, info);
    }

    public LoanContractRepayCollection getLoanContractRepayCollectionByLoanContractRepayInfo(Context ctx, LoanContractRepayInfo info) throws BOSException, EASBizException {
        String sourceBillId = info.getSourceBillId();
        EntityViewInfo viewC = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("RepaySeq"));
        sic.add(new SelectorItemInfo("RepayAmount"));
        sic.add(new SelectorItemInfo("bizDate"));
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)sourceBillId));
        viewC.setFilter(filter);
        viewC.setSelector(sic);
        SorterItemInfo sorter = new SorterItemInfo("RepaySeq");
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorter.setSortType(SortType.DESCEND);
        sorterColl.add(sorter);
        viewC.setSorter(sorterColl);
        LoanContractRepayCollection coll = LoanContractRepayFactory.getLocalInstance(ctx).getLoanContractRepayCollection(viewC);
        return coll;
    }

    private void checkDeleteLoanFetch(Context ctx, LoanContractRepayInfo info) throws BOSException, EASBizException {
        LoanContractExecuteEntryInfo contractExecuteEntryInfo;
        String sourceBillId = info.getSourceBillId();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterFetch = new FilterInfo();
        SelectorItemCollection sicFetch = new SelectorItemCollection();
        sicFetch.add(new SelectorItemInfo("sourceBillId"));
        sicFetch.add(new SelectorItemInfo("status"));
        sicFetch.add(new SelectorItemInfo("IssueDate"));
        filterFetch.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)sourceBillId));
        view.setFilter(filterFetch);
        view.setSelector(sicFetch);
        SorterItemInfo sorterFetch = new SorterItemInfo("IssueDate");
        SorterItemCollection sorterCollFetch = new SorterItemCollection();
        sorterFetch.setSortType(SortType.DESCEND);
        sorterCollFetch.add(sorterFetch);
        view.setSorter(sorterCollFetch);
        LoanFetchCollection collFetch = LoanFetchFactory.getLocalInstance(ctx).getLoanFetchCollection(view);
        if (collFetch != null && collFetch.size() > 0) {
            Iterator it = collFetch.iterator();
            while (it.hasNext()) {
                LoanFetchInfo fetchInfo = (LoanFetchInfo)it.next();
                if (fetchInfo.getStatus() == FsBillStatusEnum.AUDIT) continue;
                throw new BEException(BEException.COMMON, new Object[]{"\u501f\u6b3e\u5408\u540c\u8fd8\u6b3e\u5355\u4e0d\u80fd\u63d0\u4ea4\uff0c\u4e0a\u6e38\u63d0\u6b3e\u5355\u672a\u5ba1\u6279"});
            }
        }
        if ((contractExecuteEntryInfo = this.getMaxLoanContractExecuteEntryInfo(ctx, info)) != null && !info.getBizDate().after(contractExecuteEntryInfo.getDate())) {
            throw new BEException(BEException.COMMON, new Object[]{"\u8fd8\u6b3e\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u6700\u540e\u4e00\u5f20\u63d0\u6b3e\u5355\u63d0\u6b3e\u65e5\u671f"});
        }
    }

    private LoanContractExecuteEntryInfo getMaxLoanContractExecuteEntryInfo(Context ctx, LoanContractRepayInfo info) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("date"));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)info.getSourceBillId()));
        view.setFilter(filter);
        view.setSelector(sic);
        SorterItemInfo sorter = new SorterItemInfo("date");
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorter.setSortType(SortType.DESCEND);
        sorterColl.add(sorter);
        view.setSorter(sorterColl);
        LoanContractExecuteEntryCollection colls = LoanContractExecuteEntryFactory.getLocalInstance(ctx).getLoanContractExecuteEntryCollection(view);
        if (colls != null && colls.size() > 0) {
            return colls.get(0);
        }
        return null;
    }

    private LoanContractRepayInfo resetLoanContractRepayInfoByDeleteLoanContractReapy(Context ctx, LoanContractRepayInfo info) throws BOSException, EASBizException {
        LoanContractRepayCollection collRepay = this.getLoanContractRepayCollectionByLoanContractRepayInfo(ctx, info);
        int repaySeq = 0;
        BigDecimal totalAmount = Constants.ZERO;
        if (collRepay != null) {
            if (collRepay.size() > 0) {
                repaySeq = collRepay.get(0).getRepaySeq();
                info.setRepaySeq(repaySeq + 1);
                if (info.getBizDate().before(collRepay.get(0).getBizDate())) {
                    throw new BEException(BEException.COMMON, new Object[]{"\u8fd8\u6b3e\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u4e0a\u6b21\u8fd8\u6b3e\u65e5"});
                }
            } else {
                info.setRepaySeq(1);
            }
            totalAmount = totalAmount.add(this.getHistoryOverRepayAmount(ctx, info.getSourceBillId()));
            info.setTotalAddAmount(totalAmount.add(info.getRepayAmount()));
            info.setBalance(info.getLoanAmount().subtract(totalAmount.add(info.getRepayAmount())));
        }
        return info;
    }

    private BigDecimal getHistoryOverRepayAmount(Context ctx, String sourceBillId) throws BOSException, EASBizException {
        BigDecimal historyRepayAmount = Constants.ZERO;
        EntityViewInfo viewC = new EntityViewInfo();
        FilterInfo filterC = new FilterInfo();
        viewC.setFilter(filterC);
        filterC.getFilterItems().add(new FilterItemInfo("parent.id", (Object)sourceBillId));
        viewC.getSelector().add(new SelectorItemInfo("amount"));
        viewC.getSelector().add(new SelectorItemInfo("loanExtraAmount"));
        LoanContractExecuteEntryCollection colls = LoanContractExecuteEntryFactory.getLocalInstance(ctx).getLoanContractExecuteEntryCollection(viewC);
        Iterator it = colls.iterator();
        while (it.hasNext()) {
            LoanContractExecuteEntryInfo entryInfo = (LoanContractExecuteEntryInfo)it.next();
            BigDecimal overLoanAmount = SLUtils.getBigDecimalValue(entryInfo.getAmount());
            BigDecimal repayAmount = SLUtils.getBigDecimalValue(entryInfo.getLoanExtraAmount());
            historyRepayAmount = historyRepayAmount.add(overLoanAmount.subtract(repayAmount));
        }
        return historyRepayAmount;
    }

    private void createBotpWithLoanFetch(Context ctx, LoanContractRepayInfo info) throws BOSException, EASBizException {
        if (info == null) {
            return;
        }
        String fetchID = null;
        for (int i = 0; i < info.getRepayContractDetail().size(); ++i) {
            LoanContractRepayDetailInfo detailInfo = info.getRepayContractDetail().get(i);
            LoanFetchInfo fetchInfo = this.getLoanFetchInfoByFetchNumber(ctx, detailInfo);
            if (fetchInfo == null || fetchInfo.getId() == null) continue;
            fetchID = fetchInfo.getId().toString();
            FinUtils.addBotRelation((Context)ctx, (String)fetchID, (String)info.getId().toString());
        }
    }

    private void deleteBotpWithLoanFetch(Context ctx, LoanContractRepayInfo info) throws BOSException, EASBizException {
        Object[] paramList = new Object[]{info.getId().toString()};
        String sql = "delete from T_BOT_Relation where fdestobjectid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])paramList);
    }

    private LoanFetchInfo getLoanFetchInfoByFetchNumber(Context ctx, LoanContractRepayDetailInfo detailInfo) throws BOSException, EASBizException {
        if (detailInfo == null) {
            return null;
        }
        String fetchNumber = detailInfo.getFetchLoanNm();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)fetchNumber));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        LoanFetchCollection coll = LoanFetchFactory.getLocalInstance(ctx).getLoanFetchCollection(view);
        LoanFetchInfo fetchInfo = coll.get(0);
        return fetchInfo;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EntityViewInfo viewC = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("RepayAmount"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("sourceBillNm.id"));
        sic.add(new SelectorItemInfo("RepayContractDetail.id"));
        sic.add(new SelectorItemInfo("RepayContractDetail.isRepay"));
        sic.add(new SelectorItemInfo("RepayContractDetail.repaySeq"));
        sic.add(new SelectorItemInfo("RepayContractDetail.fetchLoanNm"));
        sic.add(new SelectorItemInfo("RepayContractDetail.fetchDate"));
        sic.add(new SelectorItemInfo("RepayContractDetail.loanBalance"));
        sic.add(new SelectorItemInfo("RepayContractDetail.repayAmt"));
        sic.add(new SelectorItemInfo("RepayContractDetail.balance"));
        sic.add(new SelectorItemInfo("RepayContractDetail.remark"));
        sic.add(new SelectorItemInfo("LoanBankDetail.id"));
        sic.add(new SelectorItemInfo("LoanBankDetail.LenderProperty.name"));
        sic.add(new SelectorItemInfo("LoanBankDetail.bank.id"));
        sic.add(new SelectorItemInfo("LoanBankDetail.bank.name"));
        sic.add(new SelectorItemInfo("LoanBankDetail.bank.number"));
        sic.add(new SelectorItemInfo("LoanBankDetail.permissionRate"));
        sic.add(new SelectorItemInfo("LoanBankDetail.CreditLimit.*"));
        sic.add(new SelectorItemInfo("LoanBankDetail.creditCurrency.id"));
        sic.add(new SelectorItemInfo("LoanBankDetail.creditCurrency.name"));
        sic.add(new SelectorItemInfo("LoanBankDetail.repayAmt"));
        sic.add(new SelectorItemInfo("LoanBankDetail.creditRate"));
        sic.add(new SelectorItemInfo("LoanBankDetail.returnQuota"));
        sic.add(new SelectorItemInfo("LoanBankDetail.remark"));
        sic.add(new SelectorItemInfo("LoanBankDetail.sourceBillId"));
        LoanContractRepayInfo info = (LoanContractRepayInfo)this.getValue(ctx, pk, sic);
        boolean onlyRepayInterestBill = this.onlyRepayInterestBill(ctx, info.getId().toString(), "3562F30C");
        if (!info.getStatus().equals((Object)FsBillStatusEnum.SUBMIT) || onlyRepayInterestBill) {
            throw new BEException(BEException.COMMON, new Object[]{"\u63d0\u4ea4\u72b6\u6001\u4e14\u65e0\u4e0b\u6e38\u5355\u636e\u7684\u8bb0\u5f55\u5141\u8bb8\u5220\u9664"});
        }
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)info.getSourceBillId()));
        viewC.setFilter(filter);
        viewC.setSelector(sic);
        SorterItemInfo sorter = new SorterItemInfo("RepaySeq");
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorter.setSortType(SortType.DESCEND);
        sorterColl.add(sorter);
        viewC.setSorter(sorterColl);
        LoanContractRepayCollection coll = LoanContractRepayFactory.getLocalInstance(ctx).getLoanContractRepayCollection(viewC);
        if (!info.getId().equals((Object)coll.get(0).getId())) {
            throw new BEException(BEException.COMMON, new Object[]{"\u540c\u4e00\u501f\u6b3e\u5408\u540c\u7684\u8fd8\u6b3e\u5355\u5220\u9664\u5fc5\u987b\u6309\u8fd8\u6b3e\u5e8f\u53f7\u4ece\u540e\u5f80\u524d\u987a\u5e8f\u5220\u9664"});
        }
        LoanContractInterestFactory.getLocalInstance(ctx).deleteRaleted(pk);
        this.updateEntryDetail(ctx, (IObjectValue)info, false);
        this.deleteBotpWithLoanFetch(ctx, info);
        this.returnQuota(ctx, info, false);
        AssureBillManagerFacadeFactory.getLocalInstance((Context)ctx).cancelReturnAssure(info.getId());
        super._delete(ctx, pk);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanContractRepayInfo info = (LoanContractRepayInfo)model;
        this.isAuditModify(ctx, info);
        return super._submit(ctx, model);
    }

    private void isAuditModify(Context ctx, LoanContractRepayInfo info) throws BOSException, EASBizException {
        ObjectUuidPK PK = new ObjectUuidPK(info.getId());
        boolean exist = this.exists(ctx, (IObjectPK)PK);
        LoanContractRepayInfo oldInfo = null;
        if (exist) {
            oldInfo = this.getLoanContractRepayInfo(ctx, (IObjectPK)PK);
        }
        if (oldInfo != null && info.getStatus() != oldInfo.getStatus() && oldInfo.getStatus() == FsBillStatusEnum.AUDIT) {
            throw new BEException(BEException.COMMON, new Object[]{"\u5f53\u524d\u8bb0\u5f55\u5df2\u7ecf\u5ba1\u6279\uff0c\u4e0d\u80fd\u63d0\u4ea4"});
        }
    }

    private void removeTotalRowAndNotCheck(Context ctx, IObjectValue model) {
        int i;
        LoanContractRepayInfo info = (LoanContractRepayInfo)model;
        for (i = 0; i < info.getRepayContractDetail().size(); ++i) {
            if (info.getRepayContractDetail().get(i).isIsRepay()) continue;
            info.getRepayContractDetail().removeObject(i);
        }
        for (i = 0; i < info.getLoanBankDetail().size(); ++i) {
            if (!FMHelper.isEmpty((CoreBaseInfo)info.getLoanBankDetail().get(i).getBank())) continue;
            info.getLoanBankDetail().removeObject(i);
        }
    }

    private void updateEntryDetail(Context ctx, IObjectValue model, boolean isAddNew) throws EASBizException, BOSException {
        LoanContractRepayInfo info = (LoanContractRepayInfo)model;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("totalBalance"));
        sic.add(new SelectorItemInfo("loanContractExecuteEntry.fetchAmountNo"));
        sic.add(new SelectorItemInfo("loanContractExecuteEntry.loanExtraAmount"));
        sic.add(new SelectorItemInfo("LoanBankEntry.loanBalance"));
        sic.add(new SelectorItemInfo("LoanBankEntry.bank.id"));
        sic.add(new SelectorItemInfo("LoanBankEntry.bank.number"));
        sic.add(new SelectorItemInfo("LoanBankEntry.overLoanAmount"));
        LoanContractInfo linfo = LoanContractFactory.getLocalInstance(ctx).getLoanContractInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillNm().getId()), sic);
        this.updateContractRepayDetail(ctx, linfo, info, isAddNew);
        this.updateLoanBankDetail(ctx, linfo, info, isAddNew);
        if (isAddNew) {
            linfo.setTotalBalance(linfo.getTotalBalance().subtract(info.getRepayAmount()));
        } else {
            linfo.setTotalBalance(linfo.getTotalBalance().add(info.getRepayAmount()));
        }
        LoanContractFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getSourceBillNm().getId()), linfo);
    }

    private void updateContractRepayDetail(Context ctx, LoanContractInfo info, LoanContractRepayInfo repayInfo, boolean isAddNew) throws EASBizException, BOSException {
        int i;
        HashMap<String, BigDecimal> valueMap = new HashMap<String, BigDecimal>();
        for (i = 0; i < repayInfo.getRepayContractDetail().size(); ++i) {
            String key = repayInfo.getRepayContractDetail().get(i).getFetchLoanNm();
            BigDecimal repayAmt = repayInfo.getRepayContractDetail().get(i).getRepayAmt();
            if (valueMap.containsKey(key)) {
                valueMap.put(key, ((BigDecimal)valueMap.get(key)).add(repayAmt));
                continue;
            }
            valueMap.put(key, repayAmt);
        }
        for (i = 0; i < info.getLoanContractExecuteEntry().size(); ++i) {
            String fetchNm = info.getLoanContractExecuteEntry().get(i).getFetchAmountNo();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)fetchNm));
            view.getSelector().add(new SelectorItemInfo("id"));
            view.setFilter(filter);
            LoanFetchCollection coll = LoanFetchFactory.getLocalInstance(ctx).getLoanFetchCollection(view);
            LoanFetchInfo fetchInfo = coll.get(0);
            if (!valueMap.containsKey(fetchNm)) continue;
            BigDecimal repayAmount = (BigDecimal)valueMap.get(fetchNm);
            BigDecimal oldValue = info.getLoanContractExecuteEntry().get(i).getLoanExtraAmount();
            BigDecimal loanExtraAmount = oldValue.subtract(repayAmount);
            if (!isAddNew) {
                loanExtraAmount = oldValue.add(repayAmount);
            }
            info.getLoanContractExecuteEntry().get(i).setLoanExtraAmount(loanExtraAmount);
            if (fetchInfo != null && fetchInfo.getId() != null) {
                fetchInfo.setBalance(loanExtraAmount);
                LoanFetchFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(fetchInfo.getId()), fetchInfo);
            }
            if (!isAddNew) continue;
            this.resetLoanContractRepayDetailInfo(ctx, repayInfo, fetchNm, oldValue);
        }
    }

    private void resetLoanContractRepayDetailInfo(Context ctx, LoanContractRepayInfo repayInfo, String fetchNm, BigDecimal oldValue) throws EASBizException, BOSException {
        for (int i = 0; i < repayInfo.getRepayContractDetail().size(); ++i) {
            String fetchNumber = repayInfo.getRepayContractDetail().get(i).getFetchLoanNm();
            if (fetchNm == null || !fetchNm.trim().equals(fetchNumber.trim())) continue;
            BigDecimal repayAmount = SLAppUtils.getBigDecimalValue(repayInfo.getRepayContractDetail().get(i).getRepayAmt());
            repayInfo.getRepayContractDetail().get(i).setLoanBalance(oldValue);
            repayInfo.getRepayContractDetail().get(i).setBalance(oldValue.subtract(repayAmount));
        }
    }

    private void updateLoanBankDetail(Context ctx, LoanContractInfo info, LoanContractRepayInfo repayInfo, boolean isAddNew) {
        int i;
        HashMap<String, BigDecimal> valueMap = new HashMap<String, BigDecimal>();
        for (i = 0; i < repayInfo.getLoanBankDetail().size(); ++i) {
            if (FMHelper.isEmpty((String)repayInfo.getLoanBankDetail().get(i).getSourceBillId())) continue;
            String key = repayInfo.getLoanBankDetail().get(i).getSourceBillId();
            BigDecimal repayAmt = repayInfo.getLoanBankDetail().get(i).getRepayAmt();
            if (valueMap.containsKey(key)) {
                valueMap.put(key, ((BigDecimal)valueMap.get(key)).add(repayAmt));
                continue;
            }
            valueMap.put(key, repayAmt);
        }
        for (i = 0; i < info.getLoanBankEntry().size(); ++i) {
            LoanContractOfLenderEntryInfo lenInfo = info.getLoanBankEntry().get(i);
            String key = lenInfo.getId().toString();
            if (!valueMap.containsKey(key)) continue;
            BigDecimal loanBalance = lenInfo.getLoanBalance();
            BigDecimal repayAmt = (BigDecimal)valueMap.get(key);
            if (isAddNew) {
                lenInfo.setLoanBalance(loanBalance.subtract(repayAmt));
                continue;
            }
            lenInfo.setLoanBalance(loanBalance.add(repayAmt));
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanContractRepayInfo info = this.getLoanContractRepayInfo(ctx, pk);
        if (info.getStatus() == FsBillStatusEnum.AUDIT) {
            throw new LoanSLException(LoanSLException.BILL_AUDIT_EXCEPTION, new Object[]{info.getNumber()});
        }
        UserInfo currentUser = (UserInfo)ctx.get((Object)"UserInfo");
        info.setAuditor(currentUser);
        info.setAuditDate(new Timestamp(System.currentTimeMillis()));
        info.setStatus(FsBillStatusEnum.AUDIT);
        this.update(ctx, pk, (CoreBaseInfo)info);
    }

    @Override
    protected void _antiAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanContractRepayInfo info = this.getLoanContractRepayInfo(ctx, pk);
        if (info.getStatus() == FsBillStatusEnum.SUBMIT) {
            throw new LoanSLException(LoanSLException.BILL_UNAUDIT_EXCEPTION, new Object[]{info.getNumber()});
        }
        boolean onlyRepayInterestBill = this.onlyRepayInterestBill(ctx, info.getId().toString(), "3562F30C");
        if (onlyRepayInterestBill) {
            throw new LoanSLException(LoanSLException.BILL_UNAUDIT_EXCEPTION, new Object[]{info.getNumber()});
        }
        info.setAuditor(null);
        info.setAuditDate(null);
        info.setStatus(FsBillStatusEnum.SUBMIT);
        this.update(ctx, pk, (CoreBaseInfo)info);
    }

    private boolean onlyRepayInterestBill(Context ctx, String srcBillId, String destEntityID) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)destEntityID, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)srcBillId));
        view.setFilter(filter);
        BOTRelationCollection coll = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(view);
        return coll.size() != 0;
    }

    @Override
    protected void _dispose(Context ctx, IObjectValue destInfo, DisposerActionEnum actionType) throws BOSException, EASBizException {
        if (destInfo != null && actionType != null && destInfo instanceof PaymentBillInfo) {
            String sourceBillId = ((PaymentBillInfo)destInfo).getSourceBillId();
            if (DisposerActionEnum.DELETE.equals((Object)actionType)) {
                String sql = "update T_SL_LoanContractRepay set FIsGenPay =0 where FID= ? ";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{sourceBillId});
            } else if (DisposerActionEnum.SAVE.equals((Object)actionType) || DisposerActionEnum.SUBMIT.equals((Object)actionType)) {
                String sql = "UPDATE T_SL_LoanContractRepay SET FIsGenPay = 1 WHERE FID = ? ";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{sourceBillId});
            }
        }
    }
}

