/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.ReceivingBillEntryCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.CreditLimitManagerFactory;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.sl.FsBillStatusEnum;
import com.kingdee.eas.fm.sl.LoanContractExecuteEntryFactory;
import com.kingdee.eas.fm.sl.LoanContractFactory;
import com.kingdee.eas.fm.sl.LoanContractInfo;
import com.kingdee.eas.fm.sl.LoanContractOfLenderEntryFactory;
import com.kingdee.eas.fm.sl.LoanContractOfLenderEntryInfo;
import com.kingdee.eas.fm.sl.LoanFetchCollection;
import com.kingdee.eas.fm.sl.LoanFetchFactory;
import com.kingdee.eas.fm.sl.LoanFetchInfo;
import com.kingdee.eas.fm.sl.LoanFetchOfLenderEntryCollection;
import com.kingdee.eas.fm.sl.LoanFetchOfLenderEntryFactory;
import com.kingdee.eas.fm.sl.LoanFetchOfLenderEntryInfo;
import com.kingdee.eas.fm.sl.LoanSLException;
import com.kingdee.eas.fm.sl.app.AbstractLoanFetchControllerBean;
import com.kingdee.eas.fm.sl.app.SLAppUtils;
import com.kingdee.eas.fm.sl.util.SLUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class LoanFetchControllerBean
extends AbstractLoanFetchControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.sl.app.LoanFetchControllerBean");

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanFetchInfo info = this.getLoanFetchInfo(ctx, pk);
        if (info.getStatus() == FsBillStatusEnum.SAVE || info.getStatus() == FsBillStatusEnum.AUDIT) {
            throw new LoanSLException(LoanSLException.BILL_AUDIT_EXCEPTION, new Object[]{info.getNumber()});
        }
        UserInfo currentUser = (UserInfo)ctx.get((Object)"UserInfo");
        info.setAuditor(currentUser);
        info.setAuditorTime(new Timestamp(System.currentTimeMillis()));
        info.setStatus(FsBillStatusEnum.AUDIT);
        this.update(ctx, pk, info);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanFetchInfo info = this.getLoanFetchInfo(ctx, pk);
        if (info.getStatus() == FsBillStatusEnum.SAVE || info.getStatus() == FsBillStatusEnum.SUBMIT) {
            throw new LoanSLException(LoanSLException.BILL_UNAUDIT_EXCEPTION, new Object[]{info.getNumber()});
        }
        Set descSet = FMHelper.getDestBillIdSet((Context)ctx, (String)info.getId().toString());
        if (descSet.size() > 0) {
            throw new LoanSLException(LoanSLException.BILL_UNAUDIT_EXCEPTION, new Object[]{info.getNumber()});
        }
        info.setAuditor(null);
        info.setAuditorTime(null);
        info.setStatus(FsBillStatusEnum.SAVE);
        this.update(ctx, pk, info);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanFetchInfo info = (LoanFetchInfo)model;
        IObjectPK pkReturn = super._addnewOther(ctx, model);
        return pkReturn;
    }

    private void creditLimitReduce(Context ctx, LoanFetchInfo info) throws EASBizException, BOSException {
        HashMap<BOSUuid, BigDecimal> amountMap = new HashMap<BOSUuid, BigDecimal>();
        LoanFetchOfLenderEntryCollection colls = info.getLoanBankEntry();
        for (int i = 0; i < colls.size(); ++i) {
            LoanFetchOfLenderEntryInfo entryInfo = colls.get(i);
            if (FMHelper.isEmpty((CoreBaseInfo)entryInfo.getCreditLimit())) continue;
            BOSUuid id = entryInfo.getCreditLimit().getId();
            if (amountMap.containsKey(id)) {
                BigDecimal amount = (BigDecimal)amountMap.get(id);
                amountMap.put(id, amount.add(entryInfo.getCreditAmount()));
                continue;
            }
            amountMap.put(id, entryInfo.getCreditAmount());
        }
        for (BOSUuid id : amountMap.keySet()) {
            BigDecimal retAmt = (BigDecimal)amountMap.get(id);
            CreditLimitManagerFactory.getLocalInstance((Context)ctx).useLimit(id, retAmt, info.getCompany().getId(), info.getId(), false);
            LoanFetchControllerBean.addCreditBotp((Context)ctx, (FinancingBillInfo)info, (String)id.toString());
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanFetchInfo info = (LoanFetchInfo)model;
        this.checkContractISAudit(ctx, info);
        this.checkExesitsDBFetchNumber(ctx, info);
        return super._save(ctx, model);
    }

    private void checkContractISAudit(Context ctx, LoanFetchInfo info) throws BOSException, EASBizException {
        LoanContractInfo contractInfo = LoanContractFactory.getLocalInstance(ctx).getLoanContractInfo((IObjectPK)new ObjectUuidPK(info.getSourceBillId()));
        if (contractInfo != null && contractInfo.getStatus() != FsBillStatusEnum.AUDIT) {
            throw new BEException(BEException.COMMON, new Object[]{"\u5df2\u5ba1\u6279\u7684\u501f\u6b3e\u5408\u540c\u624d\u80fd\u63d0\u6b3e"});
        }
    }

    public void checkExists(Context ctx, LoanFetchInfo info) throws BOSException, EASBizException {
        String billId;
        String string = billId = info.getId() == null ? null : info.getId().toString();
        if (billId != null && FMHelper.getDestBillIdSet((Context)ctx, (String)billId).size() > 0) {
            throw new BEException(BEException.COMMON, new Object[]{"\u5df2\u5b58\u5728\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u80fd\u63d0\u4ea4\u4fee\u6539"});
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanFetchInfo info = (LoanFetchInfo)model;
        this.checkContractISAudit(ctx, info);
        this.checkExesitsDBFetchNumber(ctx, info);
        this.isAuditModify(ctx, info);
        this.checkExists(ctx, info);
        boolean isWriteContract = this.isWriteContract(ctx, info.getNumber());
        if (isWriteContract) {
            SLAppUtils.cancelAssure(ctx, info);
        }
        String fetchNumber = "";
        if (FMHelper.isEmpty((String)info.getNumber())) {
            if (FMHelper.hasNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString())) {
                fetchNumber = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            }
        } else {
            fetchNumber = info.getNumber();
        }
        info.setNumber(fetchNumber);
        LoanContractFactory.getLocalInstance(ctx).fetchForWrite(info);
        info.setLastCalDate(DateUtil.getBeforeDay((Date)info.getIssueDate()));
        info.setOldLastCalDate(DateUtil.getBeforeDay((Date)info.getIssueDate()));
        info.setLastFetchDate(DateUtil.getBeforeDay((Date)info.getIssueDate()));
        info.setOldLastFetchDate(DateUtil.getBeforeDay((Date)info.getIssueDate()));
        this.updateContractLoanBankEntrys(ctx, info, isWriteContract, false);
        info.setStatus(FsBillStatusEnum.SUBMIT);
        IObjectPK pk = super._submitOther(ctx, (IObjectValue)info);
        this.writeAssBalance(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), info);
        this.writeWage(ctx, info);
        this.creditLimitReduce(ctx, info);
        SLAppUtils.removeBotpRelation(ctx, info);
        SLAppUtils.createBotpRelation(ctx, info);
        SLAppUtils.createBotpWithLoanContract(ctx, info);
        return pk;
    }

    protected void updateContractLoanBankEntrys(Context ctx, LoanFetchInfo fetchInfo, boolean isWriteContract, boolean isDelete) throws BOSException, EASBizException {
        if (fetchInfo == null) {
            return;
        }
        LoanFetchOfLenderEntryCollection fetchLoanBankColl = fetchInfo.getLoanBankEntry();
        LoanContractInfo contractInfo = LoanContractFactory.getLocalInstance(ctx).getLoanContractInfo((IObjectPK)new ObjectUuidPK(fetchInfo.getSourceBillId()));
        LoanFetchInfo oldInfo = null;
        if (isWriteContract) {
            oldInfo = (LoanFetchInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(fetchInfo.getId()));
        }
        for (int i = 0; i < fetchLoanBankColl.size(); ++i) {
            LoanFetchOfLenderEntryInfo fetchEntryInfo = fetchLoanBankColl.get(i);
            ObjectUuidPK PK = new ObjectUuidPK(fetchEntryInfo.getId());
            boolean existsFlag = LoanFetchOfLenderEntryFactory.getLocalInstance(ctx).exists((IObjectPK)PK);
            LoanFetchOfLenderEntryInfo oldFetchEntryInfo = null;
            if (existsFlag) {
                oldFetchEntryInfo = LoanFetchOfLenderEntryFactory.getLocalInstance(ctx).getLoanFetchOfLenderEntryInfo((IObjectPK)PK);
            }
            BigDecimal lastFetchAmount = Constants.ZERO;
            BigDecimal lastFetchProportion = Constants.ZERO;
            BigDecimal lastTotalFetchAmount = Constants.ZERO;
            BigDecimal fetchAmount = SLAppUtils.getBigDecimalValue(fetchEntryInfo.getPromiseLoanAmount());
            BigDecimal oldFetchAmount = oldFetchEntryInfo != null ? SLAppUtils.getBigDecimalValue(oldFetchEntryInfo.getPromiseLoanAmount()) : FMConstants.ZERO;
            LoanContractOfLenderEntryInfo loanContractOfLenderEntryInfo = LoanContractOfLenderEntryFactory.getLocalInstance(ctx).getLoanContractOfLenderEntryInfo((IObjectPK)new ObjectUuidPK(fetchEntryInfo.getSourceBillId()));
            if (loanContractOfLenderEntryInfo == null) continue;
            BigDecimal overLoanAmount = SLAppUtils.getBigDecimalValue(loanContractOfLenderEntryInfo.getOverLoanAmount());
            BigDecimal loanBalance = SLAppUtils.getBigDecimalValue(loanContractOfLenderEntryInfo.getLoanBalance());
            if (!isDelete) {
                if (isWriteContract) {
                    loanContractOfLenderEntryInfo.setOverLoanAmount(overLoanAmount.add(fetchAmount).subtract(oldFetchAmount));
                    loanContractOfLenderEntryInfo.setLoanBalance(loanBalance.add(fetchAmount).subtract(oldFetchAmount));
                    lastFetchAmount = fetchAmount.add(overLoanAmount).subtract(oldFetchAmount);
                    lastTotalFetchAmount = contractInfo.getAmount().subtract(contractInfo.getBalance());
                } else {
                    loanContractOfLenderEntryInfo.setOverLoanAmount(overLoanAmount.add(fetchAmount));
                    loanContractOfLenderEntryInfo.setLoanBalance(loanBalance.add(fetchAmount));
                    lastFetchAmount = fetchAmount.add(overLoanAmount);
                    lastTotalFetchAmount = contractInfo.getAmount().subtract(contractInfo.getBalance());
                }
            } else {
                loanContractOfLenderEntryInfo.setOverLoanAmount(overLoanAmount.subtract(fetchAmount));
                loanContractOfLenderEntryInfo.setLoanBalance(loanBalance.subtract(fetchAmount));
                lastFetchAmount = overLoanAmount.subtract(fetchAmount);
                lastTotalFetchAmount = contractInfo.getAmount().subtract(contractInfo.getBalance());
            }
            lastFetchProportion = lastTotalFetchAmount.compareTo(Constants.ZERO) == 0 ? loanContractOfLenderEntryInfo.getPromiseProportion() : lastFetchAmount.multiply(Constants.ONE_HUNDRED).divide(lastTotalFetchAmount, 4);
            loanContractOfLenderEntryInfo.setFetchProportion(lastFetchProportion);
            LoanContractOfLenderEntryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(loanContractOfLenderEntryInfo.getId()), loanContractOfLenderEntryInfo);
        }
    }

    private void isAuditModify(Context ctx, LoanFetchInfo info) throws BOSException, EASBizException {
        ObjectUuidPK PK = new ObjectUuidPK(info.getId());
        boolean exist = this.exists(ctx, (IObjectPK)PK);
        LoanFetchInfo oldInfo = null;
        if (exist) {
            oldInfo = this.getLoanFetchInfo(ctx, (IObjectPK)PK);
        }
        if (oldInfo != null && info.getStatus() != oldInfo.getStatus() && oldInfo.getStatus() == FsBillStatusEnum.AUDIT) {
            throw new BEException(BEException.COMMON, new Object[]{"\u5f53\u524d\u8bb0\u5f55\u5df2\u7ecf\u5ba1\u6279\uff0c\u4e0d\u80fd\u63d0\u4ea4"});
        }
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        LoanFetchInfo info = (LoanFetchInfo)model;
        super._updateOther(ctx, pk, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LoanFetchInfo info = this.getLoanFetchInfo(ctx, pk);
        if (info.isIsExtension()) {
            throw new LoanSLException(LoanSLException.EXTENDSION_NOT_DELETE_EXCEPTION, new Object[]{info.getNumber()});
        }
        if (this.isWriteContract(ctx, info.getNumber())) {
            this.updateLoanContract(ctx, info);
            this.updateContractLoanBankEntrys(ctx, info, true, true);
            this.deleteContractExecuteEntry(ctx, info);
            this.cancelCreditLimit(ctx, info);
            SLAppUtils.cancelAssure(ctx, info);
            LoanFetchInfo nullInfo = new LoanFetchInfo();
            nullInfo.setId(BOSUuid.read((String)pk.toString()));
            this.writeWage(ctx, nullInfo);
        }
        super._deleteOther(ctx, pk);
        SLAppUtils.removeBotpRelation(ctx, info);
    }

    private void cancelCreditLimit(Context ctx, LoanFetchInfo info) throws EASBizException, BOSException {
        HashMap<BOSUuid, CreditLimitInfo> creditMap = new HashMap<BOSUuid, CreditLimitInfo>();
        LoanFetchOfLenderEntryCollection colls = info.getLoanBankEntry();
        for (int i = 0; i < colls.size(); ++i) {
            BOSUuid id;
            LoanFetchOfLenderEntryInfo entryInfo = colls.get(i);
            if (FMHelper.isEmpty((CoreBaseInfo)entryInfo.getCreditLimit()) || creditMap.containsKey(id = entryInfo.getCreditLimit().getId())) continue;
            creditMap.put(id, entryInfo.getCreditLimit());
        }
        for (BOSUuid id : creditMap.keySet()) {
            CreditLimitInfo credit = (CreditLimitInfo)creditMap.get(id);
            CreditLimitManagerFactory.getLocalInstance((Context)ctx).cancelLimit(info.getId(), credit.getId());
        }
    }

    private boolean isWriteContract(Context ctx, String fetchNumber) throws BOSException, EASBizException {
        if (fetchNumber == null) {
            return false;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fetchAmountNo", (Object)fetchNumber));
        return LoanContractExecuteEntryFactory.getLocalInstance(ctx).exists(filter);
    }

    protected void deleteContractExecuteEntry(Context ctx, LoanFetchInfo info) throws BOSException, EASBizException {
        if (info == null) {
            return;
        }
        String sourceBillId = info.getSourceBillId();
        int fetchNumber = info.getFetchSeq();
        String sql = "delete from T_SL_LoanContractExecuteEntry where fparentid=? and ffetchamountseq=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{sourceBillId, String.valueOf(fetchNumber)});
    }

    protected void updateLoanContract(Context ctx, LoanFetchInfo info) throws BOSException, EASBizException {
        BigDecimal totalBalance;
        if (info == null) {
            return;
        }
        String sourceBillId = info.getSourceBillId();
        ObjectStringPK pk = new ObjectStringPK(sourceBillId);
        LoanContractInfo loanContractInfo = LoanContractFactory.getLocalInstance(ctx).getLoanContractInfo((IObjectPK)pk);
        if (info.getFetchSeq() == 1) {
            loanContractInfo.setFirstFetchDate(null);
            loanContractInfo.setExpiredDate(null);
        }
        BigDecimal fetchAmount = info.getAmount();
        BigDecimal balance = info.getBalance();
        BigDecimal notFetchAmount = loanContractInfo.getBalance();
        BigDecimal totalFetchAmount = FMHelper.isEmpty((Object)loanContractInfo.getTotalFetchAmount()) ? Constants.ZERO : loanContractInfo.getTotalFetchAmount();
        BigDecimal bigDecimal = totalBalance = FMHelper.isEmpty((Object)loanContractInfo.getTotalBalance()) ? Constants.ZERO : loanContractInfo.getTotalBalance();
        if (notFetchAmount != null && fetchAmount != null && balance != null) {
            loanContractInfo.setBalance(notFetchAmount.add(fetchAmount));
            loanContractInfo.setTotalFetchAmount(totalFetchAmount.subtract(fetchAmount));
            loanContractInfo.setTotalBalance(totalBalance.subtract(balance));
        }
        LoanContractFactory.getLocalInstance(ctx).update((IObjectPK)pk, loanContractInfo);
    }

    @Override
    protected int _existsLoancontract(Context ctx, String sourceBillId, boolean isHistoryLoanContract) throws BOSException, EASBizException {
        if (sourceBillId == null) {
            return 0;
        }
        String sql = "select max(FFetchSeq) seq from T_SL_LoanFetch where FSourceBillID=? group by FSourceBillID";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{sourceBillId});
        IRowSet rs1 = null;
        int count = 0;
        int historyCount = 0;
        if (isHistoryLoanContract) {
            String sql1 = "select max(FFetchAmountSeq) historySeq from T_SL_LoanContractExecuteEntry where FParentID=? group by FParentID";
            rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new Object[]{sourceBillId});
            try {
                if (rs1.next()) {
                    historyCount = rs1.getInt("historySeq");
                }
            }
            catch (SQLException ex1) {
                throw new BOSException((Throwable)ex1);
            }
        }
        try {
            if (rs.next()) {
                count = rs.getInt("seq");
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        if (count < historyCount) {
            return historyCount;
        }
        return count;
    }

    protected LoanFetchInfo getLoanFetchByNumber(Context ctx, String number) throws BOSException, EASBizException {
        LoanFetchInfo info = null;
        if (FMHelper.isEmpty((String)number)) {
            return info;
        }
        FilterInfo filterInt = new FilterInfo();
        filterInt.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInt);
        LoanFetchCollection coll = LoanFetchFactory.getLocalInstance(ctx).getLoanFetchCollection(evi);
        if (!FMHelper.isEmpty((AbstractObjectCollection)coll)) {
            info = coll.get(0);
        }
        return info;
    }

    @Override
    protected void _contractExtension(Context ctx, String sourceBillId, Date extensionTime, boolean extensionFlag) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)sourceBillId)) {
            return;
        }
        FilterInfo filterInt = new FilterInfo();
        filterInt.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)sourceBillId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInt);
        LoanFetchCollection coll = LoanFetchFactory.getLocalInstance(ctx).getLoanFetchCollection(evi);
        LoanContractInfo loanContractInfo = LoanContractFactory.getLocalInstance(ctx).getLoanContractInfo((IObjectPK)new ObjectStringPK(sourceBillId));
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            LoanFetchInfo info = (LoanFetchInfo)it.next();
            if (extensionFlag) {
                info.setIsExtension(extensionFlag);
                info.setExtensionDate(info.getExpiredDate());
                info.setExpiredDate(extensionTime);
                info.setHorizon(SLUtils.getHorizon(info.getIssueDate(), extensionTime));
            } else if (info.isIsExtension()) {
                info.setIsExtension(extensionFlag);
                info.setExpiredDate(info.getExtensionDate());
                info.setHorizon(SLUtils.getHorizon(info.getIssueDate(), info.getExtensionDate()));
                info.setExtensionDate(null);
            } else if (!FMHelper.isEmpty((Object)loanContractInfo.getExpiredDate())) {
                info.setExpiredDate(loanContractInfo.getExpiredDate());
                info.setHorizon(SLUtils.getHorizon(info.getIssueDate(), loanContractInfo.getExpiredDate()));
            }
            this.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), info);
        }
    }

    private void checkExesitsDBFetchNumber(Context ctx, LoanFetchInfo info) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        if (FMHelper.isEmpty((CoreBaseInfo)currCompany)) {
            return;
        }
        String needCheckFetchNumber = "";
        BOSUuid fid = info.getId();
        String number = info.getNumber();
        if (FMHelper.isEmpty((Object)fid)) {
            needCheckFetchNumber = needCheckFetchNumber + "'" + number + "',";
        } else {
            LoanFetchInfo fetchInfo = this.getLoanFetchByNumber(ctx, number);
            if (!FMHelper.isEmpty((CoreBaseInfo)fetchInfo)) {
                if (!FMHelper.isEmpty((String)number) && !number.equals(fetchInfo.getNumber())) {
                    needCheckFetchNumber = needCheckFetchNumber + "'" + number + "',";
                }
            } else {
                needCheckFetchNumber = needCheckFetchNumber + "'" + number + "',";
            }
        }
        this._existsFetchNumber(ctx, needCheckFetchNumber, currCompany.getId().toString());
    }

    @Override
    protected void _existsFetchNumber(Context ctx, String fetchNumber, String companyId) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)fetchNumber) || fetchNumber.length() == 0) {
            return;
        }
        fetchNumber = SLUtils.subString(fetchNumber, ",");
        String fetchNO = "";
        String sql = "select  t.FFetchAmountNo  from T_SL_LoanContractExecuteEntry t inner join t_sl_loancontract x on t.fparentid=x.fid where t.FFetchAmountNo in (" + fetchNumber + ") and x.FCompanyID=? group by t.FFetchAmountNo";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{companyId});
        try {
            while (rs.next()) {
                fetchNO = fetchNO + rs.getString("FFetchAmountNo") + ",";
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (!FMHelper.isEmpty((String)fetchNO)) {
            throw new LoanSLException(LoanSLException.CONTRACT_EXECUTE_EXISTS_FETCHNUMBER, new Object[]{SLUtils.subString(fetchNO, ",")});
        }
        String sql_ = "select t.Fnumber   from T_SL_LoanFetch t where t.Fnumber in (" + fetchNumber + ") and t.FCompanyID=? group by t.Fnumber";
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql_, (Object[])new Object[]{companyId});
        try {
            while (rs1.next()) {
                fetchNO = fetchNO + rs1.getString("Fnumber") + ",";
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (!FMHelper.isEmpty((String)fetchNO)) {
            throw new LoanSLException(LoanSLException.EXISTS_FETCHNUMBER, new Object[]{SLUtils.subString(fetchNO, ",")});
        }
    }

    @Override
    public void _dispose(Context ctx, IObjectValue destInfo, DisposerActionEnum actionType) throws BOSException, EASBizException {
        if (destInfo != null && destInfo instanceof ReceivingBillInfo) {
            ReceivingBillInfo recingBillInfo = (ReceivingBillInfo)destInfo;
            LoanFetchInfo loanFetchInfo = null;
            ReceivingBillEntryInfo receivingEnInfo = null;
            ReceivingBillEntryCollection receiveEntryNum = recingBillInfo.getEntries();
            if (receiveEntryNum != null && receiveEntryNum.size() > 0) {
                receivingEnInfo = receiveEntryNum.get(0);
                loanFetchInfo = this.getLoanFetchInfo(ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)receivingEnInfo.getSourceBillId())));
            }
            if (loanFetchInfo != null && actionType != null && (actionType.equals((Object)DisposerActionEnum.SAVE) || actionType.equals((Object)DisposerActionEnum.SUBMIT))) {
                BigDecimal amount = FMHelper.isEmpty((Object)receivingEnInfo.getActualAmt()) ? Constants.ZERO : receivingEnInfo.getActualAmt();
                Date issueDate = loanFetchInfo.getIssueDate();
                Date recBizDate = recingBillInfo.getBizDate();
                if (!loanFetchInfo.getCurrency().getId().equals((Object)recingBillInfo.getCurrency().getId()) || loanFetchInfo.getAmount().compareTo(amount) != 0) {
                    throw new LoanSLException(LoanSLException.CAN_NOT_MODIFY_CREATETORECEIVEBILL);
                }
                if (issueDate != null && recBizDate != null && issueDate.compareTo(recBizDate) != 0) {
                    throw new LoanSLException(LoanSLException.CAN_NOT_MODIFY_CREATETORECEIVEBILL);
                }
            }
            if (actionType != null && (actionType.equals((Object)DisposerActionEnum.SAVE) || actionType.equals((Object)DisposerActionEnum.SUBMIT))) {
                DbUtil.execute((Context)ctx, (String)("update " + this.getDBTableName() + " set FIsGenRecBill= 1 where FID=?"), (Object[])new Object[]{receivingEnInfo.getSourceBillId()});
            }
            if (actionType != null && actionType.equals((Object)DisposerActionEnum.DELETE)) {
                DbUtil.execute((Context)ctx, (String)("update " + this.getDBTableName() + " set FIsGenRecBill = 0 where FIsGenRecBill is not null and FID=?"), (Object[])new Object[]{receivingEnInfo.getSourceBillId()});
            }
        }
    }

    protected String getDBTableName() {
        return "T_SL_LOANFETCH";
    }

    @Override
    public boolean _existsDownStream(Context ctx, String sql) throws BOSException, EASBizException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next() && rs.size() > 0) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }
}

