/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sl.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.ctl.AssureBillFactory;
import com.kingdee.eas.fm.ctl.AssureBillInfo;
import com.kingdee.eas.fm.ctl.AssureBillManagerFacadeFactory;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.GuanTypeBillEnum;
import com.kingdee.eas.fm.fin.GuaranteeDetailInfo;
import com.kingdee.eas.fm.fin.WageFactory;
import com.kingdee.eas.fm.fin.WageInfo;
import com.kingdee.eas.fm.sl.LoanContractInfo;
import com.kingdee.eas.fm.sl.LoanContractOfLenderEntryCollection;
import com.kingdee.eas.fm.sl.LoanContractOfLenderEntryInfo;
import com.kingdee.eas.fm.sl.LoanFetchInfo;
import com.kingdee.eas.fm.sl.LoanFetchOfLenderEntryCollection;
import com.kingdee.eas.fm.sl.LoanFetchOfLenderEntryInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;

public class SLAppUtils {
    public static final String RepayInterestBOSType = "3562F30C";

    public static void createBotpRelation(Context ctx, FinancingBillInfo info) throws BOSException, EASBizException {
        SLAppUtils.addAssureBillBotp(ctx, info);
        SLAppUtils.addWageBotp(ctx, info);
        if (info instanceof LoanContractInfo) {
            SLAppUtils.addCreditLimitBotpForLoanContract(ctx, (LoanContractInfo)info);
        }
        if (info instanceof LoanFetchInfo) {
            SLAppUtils.addCreditLimitBotpForLoanFetch(ctx, (LoanFetchInfo)info);
        }
    }

    public static void addAssureBillBotp(Context ctx, FinancingBillInfo info) throws BOSException, EASBizException {
        for (GuaranteeDetailInfo element : info.getGuaranteeEntrys()) {
            AssureBillInfo assBill;
            if (element.getBilltype() != GuanTypeBillEnum.AssureBill || element.getBillId() == null || (assBill = AssureBillFactory.getLocalInstance((Context)ctx).getAssureBillInfo((IObjectPK)new ObjectUuidPK(element.getBillId()))) == null || assBill.getId() == null) continue;
            FinUtils.addBotRelation((Context)ctx, (String)assBill.getId().toString(), (String)info.getId().toString());
        }
    }

    public static void addWageBotp(Context ctx, FinancingBillInfo info) throws EASBizException, BOSException {
        for (GuaranteeDetailInfo element : info.getGuaranteeEntrys()) {
            WageInfo wageInfo;
            if (element.getBilltype() != GuanTypeBillEnum.wage || element.getBillId() == null || (wageInfo = WageFactory.getLocalInstance((Context)ctx).getWageInfo((IObjectPK)new ObjectUuidPK(element.getBillId()))) == null) continue;
            FinUtils.addBotRelation((Context)ctx, (String)wageInfo.getId().toString(), (String)info.getId().toString());
        }
    }

    public static void addCreditLimitBotpForLoanContract(Context ctx, LoanContractInfo info) throws BOSException, EASBizException {
        LoanContractOfLenderEntryCollection lenderEntryCollection = info.getLoanBankEntry();
        if (lenderEntryCollection != null && lenderEntryCollection.size() > 0) {
            LoanContractOfLenderEntryInfo entryInfo = null;
            for (int i = 0; i < info.getLoanBankEntry().size(); ++i) {
                entryInfo = lenderEntryCollection.get(i);
                CreditLimitInfo creditLimitInfo = entryInfo.getCreditLimit();
                if (creditLimitInfo == null || creditLimitInfo.getId() == null) continue;
                FinUtils.addBotRelation((Context)ctx, (String)creditLimitInfo.getId().toString(), (String)info.getId().toString());
            }
        }
    }

    public static void addCreditLimitBotpForLoanFetch(Context ctx, LoanFetchInfo info) throws BOSException, EASBizException {
        LoanFetchOfLenderEntryCollection lenderEntryCollection = info.getLoanBankEntry();
        if (lenderEntryCollection != null && lenderEntryCollection.size() > 0) {
            LoanFetchOfLenderEntryInfo entryInfo = null;
            for (int i = 0; i < info.getLoanBankEntry().size(); ++i) {
                entryInfo = lenderEntryCollection.get(i);
                CreditLimitInfo creditLimitInfo = entryInfo.getCreditLimit();
                if (creditLimitInfo == null || creditLimitInfo.getId() == null) continue;
                FinUtils.addBotRelation((Context)ctx, (String)creditLimitInfo.getId().toString(), (String)info.getId().toString());
            }
        }
    }

    public static void createBotpWithLoanApply(Context ctx, LoanContractInfo info) throws BOSException, EASBizException {
        if (info == null || info.getSourceBillId() == null) {
            return;
        }
        FinUtils.addBotRelation((Context)ctx, (String)info.getSourceBillId(), (String)info.getId().toString());
    }

    public static void createBotpWithLoanContract(Context ctx, LoanFetchInfo info) throws BOSException, EASBizException {
        if (info == null || info.getSourceBillId() == null) {
            return;
        }
        FinUtils.addBotRelation((Context)ctx, (String)info.getSourceBillId(), (String)info.getId().toString());
    }

    public static void removeBotpRelation(Context ctx, FinancingBillInfo info) throws BOSException, EASBizException {
        SLAppUtils.removeMainBotpRelation(ctx, info);
        SLAppUtils.removeEntryBotpRelation(ctx, info);
    }

    public static void removeEntryBotpRelation(Context ctx, FinancingBillInfo info) throws BOSException, EASBizException {
        if (info == null || info.getId() == null) {
            return;
        }
        Object[] paramList = new Object[]{info.getId().toString()};
        String sql = "delete from T_BOT_RelationEntry where fdestobjectid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])paramList);
    }

    public static void removeMainBotpRelation(Context ctx, FinancingBillInfo info) throws BOSException, EASBizException {
        if (info == null || info.getId() == null) {
            return;
        }
        Object[] paramList = new Object[]{info.getId().toString()};
        String sql = "delete from T_BOT_Relation where fdestobjectid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])paramList);
    }

    public static void cancelAssure(Context ctx, FinancingBillInfo info) throws BOSException, EASBizException {
        AssureBillManagerFacadeFactory.getLocalInstance((Context)ctx).cancelAssure(info.getId());
    }

    public static BigDecimal getBigDecimalValue(BigDecimal amount) {
        if (amount == null) {
            amount = Constants.ZERO;
        }
        return amount;
    }
}

