/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.sl.util;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.util.MsgPromtUtil;
import com.kingdee.eas.fm.sl.LoanSLException;
import com.kingdee.eas.fm.sl.util.SLUtils;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class DownStreamObject {
    private static Set existsRecordSet = new HashSet();
    private String tableName;
    private String[] sqlParams = null;
    private Object[] params = null;
    private Object[] execParams = null;
    private NumericExceptionSubItem exec = null;
    private String resource = null;
    private String msgKey = null;
    private CoreUI ui = null;
    private String type = null;
    private String exceptionType = null;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public CoreUI getUi() {
        return this.ui;
    }

    public void setUi(CoreUI ui) {
        this.ui = ui;
    }

    public DownStreamObject(String tableName, String[] sqlParams, Object[] params, NumericExceptionSubItem exec, Object[] execParams) {
        this.tableName = tableName;
        this.sqlParams = sqlParams;
        this.params = params;
        this.exec = exec;
        this.execParams = execParams;
        existsRecordSet.add(this);
    }

    public DownStreamObject(String tableName, String[] sqlParams, Object[] params, CoreUI ui, String resource, String msgKey) {
        this.tableName = tableName;
        this.sqlParams = sqlParams;
        this.params = params;
        this.resource = resource;
        this.msgKey = msgKey;
        this.ui = ui;
        existsRecordSet.add(this);
    }

    public DownStreamObject(String tableName, String[] sqlParams, Object[] params) {
        this.tableName = tableName;
        this.sqlParams = sqlParams;
        this.params = params;
        existsRecordSet.add(this);
    }

    public DownStreamObject(String tableName, String[] sqlParams, Object[] params, NumericExceptionSubItem exec) {
        this.tableName = tableName;
        this.sqlParams = sqlParams;
        this.params = params;
        this.exec = exec;
        existsRecordSet.add(this);
    }

    public DownStreamObject(String tableName, NumericExceptionSubItem exec) {
        this.tableName = tableName;
        this.exec = exec;
        existsRecordSet.add(this);
    }

    public void operate(String type) throws BOSException, EASBizException {
        if (!FMHelper.isEmpty((Collection)existsRecordSet)) {
            for (DownStreamObject obj : existsRecordSet) {
                boolean returnFlag = SLUtils.existsDownstreamItem(obj.getTableName(), obj.getSqlParams(), obj.getParams());
                if (!returnFlag) continue;
                existsRecordSet.clear();
                if (type.equals("client")) {
                    this.showMessage(obj.getUi(), obj.getResource(), obj.getMsgKey());
                    continue;
                }
                if (!type.equals("app")) continue;
                this.throwsException(obj.getExec(), obj.getExecParams());
            }
            existsRecordSet.clear();
        }
    }

    public void operateForApp() throws BOSException, EASBizException {
        this.operate("app");
    }

    public void operateForClient() throws BOSException, EASBizException {
        this.operate("client");
    }

    public void showMessage(CoreUI ui, String path, String msgKey) {
        if (ui == null || path == null || msgKey == null) {
            return;
        }
        MsgPromtUtil.showInfo((CoreUI)ui, (String)path, (String)msgKey);
    }

    public void throwsException(NumericExceptionSubItem exec, Object[] execParams) throws LoanSLException {
        if (exec == null) {
            return;
        }
        if (execParams == null) {
            throw new LoanSLException(exec);
        }
        throw new LoanSLException(exec, execParams);
    }

    public static Set getExistsRecordSet() {
        return existsRecordSet;
    }

    public static void setExistsRecordSet(Set existsRecordSet) {
        DownStreamObject.existsRecordSet = existsRecordSet;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String[] getSqlParams() {
        return this.sqlParams;
    }

    public void setSqlParams(String[] sqlParams) {
        this.sqlParams = sqlParams;
    }

    public Object[] getParams() {
        return this.params;
    }

    public void setParams(Object[] params) {
        this.params = params;
    }

    public Object[] getExecParams() {
        return this.execParams;
    }

    public void setExecParams(Object[] execParams) {
        this.execParams = execParams;
    }

    public NumericExceptionSubItem getExec() {
        return this.exec;
    }

    public void setExec(NumericExceptionSubItem exec) {
        this.exec = exec;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getMsgKey() {
        return this.msgKey;
    }

    public void setMsgKey(String msgKey) {
        this.msgKey = msgKey;
    }

    public String getExceptionType() {
        return this.exceptionType;
    }

    public void setExceptionType(String exceptionType) {
        this.exceptionType = exceptionType;
    }
}

