/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ss.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.ss.BillTypeFactory;
import com.kingdee.eas.fm.ss.BillTypeInfo;
import com.kingdee.eas.fm.ss.BusinessTypeFactory;
import com.kingdee.eas.fm.ss.BusinessTypeInfo;
import com.kingdee.eas.fm.ss.SmartSettleEntryBusinessInfo;
import com.kingdee.eas.fm.ss.app.AbstractSmartSettleEntryBusinessControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class SmartSettleEntryBusinessControllerBean
extends AbstractSmartSettleEntryBusinessControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.ss.app.SmartSettleEntryBusinessControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CoreBaseInfo info;
        SmartSettleEntryBusinessInfo businessEntry = (SmartSettleEntryBusinessInfo)model;
        System.out.println("===========");
        int subSystem = businessEntry.getSubSystem().getValue();
        String businessNumber = businessEntry.getBusinessNumber();
        String operatorNumber = businessEntry.getOperatorNumber();
        String billId = null;
        String businessId = null;
        int isBill = 0;
        if (operatorNumber.equals("scpz")) {
            billId = this.getBillTypeID(ctx, subSystem, businessNumber);
            isBill = 1;
        } else {
            businessId = this.getBusinessTypeID(ctx, subSystem, businessNumber, operatorNumber);
        }
        if (billId != null) {
            if (operatorNumber.equals("scpz")) {
                info = (BillTypeInfo)BillTypeFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(billId));
                businessEntry.setBillType((BillTypeInfo)info);
            } else {
                businessEntry.setBillType(null);
            }
        } else {
            businessEntry.setBillType(null);
        }
        if (businessId != null) {
            info = (BusinessTypeInfo)BusinessTypeFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(businessId));
            isBill = info.getIsBill();
            businessEntry.setBusinessType((BusinessTypeInfo)info);
        }
        businessEntry.setIsBill(isBill);
        IObjectPK businessPK = super._submit(ctx, (IObjectValue)businessEntry);
        return businessPK;
    }

    private String getBillTypeID(Context ctx, int subSystem, String number) throws BOSException, EASBizException {
        String id = null;
        boolean exist = false;
        Connection cn = null;
        PreparedStatement psStmt = null;
        ResultSet rs = null;
        String sql = "SELECT  fid FROM t_ss_billtype where FSubSystem=? and FBosObjectType = ?  ";
        try {
            cn = this.getConnection(ctx);
            psStmt = cn.prepareStatement(sql);
            psStmt.setInt(1, subSystem);
            psStmt.setString(2, number);
            rs = psStmt.executeQuery();
            if (rs.next()) {
                id = rs.getString("fid");
            }
        }
        catch (SQLException sqle) {
            try {
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, psStmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)psStmt, (Connection)cn);
        return id;
    }

    private String getBusinessTypeID(Context ctx, int subSystem, String businessNumber, String operatorNumber) throws BOSException, EASBizException {
        String id = null;
        boolean exist = false;
        Connection cn = null;
        PreparedStatement psStmt = null;
        ResultSet rs = null;
        String sql = "SELECT  fid FROM t_ss_businesstype where FSubSystem=? and FNumber = ? and FOperatorNumber = ? ";
        try {
            cn = this.getConnection(ctx);
            psStmt = cn.prepareStatement(sql);
            psStmt.setInt(1, subSystem);
            psStmt.setString(2, businessNumber);
            psStmt.setString(3, operatorNumber);
            rs = psStmt.executeQuery();
            if (rs.next()) {
                id = rs.getString("fid");
            }
        }
        catch (SQLException sqle) {
            try {
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, psStmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)psStmt, (Connection)cn);
        return id;
    }
}

