/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ss.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.ss.SmartSettleEntryBusinessInfo;
import com.kingdee.eas.fm.ss.SmartSettleEntryCompanyCollection;
import com.kingdee.eas.fm.ss.SmartSettleEntryCompanyInfo;
import com.kingdee.eas.fm.ss.SmartSettleReportFactory;
import com.kingdee.eas.fm.ss.SmartSettleReportInfo;
import com.kingdee.eas.fm.ss.SmartSettleSchemaFactory;
import com.kingdee.eas.fm.ss.SmartSettleSchemaInfo;
import com.kingdee.eas.fm.ss.SmartSettleStateEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;

public class SmartSettleSchemaUtils {
    private static Logger logger = Logger.getLogger(SmartSettleSchemaUtils.class);
    private static String resource = "com.kingdee.eas.fi.vc.SmartSettleResource";

    public static String createGuuid(Context ctx) {
        String id = UUID.randomUUID().toString();
        id = id.replaceAll("-", "");
        return id;
    }

    public static String getFirstReportIDByGuuid(Context ctx, String guuid) throws BOSException, EASBizException {
        String reportID = null;
        String sql = " select top 1 fid from T_SS_SmartSettleReport where fguuid='" + guuid + "' and fstatus = 0 order by fseq ";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                reportID = rs.getString("fid");
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return reportID;
    }

    public static MutexParameter getTaskMutexParameter(Context ctx, String dcName, String schemaID, String businessEntryID, String companyID, String userId, String actionResName, String actionDetail, MutexLockType type) {
        MutexParameter mp = new MutexParameter();
        Uuid requestId = Uuid.create();
        mp.setRequestId(requestId);
        if (businessEntryID != null) {
            mp.setMutexName("GL_SmartSettle_" + schemaID + "_" + businessEntryID + "_" + companyID);
        } else {
            mp.setMutexName("GL_SmartSettle_" + schemaID);
        }
        String actionName = ResourceBase.getString((String)"com.kingdee.eas.fm.ss.SmartSettleResource", (String)actionResName, (Locale)ctx.getLocale());
        if (actionDetail != null && actionDetail.trim().length() > 0) {
            actionName = actionName + "[" + actionDetail.trim() + "]";
        }
        mp.setActionName(actionName);
        if (!EmptyUtil.isEmpty((String)companyID)) {
            mp.setOrgUnitID(BOSUuid.read((String)companyID));
        }
        mp.setUserID(BOSUuid.read((String)userId));
        mp.setMutexLockType(type);
        if (dcName == null) {
            dcName = "";
        }
        mp.setDcName(dcName);
        String description = ResourceBase.getString((String)"com.kingdee.eas.fi.vc.SmartSettleResource", (String)"GL_SmartSettle", (Locale)ctx.getLocale());
        mp.setDescription(description);
        return mp;
    }

    public static List getSchemaAllTaskInfo(Context ctx, String schemaID) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        int seq = 1;
        if (schemaID == null) {
            return null;
        }
        SmartSettleSchemaInfo schemaInfo = SmartSettleSchemaFactory.getLocalInstance(ctx).getSmartSettleSchemaInfo((IObjectPK)new ObjectUuidPK(schemaID), SmartSettleSchemaInfo.getDefaultSelector());
        if (schemaInfo != null) {
            Iterator busiItr = schemaInfo.getSmartAccountEntriesBusiness().iterator();
            SmartSettleEntryCompanyCollection comCol = schemaInfo.getSmartAccountEntriesCompany();
            while (busiItr.hasNext()) {
                SmartSettleEntryBusinessInfo busi = (SmartSettleEntryBusinessInfo)busiItr.next();
                if (!EmptyUtil.isEmpty((AbstractObjectCollection)comCol)) {
                    for (int i = 0; i < comCol.size(); ++i) {
                        SmartSettleEntryCompanyInfo com = comCol.get(i);
                        HashMap<String, Serializable> temp = new HashMap<String, Serializable>();
                        temp.put("schema", schemaInfo);
                        temp.put("businessEntry", busi);
                        temp.put("companyEntry", com);
                        temp.put("seq", Integer.valueOf(seq++));
                        result.add(temp);
                    }
                    continue;
                }
                HashMap<String, Serializable> temp = new HashMap<String, Serializable>();
                temp.put("schema", schemaInfo);
                temp.put("businessEntry", busi);
                temp.put("companyEntry", null);
                temp.put("seq", Integer.valueOf(seq++));
                result.add(temp);
            }
        }
        return result;
    }

    public static List getSchemaAllTaskID(Context ctx, String schemaID) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        int seq = 1;
        if (schemaID == null) {
            return null;
        }
        SmartSettleSchemaInfo schemaInfo = SmartSettleSchemaFactory.getLocalInstance(ctx).getSmartSettleSchemaInfo((IObjectPK)new ObjectUuidPK(schemaID));
        if (schemaInfo != null) {
            Iterator busiItr = schemaInfo.getSmartAccountEntriesBusiness().iterator();
            Iterator comItr = schemaInfo.getSmartAccountEntriesCompany().iterator();
            while (busiItr.hasNext()) {
                String busiID = ((SmartSettleEntryBusinessInfo)busiItr.next()).getId().toString();
                while (comItr.hasNext()) {
                    String comID = ((SmartSettleEntryCompanyInfo)comItr.next()).getId().toString();
                    String com = ((SmartSettleEntryCompanyInfo)comItr.next()).getCompany().getId().toString();
                    HashMap<String, Object> temp = new HashMap<String, Object>();
                    temp.put("schema", schemaID);
                    temp.put("businessEntry", busiID);
                    temp.put("companyEntry", comID);
                    temp.put("company", com);
                    temp.put("seq", seq++);
                    result.add(temp);
                }
            }
        }
        return result;
    }

    public static EntityViewInfo getSmartSettleReportByParam(String schemaID, String businessID, String companyID, String reportID) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("smartAccounting", (Object)schemaID, CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("businessEntry", (Object)businessID, CompareType.EQUALS));
        if (!EmptyUtil.isEmpty((String)companyID)) {
            fi.getFilterItems().add(new FilterItemInfo("company", (Object)companyID, CompareType.EQUALS));
        }
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)reportID, CompareType.EQUALS));
        evi.setFilter(fi);
        return evi;
    }

    public static String record(Context ctx, SmartSettleSchemaInfo schema, SmartSettleEntryBusinessInfo busiInfo, SmartSettleEntryCompanyInfo comInfo, int status, String result, int sucessCount, int failureCount, UserInfo exeUser, String reportID, String uuid, int seq) throws BOSException, EASBizException {
        SmartSettleReportInfo reportInfo = null;
        CoreBaseCollection reportCollection = null;
        String schemaID = schema.getId().toString();
        String businessID = busiInfo.getId().toString();
        String companyID = null;
        if (comInfo != null) {
            companyID = comInfo.getCompany().getId().toString();
        }
        logger.error((Object)("SmartSettleSchemaUtils record ------ " + schemaID + " ------- Begin."));
        if (reportID != null) {
            EntityViewInfo evi = SmartSettleSchemaUtils.getSmartSettleReportByParam(schemaID, businessID, companyID, reportID);
            reportCollection = SmartSettleReportFactory.getLocalInstance(ctx).getCollection(evi);
            CoreBaseCollection vrcNew = new CoreBaseCollection();
            if (reportCollection.size() > 0) {
                SmartSettleReportInfo info = (SmartSettleReportInfo)reportCollection.get(0);
                if (status == 1) {
                    info.setStatus(SmartSettleStateEnum.STATE_PROCESS);
                    info.setExeStartTime(new Date());
                } else if (status == 2) {
                    info.setStatus(SmartSettleStateEnum.STATE_FINISHED);
                    info.setExeEndTime(new Date());
                    if (sucessCount != 0) {
                        info.setSuccessCount(sucessCount);
                    }
                    if (failureCount != 0) {
                        info.setFailureCount(failureCount);
                    }
                    info.setResult(result);
                }
                info.setModule(schema.getModule());
                reportInfo = info;
            } else {
                reportInfo = new SmartSettleReportInfo();
                reportInfo.setSubSystem(busiInfo.getSubSystem());
                reportInfo.setBusinessNumber(busiInfo.getBusinessNumber());
                reportInfo.setOperatorNumber(busiInfo.getOperatorNumber());
                reportInfo.setModule(schema.getModule());
                Date date = new Date();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String strDate = sdf.format(date);
                try {
                    date = sdf.parse(strDate);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
                if (status == 1) {
                    reportInfo.setStatus(SmartSettleStateEnum.STATE_PROCESS);
                    reportInfo.setExeStartTime(new Date());
                } else if (status == 2) {
                    reportInfo.setStatus(SmartSettleStateEnum.STATE_FINISHED);
                    reportInfo.setExeEndTime(new Date());
                }
                reportInfo.setExeStartTime(date);
                reportInfo.setSmartAccounting(schema);
                reportInfo.setBusinessEntry(busiInfo);
                reportInfo.setCompanyEntry(comInfo);
                if (companyID != null) {
                    reportInfo.setCompany(comInfo.getCompany());
                }
                reportInfo.setUser(exeUser);
                reportInfo.setBusinessType(busiInfo.getBusinessType());
                reportInfo.setBillType(busiInfo.getBillType());
                reportInfo.setGuuID(uuid);
                reportInfo.setSeq(seq);
            }
        } else {
            reportInfo = new SmartSettleReportInfo();
            reportInfo.setSubSystem(busiInfo.getSubSystem());
            reportInfo.setBusinessNumber(busiInfo.getBusinessNumber());
            reportInfo.setOperatorNumber(busiInfo.getOperatorNumber());
            reportInfo.setModule(schema.getModule());
            Date date = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String strDate = sdf.format(date);
            try {
                date = sdf.parse(strDate);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            reportInfo.setStatus(SmartSettleStateEnum.STATE_WAITING);
            reportInfo.setExeStartTime(date);
            reportInfo.setSmartAccounting(schema);
            reportInfo.setBusinessEntry(busiInfo);
            reportInfo.setCompanyEntry(comInfo);
            if (companyID != null) {
                reportInfo.setCompany(comInfo.getCompany());
            }
            reportInfo.setUser(exeUser);
            reportInfo.setBusinessType(busiInfo.getBusinessType());
            reportInfo.setBillType(busiInfo.getBillType());
            reportInfo.setGuuID(uuid);
            reportInfo.setSeq(seq);
        }
        IObjectPK reportPK = null;
        try {
            if (reportInfo != null) {
                reportPK = SmartSettleReportFactory.getLocalInstance(ctx).submitReportNew(reportInfo);
            }
            logger.error((Object)("SmartSettleSchemaUtils reportPK ------ " + reportPK + " ------- End."));
        }
        catch (Exception e) {
            String string = "";
        }
        return reportPK.toString();
    }

    public static String recordByID(Context ctx, String schemaID, String busiInfoID, String comInfoID, String companyID, String subSystem, String businessNumber, String operatorNumber, String billTypeID, String businessTypeID, UserInfo exeUser, String uuid, int seq, String module) throws BOSException, EASBizException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("schemaID", schemaID);
        paramMap.put("busiInfoID", busiInfoID);
        paramMap.put("companyID", companyID);
        paramMap.put("subSystem", subSystem);
        paramMap.put("businessNumber", businessNumber);
        paramMap.put("operatorNumber", operatorNumber);
        paramMap.put("exeUserID", exeUser.getId().toString());
        paramMap.put("comInfoID", comInfoID);
        paramMap.put("billTypeID", billTypeID);
        paramMap.put("businessTypeID", businessTypeID);
        paramMap.put("uuid", uuid);
        paramMap.put("seq", seq);
        paramMap.put("module", module);
        SmartSettleReportFactory.getLocalInstance(ctx).insertNew(paramMap, null);
        return null;
    }

    public static String recordByIDNew(Context ctx, String schemaID, String busiInfoID, String comInfoID, String companyID, String subSystem, String businessNumber, String operatorNumber, String billTypeID, String businessTypeID, UserInfo exeUser, String uuid, int seq) throws BOSException, EASBizException {
        Object reportInfo = null;
        Object reportCollection = null;
        DateFormat df = DateFormat.getDateInstance(1, Locale.CHINA);
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String strDate = sdf.format(date);
        try {
            date = sdf.parse(strDate);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        String sql = " insert into T_SS_SmartSettleReport(FID ,FSmartSettleID ,FSmartSettleEntryID ,FCompanyID ,FSubSystem ,FBusinessNumber ,FOperatorNumber ,FExecutor   ,FStatus ,FSmartAccountCompanyEntryID ,FBillTypeID ,FBusinessTypeID,FGuuID ,FSeq ) values(newbosid('D6248D4A'),?,?,?,?,?,?,?,?,?,?,?,?,?) ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{schemaID, busiInfoID, companyID, subSystem, businessNumber, operatorNumber, exeUser.getId().toString(), 0, comInfoID, billTypeID, businessTypeID, uuid, seq});
        return null;
    }

    public static List cancelTask(Context ctx, List paramList, UserInfo cancelUser) throws BOSException, EASBizException {
        int i;
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<ObjectUuidPK> canCancelIds = new ArrayList<ObjectUuidPK>();
        String schemaIds = "";
        String busiEntryIds = "";
        String comEntryIds = "";
        HashSet<String> schemaSet = new HashSet<String>();
        HashSet<String> busiSet = new HashSet<String>();
        HashSet<String> comSet = new HashSet<String>();
        ArrayList<String> keyList = new ArrayList<String>();
        for (int i2 = 0; i2 < paramList.size(); ++i2) {
            Map temp = (Map)paramList.get(i2);
            schemaIds = temp.get("schemaID").toString();
            busiEntryIds = temp.get("busiEntryID").toString();
            comEntryIds = temp.get("compEntryID").toString();
            schemaSet.add(schemaIds);
            busiSet.add(busiEntryIds);
            comSet.add(comEntryIds);
            keyList.add(temp.get("schemaID").toString() + temp.get("busiEntryID").toString() + temp.get("compEntryID").toString());
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("smartAccounting", schemaSet, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("businessEntry", busiSet, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("companyEntry", comSet, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("status", (Object)0, CompareType.EQUALS));
        evi.setFilter(fi);
        evi.setSelector(SmartSettleReportInfo.getDefaultSelectorForRegister());
        CoreBaseCollection reportCollection = SmartSettleReportFactory.getLocalInstance(ctx).getCollection(evi);
        HashMap<String, SmartSettleReportInfo> reportMap = new HashMap<String, SmartSettleReportInfo>();
        for (i = 0; i < reportCollection.size(); ++i) {
            SmartSettleReportInfo temp = (SmartSettleReportInfo)reportCollection.get(i);
            String key = temp.getSmartAccounting().getId().toString() + temp.getBusinessEntry().getId().toString() + temp.getCompanyEntry().getId().toString();
            reportMap.put(key, temp);
        }
        for (i = 0; i < keyList.size(); ++i) {
            SmartSettleReportInfo reportInfo = (SmartSettleReportInfo)reportMap.get(keyList.get(i));
            if (reportInfo == null) continue;
            if (reportInfo.getUser().getId().toString().equals(cancelUser.getId().toString())) {
                canCancelIds.add(new ObjectUuidPK(reportInfo.getId().toString()));
                continue;
            }
            String error = MessageFormat.format(EASResource.getString((String)resource, (String)"schemaMsg4", (Locale)ctx.getOriginLocale()), reportInfo.getSmartAccounting().getName(), reportInfo.getCompany().getName());
            String opeStr = "";
            opeStr = reportInfo.getBusinessType() == null ? MessageFormat.format(EASResource.getString((String)resource, (String)"schemaMsg5", (Locale)ctx.getOriginLocale()), reportInfo.getBillType().getName(), reportInfo.getUser().getName()) : MessageFormat.format(EASResource.getString((String)resource, (String)"schemaMsg6", (Locale)ctx.getOriginLocale()), reportInfo.getBusinessType().getName(), reportInfo.getBusinessType().getOperatorName(), reportInfo.getUser().getName());
            result.add(error + opeStr);
        }
        if (canCancelIds.size() > 0) {
            IObjectPK[] idPK = new IObjectPK[canCancelIds.size()];
            for (int i3 = 0; i3 < canCancelIds.size(); ++i3) {
                idPK[i3] = (IObjectPK)canCancelIds.get(i3);
                String sql = "select fbusinessId from T_SS_ExcuteStatus where fbusinessId = '" + canCancelIds.get(i3) + "'";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[0]);
                try {
                    if (rs == null || !rs.next()) continue;
                    sql = "delete from  T_SS_ExcuteStatus where fbusinessId = '" + canCancelIds.get(i3) + "'";
                    DbUtil.execute((Context)ctx, (String)sql);
                    sql = " update t_ss_smartSettlereport set fstatus = 2 where fid  ='" + canCancelIds.get(i3) + "'";
                    DbUtil.execute((Context)ctx, (String)sql);
                    continue;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            SmartSettleReportFactory.getLocalInstance(ctx).deleteNew(idPK);
        }
        return result;
    }

    public static List cancelTaskSingle(Context ctx, List paramList, UserInfo cancelUser) throws BOSException, EASBizException {
        ArrayList<String> result = new ArrayList<String>();
        IObjectPK[] canCancelIds = new IObjectPK[]{};
        String schemaIds = "";
        String busiEntryIds = "";
        String comEntryIds = "";
        ArrayList keyList = new ArrayList();
        if (paramList.size() > 0) {
            Map param = (Map)paramList.get(0);
            schemaIds = param.get("schemaID").toString();
            busiEntryIds = param.get("busiEntryID").toString();
            comEntryIds = param.get("compEntryID").toString();
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("smartSettle", (Object)schemaIds, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("businessEntry", (Object)busiEntryIds, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("companyEntry", (Object)comEntryIds, CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("status", (Object)0, CompareType.EQUALS));
            evi.setFilter(fi);
            evi.setSelector(SmartSettleReportInfo.getDefaultSelectorForRegister());
            CoreBaseCollection reportCollection = SmartSettleReportFactory.getLocalInstance(ctx).getCollection(evi);
            for (int i = 0; i < reportCollection.size(); ++i) {
                String opeStr;
                String error;
                SmartSettleReportInfo reportInfo = (SmartSettleReportInfo)reportCollection.get(i);
                if (reportInfo == null) {
                    error = "\u65b9\u6848 " + reportInfo.getSmartAccounting().getName() + " \u4e2d  " + reportInfo.getCompany().getName() + " \u516c\u53f8\u7684 ";
                    opeStr = "";
                    opeStr = reportInfo.getBusinessType() == null ? reportInfo.getBillType().getName() + " \u7684\u751f\u6210\u603b\u8d26\u51ed\u8bc1\u7684\u64cd\u4f5c \u4e0d\u662f\u7b49\u5f85\u4e2d\u7684\u4efb\u52a1\uff0c\u4e0d\u80fd\u53d6\u6d88!" : reportInfo.getBusinessType().getName() + " \u7684 " + reportInfo.getBusinessType().getOperatorName() + " \u7684\u64cd\u4f5c \u4e0d\u662f\u7b49\u5f85\u4e2d\u7684\u4efb\u52a1\uff0c\u4e0d\u80fd\u53d6\u6d88!";
                    result.add(error);
                    continue;
                }
                if (reportInfo.getUser().getId().toString().equals(cancelUser.getId().toString())) {
                    canCancelIds[canCancelIds.length] = new ObjectUuidPK(reportInfo.getId().toString());
                    continue;
                }
                error = "\u65b9\u6848 " + reportInfo.getSmartAccounting().getName() + " \u4e2d  " + reportInfo.getCompany().getName() + " \u516c\u53f8\u7684 ";
                opeStr = "";
                opeStr = reportInfo.getBusinessType() == null ? reportInfo.getBillType().getName() + " \u7684\u751f\u6210\u603b\u8d26\u51ed\u8bc1\u7684\u64cd\u4f5c \u4e3a" + reportInfo.getUser().getName() + " \u63d0\u4ea4\u7684\u4efb\u52a1\uff0c\u4e0d\u80fd\u53d6\u6d88!" : reportInfo.getBusinessType().getName() + " \u7684 " + reportInfo.getBusinessType().getOperatorName() + " \u7684\u64cd\u4f5c \u4e3a" + reportInfo.getUser().getName() + " \u63d0\u4ea4\u7684\u4efb\u52a1\uff0c\u4e0d\u80fd\u53d6\u6d88!";
                result.add(error);
            }
            if (canCancelIds.length > 0) {
                SmartSettleReportFactory.getLocalInstance(ctx).deleteNew(canCancelIds);
            }
        }
        return result;
    }
}

