/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.stock;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.DefaultBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.stock.IStockInvestBill;
import com.kingdee.eas.fm.stock.InvestTypeEnum;
import com.kingdee.eas.fm.stock.StockInvestBillFactory;
import com.kingdee.eas.fm.stock.StockInvestBillInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.Date;

public class StockInvestBillBookNotifyBuilder
extends DefaultBookNotifyBuilder {
    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        JournalCollection journalCollection = new JournalCollection();
        StockInvestBillInfo billInfo = this.getStockInvestBillInfo(ctx, billId);
        if (billInfo.getStockHolder().getSettleAccount() != null) {
            this.book(ctx, billId, journalCollection, billInfo);
            return journalCollection;
        }
        return null;
    }

    private void book(Context ctx, String billId, JournalCollection journalCollection, StockInvestBillInfo billInfo) throws BOSException, EASBizException {
        if (billInfo.getStockHolder().getSettleAccount().isIsBank()) {
            JournalInfo journalInfo = this.createBaseJournal(ctx, billInfo);
            journalInfo.setType(JournalTypeEnum.BANK);
            journalInfo.setAccountBank(billInfo.getStockHolder().getSettleAccount());
            journalInfo.setAccountView(billInfo.getStockHolder().getSettleAccount().getAccount());
            BigDecimal amount = billInfo.getExchangeAmount();
            if (billInfo.getInvestType().equals((Object)InvestTypeEnum.BanktoBond)) {
                journalInfo.setCreditAmount(amount);
                journalInfo.setDebitAmount(Constants.ZERO);
            } else {
                journalInfo.setCreditAmount(Constants.ZERO);
                journalInfo.setDebitAmount(amount);
            }
            journalCollection.add(journalInfo);
            this.updateStockInvestBill(ctx, billId);
        }
    }

    private void updateStockInvestBill(Context ctx, String billId) throws BOSException, EASBizException {
        String sql = "update t_sk_stockinvestbill set fisbankbond=1 where fid='" + billId + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection cel = new SelectorItemCollection();
        cel.add("*");
        cel.add("stockHolder.*");
        cel.add("stockHolder.settleAccount.*");
        cel.add("stockHolder.settleAccount.account.*");
        return cel;
    }

    private StockInvestBillInfo getStockInvestBillInfo(Context ctx, String billId) throws BOSException, EASBizException {
        IStockInvestBill StockInvestBill2 = StockInvestBillFactory.getLocalInstance(ctx);
        StockInvestBillInfo StockInvestBillInfo2 = StockInvestBill2.getStockInvestBillInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        return StockInvestBillInfo2;
    }

    private JournalInfo createBaseJournal(Context ctx, StockInvestBillInfo billInfo) throws BOSException, EASBizException {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setCompany(billInfo.getCompany());
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        journalInfo.setBillId(billInfo.getId().toString());
        journalInfo.setBillType(BillTypeEnum.StockInvestBill);
        journalInfo.setBillNumber(billInfo.getNumber());
        journalInfo.setBizDate(billInfo.getBizDate());
        CompanyOrgUnitInfo companyInfo1 = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        Date bookDate = this.getBookDate(ctx, billInfo, companyInfo1);
        journalInfo.setCreateDate(bookDate);
        PeriodInfo bookPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)bookDate, (CompanyOrgUnitInfo)companyInfo1);
        journalInfo.setPeriod(bookPeriodInfo);
        journalInfo.setCurrency(billInfo.getCurrency());
        journalInfo.setDescription(billInfo.getDescription());
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        journalInfo.setCashier(userInfo);
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        return journalInfo;
    }

    private Date getBookDate(Context ctx, StockInvestBillInfo billInfo, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (currPeriodInfo == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{"current Period"});
        }
        Date bookDate = billInfo.getBizDate();
        if (bookDate.before(currPeriodInfo.getBeginDate())) {
            bookDate = currPeriodInfo.getBeginDate();
        }
        return bookDate;
    }
}

