/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.stock.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.IBank;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.stock.FundSettleBillCollection;
import com.kingdee.eas.fm.stock.FundSettleBillFactory;
import com.kingdee.eas.fm.stock.FundSettleBillInfo;
import com.kingdee.eas.fm.stock.IFundSettleBill;
import com.kingdee.eas.fm.stock.ISettleDate;
import com.kingdee.eas.fm.stock.IStockSettleBill;
import com.kingdee.eas.fm.stock.IStockholder;
import com.kingdee.eas.fm.stock.SettleDateFactory;
import com.kingdee.eas.fm.stock.SettleDateInfo;
import com.kingdee.eas.fm.stock.StockException;
import com.kingdee.eas.fm.stock.StockInfo;
import com.kingdee.eas.fm.stock.StockSettleBillCollection;
import com.kingdee.eas.fm.stock.StockSettleBillFactory;
import com.kingdee.eas.fm.stock.StockSettleBillInfo;
import com.kingdee.eas.fm.stock.StockholderFactory;
import com.kingdee.eas.fm.stock.StockholderInfo;
import com.kingdee.eas.fm.stock.app.AbstractInitStockFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class InitStockFacadeControllerBean
extends AbstractInitStockFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.stock.app.InitStockFacadeControllerBean");
    private static final String[] fundKeys = new String[]{"bankAccount", "currency"};
    private static final String[] stockKeys = new String[]{"stock", "stockholder"};

    @Override
    protected void _submit(Context ctx, FundSettleBillCollection fundbillColl, StockSettleBillCollection stockbillColl, String companyid, java.util.Date date) throws BOSException, EASBizException {
        java.util.Date openDate = DateTimeUtils.truncateDate((java.util.Date)date);
        DbUtil.execute((Context)ctx, (String)"DELETE FROM T_SK_FundSettleBill  where FcompanyId=?", (Object[])new Object[]{companyid});
        DbUtil.execute((Context)ctx, (String)"DELETE FROM T_SK_StockSettleBill  where FcompanyId=?", (Object[])new Object[]{companyid});
        DbUtil.execute((Context)ctx, (String)"delete T_SK_SettleDate where FCurCompanyID=? ", (Object[])new Object[]{companyid});
        this.addnew(ctx, fundbillColl, stockbillColl);
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        ISettleDate s2Factory = SettleDateFactory.getLocalInstance(ctx);
        SettleDateInfo dateinfo = new SettleDateInfo();
        dateinfo.setCurCompany(currentCompany);
        dateinfo.setSettleDate(openDate);
        dateinfo.setIsinit(false);
        s2Factory.addnew(dateinfo);
    }

    @Override
    protected IObjectCollection _getInitFundCollection(Context ctx, String companyid) throws BOSException, EASBizException {
        IFundSettleBill slFactory = FundSettleBillFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        viewInfo.setFilter(filterInfo);
        if (companyid != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
            filterInfo.getFilterItems().add(new FilterItemInfo("isInit", (Object)Boolean.TRUE));
        }
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bankAccount.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("stockJobber.*"));
        FundSettleBillCollection FundSettleBillCollection2 = slFactory.getFundSettleBillCollection(viewInfo);
        return FundSettleBillCollection2;
    }

    @Override
    protected IObjectCollection _getInitStockCollection(Context ctx, String companyid) throws BOSException, EASBizException {
        IStockSettleBill s2Factory = StockSettleBillFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        viewInfo.setFilter(filterInfo);
        if (companyid != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
            filterInfo.getFilterItems().add(new FilterItemInfo("isInit", (Object)Boolean.TRUE));
        }
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("bankAccount.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("stockholder.*"));
        sic.add(new SelectorItemInfo("stock.*"));
        sic.add(new SelectorItemInfo("stockJobber.*"));
        StockSettleBillCollection StockSettleBillCollection2 = s2Factory.getStockSettleBillCollection(viewInfo);
        return StockSettleBillCollection2;
    }

    @Override
    protected void _antiInit(Context ctx, String companyid) throws BOSException, EASBizException {
        String sql = "SELECT FSettleDate,FIsInit FROM T_SK_SETTLEDATE WHERE FCurCompanyId = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{companyid});
        try {
            java.util.Date settleDate = null;
            Date openDate = null;
            while (rs.next()) {
                if (rs.getInt("FIsInit") == 1) {
                    openDate = rs.getDate("FSettleDate");
                    continue;
                }
                if (rs.getInt("FIsInit") != 0) continue;
                settleDate = rs.getDate("FSettleDate");
            }
            if (settleDate.after(openDate)) {
                throw new StockException(StockException.ANTIINIT_ERROR, new Object[]{DateUtil.formatDate2((java.util.Date)settleDate), DateUtil.formatDate2((java.util.Date)openDate)});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        DbUtil.execute((Context)ctx, (String)"delete T_SK_SettleDate where FCurCompanyID=? and FIsinit=1", (Object[])new Object[]{companyid});
    }

    @Override
    protected void _Init(Context ctx, String companyid, java.util.Date date) throws BOSException, EASBizException {
        java.util.Date openDate = DateTimeUtils.truncateDate((java.util.Date)date);
        java.util.Date preSettleDate = DateUtil.getBeforeDay((java.util.Date)date);
        Date preSqlDate = new Date(preSettleDate.getTime());
        DbUtil.execute((Context)ctx, (String)"update T_SK_FundSettleBill set FExchagedate= ?, FIsInit=1 where FcompanyId=?", (Object[])new Object[]{preSqlDate, companyid});
        DbUtil.execute((Context)ctx, (String)"update T_SK_StockSettleBill set FExchangedate= ?, FIsInit=1 where FcompanyId=?", (Object[])new Object[]{preSqlDate, companyid});
        DbUtil.execute((Context)ctx, (String)"update T_SK_SettleDate set FIsInit=1 where FCurCompanyID=? ", (Object[])new Object[]{companyid});
        ISettleDate s2Factory = SettleDateFactory.getLocalInstance(ctx);
        SettleDateInfo dateinfo = new SettleDateInfo();
        dateinfo.setCurCompany(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany());
        dateinfo.setSettleDate(openDate);
        dateinfo.setIsinit(false);
        s2Factory.addnew(dateinfo);
    }

    @Override
    protected void _dailySettle(Context ctx, CompanyOrgUnitInfo company, java.util.Date preDate, java.util.Date endDate) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((CoreBaseInfo)company) || preDate == null || endDate == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.stock.STOCKAutoGenerateResource", (String)"0_InitStockFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        preDate = DateTimeUtils.truncateDate((java.util.Date)preDate);
        endDate = DateTimeUtils.truncateDate((java.util.Date)endDate);
        java.util.Date settleDate = DateTimeUtils.truncateDate((java.util.Date)preDate);
        int daySize = DateUtil.getDiffDays((java.util.Date)preDate, (java.util.Date)endDate);
        for (int i = 0; i < daySize; ++i) {
            FundSettleBillCollection newFundColl = this.initCurrFundColl(ctx, settleDate, company);
            StockSettleBillCollection newStockColl = this.initCurrStockColl(ctx, settleDate, company);
            this.addnew(ctx, newFundColl, newStockColl);
            settleDate = DateUtil.getAfterDay((java.util.Date)settleDate);
        }
        DbUtil.execute((Context)ctx, (String)"update t_sk_settledate set FSettleDate= ?  where FIsInit = 0 and FCurCompanyID = ?", (Object[])new Object[]{new Date(settleDate.getTime()), company.getId().toString()});
    }

    @Override
    protected void _antiDailySettle(Context ctx, String companyid, java.util.Date predate, java.util.Date enddate) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)companyid) || predate == null || enddate == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fm.stock.STOCKAutoGenerateResource", (String)"0_InitStockFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        Date sqlpredate = new Date(predate.getTime());
        Date sqlenddate = new Date(enddate.getTime());
        DbUtil.execute((Context)ctx, (String)"delete T_SK_FundSettleBill where FExchagedate>=? and FExchagedate<=? and FcompanyId=?", (Object[])new Object[]{sqlenddate, sqlpredate, companyid});
        DbUtil.execute((Context)ctx, (String)"delete T_SK_StockSettleBill where FExchangedate>=? and FExchangedate<=? and FcompanyId=?", (Object[])new Object[]{sqlenddate, sqlpredate, companyid});
        Date settleDate = new Date(enddate.getTime());
        DbUtil.execute((Context)ctx, (String)"update t_sk_settledate set FSettleDate= ?  where FIsInit=0 and FCurCompanyID=?", (Object[])new Object[]{settleDate, companyid});
    }

    private FundSettleBillCollection getFundSettleColl(Context ctx, java.util.Date settleDate, String companyId) throws BOSException, EASBizException {
        settleDate = DateTimeUtils.truncateDate((java.util.Date)settleDate);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("exchagedate", (Object)settleDate));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IFundSettleBill iFundSettleBill = FundSettleBillFactory.getLocalInstance(ctx);
        return iFundSettleBill.getFundSettleBillCollection(evi);
    }

    private StockSettleBillCollection getStockSettleColl(Context ctx, java.util.Date settleDate, String companyId) throws BOSException, EASBizException {
        settleDate = DateTimeUtils.truncateDate((java.util.Date)settleDate);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("exchangedate", (Object)settleDate));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IStockSettleBill iStockSettleBill = StockSettleBillFactory.getLocalInstance(ctx);
        return iStockSettleBill.getStockSettleBillCollection(evi);
    }

    private FundSettleBillCollection genCurrFundColl(Context ctx, java.util.Date settleDate, FundSettleBillCollection preFundSettleColl, FundSettleBillCollection currFundSettleColl) {
        Map currFundMap = InitStockFacadeControllerBean.getHashSearchMap((IObjectCollection)currFundSettleColl, fundKeys);
        FundSettleBillInfo preFundInfo = null;
        String key = null;
        int size = preFundSettleColl.size();
        for (int i = 0; i < size; ++i) {
            preFundInfo = preFundSettleColl.get(i);
            key = FSHelper.getKeyString((IObjectValue)preFundInfo, (String[])fundKeys);
            if (currFundMap.containsKey(key)) continue;
            FundSettleBillInfo newFundInfo = this.initFundSettleInfo(settleDate, preFundInfo);
            currFundSettleColl.add(newFundInfo);
        }
        return currFundSettleColl;
    }

    private FundSettleBillInfo initFundSettleInfo(java.util.Date settleDate, FundSettleBillInfo preFundInfo) {
        FundSettleBillInfo newInfo = (FundSettleBillInfo)preFundInfo.clone();
        newInfo.setExchagedate(settleDate);
        newInfo.setBeginFundBalance(preFundInfo.getFundBalance());
        newInfo.setAddfund(Constants.ZERO);
        newInfo.setSubFund(Constants.ZERO);
        newInfo.setFundBalance(preFundInfo.getFundBalance());
        newInfo.setInitFund(Constants.ZERO);
        newInfo.setIsInit(false);
        newInfo.setCreateTime(null);
        newInfo.setCreator(null);
        newInfo.setLastUpdateTime(null);
        newInfo.setLastUpdateUser(null);
        newInfo.setId(null);
        return newInfo;
    }

    private static Map getHashSearchMap(IObjectCollection coll, String[] keys) {
        HashMap<String, IObjectValue> map = new HashMap<String, IObjectValue>();
        IObjectValue info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.getObject(i);
            map.put(FSHelper.getKeyString((IObjectValue)info, (String[])keys), info);
        }
        return map;
    }

    private FundSettleBillCollection initCurrFundColl(Context ctx, java.util.Date settleDate, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        FundSettleBillCollection currFundSettleColl = this.getCurrFundSettleColl(ctx, settleDate, company);
        java.util.Date preSettleDate = DateUtil.getBeforeDay((java.util.Date)settleDate);
        String companyId = company.getId().toString();
        FundSettleBillCollection preFundSettleColl = this.getFundSettleColl(ctx, preSettleDate, companyId);
        FundSettleBillCollection fundSettleColl = this.genCurrFundColl(ctx, settleDate, preFundSettleColl, currFundSettleColl);
        return fundSettleColl;
    }

    private FundSettleBillCollection getCurrFundSettleColl(Context ctx, java.util.Date currSettleDate, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        FundSettleBillCollection currColl = new FundSettleBillCollection();
        FundSettleBillInfo currInfo = null;
        java.util.Date preSettleDate = DateUtil.getBeforeDay((java.util.Date)currSettleDate);
        Date sqlDate = new Date(currSettleDate.getTime());
        Date presqlDate = new Date(preSettleDate.getTime());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select FBankAccountID,FStockJobberID,fcurrencyid,sum(addamt)addfund,sum(subamt)subfund from (select  b.FBankAccountID,FStockJobberID,b.fcurrencyid,case when a.FInvestType='3' or a.FInvestType='4' then  a.fexchangeAmount  else 0 end addamt,case when a.FInvestType='1' or a.FInvestType='2' or a.FInvestType='5' then  a.fexchangeAmount  else 0 end subamt from t_sk_stockinvestbill a right outer join T_SK_Stockholder b on a.FStockHolderID=b.fid where a.fexchangedate=? and b.FCurCompanyID=? ) a  group by FBankAccountID,FStockJobberID,fcurrencyid", (Object[])new Object[]{sqlDate, company.getId().toString()});
        try {
            while (rs.next()) {
                currInfo = new FundSettleBillInfo();
                currInfo.setCompany(company);
                currInfo.setBankAccount(this.getBankAccount(ctx, rs.getString("FBankAccountID")));
                currInfo.setCurrency(this.getCurrency(ctx, rs.getString("fcurrencyid")));
                currInfo.setExchagedate(currSettleDate);
                currInfo.setStockJobber(this.getStockJobber(ctx, rs.getString("FStockJobberID")));
                currInfo.setIsInit(false);
                BigDecimal addFund = rs.getBigDecimal("addFund");
                currInfo.setAddfund(addFund);
                BigDecimal subFund = rs.getBigDecimal("subFund");
                currInfo.setSubFund(subFund);
                BigDecimal beginFundBalance = this.getpreBalance(ctx, rs.getString("fcurrencyid"), presqlDate, rs.getString("FBankAccountID"));
                currInfo.setBeginFundBalance(beginFundBalance);
                currInfo.setFundBalance(this.getBalance(beginFundBalance, addFund, subFund));
                currColl.add(currInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return currColl;
    }

    private StockSettleBillCollection initCurrStockColl(Context ctx, java.util.Date settleDate, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        StockSettleBillCollection currStockSettleColl = this.getCurrStockSettleColl(ctx, settleDate, company);
        java.util.Date preSettleDate = DateUtil.getBeforeDay((java.util.Date)settleDate);
        String companyId = company.getId().toString();
        StockSettleBillCollection preStockSettleColl = this.getStockSettleColl(ctx, preSettleDate, companyId);
        StockSettleBillCollection fundSettleColl = this.genCurrStockColl(ctx, settleDate, preStockSettleColl, currStockSettleColl);
        return fundSettleColl;
    }

    private StockSettleBillCollection genCurrStockColl(Context ctx, java.util.Date settleDate, StockSettleBillCollection preStockSettleColl, StockSettleBillCollection currStockSettleColl) {
        Map currStockMap = InitStockFacadeControllerBean.getHashSearchMap((IObjectCollection)currStockSettleColl, stockKeys);
        StockSettleBillInfo preStockInfo = null;
        String key = null;
        int size = preStockSettleColl.size();
        for (int i = 0; i < size; ++i) {
            preStockInfo = preStockSettleColl.get(i);
            key = FSHelper.getKeyString((IObjectValue)preStockInfo, (String[])stockKeys);
            if (currStockMap.containsKey(key)) continue;
            StockSettleBillInfo newStockInfo = this.initStockSettleInfo(settleDate, preStockInfo);
            currStockSettleColl.add(newStockInfo);
        }
        return currStockSettleColl;
    }

    private StockSettleBillInfo initStockSettleInfo(java.util.Date settleDate, StockSettleBillInfo preStockInfo) {
        StockSettleBillInfo newInfo = (StockSettleBillInfo)preStockInfo.clone();
        newInfo.setExchangedate(settleDate);
        newInfo.setBeginSumAmount(preStockInfo.getSumamount());
        newInfo.setAddamount(Constants.ZERO);
        newInfo.setSubamount(Constants.ZERO);
        newInfo.setSumamount(preStockInfo.getSumamount());
        newInfo.setBeginSumNum(preStockInfo.getSumnum());
        newInfo.setAddnum(Constants.ZERO);
        newInfo.setSubnum(Constants.ZERO);
        newInfo.setSumnum(preStockInfo.getSumnum());
        newInfo.setInitAmount(Constants.ZERO);
        newInfo.setInitCostPrice(Constants.ZERO);
        newInfo.setInitStorageNum(Constants.ZERO);
        newInfo.setIsInit(false);
        newInfo.setCreateTime(null);
        newInfo.setCreator(null);
        newInfo.setLastUpdateTime(null);
        newInfo.setLastUpdateUser(null);
        newInfo.setId(null);
        return newInfo;
    }

    private StockSettleBillCollection getCurrStockSettleColl(Context ctx, java.util.Date currSettleDate, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        StockSettleBillCollection currColl = new StockSettleBillCollection();
        StockSettleBillInfo currInfo = null;
        java.util.Date preSettleDate = DateUtil.getBeforeDay((java.util.Date)currSettleDate);
        Date sqlDate = new Date(currSettleDate.getTime());
        Date presqlDate = new Date(preSettleDate.getTime());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select FStockID,FBankAccountID,FStockJobberID,fcurrencyid,FstockholderID,sum(addamt)addamt,sum(subamt)subamt,sum(addnum)addnum,sum(subnum)subnum from (select a.FStockID,b.FBankAccountID,FStockJobberID,b.fcurrencyid   ,b.fid FstockholderID,case when a.FInvestType='1' or a.FInvestType='2' then  a.fexchangeAmount  else 0 end addamt,case when a.FInvestType='3' then  a.fexchangeAmount  else 0 end subamt,case when a.FInvestType='1' or a.FInvestType='2' then  a.FExchangeNum  else 0 end addnum,case when a.FInvestType='3' then  a.FExchangeNum  else 0 end subnum from t_sk_stockinvestbill a right outer join T_SK_Stockholder b on a.FStockHolderID=b.fid where a.fexchangedate=? and b.FCurCompanyID=?) a  group by FStockID,FBankAccountID,FStockJobberID,fcurrencyid,FstockholderID", (Object[])new Object[]{sqlDate, company.getId().toString()});
        try {
            while (rs.next()) {
                String stockId = rs.getString("FStockID");
                if (stockId == null) continue;
                currInfo = new StockSettleBillInfo();
                StockInfo StockInfo2 = new StockInfo();
                StockInfo2.setId(BOSUuid.read((String)stockId));
                currInfo.setCompany(company);
                currInfo.setBankAccount(this.getBankAccount(ctx, rs.getString("FBankAccountID")));
                currInfo.setCurrency(this.getCurrency(ctx, rs.getString("fcurrencyid")));
                currInfo.setExchangedate(currSettleDate);
                currInfo.setStock(StockInfo2);
                String stockHolderId = rs.getString("FstockholderID");
                currInfo.setStockholder(this.getStockHolder(ctx, stockHolderId));
                currInfo.setStockjobber(this.getStockJobber(ctx, rs.getString("FStockJobberID")));
                currInfo.setIsInit(false);
                BigDecimal addAmount = rs.getBigDecimal("addamt");
                currInfo.setAddamount(addAmount);
                BigDecimal subAmount = rs.getBigDecimal("subamt");
                currInfo.setSubamount(subAmount);
                BigDecimal addNum = rs.getBigDecimal("addnum");
                currInfo.setAddnum(addNum);
                BigDecimal subNum = rs.getBigDecimal("subnum");
                currInfo.setSubnum(subNum);
                BigDecimal beginSumAmount = this.getpreStockBalance(ctx, stockId, presqlDate, stockHolderId);
                currInfo.setBeginSumAmount(beginSumAmount);
                currInfo.setSumamount(this.getBalance(beginSumAmount, addAmount, subAmount));
                BigDecimal beginSumNum = this.getpreStockNumBalance(ctx, stockId, presqlDate, stockHolderId);
                currInfo.setBeginSumNum(beginSumNum);
                currInfo.setSumnum(this.getBalance(beginSumNum, addNum, subNum));
                if (currInfo.getSumnum().compareTo(Constants.ZERO) == 0) {
                    currInfo.setCostprice(Constants.ZERO);
                } else {
                    currInfo.setCostprice(currInfo.getSumamount().divide(currInfo.getSumnum(), 3, 4));
                }
                currColl.add(currInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return currColl;
    }

    private BigDecimal getpreBalance(Context ctx, String CurrencyID, Date date, String BankAccountID) throws BOSException, SQLException {
        BigDecimal preBalance = Constants.ZERO;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select  FfundBalance from T_SK_FundSettleBill  where FExchagedate=? and FCurrencyID=? and FBankAccountID=? order by FExchagedate desc", (Object[])new Object[]{date, CurrencyID, BankAccountID});
        while (rs.next()) {
            if (rs.getBigDecimal("FfundBalance") == null) continue;
            preBalance = rs.getBigDecimal("FfundBalance");
        }
        return preBalance;
    }

    private BigDecimal getpreStockBalance(Context ctx, String StockID, Date date, String StockHolderID) throws BOSException, SQLException {
        BigDecimal preBalance = Constants.ZERO;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select  FSumamount from T_SK_stockSettleBill  where FExchangedate=? and FStockID=? and FStockholderID=? order by FExchangedate desc", (Object[])new Object[]{date, StockID, StockHolderID});
        while (rs.next()) {
            if (rs.getBigDecimal("FSumamount") == null) continue;
            preBalance = rs.getBigDecimal("FSumamount");
        }
        return preBalance;
    }

    private BigDecimal getpreStockNumBalance(Context ctx, String StockID, Date date, String StockHolderID) throws BOSException, SQLException {
        BigDecimal preBalance = Constants.ZERO;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select  Fsumnum from T_SK_stockSettleBill                              where FExchangedate=? and FStockID=? and FStockholderID=? order by FExchangedate desc", (Object[])new Object[]{date, StockID, StockHolderID});
        while (rs.next()) {
            if (rs.getBigDecimal("Fsumnum") == null) continue;
            preBalance = rs.getBigDecimal("Fsumnum");
        }
        return preBalance;
    }

    private BigDecimal getBalance(BigDecimal prebalance, BigDecimal addfund, BigDecimal subfund) {
        BigDecimal fundBalance = Constants.ZERO.add(prebalance).add(addfund).subtract(subfund);
        return fundBalance;
    }

    private AccountBankInfo getBankAccount(Context ctx, String id) throws BOSException, EASBizException {
        IAccountBank iAccountBank = AccountBankFactory.getLocalInstance((Context)ctx);
        return iAccountBank.getAccountBankInfo((IObjectPK)new ObjectUuidPK(id));
    }

    private BankInfo getStockJobber(Context ctx, String id) throws BOSException, EASBizException {
        IBank iBank = BankFactory.getLocalInstance((Context)ctx);
        return iBank.getBankInfo((IObjectPK)new ObjectUuidPK(id));
    }

    private StockholderInfo getStockHolder(Context ctx, String id) throws BOSException, EASBizException {
        IStockholder iStockHolder = StockholderFactory.getLocalInstance(ctx);
        return iStockHolder.getStockholderInfo((IObjectPK)new ObjectUuidPK(id));
    }

    private CurrencyInfo getCurrency(Context ctx, String id) throws BOSException, EASBizException {
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        return iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(id));
    }

    protected void addnew(Context ctx, FundSettleBillCollection fundbillColl, StockSettleBillCollection stockbillColl) throws BOSException, EASBizException {
        if (!(fundbillColl != null && fundbillColl.size() != 0 || stockbillColl != null && stockbillColl.size() != 0)) {
            return;
        }
        IFundSettleBill slFactory = FundSettleBillFactory.getLocalInstance(ctx);
        if (fundbillColl != null && fundbillColl.size() > 0) {
            for (int i = 0; i < fundbillColl.size(); ++i) {
                FundSettleBillInfo billInfo = fundbillColl.get(i);
                slFactory.addnew((CoreBaseInfo)billInfo);
            }
        }
        IStockSettleBill s2Factory = StockSettleBillFactory.getLocalInstance(ctx);
        if (stockbillColl != null && stockbillColl.size() > 0) {
            for (int i = 0; i < stockbillColl.size(); ++i) {
                StockSettleBillInfo billInfo = stockbillColl.get(i);
                s2Factory.addnew((CoreBaseInfo)billInfo);
            }
        }
    }
}

