/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.stock.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.stock.InvestTypeEnum;
import com.kingdee.eas.fm.stock.StockException;
import com.kingdee.eas.fm.stock.StockInvestBillInfo;
import com.kingdee.eas.fm.stock.app.AbstractStockInvestBillControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Date;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class StockInvestBillControllerBean
extends AbstractStockInvestBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.stock.app.StockInvestBillControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        StockInvestBillInfo stInfo = (StockInvestBillInfo)model;
        this.checkeDate(ctx, stInfo.getExchangeDate());
        if (FMHelper.isEmpty((String)stInfo.getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)stInfo, (String)stInfo.getCompany().getId().toString());
            stInfo.setNumber(numberSilent);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)stInfo, (String)"number");
        this.checkNumberDup(ctx, (IObjectValue)stInfo);
        if (stInfo.getInvestType().equals((Object)InvestTypeEnum.Apply)) {
            this.isApplyStockInvestBill(ctx, stInfo.getStockHolder().getId().toString(), stInfo.getStock().getId().toString());
        }
        IObjectPK pk = super._addnew(ctx, model);
        return pk;
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            StockInvestBillInfo info = (StockInvestBillInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setAccountant(null);
            } else if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.ADDNEW)) {
                info.setAccountant(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StockInvestBillInfo info = (StockInvestBillInfo)this.getValue(ctx, pk);
        this.checkeDate(ctx, info.getExchangeDate());
        BookNotifyFacadeFactory.getLocalInstance((Context)ctx).antiBook(pk.toString());
        super._delete(ctx, pk);
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._submit(ctx, model);
        return pk;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        StockInvestBillInfo stInfo1;
        StockInvestBillInfo stInfo = (StockInvestBillInfo)model;
        this.checkeDate(ctx, stInfo.getExchangeDate());
        if (stInfo.getId() != null && (stInfo1 = (StockInvestBillInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(stInfo.getId()))).getInvestType().equals((Object)InvestTypeEnum.Apply)) {
            this.isApplyStockInvestBill(ctx, stInfo.getStockHolder().getId().toString(), stInfo.getStock().getId().toString(), stInfo.getId().toString());
        }
        return super._save(ctx, model);
    }

    protected void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    public static boolean isBillRecAccount(Context ctx) {
        BOSUuid curOrgId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId();
        ObjectUuidPK orgPK = new ObjectUuidPK(curOrgId);
        int val = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("CS001", (IObjectPK)orgPK);
        return val == 0;
    }

    private void isApplyStockInvestBill(Context ctx, String FStockHolderID, String FStockID) throws BOSException, EASBizException {
        String sql = "select fid from t_sk_stockinvestbill where FStockHolderID ='" + FStockHolderID + "' and FStockID = '" + FStockID + "' and FInvestType='1'";
        IRowSet rs1 = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql).executeSQL();
        try {
            if (rs1.next()) {
                throw new StockException(StockException.APPLY_EXC1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void isApplyStockInvestBill(Context ctx, String FStockHolderID, String FStockID, String fid) throws BOSException, EASBizException {
        String sql = "select fid from t_sk_stockinvestbill where FStockHolderID ='" + FStockHolderID + "' and FStockID = '" + FStockID + "' and FInvestType='1' and fid<>'" + fid + "'";
        IRowSet rs1 = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql).executeSQL();
        try {
            if (rs1.next()) {
                throw new StockException(StockException.APPLY_EXC1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void checkeDate(Context ctx, java.util.Date exchangeDate) throws BOSException, EASBizException {
        Date initDate = new Date(exchangeDate.getTime());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select *  from T_SK_SettleDate where   FCurCompanyID=? and FSettleDate>?", (Object[])new Object[]{ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString(), initDate});
        try {
            if (rs.next()) {
                throw new StockException(StockException.EDIT_DATEEXC1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

