/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.DefaultBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.common.IntReceivedBillTypeEnum;
import com.kingdee.eas.fm.td.IIntReceivedBill;
import com.kingdee.eas.fm.td.ITimeDepositBill;
import com.kingdee.eas.fm.td.IntReceivedBillFactory;
import com.kingdee.eas.fm.td.IntReceivedBillInfo;
import com.kingdee.eas.fm.td.TimeDepositBillFactory;
import com.kingdee.eas.fm.td.TimeDepositBillInfo;

public class IntReceiveBillBookNotifyBuilder
extends DefaultBookNotifyBuilder {
    private ITimeDepositBill iTimeDepositBill;
    private IIntReceivedBill iIntReceivedBill;

    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        JournalInfo dJournal;
        JournalCollection journalCollection = new JournalCollection();
        IntReceivedBillInfo intReceivedBillInfo = this.getIntReceivedBillInfo(ctx, billId);
        intReceivedBillInfo.setAddNewType((String)ctx.get((Object)"AddNewType"));
        TimeDepositBillInfo timeDepositBillInfo = this.getTimeDepositBillInfo(ctx, intReceivedBillInfo.getTimeDepositBillID().getId().toString());
        if (intReceivedBillInfo.getCorpCurAcct() != null && (dJournal = this.createJournal(intReceivedBillInfo, timeDepositBillInfo, billId)).getAccountBank().isIsBank()) {
            journalCollection.add(this.createJournal(intReceivedBillInfo, timeDepositBillInfo, billId));
        }
        return journalCollection;
    }

    private IntReceivedBillInfo getIntReceivedBillInfo(Context ctx, String billId) throws BOSException, EASBizException {
        this.iIntReceivedBill = ctx == null ? IntReceivedBillFactory.getRemoteInstance() : IntReceivedBillFactory.getLocalInstance(ctx);
        SelectorItemCollection cel = new SelectorItemCollection();
        cel.add("*");
        cel.add("corpCurAcct.*");
        return (IntReceivedBillInfo)this.iIntReceivedBill.getValue((IObjectPK)new ObjectUuidPK(billId), cel);
    }

    private JournalInfo createJournal(IntReceivedBillInfo intReceivedBillInfo, TimeDepositBillInfo timeDepositBill, String billId) {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setType(JournalTypeEnum.BANK);
        this.setDC(journalInfo, timeDepositBill, intReceivedBillInfo);
        journalInfo.setCurrency(intReceivedBillInfo.getCurrency());
        journalInfo.setCreateDate(intReceivedBillInfo.getBizDate());
        journalInfo.setBizDate(intReceivedBillInfo.getBizDate());
        journalInfo.setDescription(intReceivedBillInfo.getDescription());
        journalInfo.setCompany(intReceivedBillInfo.getCompany());
        journalInfo.setBillId(intReceivedBillInfo.getId().toString());
        journalInfo.setBillNumber(intReceivedBillInfo.getNumber());
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        journalInfo.setBillType(BillTypeEnum.IntDepositAccount);
        return journalInfo;
    }

    private void setDC(JournalInfo journalInfo, TimeDepositBillInfo timeDepositBill, IntReceivedBillInfo intReceivedBillInfo) {
        if (intReceivedBillInfo.getIntReceiveType() == IntReceivedBillTypeEnum.INTBILL_REDEPOSIT) {
            journalInfo.setAccountBank(intReceivedBillInfo.getCorpCurAcct());
            journalInfo.setDebitAmount(intReceivedBillInfo.getShijiAmt());
            journalInfo.setAccountView(intReceivedBillInfo.getCorpCurAcct().getAccount());
        } else if (intReceivedBillInfo.getIntReceiveType() == IntReceivedBillTypeEnum.INTBILL_UNTIMEDEPOSIT) {
            journalInfo.setAccountBank(intReceivedBillInfo.getCorpCurAcct());
            journalInfo.setDebitAmount(intReceivedBillInfo.getShijiAmt());
            journalInfo.setAccountView(intReceivedBillInfo.getCorpCurAcct().getAccount());
        }
    }

    private TimeDepositBillInfo getTimeDepositBillInfo(Context ctx, String billId) throws BOSException, EASBizException {
        this.iTimeDepositBill = ctx == null ? TimeDepositBillFactory.getRemoteInstance() : TimeDepositBillFactory.getLocalInstance(ctx);
        return this.iTimeDepositBill.getTimeDepositBillInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection cel = new SelectorItemCollection();
        cel.add("*");
        cel.add("bankDepAcct.*");
        cel.add("bankDepAcct.account.id");
        cel.add("bankCurAcct.*");
        cel.add("bankCurAcct.account.id");
        return cel;
    }
}

