/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.td.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.td.ApplyBillStatusEnum;
import com.kingdee.eas.fm.td.ApplyTimeDepositTypeEnum;
import com.kingdee.eas.fm.td.TDException;
import com.kingdee.eas.fm.td.TimeDepositApplyFactory;
import com.kingdee.eas.fm.td.TimeDepositApplyInfo;
import com.kingdee.eas.fm.td.app.AbstractTimeDepositApplyControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class TimeDepositApplyControllerBean
extends AbstractTimeDepositApplyControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fm.td.app.TimeDepositApplyControllerBean");

    public IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TimeDepositApplyInfo timeDepositApplyInfo = (TimeDepositApplyInfo)model;
        timeDepositApplyInfo.setBillState(ApplyBillStatusEnum.SUBMIT);
        this.checkCanSaveSubmit(ctx, timeDepositApplyInfo);
        if (ApplyTimeDepositTypeEnum.TIMEDEPOSIT_OUTER.equals((Object)timeDepositApplyInfo.getApplyType()) || ApplyTimeDepositTypeEnum.TIMEDEPOSIT_INNER.equals((Object)timeDepositApplyInfo.getApplyType())) {
            model.setString("depositType", null);
        }
        return super._submit(ctx, (IObjectValue)timeDepositApplyInfo);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TimeDepositApplyInfo info = (TimeDepositApplyInfo)model;
        if (info.getApplyType().equals((Object)ApplyTimeDepositTypeEnum.TIMEDEPOSIT_OUTER) || info.getApplyType().equals((Object)ApplyTimeDepositTypeEnum.TIMEDEPOSIT_INNER)) {
            model.setString("depositType", null);
        }
        this.checkCanSaveSubmit(ctx, info);
        if (FMHelper.isEmpty((String)info.getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            info.setNumber(numberSilent);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        this._checkNumberDup(ctx, (IObjectValue)info);
        return super._addnew(ctx, (IObjectValue)info);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TimeDepositApplyInfo modelInfo = (TimeDepositApplyInfo)model;
        this.checkCanSaveSubmit(ctx, modelInfo);
        if (((TimeDepositApplyInfo)model).getBillState() == null || !((TimeDepositApplyInfo)model).getBillState().equals((Object)ApplyBillStatusEnum.AUDITED)) {
            ((TimeDepositApplyInfo)model).setBillState(ApplyBillStatusEnum.SAVE);
            if (((TimeDepositApplyInfo)model).getApplyType().equals((Object)ApplyTimeDepositTypeEnum.TIMEDEPOSIT_OUTER) || ((TimeDepositApplyInfo)model).getApplyType().equals((Object)ApplyTimeDepositTypeEnum.TIMEDEPOSIT_INNER)) {
                model.setString("depositType", null);
            }
        }
        return super._save(ctx, model);
    }

    @Override
    protected void _antiAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TimeDepositApplyInfo applyInfo = (TimeDepositApplyInfo)TimeDepositApplyFactory.getLocalInstance(ctx).getValue(pk);
        if (applyInfo.getIsBalanceBill() == 1 || applyInfo.getIsTimeDepBank() == 1 || applyInfo.isIsCreatePayment()) {
            throw new TDException(TDException.APPLYED);
        }
        if (applyInfo.getBillState() != ApplyBillStatusEnum.AUDITED) {
            throw new TDException(TDException.CANNOTUNAUDIT, new Object[]{applyInfo.getNumber()});
        }
        applyInfo.setBillState(ApplyBillStatusEnum.SAVE);
        this.update(ctx, pk, (CoreBaseInfo)applyInfo);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TimeDepositApplyInfo applyInfo = TimeDepositApplyFactory.getLocalInstance(ctx).getTimeDepositApplyInfo(pk);
        if (applyInfo.getBillState() != ApplyBillStatusEnum.SUBMIT) {
            throw new TDException(TDException.CANNOTAUDIT, new Object[]{applyInfo.getNumber()});
        }
        applyInfo.setBillState(ApplyBillStatusEnum.AUDITED);
        this.update(ctx, pk, (CoreBaseInfo)applyInfo);
    }

    @Override
    protected void _auditBatch(Context ctx, Set idSet) throws BOSException, EASBizException {
        Iterator iterator = idSet.iterator();
        while (iterator.hasNext()) {
            this.audit(ctx, (IObjectPK)new ObjectUuidPK(iterator.next().toString()));
        }
    }

    @Override
    protected void _antiAuditBatch(Context ctx, Set idSet) throws BOSException, EASBizException {
        Iterator iterator = idSet.iterator();
        while (iterator.hasNext()) {
            this.antiAudit(ctx, (IObjectPK)new ObjectUuidPK(iterator.next().toString()));
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TimeDepositApplyInfo applyInfo = TimeDepositApplyFactory.getLocalInstance(ctx).getTimeDepositApplyInfo(pk);
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)applyInfo, (String)applyInfo.getCompany().getId().toString());
        if (!this.isCanDelete(applyInfo)) {
            throw new TDException(TDException.CANNOTDEL, new Object[]{applyInfo.getNumber()});
        }
        super._delete(ctx, pk);
    }

    private boolean isCanDelete(TimeDepositApplyInfo applyInfo) {
        return ApplyBillStatusEnum.SAVE.equals((Object)applyInfo.getBillState()) || ApplyBillStatusEnum.SUBMIT.equals((Object)applyInfo.getBillState());
    }

    @Override
    protected void _submitBank(Context ctx, IObjectPK pk) throws BOSException {
    }

    private void checkCanSaveSubmit(Context ctx, TimeDepositApplyInfo modelInfo) throws BOSException, EASBizException, FMException {
        if (modelInfo.getId() == null) {
            return;
        }
        boolean isExist = TimeDepositApplyFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(modelInfo.getId()));
        if (!isExist) {
            return;
        }
        TimeDepositApplyInfo applyInfo = TimeDepositApplyFactory.getLocalInstance(ctx).getTimeDepositApplyInfo((IObjectPK)new ObjectUuidPK(modelInfo.getId()));
        if (null != applyInfo && ApplyBillStatusEnum.AUDITED.equals((Object)applyInfo.getBillState())) {
            throw new FMException(FMException.EDITERROR);
        }
        if (null != applyInfo && ApplyBillStatusEnum.SUBMIT.equals((Object)applyInfo.getBillState()) && ApplyBillStatusEnum.SAVE.equals((Object)modelInfo.getBillState())) {
            throw new FMException(FMException.SUBMMITED_CANNNOTSAVE);
        }
    }
}

