/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.job.util.DateUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.FlucInBizBillEntryInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.affair.LoanInBizBillEntryInfo;
import com.kingdee.eas.hr.base.AffairActioniOperateException;
import com.kingdee.eas.hr.base.EmpHRORelationHisInfo;
import com.kingdee.eas.hr.base.EmpLaborRelationHisInfo;
import com.kingdee.eas.hr.base.EmpOptBURelaConfigInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationDomainFacadeFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.EmpPositionInfo;
import com.kingdee.eas.hr.base.HRBizData;
import com.kingdee.eas.hr.base.HRBizDefineCheckUtil;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.HRBizDefineTypeEnum;
import com.kingdee.eas.hr.base.PositionStatuEnum;
import com.kingdee.eas.hr.base.app.his.HistoryVersionUtil;
import com.kingdee.eas.hr.base.app.util.EmpOptBURelaConfigHelper;
import com.kingdee.eas.hr.base.app.util.HRBizDefineAppUtils;
import com.kingdee.eas.hr.base.app.util.SHRSameDatePersonChangeUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptBizManageTool;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptEmpLaborRelationUtil;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptEmpOrgRelationTool;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.shr.ml.util.SHRServerResource;
import java.util.Date;

public class AffairAuditEffectHelper {
    private final String shr20Id = "j8ajlE9lSOOBo95Ap0aT8+Zovtk=";

    public HRBizData affairEntryConvertToBizData(Context ctx, Date effetDate, HRAffairBizBillEntryInfo entry) throws AffairActioniOperateException, BOSException, EASBizException {
        String personId;
        String personId2;
        EmpLaborRelationHisInfo hisInfo;
        if (entry.getHrBizDefine() == null) {
            throw new AffairActioniOperateException(AffairActioniOperateException.HRBIZDEFINENOTNULL);
        }
        if (effetDate == null) {
            throw new AffairActioniOperateException(AffairActioniOperateException.EFFECTDATEISNULL);
        }
        HRBizData bizData = new HRBizData();
        bizData.setPersonInfo(entry.getPerson());
        HRBizDefineInfo hrBizDefineInfo = HRBizDefineAppUtils.getHRBizDefineInfo((Context)ctx, (String)entry.getHrBizDefine().getId().toString());
        bizData.setHrbizDefine(hrBizDefineInfo);
        bizData.setActionType(entry.getAffairActionReason());
        bizData.setActionReason(entry.getVariationReason());
        if (entry.getId() != null) {
            bizData.setEntryID(entry.getId().toString());
        }
        bizData.setStartDate(effetDate);
        EmpPositionInfo oldPositionInfo = new EmpPositionInfo();
        oldPositionInfo.setCompany(entry.getOldCompany());
        oldPositionInfo.setAdminInfo(entry.getOldAdminOrg());
        oldPositionInfo.setPositionInfo(entry.getOldPosition());
        oldPositionInfo.setPersonInfo(entry.getPerson());
        oldPositionInfo.setEmployeeType(entry.getOldEmpType());
        if (entry.getOldEmpType() == null && entry.getPerson() != null && entry.getPerson().getId() != null && (hisInfo = SHREmpOptEmpLaborRelationUtil.getPointDateEmpLaborRelationHis((Context)ctx, (String)(personId2 = entry.getPerson().getId().toString()), (Date)effetDate)) != null) {
            oldPositionInfo.setEmployeeType(hisInfo.getLaborRelationState());
            oldPositionInfo.setEmpLabrRelationHisInfo(hisInfo);
        }
        bizData.setOldPosition(oldPositionInfo);
        EmpPositionInfo newPositionInfo = new EmpPositionInfo();
        newPositionInfo.setCompany(entry.getCompany());
        newPositionInfo.setAdminInfo(entry.getAdminOrg());
        newPositionInfo.setPositionInfo(entry.getPosition());
        newPositionInfo.setPositionStateEnum(PositionStatuEnum.Active);
        newPositionInfo.setPersonInfo(entry.getPerson());
        newPositionInfo.setEmployeeType(entry.getEmpType());
        EmpLaborRelationHisInfo empLarborRelationHisInfo = new EmpLaborRelationHisInfo();
        empLarborRelationHisInfo.setEmployerUnit(entry.getEmployerUnit());
        newPositionInfo.setEmpLabrRelationHisInfo(empLarborRelationHisInfo);
        bizData.setNewPosition(newPositionInfo);
        bizData.setRemark((String)entry.get("description"));
        if (entry instanceof FlucInBizBillEntryInfo || entry instanceof LoanInBizBillEntryInfo) {
            EmpHRORelationHisInfo buInfo = SHREmpOptBizManageTool.getEmpHRORelationHisInfo((Context)ctx, (String)entry.getPerson().getId().toString());
            if (buInfo != null) {
                bizData.setOldHrOrgUnitInfo(buInfo.getHrOrgUnit());
                bizData.setOldUseDefault(buInfo.isUseDefault());
            } else {
                bizData.setOldHrOrgUnitInfo(entry.getHrOrgUnit());
                bizData.setOldUseDefault(entry.isUseDefault());
            }
        } else {
            bizData.setOldHrOrgUnitInfo(entry.getHrOrgUnit());
            bizData.setOldUseDefault(entry.isUseDefault());
        }
        EmpOptBURelaConfigInfo configInfo = EmpOptBURelaConfigHelper.getInstance().getEmpOptBURelaConfigInfo(ctx, hrBizDefineInfo.getId().toString());
        if (configInfo != null) {
            if (0 == configInfo.getHrOrgType().getValue()) {
                bizData.setHrOrgUnitInfo(entry.getHrOrgUnit());
            } else if (1 == configInfo.getHrOrgType().getValue()) {
                bizData.setHrOrgUnitInfo(SHREmpOptBizManageTool.getManageHROByAdminOrg((Context)ctx, (String)bizData.getNewPosition().getAdminInfo().getId().toString()));
            }
            if (0 == configInfo.getUseDefaultType().getValue()) {
                bizData.setUseDefault(false);
            } else if (1 == configInfo.getUseDefaultType().getValue()) {
                bizData.setUseDefault(true);
            } else if (2 == configInfo.getUseDefaultType().getValue()) {
                bizData.setUseDefault(entry.isUseDefault());
            }
        } else if (HRBizDefineCheckUtil.needTargetPosition((HRBizDefineInfo)hrBizDefineInfo)) {
            bizData.setHrOrgUnitInfo(SHREmpOptBizManageTool.getManageHROByAdminOrg((Context)ctx, (String)bizData.getNewPosition().getAdminInfo().getId().toString()));
            bizData.setUseDefault(true);
        } else if ("j8ajlE9lSOOBo95Ap0aT8+Zovtk=".equals(hrBizDefineInfo.getId().toString())) {
            EmpPosOrgRelationCollection suspendColl = EmpPosOrgRelationDomainFacadeFactory.getLocalInstance((Context)ctx).getAllSuspendPositioin(bizData.getPersonInfo().getId().toString(), bizData.getStartDate());
            if (suspendColl != null && suspendColl.size() > 0) {
                bizData.setHrOrgUnitInfo(SHREmpOptBizManageTool.getManageHROByAdminOrg((Context)ctx, (String)suspendColl.get(0).getAdminOrg().getId().toString()));
                bizData.setUseDefault(true);
            }
        } else {
            bizData.setHrOrgUnitInfo(entry.getHrOrgUnit());
            bizData.setUseDefault(entry.isUseDefault());
        }
        bizData.setCompany(HRUtilExtend.getCompany((Context)ctx, (AdminOrgUnitInfo)entry.getAdminOrg()));
        if (entry.getPosition() != null) {
            if (entry.getJobGrade() != null) {
                bizData.setJobGradeInfo(entry.getJobGrade());
            }
            if (entry.get("jobLevel") != null) {
                bizData.setJobLevelInfo((JobLevelInfo)entry.get("jobLevel"));
            }
        }
        bizData.setEntryInfo(entry);
        Date leftCompanyDate = (Date)entry.get("leftCompanyDate");
        Date bizDate = (Date)entry.get("bizDate");
        if (null != leftCompanyDate && null != bizDate && DateUtil.isEqualDay((Date)leftCompanyDate, (Date)bizDate)) {
            bizData.setLeftConpanyDateFalg(true);
            bizData.setLeftCompanyDate(leftCompanyDate);
        } else {
            bizData.setLeftConpanyDateFalg(false);
            bizData.setLeftCompanyDate(leftCompanyDate);
        }
        if (entry.getPerson() != null && entry.getPerson().getId() != null) {
            SHRSameDatePersonChangeUtil util = new SHRSameDatePersonChangeUtil();
            personId = entry.getPerson().getId().toString();
            boolean isSameDatePersonChange = util.isSameDatePersonChange(ctx, personId, effetDate, 1);
            if (isSameDatePersonChange && !hrBizDefineInfo.getBizDefineType().equals((Object)HRBizDefineTypeEnum.PLURALITY)) {
                bizData.setSameDatePersonChange(true);
                bizData.setStartDateTime(HistoryVersionUtil.getStartDateTimeFromEFFDT((Date)bizData.getStartDate()));
                bizData.setPreEndDateTime(HistoryVersionUtil.getPreRecordEndDateTime((Date)bizData.getStartDateTime()));
                if (null != leftCompanyDate && null != bizDate && !DateUtil.isEqualDay((Date)leftCompanyDate, (Date)bizDate)) {
                    Object[] params = new String[3];
                    PersonInfo person = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
                    params[0] = person.getNumber();
                    params[1] = person.getName();
                    if (hrBizDefineInfo.getBizDefineType().equals((Object)HRBizDefineTypeEnum.RESIGN)) {
                        params[2] = SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"dep_date", (Context)ctx);
                        throw new AffairActioniOperateException(AffairActioniOperateException.LEFTCONPANYDATE_ERROR1, params);
                    }
                    if (hrBizDefineInfo.getBizDefineType().equals((Object)HRBizDefineTypeEnum.RETIRE)) {
                        params[2] = SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"retired_date", (Context)ctx);
                        throw new AffairActioniOperateException(AffairActioniOperateException.LEFTCONPANYDATE_ERROR1, params);
                    }
                    if (hrBizDefineInfo.getBizDefineType().equals((Object)HRBizDefineTypeEnum.REINVITEFIRE)) {
                        params[2] = SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"restart_date", (Context)ctx);
                        throw new AffairActioniOperateException(AffairActioniOperateException.LEFTCONPANYDATE_ERROR1, params);
                    }
                }
                String oql = "where person.id ='" + personId + "' and startDateTime> " + HRUtilExtend.getDateStringWithMinuteTs((Date)bizData.getStartDateTime()) + " and assignType = 1 and isinner =1  order by endDateTime desc";
                EmpPosOrgRelationCollection collection = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(oql);
                if (collection.size() > 0) {
                    EmpPosOrgRelationInfo maxInfo = collection.get(0);
                    Date maxStartDateTime = maxInfo.getStartDateTime();
                    bizData.setStartDateTime(HistoryVersionUtil.getStartDateTimeFromMax((Date)maxStartDateTime));
                    bizData.setPreEndDateTime(HistoryVersionUtil.getPreRecordEndDateTime((Date)bizData.getStartDateTime()));
                }
            } else {
                bizData.setSameDatePersonChange(false);
                bizData.setStartDateTime(bizData.getStartDate());
                bizData.setPreEndDateTime(HistoryVersionUtil.getPreRecordEndDateTime((Date)bizData.getStartDate()));
            }
        } else {
            bizData.setSameDatePersonChange(false);
            bizData.setStartDateTime(bizData.getStartDate());
            bizData.setPreEndDateTime(HistoryVersionUtil.getPreRecordEndDateTime((Date)bizData.getStartDate()));
        }
        if (entry.getPerson() != null && entry.getPerson().getId() != null && !HRBizDefineTypeEnum.PLURALITY.equals((Object)hrBizDefineInfo.getBizDefineType()) && !HRBizDefineTypeEnum.RISE.equals((Object)hrBizDefineInfo.getBizDefineType())) {
            personId = entry.getPerson().getId().toString();
            EmpPosOrgRelationInfo info = SHREmpOptEmpOrgRelationTool.getCurrntMainEmpOrgRelationInfo((Context)ctx, (String)personId);
            if (info != null && effetDate.before(info.getEFFDT())) {
                bizData.setSupplementBill(true);
            } else {
                bizData.setSupplementBill(false);
            }
        } else {
            bizData.setSupplementBill(false);
        }
        return bizData;
    }
}

