/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.affair.AffairBizCheckFacadeFactory;
import com.kingdee.eas.hr.affair.AffairBizException;
import com.kingdee.eas.hr.affair.EmpEnrollTemplateBillEntryInfo;
import com.kingdee.eas.hr.affair.EmpEnrollTemplateBillInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.affair.IEmpEnrollTemplateBill;
import com.kingdee.eas.hr.affair.IEmpEnrollTemplateBillEntry;
import com.kingdee.eas.hr.affair.app.EmpEnrollHelper;
import com.kingdee.eas.hr.affair.app.HRAffairBillBizBean;
import com.kingdee.eas.hr.base.AffairActionReasonInfo;
import com.kingdee.eas.hr.base.EnrollSourceCollection;
import com.kingdee.eas.hr.base.EnrollSourceFactory;
import com.kingdee.eas.hr.base.EnrollSourceInfo;
import com.kingdee.eas.hr.base.EntityFieldMappingCollection;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HROrgContextManagerFacadeFactory;
import com.kingdee.eas.hr.base.batch.BatchProcessedResult;
import com.kingdee.eas.hr.base.util.EmpEnrollUserPermHelper;
import com.kingdee.eas.hr.base.util.HRCheckUtil;
import com.kingdee.eas.hr.base.util.HRParamUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.base.util.MappingApplyUtil;
import com.kingdee.eas.hr.emp.IPersonOptFacade;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.PersonOptFacadeFactory;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.app.PersonOptBaseInfo;
import com.kingdee.eas.hr.org.PosPerPlanInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.Locale;

public class EmpEnrollTemplateBizBean
extends HRAffairBillBizBean {
    private static final String RES = "com.kingdee.eas.hr.affair.EnrollResource";
    private BOSObjectType type;
    private IMetaDataPK pk;

    public BOSObjectType getBOSType() {
        return this.type;
    }

    public void setBOSType(BOSObjectType type) {
        this.type = type;
    }

    public IMetaDataPK getPK() {
        return this.pk;
    }

    public void setPK(IMetaDataPK pk) {
        this.pk = pk;
    }

    @Override
    protected String getInnerState() {
        return null;
    }

    @Override
    protected String getOldAdminField() {
        return null;
    }

    @Override
    protected String getOldPositionField() {
        return null;
    }

    private IEmpEnrollTemplateBill getLocalInstance(Context ctx) throws BOSException {
        return (IEmpEnrollTemplateBill)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)this.getBOSType());
    }

    private IEmpEnrollTemplateBillEntry getEntryLocalInstance(Context ctx) throws BOSException {
        IEmpEnrollTemplateBillEntry enFactoty = (IEmpEnrollTemplateBillEntry)EmpEnrollHelper.getEntryLocalInstance(ctx, this.getBOSType());
        return enFactoty;
    }

    private String getTableName(Context ctx) throws BOSException {
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(this.getBOSType());
        return entityInfo.getTable().getName();
    }

    private String getEntryTableName(Context ctx) throws BOSException {
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(this.getBOSType());
        LinkPropertyInfo prop = (LinkPropertyInfo)entityInfo.getPropertyByNameRuntime(this.getEntryField());
        EntityObjectInfo clienEntityInfo = prop.getRelationship().getSupplierObject();
        return clienEntityInfo.getTable().getName();
    }

    @Override
    protected void _check(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        super._check(ctx, entry);
        EmpEnrollTemplateBillEntryInfo enrollEntry = (EmpEnrollTemplateBillEntryInfo)entry;
        EmpEnrollTemplateBillInfo bill = enrollEntry.getBill();
        String billID = null;
        if (bill != null && bill.getId() != null) {
            billID = bill.getId().toString();
        }
        String IDCardNo = enrollEntry.getIDCardNo();
        String passportNo = enrollEntry.getPassportNo();
        BatchProcessedResult result = null;
        result = AffairBizCheckFacadeFactory.getLocalInstance(ctx).checkIDCardNoAndPassportNoInEnroll(IDCardNo, passportNo, billID);
        if (result != null && result.isHasValidInfo()) {
            throw new AffairBizException(AffairBizException.BILL_CHECK_FAILED, new Object[]{result.getInvalidInfo()});
        }
        String personID = null;
        if (enrollEntry.getExistPersonID() != null) {
            personID = enrollEntry.getExistPersonID().toString();
        }
        HRCheckUtil.getPersonNumberCheckInstanceForEmpEnroll((String)billID, personID).check(enrollEntry.getEmpNumber(), ctx);
        HROrgUnitInfo hrFullUnit = HRUtilExtend.getAdminOrgOfHRO((Context)ctx, (AdminOrgUnitInfo)enrollEntry.getAdminOrg());
        if (hrFullUnit == null) {
            throw new AffairBizException(AffairBizException.BILL_CHECK_FAILED, new Object[]{SHRServerResource.getString((String)RES, (String)"adminOrgNoHR", (Locale)ctx.getLocale())});
        }
    }

    protected void doWithPriorityThingEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        EmpEnrollTemplateBillEntryInfo entryInfo = (EmpEnrollTemplateBillEntryInfo)entry;
        PersonInfo pInfo = this.savePersonInfo(ctx, entryInfo);
        entryInfo.setPerson(pInfo);
    }

    protected void doWithCommonRelationEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
    }

    protected void doWithSpecialFiledsEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        EmpEnrollTemplateBillEntryInfo entryInfo = (EmpEnrollTemplateBillEntryInfo)entry;
        PersonInfo pInfo = entry.getPerson();
        if (pInfo == null) {
            return;
        }
        String entryTableName = this.getEntryTableName(ctx);
        Object[] param = new Object[]{pInfo.getId().toString(), entryInfo.getId().toString()};
        if (!StringUtils.isEmpty((String)entryTableName)) {
            DbUtil.execute((Context)ctx, (String)("Update " + entryTableName + " SET FPersonID = ? where FID = ? "), (Object[])param);
        }
        DbUtil.execute((Context)ctx, (String)"Update T_HR_AffairBizHistory SET FPersonID = ? where FEntryID = ? ", (Object[])param);
        param = new Object[]{pInfo.getId().toString(), entryInfo.getBill().getId().toString(), entry.getId().toString()};
        DbUtil.execute((Context)ctx, (String)"update T_HR_HRAffairBiz set FPersonID = ? where FBillID = ? and FEntryID = ?", (Object[])param);
        DbUtil.execute((Context)ctx, (String)"update T_HR_AffairBizDetail set FPersonID = ? where FBillID = ? and FEntryID = ?", (Object[])param);
    }

    protected void doWithOtherChangeEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        EmpEnrollTemplateBillEntryInfo entryInfo = (EmpEnrollTemplateBillEntryInfo)entry;
        PersonInfo pInfo = entry.getPerson();
        EmpEnrollTemplateBillInfo eebbInfo = this.getLocalInstance(ctx).getEmpEnrollTemplateBillInfo("select id, hrOrgUnit.id,cu.id where id = '" + entryInfo.getBill().getId().toString() + "'");
        if (eebbInfo.getHrOrgUnit() == null) {
            return;
        }
        String hrOrgId = eebbInfo.getHrOrgUnit().getId().toString();
        boolean isAutoUser = false;
        isAutoUser = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_Auto_User", (String)hrOrgId);
        if (isAutoUser) {
            EmpEnrollUserPermHelper.autoCreateUser((Context)ctx, (PersonInfo)pInfo, (boolean)entryInfo.isEnrollAgain(), (Date)entryInfo.getEnrollDate(), (AdminOrgUnitInfo)entryInfo.getAdminOrg());
        }
        if (!entryInfo.isIsParPerson()) {
            return;
        }
        boolean is_use_affairFixed = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_USE_AFFAIRFIXED", (String)hrOrgId);
        if (is_use_affairFixed) {
            EmpEnrollHelper.processAffairFixedSalary(ctx, entryInfo, eebbInfo);
        } else {
            EmpEnrollHelper.addfixedcmpscheme(ctx, entryInfo, hrOrgId);
        }
    }

    @Override
    public void _entryEffect(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        super._entryEffect(ctx, entry);
    }

    protected PersonInfo savePersonInfo(Context ctx, EmpEnrollTemplateBillEntryInfo info) throws BOSException, EASBizException {
        PersonInfo pInfo = this.getPersonInfo(ctx, null, info);
        PersonPositionInfo ppInfo = this.getPersonPositionInfo(ctx, info, pInfo);
        pInfo.put("personPosition", (Object)ppInfo);
        IPersonOptFacade iPersonOptFacade = PersonOptFacadeFactory.getLocalInstance((Context)ctx);
        PersonOptBaseInfo personOptInfo = new PersonOptBaseInfo();
        personOptInfo.setPerson(pInfo);
        personOptInfo.setPersonPosition(ppInfo);
        personOptInfo.setFromInitialize(false);
        Date effectDate = null;
        if (this.getEntryEffectDateField() != null) {
            effectDate = info.getDate(this.getEntryEffectDateField());
            effectDate = effectDate != null ? DateTimeUtils.truncateDate((Date)effectDate) : info.getBizDate();
        }
        if (!info.isEnrollAgain()) {
            IObjectPK pkPerson = iPersonOptFacade.personAddNew(effectDate, personOptInfo);
            pInfo.setId(BOSUuid.read((String)pkPerson.toString()));
        } else {
            pInfo.setId(info.getExistPersonID());
            iPersonOptFacade.personUpdate(effectDate, personOptInfo);
        }
        return pInfo;
    }

    public PersonInfo getPersonInfo(Context ctx, PersonInfo pInfo, EmpEnrollTemplateBillEntryInfo info) throws BOSException, EASBizException {
        if (info == null) {
            return null;
        }
        if (pInfo == null) {
            pInfo = new PersonInfo();
        }
        EmpEnrollTemplateBillInfo bill = info.getBill();
        pInfo.setEmployeeType(info.getEmpType());
        pInfo.setName(info.getEmpName());
        pInfo.setName(info.getEmpName(), SysContext.getSysContext().getLocale());
        pInfo.setNumber(info.getEmpNumber());
        pInfo.setPassportNO(info.getPassportNo());
        pInfo.setIdCardNO(info.getIDCardNo());
        pInfo.setGender(info.getGender());
        pInfo.setBirthday(info.getBirthday());
        HROrgUnitInfo hrOrg = bill.getHrOrgUnit();
        if (hrOrg != null) {
            CtrlUnitInfo cu = hrOrg.getCU();
            if (cu == null) {
                cu = HROrgContextManagerFacadeFactory.getLocalInstance((Context)ctx).getCUByHRO(hrOrg);
            }
            pInfo.setCU(cu);
        }
        pInfo.setHrOrgUnit(hrOrg);
        if (bill.getId() != null) {
            pInfo.put("PersonEnroll", (Object)bill.getId().toString());
            pInfo.put("isEnroll", (Object)true);
        }
        String hrOrgID = null;
        if (hrOrg != null) {
            hrOrgID = hrOrg.getId().toString();
        }
        if (info.isEnrollAgain()) {
            pInfo.setId(info.getExistPersonID());
        }
        MappingApplyUtil.setValueByMapping((Context)ctx, (IObjectValue)pInfo, (IObjectValue)info, (String)"entrys", (EntityFieldMappingCollection)MappingApplyUtil.getFieldMappingCollection((Context)ctx, (IObjectValue)bill, (String)hrOrgID));
        return pInfo;
    }

    protected PersonPositionInfo getPersonPositionInfo(Context ctx, EmpEnrollTemplateBillEntryInfo enrolInfo, PersonInfo perInfo) throws EASBizException, BOSException {
        IPersonPosition ipp = PersonPositionFactory.getLocalInstance((Context)ctx);
        PersonPositionInfo pInfo = null;
        if (!enrolInfo.isEnrollAgain()) {
            pInfo = new PersonPositionInfo();
        } else {
            pInfo = ipp.getPersonPositionInfo("select * where person.id = '" + perInfo.getId().toString() + "'");
            pInfo.setLeftDate(null);
            pInfo.setIsEnrollAgain(true);
        }
        pInfo.setPerson(perInfo);
        AffairActionReasonInfo affaircReasonInfo = enrolInfo.getAffairActionReason();
        if (affaircReasonInfo != null) {
            EnrollSourceInfo sourceInfo = this.getEnrollSourceInfoByAffairActionReason(ctx, affaircReasonInfo);
            pInfo.setEnrollSource(sourceInfo);
        }
        Date date = DateTimeUtils.truncateDate((Date)enrolInfo.getEnrollDate());
        Date jobStartDate = new Date();
        pInfo.setEnterDate(date);
        pInfo.setJoinDate(date);
        pInfo.setJoinGroupDate(date);
        pInfo.setJobGrade(enrolInfo.getJobGrade());
        pInfo.setJobGradeEndDate(date);
        pInfo.setPrimaryPosition(enrolInfo.getPosition());
        pInfo.setPersonDep(enrolInfo.getAdminOrg());
        int joinYear = 0;
        if (date != null) {
            int curYear = DateTimeUtils.getYear((Date)date);
            if (curYear - (joinYear = DateTimeUtils.getYear((Date)jobStartDate)) >= 0) {
                pInfo.setWorkTime((long)(curYear - joinYear));
            }
        } else {
            pInfo.setWorkTime(0L);
        }
        int probation = enrolInfo.getProbation();
        pInfo.setTryoutMonth(probation);
        if (enrolInfo.getFormalDate() != null) {
            pInfo.setFormalDate(enrolInfo.getFormalDate());
        } else {
            pInfo.setFormalDate(DateTimeUtils.addMonth((Date)date, (int)probation));
        }
        return pInfo;
    }

    private EnrollSourceInfo getEnrollSourceInfoByAffairActionReason(Context ctx, AffairActionReasonInfo affaircReasonInfo) throws BOSException {
        EnrollSourceInfo sourceInfo = null;
        StringBuffer oql = new StringBuffer();
        oql.append("select id where affairActionReason='").append(affaircReasonInfo.getId()).append("'");
        EnrollSourceCollection coll = EnrollSourceFactory.getLocalInstance((Context)ctx).getEnrollSourceCollection(oql.toString());
        if (coll.size() > 0) {
            sourceInfo = coll.get(0);
        }
        return sourceInfo;
    }

    @Override
    protected PosPerPlanInfo[] getAddPosPerPlanInfo(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        EmpEnrollTemplateBillEntryInfo einfo = (EmpEnrollTemplateBillEntryInfo)entry;
        return new PosPerPlanInfo[]{new PosPerPlanInfo(null, einfo.getPosition(), einfo.getEmpType())};
    }

    @Override
    protected PosPerPlanInfo[] getDelPosPerPlanInfo(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        return null;
    }
}

