/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.hr.affair.EnrollBillEntryCollection;
import com.kingdee.eas.hr.affair.EnrollBillEntryInfo;
import com.kingdee.eas.hr.affair.EnrollBillFactory;
import com.kingdee.eas.hr.affair.EnrollBillInfo;
import com.kingdee.eas.hr.affair.HRAffairBaseInfo;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.affair.app.AbstractEnrollBillControllerBean;
import com.kingdee.eas.hr.base.CodingRuleManageFacadeFactory;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.util.HRCheckUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Date;
import java.util.Locale;

public class EnrollBillControllerBean
extends AbstractEnrollBillControllerBean {
    @Override
    protected void checkBillEntry(Context ctx, HRAffairBaseInfo model) throws BOSException, EASBizException {
        super.checkBillEntry(ctx, model);
        if (model instanceof EnrollBillInfo) {
            EnrollBillEntryCollection entries = ((EnrollBillInfo)model).getEntries();
            String billID = null;
            if (model.getId() != null) {
                billID = model.getId().toString();
            }
            if (entries != null) {
                EnrollBillEntryInfo entry = null;
                int size = entries.size();
                for (int i = 0; i < size; ++i) {
                    entry = entries.get(i);
                    HRCheckUtil.getPersonNumberCheckInstanceForEnroll((String)billID, (String)entry.getExistedPersonId()).check(entry.getNumber(), ctx);
                }
            }
        }
    }

    @Override
    protected void preProcess(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super.preProcess(ctx, pk, model);
        if (model instanceof EnrollBillInfo) {
            int i;
            EnrollBillInfo oldEnrollBillInfo = this.getEnrollBillInfo(ctx, pk);
            EnrollBillEntryCollection oldEntries = null;
            if (oldEnrollBillInfo != null) {
                oldEntries = oldEnrollBillInfo.getEntries();
            }
            EnrollBillEntryCollection entries = ((EnrollBillInfo)model).getEntries();
            EnrollBillEntryInfo oldEntry = null;
            EnrollBillEntryInfo entry = null;
            if (oldEntries != null) {
                boolean isDelete = true;
                int oldsize = oldEntries.size();
                for (i = 0; i < oldsize; ++i) {
                    oldEntry = oldEntries.get(i);
                    if (entries != null) {
                        int size = entries.size();
                        for (int j = 0; j < size; ++j) {
                            entry = entries.get(j);
                            if (!oldEntry.getId().equals((Object)entry.getId())) continue;
                            isDelete = false;
                            break;
                        }
                    }
                    if (isDelete) {
                        this._dispachIntermitNumber(ctx, oldEntry);
                        continue;
                    }
                    isDelete = true;
                }
            }
            if (entries != null) {
                PersonInfo person = new PersonInfo();
                person.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                int size = entries.size();
                for (i = 0; i < size; ++i) {
                    entry = entries.get(i);
                    if (entry.isIsEnrollAgain() && entry.isIsUseOldNumber() || entry.getId() != null) continue;
                    if (entry.getBirthday() != null) {
                        person.setBirthday(entry.getBirthday());
                    }
                    if (entry.getGender() != null) {
                        person.setGender(entry.getGender());
                    }
                    person.setNumber(entry.getNumber());
                    entry.setNumber(CodingRuleManageFacadeFactory.getLocalInstance((Context)ctx).getNumberFromCodingRule((IObjectValue)person, null, null));
                }
            }
        }
    }

    @Override
    protected void setNumberFromCodingRule(Context ctx, HRBillBaseInfo model) throws BOSException, EASBizException {
        EnrollBillEntryCollection entries;
        super.setNumberFromCodingRule(ctx, model);
        if (model instanceof EnrollBillInfo && (entries = ((EnrollBillInfo)model).getEntries()) != null) {
            EnrollBillEntryInfo entry = null;
            PersonInfo person = new PersonInfo();
            person.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            String number = null;
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = entries.get(i);
                if (entry.isIsEnrollAgain() && entry.isIsUseOldNumber()) continue;
                if (entry.getBirthday() != null) {
                    person.setBirthday(entry.getBirthday());
                }
                if (entry.getGender() != null) {
                    person.setGender(entry.getGender());
                }
                person.setNumber(entry.getNumber());
                number = CodingRuleManageFacadeFactory.getLocalInstance((Context)ctx).getNumberFromCodingRule((IObjectValue)person, null, null);
                if (number == null) continue;
                entry.setNumber(number);
            }
        }
    }

    private void _dispachIntermitNumber(Context ctx, EnrollBillEntryInfo entry) throws BOSException, EASBizException {
        if (!(entry == null || entry.isIsEnrollAgain() && entry.isIsUseOldNumber() || entry.getNumber() == null)) {
            PersonInfo person = new PersonInfo();
            person.setNumber(entry.getNumber());
            CodingRuleManageFacadeFactory.getLocalInstance((Context)ctx).recycleNumber((IObjectValue)person, null, entry.getNumber());
        }
    }

    @Override
    protected void _dispachIntermitNumber(Context ctx, IObjectPK pk) throws CodingRuleException, EASBizException, BOSException {
        EnrollBillEntryCollection entries;
        super._dispachIntermitNumber(ctx, pk);
        EnrollBillInfo enrollInfo = this.getEnrollBillInfo(ctx, pk);
        if (enrollInfo != null && (entries = enrollInfo.getEntries()) != null) {
            EnrollBillEntryInfo entry = null;
            PersonInfo person = new PersonInfo();
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = entries.get(i);
                if (entry.isIsEnrollAgain() && entry.isIsUseOldNumber() || entry.getNumber() == null) continue;
                person.setNumber(entry.getNumber());
                CodingRuleManageFacadeFactory.getLocalInstance((Context)ctx).recycleNumber((IObjectValue)person, null, entry.getNumber());
            }
        }
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        EnrollBillInfo enrollBillInfo = (EnrollBillInfo)super._getValue(ctx, pk, selector);
        if (enrollBillInfo != null) {
            EnrollBillEntryCollection enrollBillEntryCol = enrollBillInfo.getEntries();
            StringBuffer entryIdStr = new StringBuffer();
            entryIdStr.append("WHERE boID in (");
            int size = enrollBillEntryCol.size();
            for (int i = 0; i < size; ++i) {
                if (i == size - 1) {
                    entryIdStr.append("'" + enrollBillEntryCol.get(i).getId().toString() + "')");
                    continue;
                }
                entryIdStr.append("'" + enrollBillEntryCol.get(i).getId().toString() + "',");
            }
            BoAttchAssoCollection boAttchAssoCol = BoAttchAssoFactory.getLocalInstance((Context)ctx).getBoAttchAssoCollection(entryIdStr.toString());
            int size2 = enrollBillEntryCol.size();
            for (int i = 0; i < size2; ++i) {
                boolean isExistAttachment = false;
                int attSize = boAttchAssoCol.size();
                for (int j = 0; j < attSize; ++j) {
                    if (!enrollBillEntryCol.get(i).getId().toString().equals(boAttchAssoCol.get(j).getBoID())) continue;
                    isExistAttachment = true;
                    break;
                }
                enrollBillEntryCol.get(i).setIsExistAttachment(isExistAttachment);
            }
        }
        return enrollBillInfo;
    }

    @Override
    protected String getResource(Context ctx) {
        return ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"25_HRAffairBaseControllerBean", (Locale)ctx.getOriginLocale());
    }

    @Override
    protected void checkEffectData(Context ctx, String billID) throws BOSException, EASBizException {
        EnrollBillInfo billInfo = EnrollBillFactory.getLocalInstance(ctx).getEnrollBillInfo((IObjectPK)new ObjectUuidPK(billID));
        String hrOrgId = null;
        EnrollBillEntryCollection entryCol = null;
        hrOrgId = billInfo.getHrOrgUnit().getId().toString();
        entryCol = billInfo.getEntries();
        boolean isPersonOnEnrollDate = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_CREATEPERSON_ON_ENROLLDATE", (String)hrOrgId);
        Date now = new Date();
        boolean result = false;
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            EnrollBillEntryInfo entryInfo = entryCol.get(i);
            Date createPersonDate = entryInfo.getEnrollDate();
            if (!isPersonOnEnrollDate) {
                createPersonDate = entryInfo.getApproveDate();
            }
            if (createPersonDate == null) {
                throw new HRAffairException(HRAffairException.MUST_CHANGE_PARAM);
            }
            if (!now.after(createPersonDate)) continue;
            result = true;
            break;
        }
        if (result) {
            throw new HRAffairException(HRAffairException.CAN_NOT_UNAUDIT);
        }
    }

    @Override
    protected String getEntryIdStr(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        EnrollBillInfo BillInfo = EnrollBillFactory.getLocalInstance(ctx).getEnrollBillInfo(pk);
        EnrollBillEntryCollection billEntryCol = BillInfo.getEntries();
        StringBuffer billEntryIdStr = new StringBuffer();
        int size = billEntryCol.size();
        for (int i = 0; i < size; ++i) {
            billEntryIdStr.append("'");
            billEntryIdStr.append(billEntryCol.get(i).getId().toString());
            if (i == size - 1) {
                billEntryIdStr.append("'");
                continue;
            }
            billEntryIdStr.append("',");
        }
        return billEntryIdStr.toString();
    }

    public void reverseSave(Context ctx, IObjectPK srcBillPK, CoreBillBaseInfo srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationInfo bOTRelationInfo) throws BOSException, EASBizException {
    }

    public void reverseSave(Context ctx, IObjectPK pk, CoreBillBaseInfo model) throws BOSException, EASBizException {
    }
}

