/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.AffairBizException;
import com.kingdee.eas.hr.affair.FluctuationBizBillEntryCollection;
import com.kingdee.eas.hr.affair.FluctuationBizBillEntryFactory;
import com.kingdee.eas.hr.affair.FluctuationBizBillEntryInfo;
import com.kingdee.eas.hr.affair.FluctuationBizBillFactory;
import com.kingdee.eas.hr.affair.FluctuationBizBillInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillInfo;
import com.kingdee.eas.hr.affair.IFluctuationBizBillEntry;
import com.kingdee.eas.hr.affair.app.AbstractFluctuationBizBillControllerBean;
import com.kingdee.eas.hr.affair.app.AffairTriggerInfo;
import com.kingdee.eas.hr.affair.app.FluctuationBillBizBean;
import com.kingdee.eas.hr.affair.app.HrAffairFillEmptyBizDefineUtil;
import com.kingdee.eas.hr.affair.util.AffairUtil;
import com.kingdee.eas.hr.base.EmpInfoMultiPageInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBizDefineFactory;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.hr.base.IHRBillBaseEntry;
import com.kingdee.eas.hr.base.app.EmpPosOrgRelationQueryHelper;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.base.util.HRParamUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.emp.CompleteStateEnum;
import com.kingdee.eas.hr.emp.FluctuationInOutCollection;
import com.kingdee.eas.hr.emp.FluctuationInOutFactory;
import com.kingdee.eas.hr.emp.FluctuationInOutInfo;
import com.kingdee.eas.hr.emp.IFluctuationInOut;
import com.kingdee.eas.hr.emp.PersonLoanFactory;
import com.kingdee.eas.hr.emp.PersonLoanInfo;
import com.kingdee.eas.hr.emp.PersonLoanOutBackState;
import com.kingdee.eas.hr.emp.app.util.FluctuationInOutUtil;
import com.kingdee.eas.hr.emp.app.util.RecEntryServiceUtil;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptOrgnizationTool;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class FluctuationBizBillControllerBean
extends AbstractFluctuationBizBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.affair.app.FluctuationBizBillControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FluctuationBizBillInfo billInfo = (FluctuationBizBillInfo)model;
        FluctuationBizBillEntryCollection col = billInfo.getEntrys();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            FluctuationBizBillEntryInfo entry = col.get(i);
            entry.setReplaceAdminOrg(entry.getAdminOrg());
            entry.setReplaceOldAdminOrg(entry.getOldAdminOrg());
        }
        HrAffairFillEmptyBizDefineUtil.fillFluctuationBizBillEntry(ctx, billInfo.getEntrys());
        return super._addnew(ctx, (IObjectValue)billInfo);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        FluctuationBizBillInfo billInfo = (FluctuationBizBillInfo)model;
        FluctuationBizBillEntryCollection col = billInfo.getEntrys();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            FluctuationBizBillEntryInfo entry = col.get(i);
            entry.setReplaceAdminOrg(entry.getAdminOrg());
            entry.setReplaceOldAdminOrg(entry.getOldAdminOrg());
        }
        super._update(ctx, pk, (IObjectValue)billInfo);
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FluctuationBizBillInfo billInfo = (FluctuationBizBillInfo)model;
        HrAffairFillEmptyBizDefineUtil.fillFluctuationBizBillEntry(ctx, billInfo.getEntrys());
        return super._submit(ctx, model);
    }

    @Override
    protected String getBillField() {
        return "bill";
    }

    @Override
    protected String getEntryField() {
        return "entrys";
    }

    @Override
    protected String getEntryEffectDateField() {
        return "bizDate";
    }

    protected String getEffectFunction() {
        return "com.kingdee.eas.hr.affair.app.FluctuationBizBillEffectFunction";
    }

    @Override
    protected IHRBillBaseEntry getEntryInterface(Context ctx) throws BOSException, EASBizException {
        return FluctuationBizBillEntryFactory.getLocalInstance(ctx);
    }

    @Override
    protected IHRBillBizBean getBizBean() {
        return new FluctuationBillBizBean();
    }

    @Override
    protected void _setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.checkIsNullPositionAndBizDate(ctx, billID);
        FluctuationBizBillInfo bill = (FluctuationBizBillInfo)this.getHRBillBaseInfo(ctx, "select entrys.person.id,entrys.adminOrg.id where id='" + billID + "'");
        FluctuationBizBillEntryCollection entry = bill.getEntrys();
        FluctuationBizBillEntryInfo fbInfo = null;
        HashMap<String, String> map = new HashMap<String, String>();
        int size = entry.size();
        for (int i = 0; i < size; ++i) {
            fbInfo = entry.get(i);
            if (fbInfo.getPerson() == null || fbInfo.getAdminOrg() == null) continue;
            map.put(fbInfo.getPerson().getId().toString(), fbInfo.getAdminOrg().getId().toString());
        }
        super._setAudited(ctx, billID);
    }

    @Override
    protected void checkBeforeSubmit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        super.checkBeforeSubmit(ctx, model);
        FluctuationBizBillInfo billInfo = (FluctuationBizBillInfo)model;
        Object submitCheck = billInfo.get("submitCheck");
        if (null != submitCheck) {
            return;
        }
        FluctuationBizBillEntryCollection col = billInfo.getEntrys();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            FluctuationBizBillEntryInfo entry = col.get(i);
            if (entry.getAdminOrg() == null || entry.getOldAdminOrg() == null) continue;
            AdminOrgUnitInfo company = HRUtilExtend.getCompany((Context)ctx, (AdminOrgUnitInfo)entry.getAdminOrg());
            AdminOrgUnitInfo oldCompany = HRUtilExtend.getCompany((Context)ctx, (AdminOrgUnitInfo)entry.getOldAdminOrg());
            if (company != null && oldCompany != null && HRUtilExtend.isObjectEquelsByPkValue((CoreBaseInfo)company, (CoreBaseInfo)oldCompany)) continue;
        }
    }

    @Override
    protected void _doWithCommonRelationEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        super._doWithCommonRelationEffect(ctx, entry);
    }

    @Override
    protected void _doWithPriorityThingEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        super._doWithPriorityThingEffect(ctx, entry);
        FluctuationBizBillEntryInfo affairEntry = (FluctuationBizBillEntryInfo)entry;
    }

    @Override
    protected void _doWithSpecialFiledsEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        super._doWithSpecialFiledsEffect(ctx, entry);
    }

    @Override
    protected void _doWithOtherChangeEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        super._doWithOtherChangeEffect(ctx, entry);
        FluctuationBizBillEntryInfo affairEntry = (FluctuationBizBillEntryInfo)entry;
        try {
            Class<?> cls = Class.forName("com.kingdee.eas.hr.rec.app.processor.ResumePersonStateUpdaterProcessor");
            Method method = cls.getMethod("updateResumeBaseState_New", Context.class, FluctuationBizBillEntryInfo.class);
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy(cls.newInstance());
            txInvoker.invoke(method, new Object[]{ctx, affairEntry}, 1);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        boolean is_use_affairFixed = false;
        if (this.getHROrgUnit(ctx, new ObjectUuidPK(entry.getId().toString())) != null) {
            is_use_affairFixed = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_USE_AFFAIRFIXED", (String)this.getHROrgUnit(ctx, new ObjectUuidPK(entry.getId().toString())).getId().toString());
        }
        if (is_use_affairFixed) {
            try {
                AffairTriggerInfo trigger = new AffairTriggerInfo(affairEntry, affairEntry.getSalaryPoint(), "FluctuationBizBill", "Init_FixedScheme", false);
                try {
                    Class<?> cls = Class.forName("com.kingdee.eas.hr.compensation.app.AffairTriggerCompensationProcessor");
                    Method method = cls.getMethod("processAffairFixedSalary", Context.class, AffairTriggerInfo.class);
                    EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy(cls.newInstance());
                    txInvoker.invoke(method, new Object[]{ctx, trigger}, 1);
                }
                catch (ClassNotFoundException e) {
                    logger.error((Object)e);
                }
                catch (SecurityException e) {
                    logger.error((Object)e);
                }
                catch (NoSuchMethodException e) {
                    logger.error((Object)e);
                }
                catch (Throwable e) {
                    logger.error((Object)e);
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        FluctuationInOutUtil.updateFluctuationInOutData((Context)ctx, (HRAffairBizBillEntryInfo)entry);
        this.doWithLoanFluctuation(ctx, entry);
    }

    @Override
    protected void _entryEffect(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        super._entryEffect(ctx, entry);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doWithLoanFluctuation(Context ctx, HRAffairBizBillEntryInfo affairEntry) throws EASBizException, BOSException {
        Date loadoutDate;
        FluctuationBizBillEntryInfo entryEntry = (FluctuationBizBillEntryInfo)affairEntry;
        FluctuationBizBillInfo fluctuationBizBillInfo = entryEntry.getBill();
        String id = fluctuationBizBillInfo.getId().toString();
        fluctuationBizBillInfo = FluctuationBizBillFactory.getLocalInstance(ctx).getFluctuationBizBillInfo((IObjectPK)new ObjectUuidPK(id));
        HRBizDefineInfo hrBizDefineInfo = entryEntry.getHrBizDefine();
        hrBizDefineInfo = this.getHRBizDefineInfo(ctx, hrBizDefineInfo);
        if (!fluctuationBizBillInfo.getBoolean("isLoanBill")) return;
        PersonInfo personInfo = entryEntry.getPerson();
        PersonLoanInfo personLoanInfo = AffairUtil.getPersonLoanInfo(ctx, personInfo);
        if ("SHR31".equals(hrBizDefineInfo.getNumber())) {
            if (personLoanInfo == null) {
                personLoanInfo = new PersonLoanInfo();
                personLoanInfo.setOutPosition(entryEntry.getOldPosition());
                personLoanInfo.setOutAdmin(entryEntry.getOldAdminOrg());
                personLoanInfo.setOutJob(entryEntry.getOldJob());
                personLoanInfo.setInPosition(entryEntry.getPosition());
                personLoanInfo.setInAdmin(entryEntry.getAdminOrg());
                personLoanInfo.setInJob(entryEntry.getJob());
                personLoanInfo.setLoanEndDate(entryEntry.getLoanEndDate());
                personLoanInfo.setLoanDate(entryEntry.getBizDate());
                personLoanInfo.setLoanEffectDate(entryEntry.getLoanEffectDate());
                personLoanInfo.setLoanEntryId(entryEntry.getId().toString());
                personLoanInfo.setPerson(entryEntry.getPerson());
                personLoanInfo.setOutBillNumber(fluctuationBizBillInfo.getNumber());
                personLoanInfo.setPersonLoanState(PersonLoanOutBackState.loaning);
                personLoanInfo.setOutBillDesc(this.getLoanDescription(ctx, personLoanInfo, entryEntry));
                personLoanInfo.setOutRemark(entryEntry.getDescription());
                PersonLoanFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)personLoanInfo);
                return;
            }
            PositionInfo position = this.getPosition(ctx, entryEntry.getPosition());
            String positionStr = position.getName();
            AdminOrgUnitInfo adminOrg = this.getAdmin(ctx, entryEntry.getAdminOrg());
            String adminOrgStr = adminOrg.getName();
            PersonInfo person = this.getPerson(ctx, entryEntry.getPerson());
            String personStr = person.getName();
            String errorMsg = MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"label17", (Context)ctx), personStr, adminOrgStr, positionStr);
            NumericExceptionSubItem EXCEPTION = new NumericExceptionSubItem("000", errorMsg);
            throw new HRCommonException(EXCEPTION);
        }
        if (personLoanInfo == null) {
            PersonInfo person = this.getPerson(ctx, entryEntry.getPerson());
            String errorMsg = MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"label16", (Context)ctx), person.getName());
            NumericExceptionSubItem EXCEPTION = new NumericExceptionSubItem("000", errorMsg);
            throw new HRCommonException(EXCEPTION);
        }
        if ("SHR33".equals(hrBizDefineInfo.getNumber())) {
            personLoanInfo.setBackAdmin(entryEntry.getAdminOrg());
            personLoanInfo.setBackPosition(entryEntry.getPosition());
            personLoanInfo.setBackJob(entryEntry.getJob());
        }
        if (DateTimeUtils.dayAfter((Date)(loadoutDate = personLoanInfo.getLoanDate()), (Date)entryEntry.getBizDate())) {
            PersonInfo person = this.getPerson(ctx, entryEntry.getPerson());
            String errorMsg = MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"label18", (Context)ctx), person.getName());
            NumericExceptionSubItem EXCEPTION = new NumericExceptionSubItem("000", errorMsg);
            throw new HRCommonException(EXCEPTION);
        }
        personLoanInfo.setBackEffectDate(entryEntry.getBizDate());
        personLoanInfo.setPersonLoanState(PersonLoanOutBackState.loanBack);
        personLoanInfo.setBackBillNumber(fluctuationBizBillInfo.getNumber());
        personLoanInfo.setBackBillDesc(this.getLoanDescription(ctx, personLoanInfo, entryEntry));
        personLoanInfo.setBackRemark(entryEntry.getDescription());
        String personLoanInfoId = personLoanInfo.getId().toString();
        PersonLoanFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(personLoanInfoId), (EmpInfoMultiPageInfo)personLoanInfo);
    }

    public HRBizDefineInfo getHRBizDefineInfo(Context ctx, HRBizDefineInfo hrBizDefineInfo) {
        String id = hrBizDefineInfo.getId().toString();
        try {
            hrBizDefineInfo = HRBizDefineFactory.getLocalInstance((Context)ctx).getHRBizDefineInfo((IObjectPK)new ObjectUuidPK(id));
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return null;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
        return hrBizDefineInfo;
    }

    public String getLoanDescription(Context ctx, PersonLoanInfo personLoanInfo, FluctuationBizBillEntryInfo entryEntry) throws BOSException {
        StringBuffer bufferStr = null;
        StringBuffer bufferStrBack = null;
        Date loanDate = personLoanInfo.getLoanDate();
        Date loanEndDate = personLoanInfo.getLoanEndDate();
        Date loanBackDate = personLoanInfo.getBackEffectDate();
        PersonLoanOutBackState personLoanState = personLoanInfo.getPersonLoanState();
        AdminOrgUnitInfo outAdmin = personLoanInfo.getOutAdmin();
        AdminOrgUnitInfo inAdmin = personLoanInfo.getInAdmin();
        PositionInfo outPosition = personLoanInfo.getOutPosition();
        PositionInfo inPosition = personLoanInfo.getInPosition();
        outAdmin = this.getAdmin(ctx, outAdmin);
        inAdmin = this.getAdmin(ctx, inAdmin);
        outPosition = this.getPosition(ctx, outPosition);
        inPosition = this.getPosition(ctx, inPosition);
        bufferStr = new StringBuffer();
        bufferStr.append(MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"label27", (Context)ctx), this.translateDateToStr(loanDate), outAdmin.getName(), outPosition.getName(), inAdmin.getName(), inPosition.getName(), this.translateDateToStr(loanEndDate)));
        if (personLoanState == PersonLoanOutBackState.getEnum((int)2)) {
            bufferStrBack = new StringBuffer();
            HRBizDefineInfo hrBizDefineInfo = entryEntry.getHrBizDefine();
            if ("SHR33".equals((hrBizDefineInfo = this.getHRBizDefineInfo(ctx, hrBizDefineInfo)).getNumber())) {
                AdminOrgUnitInfo backAdmin = personLoanInfo.getBackAdmin();
                PositionInfo backPosition = personLoanInfo.getBackPosition();
                backAdmin = this.getAdmin(ctx, backAdmin);
                backPosition = this.getPosition(ctx, backPosition);
                bufferStrBack.append(MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"label28", (Context)ctx), this.translateDateToStr(loanBackDate), inAdmin.getName(), inPosition.getName(), backAdmin.getName(), backPosition.getName()));
            } else {
                bufferStrBack.append(MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"label28", (Context)ctx), this.translateDateToStr(loanBackDate), inAdmin.getName(), inPosition.getName(), outAdmin.getName(), outPosition.getName()));
            }
            return bufferStrBack.toString();
        }
        return bufferStr.toString();
    }

    public PersonInfo getPerson(Context ctx, PersonInfo person) throws BOSException {
        PersonInfo personInfo = null;
        String id = person.getId().toString();
        try {
            personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(id));
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return personInfo;
    }

    public AdminOrgUnitInfo getAdmin(Context ctx, AdminOrgUnitInfo admin) throws BOSException {
        AdminOrgUnitInfo adminOrg = null;
        String id = admin.getId().toString();
        try {
            adminOrg = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return adminOrg;
    }

    public PositionInfo getPosition(Context ctx, PositionInfo pos) throws BOSException {
        PositionInfo position = null;
        String id = pos.getId().toString();
        try {
            position = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(id));
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return position;
    }

    public String translateDateToStr(Date date) {
        String s = "";
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            s = dateFormat.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return s;
    }

    protected String getPermItemNameDelete() {
        return "flucBiz_Delete";
    }

    protected String getPermItemNameAddnew() {
        return "flucBiz_AddNew";
    }

    protected String getPermItemNameEdit() {
        return "flucBiz_Update";
    }

    protected String getEntryIdStr(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        FluctuationBizBillInfo BillInfo = FluctuationBizBillFactory.getLocalInstance(ctx).getFluctuationBizBillInfo(pk);
        FluctuationBizBillEntryCollection billEntryCol = BillInfo.getEntrys();
        StringBuffer billEntryIdStr = new StringBuffer();
        int size = billEntryCol.size();
        for (int i = 0; i < size; ++i) {
            billEntryIdStr.append("'");
            billEntryIdStr.append(billEntryCol.get(i).getId().toString());
            if (i == size - 1) {
                billEntryIdStr.append("'");
                continue;
            }
            billEntryIdStr.append("',");
        }
        return billEntryIdStr.toString();
    }

    private void checkIsNullPositionAndBizDate(Context ctx, BOSUuid billID) throws AffairBizException, BOSException {
        IFluctuationBizBillEntry iEntry = null;
        FluctuationBizBillEntryCollection entryCol = null;
        int size = 0;
        StringBuffer oql = new StringBuffer("select adminOrg,bizDate,position where bill = '");
        oql.append(billID).append("'");
        try {
            iEntry = FluctuationBizBillEntryFactory.getLocalInstance(ctx);
            entryCol = iEntry.getFluctuationBizBillEntryCollection(oql.toString());
        }
        catch (BOSException e) {
            throw new BOSException();
        }
        if (entryCol != null) {
            size = entryCol.size();
        }
        if (size <= 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            if (entryCol.get(i).getBizDate() != null && entryCol.get(i).getAdminOrg() != null && entryCol.get(i).getPosition() != null) continue;
            throw new AffairBizException(AffairBizException.POSITION_ADMINORG_BIZDATE_NOTNULL);
        }
    }

    private void updateFluctuationInOutData(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        IFluctuationInOut iFIO = FluctuationInOutFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String personId = entry.getPerson().getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("completeState", (Object)0));
        view.setFilter(filter);
        FluctuationInOutCollection col = new FluctuationInOutCollection();
        col = iFIO.getFluctuationInOutCollection(view);
        if (col.size() > 0) {
            FluctuationInOutInfo info = col.get(0);
            info.setEFFECT(entry.getBizDate());
            info.setNewAdmin(entry.getAdminOrg());
            info.setNewPosition(entry.getPosition());
            info.setNewLaborRelState(entry.getEmpType());
            info.setCompleteState(CompleteStateEnum.COMPLETED);
            info.setEmpID(this.getEmpIDByPersonID(ctx, personId));
            iFIO.update((IObjectPK)new ObjectUuidPK(info.getId().toString()), info);
        }
    }

    private String getEmpIDByPersonID(Context ctx, String personId) throws BOSException {
        String empID = "";
        EmpPosOrgRelationQueryHelper helper = new EmpPosOrgRelationQueryHelper();
        EmpPosOrgRelationCollection col = new EmpPosOrgRelationCollection();
        col = helper.getCurrntEmpOrgRelation(ctx, personId);
        if (col.size() > 0) {
            empID = col.get(0).getId().toString();
        }
        return empID;
    }

    @Override
    public void _unAuditEachEntrySpecialPropertyRecovery(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        super._unAuditEachEntrySpecialPropertyRecovery(ctx, entry);
    }

    @Override
    protected boolean isNeedRecorderUserPermission() {
        return true;
    }

    @Override
    protected boolean isNeedDoWithUserPermission() {
        return true;
    }

    @Override
    protected HRAffairBizBillEntryInfo storefieldsForEntry(Context ctx, HRAffairBizBillInfo billInfo, HRAffairBizBillEntryInfo entryInfo) throws EASBizException, BOSException {
        JobGradeInfo jobGradeInfo = entryInfo.getJobGrade();
        JobLevelInfo jobLevelInfo = entryInfo.getJobLevel();
        if (entryInfo.getAdminOrg() == null) {
            PositionInfo positionInfo = entryInfo.getPosition();
            if (positionInfo != null) {
                AdminOrgUnitInfo adminOrgUnitInfo = SHREmpOptOrgnizationTool.getAdminOrgUnitByPosition((Context)ctx, (String)positionInfo.getId().toString());
                entryInfo.setAdminOrg(adminOrgUnitInfo);
                entryInfo.setCompany(adminOrgUnitInfo.getCompany());
            }
        } else {
            AdminOrgUnitInfo adminOrgUnitInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(entryInfo.getAdminOrg().getId().toString()));
            entryInfo.setCompany(adminOrgUnitInfo.getCompany());
        }
        super.storefieldsForEntry(ctx, billInfo, entryInfo);
        entryInfo.setJobGrade(jobGradeInfo);
        entryInfo.setJobLevel(jobLevelInfo);
        return entryInfo;
    }

    @Override
    protected void _setAuditEnd(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        super._setAuditEnd(ctx, billID);
        FluctuationBizBillInfo bill = (FluctuationBizBillInfo)this.getHRBillBaseInfo(ctx, "select number,entrys.person.id,entrys.adminOrg.id where id='" + billID + "'");
        RecEntryServiceUtil.recTransferService((Context)ctx, (FluctuationBizBillInfo)bill, (int)4);
    }

    @Override
    protected void _setAuditing(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        super._setAuditing(ctx, billID);
        FluctuationBizBillInfo bill = (FluctuationBizBillInfo)this.getHRBillBaseInfo(ctx, "select number,entrys.person.id,entrys.adminOrg.id where id='" + billID + "'");
        RecEntryServiceUtil.recTransferService((Context)ctx, (FluctuationBizBillInfo)bill, (int)2);
    }

    @Override
    protected void _setSubmited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        super._setSubmited(ctx, billID);
        FluctuationBizBillInfo bill = (FluctuationBizBillInfo)this.getHRBillBaseInfo(ctx, "select number,entrys.person.id,entrys.adminOrg.id where id='" + billID + "'");
        RecEntryServiceUtil.recTransferService((Context)ctx, (FluctuationBizBillInfo)bill, (int)1);
    }

    @Override
    protected void _untiCheckBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)billId)) {
            super._untiCheckBizBill(ctx, billId);
            FluctuationBizBillInfo bill = (FluctuationBizBillInfo)this.getHRBillBaseInfo(ctx, "select number,entrys.person.id,entrys.adminOrg.id where id='" + billId + "'");
            RecEntryServiceUtil.recTransferService((Context)ctx, (FluctuationBizBillInfo)bill, (int)4);
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FluctuationBizBillInfo billInfo = (FluctuationBizBillInfo)this._getValue(ctx, pk);
        super._delete(ctx, pk);
        RecEntryServiceUtil.recTransferService((Context)ctx, (FluctuationBizBillInfo)billInfo, (int)5);
    }

    @Override
    protected IObjectPK _submitEffect(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        FluctuationBizBillInfo billInfo = (FluctuationBizBillInfo)model;
        IObjectPK pk = super._submitEffect(ctx, model);
        RecEntryServiceUtil.recTransferService((Context)ctx, (FluctuationBizBillInfo)billInfo, (int)3);
        return pk;
    }

    @Override
    protected void checkPersonIsResign(Context ctx, HRBillBaseEntryInfo entryInfo) throws BOSException, EASBizException {
        FluctuationBizBillEntryInfo info = (FluctuationBizBillEntryInfo)entryInfo;
        String oql = "select id,effdt,person.number,person.name where action.bizDefineType = 4 and person.id = '" + info.getPerson().getId().toString() + "' and effdt >= {ts'" + info.getBizDate() + " 00:00:00'}";
        EmpPosOrgRelationCollection empRelationColls = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(oql);
        if (empRelationColls != null && empRelationColls.size() > 0) {
            String message = SHRServerResource.getString((String)"com.kingdee.eas.hr.affair.AffairBizResource", (String)"label32", (Context)ctx);
            Object[] params = new Object[]{empRelationColls.get(0).getPerson().getName(), empRelationColls.get(0).getPerson().getName(), DateTimeUtils.format((Date)empRelationColls.get(0).getEFFDT(), (String)"yyyy-MM-dd")};
            message = MessageFormat.format(message, params);
            throw new AffairBizException(AffairBizException.BILL_CHECK_FAILED, new String[]{message});
        }
    }
}

