/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillInfo;
import com.kingdee.eas.hr.affair.LoanBackBizBillEntryCollection;
import com.kingdee.eas.hr.affair.LoanBackBizBillEntryFactory;
import com.kingdee.eas.hr.affair.LoanBackBizBillEntryInfo;
import com.kingdee.eas.hr.affair.LoanBackBizBillFactory;
import com.kingdee.eas.hr.affair.LoanBackBizBillInfo;
import com.kingdee.eas.hr.affair.app.AbstractLoanBackBizBillControllerBean;
import com.kingdee.eas.hr.affair.app.LoanBackBillBizBean;
import com.kingdee.eas.hr.affair.util.AffairUtil;
import com.kingdee.eas.hr.base.EmpInfoMultiPageInfo;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.IHRBillBaseEntry;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.emp.IPersonLoan;
import com.kingdee.eas.hr.emp.LoanStateEnum;
import com.kingdee.eas.hr.emp.PersonLoanCollection;
import com.kingdee.eas.hr.emp.PersonLoanFactory;
import com.kingdee.eas.hr.emp.PersonLoanInfo;
import com.kingdee.eas.hr.emp.PersonLoanOutBackState;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptOrgnizationTool;

public class LoanBackBizBillControllerBean
extends AbstractLoanBackBizBillControllerBean {
    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanBackBizBillInfo billInfo = (LoanBackBizBillInfo)model;
        return super._addnew(ctx, model);
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LoanBackBizBillInfo billInfo = (LoanBackBizBillInfo)model;
        return super._submit(ctx, model);
    }

    @Override
    protected String getBillField() {
        return "bill";
    }

    @Override
    protected String getEntryField() {
        return "entrys";
    }

    @Override
    protected String getEntryEffectDateField() {
        return "bizDate";
    }

    protected String getEffectFunction() {
        return "com.kingdee.eas.hr.affair.app.LoanBackBizBillEffectFunction";
    }

    @Override
    protected IHRBillBaseEntry getEntryInterface(Context ctx) throws BOSException, EASBizException {
        return LoanBackBizBillEntryFactory.getLocalInstance(ctx);
    }

    @Override
    protected IHRBillBizBean getBizBean() {
        return new LoanBackBillBizBean();
    }

    @Override
    protected void _doWithPriorityThingEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        super._doWithPriorityThingEffect(ctx, entry);
        LoanBackBizBillEntryInfo einfo = (LoanBackBizBillEntryInfo)entry;
    }

    @Override
    protected void _doWithSpecialFiledsEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        super._doWithSpecialFiledsEffect(ctx, entry);
        LoanBackBizBillEntryInfo einfo = (LoanBackBizBillEntryInfo)entry;
        this.saveBackPersonLoanInfo(ctx, einfo);
    }

    @Override
    protected void _entryEffect(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        super._entryEffect(ctx, entry);
    }

    private void saveBackPersonLoanInfo(Context ctx, LoanBackBizBillEntryInfo loanBackEntryInfo) throws BOSException, EASBizException {
        IPersonLoan ipersonLoan = PersonLoanFactory.getLocalInstance((Context)ctx);
        String oql = "where state='1' and person.id='" + loanBackEntryInfo.getPerson().getId() + "'";
        PersonLoanInfo personLoan = ipersonLoan.getPersonLoanInfo(oql);
        personLoan.setState(LoanStateEnum.history);
        personLoan.setPersonLoanState(PersonLoanOutBackState.loanBack);
        personLoan.setBackEffectDate(loanBackEntryInfo.getBizDate());
        personLoan.setBackBillNumber(loanBackEntryInfo.getBill().getNumber());
        personLoan.setBackRemark(loanBackEntryInfo.getDescription());
        personLoan.setBackBillDesc(AffairUtil.getLoanDescription(ctx, personLoan, loanBackEntryInfo));
        PersonLoanInfo newpersonLoan = ipersonLoan.getPersonLoanInfo(oql);
        personLoan.setBackPosition(newpersonLoan.getBackPosition());
        personLoan.setBackAdmin(newpersonLoan.getBackAdmin());
        ipersonLoan.update((IObjectPK)new ObjectUuidPK(personLoan.getId()), (EmpInfoMultiPageInfo)personLoan);
    }

    protected String getPermItemNameDelete() {
        return "loanBack_Delete";
    }

    protected String getPermItemNameAddnew() {
        return "loanBack_AddNew";
    }

    protected String getPermItemNameEdit() {
        return "loanBack_Update";
    }

    protected String getEntryIdStr(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        LoanBackBizBillInfo BillInfo = LoanBackBizBillFactory.getLocalInstance(ctx).getLoanBackBizBillInfo(pk);
        LoanBackBizBillEntryCollection billEntryCol = BillInfo.getEntrys();
        StringBuffer billEntryIdStr = new StringBuffer();
        int size = billEntryCol.size();
        for (int i = 0; i < size; ++i) {
            billEntryIdStr.append("'");
            billEntryIdStr.append(billEntryCol.get(i).getId().toString());
            if (i == size - 1) {
                billEntryIdStr.append("'");
                continue;
            }
            billEntryIdStr.append("',");
        }
        return billEntryIdStr.toString();
    }

    @Override
    protected HRAffairBizBillEntryInfo storefieldsForEntry(Context ctx, HRAffairBizBillInfo billInfo, HRAffairBizBillEntryInfo entryInfo) throws EASBizException, BOSException {
        PositionInfo positionInfo;
        if ((entryInfo.getAdminOrg() == null || entryInfo.getCompany() == null) && (positionInfo = entryInfo.getPosition()) != null) {
            AdminOrgUnitInfo adminOrgUnitInfo = SHREmpOptOrgnizationTool.getAdminOrgUnitByPosition((Context)ctx, (String)positionInfo.getId().toString());
            if (entryInfo.getAdminOrg() == null) {
                entryInfo.setAdminOrg(adminOrgUnitInfo);
            }
            if (entryInfo.getCompany() == null) {
                entryInfo.setCompany(adminOrgUnitInfo.getCompany());
            }
        }
        return super.storefieldsForEntry(ctx, billInfo, entryInfo);
    }

    @Override
    public void _unAuditEachEntrySpecialPropertyRecovery(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        LoanBackBizBillEntryInfo entryInfo = (LoanBackBizBillEntryInfo)entry;
        String personId = entryInfo.getPerson().getId().toString();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        filterInfo.getFilterItems().add(new FilterItemInfo("backBillNumber", (Object)entryInfo.getBill().getNumber()));
        viewInfo.setFilter(filterInfo);
        IPersonLoan iPersonLoan = PersonLoanFactory.getLocalInstance((Context)ctx);
        PersonLoanCollection plColl = iPersonLoan.getPersonLoanCollection(viewInfo);
        if (plColl.size() > 0) {
            PersonLoanInfo loanInfo = plColl.get(0);
            loanInfo.setBackEffectDate(null);
            loanInfo.setState(LoanStateEnum.present);
            loanInfo.setPersonLoanState(PersonLoanOutBackState.loaning);
            loanInfo.setBackBillNumber(null);
            loanInfo.setBackBillDesc(null);
            loanInfo.setBackRemark(null);
            iPersonLoan.update((IObjectPK)new ObjectUuidPK(loanInfo.getId().toString()), (EmpInfoMultiPageInfo)loanInfo);
        }
    }

    @Override
    protected boolean isNeedDoWithUserPermission() {
        return true;
    }

    @Override
    protected void _untiCheckBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        super._untiCheckBizBill(ctx, billId);
    }
}

