/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.hr.affair.AbstractEmpHireBizBillEntryInfo;
import com.kingdee.eas.hr.affair.AbstractFlucInBizBillEntryInfo;
import com.kingdee.eas.hr.affair.AbstractFluctuationBizBillEntryInfo;
import com.kingdee.eas.hr.affair.AbstractOnPositionBizBillEntryInfo;
import com.kingdee.eas.hr.affair.EmpHireBizBillEntryCollection;
import com.kingdee.eas.hr.affair.EmpHireBizBillEntryFactory;
import com.kingdee.eas.hr.affair.EmpHireBizBillEntryInfo;
import com.kingdee.eas.hr.affair.FlucInBizBillEntryCollection;
import com.kingdee.eas.hr.affair.FlucInBizBillEntryFactory;
import com.kingdee.eas.hr.affair.FlucInBizBillEntryInfo;
import com.kingdee.eas.hr.affair.FluctuationBizBillEntryCollection;
import com.kingdee.eas.hr.affair.FluctuationBizBillEntryFactory;
import com.kingdee.eas.hr.affair.FluctuationBizBillEntryInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.affair.OnPositionBizBillEntryCollection;
import com.kingdee.eas.hr.affair.OnPositionBizBillEntryFactory;
import com.kingdee.eas.hr.affair.OnPositionBizBillEntryInfo;
import com.kingdee.eas.hr.affair.OrgAdjBizBillEntryCollection;
import com.kingdee.eas.hr.affair.OrgAdjBizBillEntryInfo;
import com.kingdee.eas.hr.affair.PersonMoveTypeEnum;
import com.kingdee.eas.hr.affair.app.AffairAuditEffectHelper;
import com.kingdee.eas.hr.base.AffairActionReasonInfo;
import com.kingdee.eas.hr.base.HRBizData;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.app.util.HRBizDefineAffairUtils;
import com.kingdee.eas.hr.base.app.util.HRBizDefineAppUtils;
import com.kingdee.eas.hr.emp.EmpTypeConvertHisCollection;
import com.kingdee.eas.hr.emp.EmpTypeConvertHisFactory;
import com.kingdee.eas.hr.emp.EmpTypeConvertHisInfo;
import com.kingdee.eas.hr.org.OrgAdjustEnableException;
import com.kingdee.eas.hr.org.OrgVerAdjEnum;
import com.kingdee.eas.hr.org.OrgVerEffectInfo;
import com.kingdee.eas.hr.org.PersonVerAdjRecCollection;
import com.kingdee.eas.hr.org.PersonVerAdjRecInfo;
import com.kingdee.eas.hr.org.app.IOrgVersionChecker;
import com.kingdee.eas.hr.org.app.OrgVersionPreparePersonData;
import com.kingdee.eas.hr.org.app.OrgVersionUtils;
import com.kingdee.eas.hr.org.util.OrgVerAdjUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class OrgVersionPersonCheckHandler
implements IOrgVersionChecker {
    public OrgVerEffectInfo check(Context ctx, OrgVerEffectInfo checkResultInfo) throws BOSException, EASBizException {
        try {
            this.personAlreadAddNew(ctx, checkResultInfo);
            this.personNoPositionToHavingPosition(ctx, checkResultInfo);
            this.personHavingPositionToNoPosition(ctx, checkResultInfo);
            this.personAffair(ctx, checkResultInfo);
            this.operateAdminPositionSame(ctx, checkResultInfo);
            this.personCanAdjustOneTime(ctx, checkResultInfo);
        }
        catch (SQLException e) {
            throw new OrgAdjustEnableException(OrgAdjustEnableException.PERSONVALIDFAILD, (Throwable)e);
        }
        return checkResultInfo;
    }

    private void personCanAdjustOneTime(Context ctx, OrgVerEffectInfo checkResultInfo) throws BOSException {
        OrgVersionPreparePersonData preparePersonData = new OrgVersionPreparePersonData();
        ArrayList list = preparePersonData.getPersonVerAdjRecList(ctx, checkResultInfo);
        OrgAdjBizBillEntryInfo entryInfo = null;
        PersonVerAdjRecInfo pvAdjInfo = null;
        AdminOrgUnitInfo oldOrg = null;
        AdminOrgUnitInfo newOrg = null;
        PositionInfo oldPos = null;
        PositionInfo newPos = null;
        OrgAdjBizBillEntryCollection entryColl = new OrgAdjBizBillEntryCollection();
        Timestamp curTime = OrgVerAdjUtil.getTime();
        HRBizDefineInfo onPosBizDefInfo = HRBizDefineAppUtils.getHRBizDefineInfo((Context)ctx, (String)"8r0AAAADbujmaL7Z");
        AffairActionReasonInfo onPosBizDefReason = null;
        if (onPosBizDefInfo != null && onPosBizDefInfo.getActionReasons() != null && onPosBizDefInfo.getActionReasons().size() > 0) {
            onPosBizDefReason = onPosBizDefInfo.getActionReasons().get(0).getActionReason();
        }
        IPosition iposition = PositionFactory.getLocalInstance((Context)ctx);
        IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < list.size(); ++i) {
            entryInfo = new OrgAdjBizBillEntryInfo();
            entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
            pvAdjInfo = (PersonVerAdjRecInfo)list.get(i);
            oldOrg = new AdminOrgUnitInfo();
            oldOrg.setId(BOSUuid.read((String)pvAdjInfo.getBeforeAdjOrg()));
            entryInfo.setOldAdminOrg(oldOrg);
            newOrg = new AdminOrgUnitInfo();
            newOrg.setId(BOSUuid.read((String)pvAdjInfo.getAfterAdjOrg()));
            entryInfo.setAdminOrg(newOrg);
            entryInfo.setBizDate(curTime);
            entryInfo.setOldEmpType(pvAdjInfo.getPersonVer().getEmployeeType());
            entryInfo.setEmpType(pvAdjInfo.getPersonVer().getEmployeeType());
            entryInfo.setIsPrimary(true);
            entryInfo.setPerson(pvAdjInfo.getPersonVer().getPerson());
            if (StringUtils.isEmpty((String)pvAdjInfo.getAfterAdjPos())) {
                entryInfo.setPersonMoveType(PersonMoveTypeEnum.IsNoPositionMove);
            } else {
                oldPos = new PositionInfo();
                oldPos.setId(BOSUuid.read((String)pvAdjInfo.getBeforeAdjPos()));
                entryInfo.setOldPosition(oldPos);
                newPos = new PositionInfo();
                newPos.setId(BOSUuid.read((String)pvAdjInfo.getAfterAdjPos()));
                entryInfo.setPosition(newPos);
                entryInfo.setPersonMoveType(PersonMoveTypeEnum.IsHasPositionMove);
                entryInfo.setHrBizDefine(onPosBizDefInfo);
                entryInfo.setAffairActionReason(onPosBizDefReason);
            }
            try {
                if (!iposition.exists((IObjectPK)new ObjectUuidPK(entryInfo.getPosition().getId())) || !iposition.exists((IObjectPK)new ObjectUuidPK(entryInfo.getOldPosition().getId())) || !iAdminOrgUnit.exists((IObjectPK)new ObjectUuidPK(entryInfo.getAdminOrg().getId())) || !iAdminOrgUnit.exists((IObjectPK)new ObjectUuidPK(entryInfo.getOldAdminOrg().getId()))) continue;
                entryColl.add(entryInfo);
                continue;
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
        Date curDate = DateTimeUtils.truncateDate((Date)new Date());
        for (int i = 0; i < entryColl.size(); ++i) {
            entryInfo = entryColl.get(i);
            try {
                AffairAuditEffectHelper helper = new AffairAuditEffectHelper();
                HRBizData bizData = helper.affairEntryConvertToBizData(ctx, curDate, entryInfo);
                HRBizDefineAffairUtils.validateBizData((Context)ctx, (HRBizData)bizData);
                continue;
            }
            catch (EASBizException ex) {
                checkResultInfo.appendErrorMsg(ex.getMessage());
            }
        }
    }

    private void operateAdminPositionSame(Context ctx, OrgVerEffectInfo checkResultInfo) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_HR_PersonVerAdjRec set fEnableStatus = 2 ");
        sql.append(" where fEnableStatus=0 and fBeforeAdjPos=fAfterAdjPos and fBeforeAdjOrg=FAfterAdjOrg and fOrgAdjSchm= ? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{checkResultInfo.getAdjSchmInfo().getId().toString()});
        sql = new StringBuffer();
        sql.append("update T_HR_PersonVerAdjRec set fEnableStatus = 2 ");
        sql.append(" where fEnableStatus=0 and (fBeforeAdjPos is null and fAfterAdjPos is null) and fBeforeAdjOrg=FAfterAdjOrg and fOrgAdjSchm= ? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{checkResultInfo.getAdjSchmInfo().getId().toString()});
    }

    private void personAlreadAddNew(Context ctx, OrgVerEffectInfo checkResultInfo) throws BOSException, EASBizException, SQLException {
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuffer sql = new StringBuffer();
        sql.append(" select ").append("per.fname_" + l + " fname_" + l + ",per.fnumber fnumber,org.fdisplayname_" + l + " orgDisplayName ").append(" from T_BD_Person per left join T_HR_PersonPosition pp on pp.fPersonID=per.fid ").append(" left join T_ORG_ADMIN org on pp.FPersonDep=org.FID").append(" where ").append(checkResultInfo.getOrgWhereStr()).append(" and not exists (select FPersonID from T_HR_PersonVer b where b.fOrgAdjSchm = ? ").append(" and b.FPersonID = per.fid )");
        Object[] params = new Object[]{checkResultInfo.getAdjSchmInfo().getId().toString()};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        StringBuffer sb = null;
        String afterAdjSchmEable = SHRServerResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"AfterAdjSchmEable", (Locale)ctx.getLocale());
        String personInfoNotChange = SHRServerResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"PersonInfoNotChange", (Locale)ctx.getLocale());
        while (rowSet.next()) {
            sb = new StringBuffer();
            sb.append(afterAdjSchmEable).append(rowSet.getString("orgDisplayName")).append(" ").append(rowSet.getString("fname_" + l + "")).append("(").append(rowSet.getString("fnumber")).append(") ").append(personInfoNotChange);
            checkResultInfo.appendWarningMsg(sb.toString());
        }
    }

    private void personNoPositionToHavingPosition(Context ctx, OrgVerEffectInfo checkResultInfo) throws BOSException, EASBizException, SQLException {
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuffer sql = new StringBuffer();
        sql.append(" select ").append("org.fdisplayname_" + l + " orgDisplayName,perv.fname_" + l + " fname_" + l + ",perv.fnumber fnumber ").append(" from T_HR_PersonVer perv inner join T_HR_PersonPosition pp on pp.fPersonID=perv.FPersonID ").append(" left join T_HR_PositionVer pv on pv.fid=perv.fPrimaryPosition ").append(" left join T_ORG_ADMIN org on pp.FPersonDep=org.FID ").append(" where ").append(" perv.fOrgAdjSchm= ?  and  pp.fprimarypositionId is not null and perv.fprimaryposition is null  ");
        Object[] params = new Object[]{checkResultInfo.getAdjSchmInfo().getId().toString()};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        StringBuffer sb = null;
        String afterAdjSchmEable = SHRServerResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"AfterAdjSchmEable", (Locale)ctx.getLocale());
        String personInfoNotChange = SHRServerResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"PersonInfoNotChange", (Locale)ctx.getLocale());
        while (rowSet.next()) {
            sb = new StringBuffer();
            sb.append(afterAdjSchmEable).append(rowSet.getString("orgDisplayName")).append(" ").append(rowSet.getString("fname_" + l + "")).append(" ").append(personInfoNotChange);
            checkResultInfo.appendWarningMsg(sb.toString());
        }
    }

    private void personHavingPositionToNoPosition(Context ctx, OrgVerEffectInfo checkResultInfo) throws BOSException, EASBizException, SQLException {
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuffer sql = new StringBuffer();
        sql.append(" select ").append("org.fdisplayname_" + l + " orgDisplayName,perv.fname_" + l + " fname_" + l + ",perv.fnumber fnumber ").append(" from T_HR_PersonVer perv inner join T_HR_PersonPosition pp on pp.fPersonID=perv.FPersonID ").append(" left join T_HR_PositionVer pv on pv.fid=perv.fPrimaryPosition ").append(" left join T_ORG_ADMIN org on pp.FPersonDep=org.FID").append(" where ").append(" perv.fOrgAdjSchm= ?  and  pp.fprimarypositionId is null and perv.fprimaryposition is not null ");
        Object[] params = new Object[]{checkResultInfo.getAdjSchmInfo().getId().toString()};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        StringBuffer sb = null;
        String afterAdjSchmEable = SHRServerResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"AfterAdjSchmEable", (Locale)ctx.getLocale());
        String personInfoNotChange = SHRServerResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"PersonInfoNotChange", (Locale)ctx.getLocale());
        while (rowSet.next()) {
            sb = new StringBuffer();
            sb.append(afterAdjSchmEable).append(rowSet.getString("orgDisplayName")).append(" ").append(rowSet.getString("fname_" + l + "")).append(" ").append(personInfoNotChange);
            checkResultInfo.appendWarningMsg(sb.toString());
        }
    }

    private void personAffair(Context ctx, OrgVerEffectInfo checkResultInfo) throws BOSException, EASBizException, SQLException {
        int i;
        PersonVerAdjRecCollection ovColl = null;
        ArrayList<PersonVerAdjRecInfo> move = new ArrayList<PersonVerAdjRecInfo>();
        ovColl = OrgVersionUtils.getPersonVerAdjRecCollection((Context)ctx, (String)checkResultInfo.getAdjSchmInfo().getId().toString());
        if (ovColl == null || ovColl.size() == 0) {
            return;
        }
        for (int i2 = 0; i2 < ovColl.size(); ++i2) {
            if (!OrgVerAdjEnum.MOVE.equals((Object)ovColl.get(i2).getAdjType())) continue;
            move.add(ovColl.get(i2));
        }
        if (move.size() == 0) {
            return;
        }
        HashSet<String> personSet = new HashSet<String>();
        HashMap personMap = new HashMap();
        for (i = 0; i < move.size(); ++i) {
            personSet.add(((PersonVerAdjRecInfo)move.get(i)).getPersonVer().getPerson().getId().toString());
        }
        for (i = 0; i < move.size(); ++i) {
            personMap.put(((PersonVerAdjRecInfo)move.get(i)).getPersonVer().getPerson().getId().toString(), move.get(i));
        }
        HashMap newPositionSamePosition = new HashMap();
        HashMap oldPositionSameNewPosition = new HashMap();
        HashMap newPositionNotEqualsNewPosition = new HashMap();
        this.fluctuation(ctx, personSet, personMap, newPositionSamePosition, oldPositionSameNewPosition, newPositionNotEqualsNewPosition);
        this.empHireBizBillFluctuation(ctx, personSet, personMap, newPositionSamePosition, oldPositionSameNewPosition, newPositionNotEqualsNewPosition);
        this.onPositionBizBillFluctuation(ctx, personSet, personMap, newPositionSamePosition, oldPositionSameNewPosition, newPositionNotEqualsNewPosition);
        this.flucInBizBillFluctuation(ctx, personSet, personMap, newPositionSamePosition, oldPositionSameNewPosition, newPositionNotEqualsNewPosition);
        this.employeeTypeExcept(ctx, personSet, personMap, newPositionSamePosition, oldPositionSameNewPosition, newPositionNotEqualsNewPosition);
        this.operatePersonAffairOldPositionSameAsNewPosition(ctx, checkResultInfo, oldPositionSameNewPosition);
        this.operatePersonAffairNewPositionSameAsNewPosition(ctx, checkResultInfo, newPositionSamePosition);
        this.operatePersonAffairNewPositionNotEqualsNewPosition(ctx, checkResultInfo, newPositionNotEqualsNewPosition);
    }

    private void employeeTypeExcept(Context ctx, HashSet personSet, HashMap personMap, HashMap newPositionSamePosition, HashMap oldPositionSameNewPosition, HashMap newPositionNotEqualsNewPosition) throws BOSException {
        int count = personSet.size() / 100;
        if (personSet.size() % 100 > 0) {
            ++count;
        }
        Calendar c = Calendar.getInstance();
        HashSet currentSet = null;
        int totalCount = 1;
        Iterator personIterator = personSet.iterator();
        for (int m = 0; m < count; ++m) {
            currentSet = new HashSet();
            while (totalCount % 100 != 0 && personIterator.hasNext()) {
                currentSet.add(personIterator.next());
                ++totalCount;
            }
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("employee.id", currentSet, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("auditState", (Object)"0"));
            filterInfo.getFilterItems().add(new FilterItemInfo("employee.id", currentSet, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("auditState", (Object)"1"));
            filterInfo.getFilterItems().add(new FilterItemInfo("effectDate", (Object)new Date(c.getTimeInMillis()), CompareType.GREATER));
            filterInfo.setMaskString("(#0 and #1)  or (#2 and #3 and #4 )  ");
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("employee.id"));
            sic.add(new SelectorItemInfo("employee.name"));
            sic.add(new SelectorItemInfo("employee.number"));
            sic.add(new SelectorItemInfo("fromPosition.id"));
            sic.add(new SelectorItemInfo("fromPosition.name"));
            sic.add(new SelectorItemInfo("fromUnit.id"));
            sic.add(new SelectorItemInfo("fromUnit.name"));
            sic.add(new SelectorItemInfo("fromUnit.displayname"));
            sic.add(new SelectorItemInfo("toPosition.id"));
            sic.add(new SelectorItemInfo("toPosition.name"));
            sic.add(new SelectorItemInfo("toUnit.id"));
            sic.add(new SelectorItemInfo("toUnit.name"));
            sic.add(new SelectorItemInfo("toUnit.displayname"));
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(sic);
            view.setFilter(filterInfo);
            EmpTypeConvertHisCollection empTypeColl = EmpTypeConvertHisFactory.getLocalInstance((Context)ctx).getEmpTypeConvertHisCollection(view);
            EmpTypeConvertHisInfo empTypeConvertInfo = null;
            PersonVerAdjRecInfo pvRecInfo = null;
            if (empTypeColl == null || empTypeColl.size() == 0) {
                return;
            }
            for (int i = 0; i < empTypeColl.size(); ++i) {
                empTypeConvertInfo = empTypeColl.get(i);
                pvRecInfo = (PersonVerAdjRecInfo)personMap.get(empTypeConvertInfo.getEmployee().getId().toString());
                if (OrgVerAdjUtil.objectIsEquals((ObjectBaseInfo)empTypeConvertInfo.getFromPosition(), (String)pvRecInfo.getAfterAdjPos()) && OrgVerAdjUtil.objectIsEquals((ObjectBaseInfo)empTypeConvertInfo.getFromUnit(), (String)pvRecInfo.getAfterAdjOrg())) {
                    oldPositionSameNewPosition.put(pvRecInfo, empTypeConvertInfo);
                    continue;
                }
                if (OrgVerAdjUtil.objectIsEquals((ObjectBaseInfo)empTypeConvertInfo.getFromPosition(), (String)pvRecInfo.getAfterAdjPos()) && OrgVerAdjUtil.objectIsEquals((ObjectBaseInfo)empTypeConvertInfo.getToUnit(), (String)pvRecInfo.getAfterAdjOrg())) {
                    newPositionSamePosition.put(pvRecInfo, empTypeConvertInfo);
                    continue;
                }
                newPositionNotEqualsNewPosition.put(pvRecInfo, empTypeConvertInfo);
            }
        }
    }

    private void fluctuation(Context ctx, HashSet personSet, HashMap personMap, HashMap newPositionSamePosition, HashMap oldPositionSameNewPosition, HashMap newPositionNotEqualsNewPosition) throws BOSException {
        int count = personSet.size() / 100;
        if (personSet.size() % 100 > 0) {
            ++count;
        }
        Calendar c = Calendar.getInstance();
        HashSet currentSet = null;
        int totalCount = 1;
        Iterator personIterator = personSet.iterator();
        for (int m = 0; m < count; ++m) {
            currentSet = new HashSet();
            while (totalCount % 100 != 0 && personIterator.hasNext()) {
                currentSet.add(personIterator.next());
                ++totalCount;
            }
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", currentSet, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)new Integer(0)));
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", currentSet, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)new Integer(2)));
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", currentSet, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)new Integer(1)));
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", currentSet, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)new Integer(3)));
            filterInfo.getFilterItems().add(new FilterItemInfo("bizDate", (Object)new Date(c.getTimeInMillis()), CompareType.GREATER));
            filterInfo.setMaskString("(#0 and #1) or (#2 and  #3) or (#4 and #5) or (#6 and #7 and #8 )  ");
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("person.id"));
            sic.add(new SelectorItemInfo("person.name"));
            sic.add(new SelectorItemInfo("person.number"));
            sic.add(new SelectorItemInfo("oldposition.id"));
            sic.add(new SelectorItemInfo("oldposition.name"));
            sic.add(new SelectorItemInfo("oldAdminOrg.id"));
            sic.add(new SelectorItemInfo("oldAdminOrg.name"));
            sic.add(new SelectorItemInfo("oldAdminOrg.displayname"));
            sic.add(new SelectorItemInfo("position.id"));
            sic.add(new SelectorItemInfo("position.name"));
            sic.add(new SelectorItemInfo("adminOrg.id"));
            sic.add(new SelectorItemInfo("adminOrg.name"));
            sic.add(new SelectorItemInfo("adminOrg.displayname"));
            sic.add(new SelectorItemInfo("bill.number"));
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(sic);
            view.setFilter(filterInfo);
            FluctuationBizBillEntryCollection fbbColl = FluctuationBizBillEntryFactory.getLocalInstance(ctx).getFluctuationBizBillEntryCollection(view);
            FluctuationBizBillEntryInfo entryInfo = null;
            PersonVerAdjRecInfo pvRecInfo = null;
            if (fbbColl == null || fbbColl.size() == 0) {
                return;
            }
            for (int i = 0; i < fbbColl.size(); ++i) {
                entryInfo = fbbColl.get(i);
                pvRecInfo = (PersonVerAdjRecInfo)personMap.get(entryInfo.getPerson().getId().toString());
                if (OrgVerAdjUtil.objectIsEquals((ObjectBaseInfo)entryInfo.getOldPosition(), (String)pvRecInfo.getAfterAdjPos()) && OrgVerAdjUtil.objectIsEquals((ObjectBaseInfo)entryInfo.getOldAdminOrg(), (String)pvRecInfo.getAfterAdjOrg())) {
                    oldPositionSameNewPosition.put(pvRecInfo, entryInfo);
                    continue;
                }
                if (OrgVerAdjUtil.objectIsEquals((ObjectBaseInfo)entryInfo.getPosition(), (String)pvRecInfo.getAfterAdjPos()) && OrgVerAdjUtil.objectIsEquals((ObjectBaseInfo)entryInfo.getAdminOrg(), (String)pvRecInfo.getAfterAdjOrg())) {
                    newPositionSamePosition.put(pvRecInfo, entryInfo);
                    continue;
                }
                newPositionNotEqualsNewPosition.put(pvRecInfo, entryInfo);
            }
        }
    }

    private void empHireBizBillFluctuation(Context ctx, HashSet personSet, HashMap personMap, HashMap newPositionSamePosition, HashMap oldPositionSameNewPosition, HashMap newPositionNotEqualsNewPosition) throws BOSException {
        int count = personSet.size() / 100;
        if (personSet.size() % 100 > 0) {
            ++count;
        }
        Calendar c = Calendar.getInstance();
        HashSet currentSet = null;
        int totalCount = 1;
        Iterator personIterator = personSet.iterator();
        for (int m = 0; m < count; ++m) {
            currentSet = new HashSet();
            while (totalCount % 100 != 0 && personIterator.hasNext()) {
                currentSet.add(personIterator.next());
                ++totalCount;
            }
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", currentSet, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)new Integer(0)));
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", currentSet, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)new Integer(2)));
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", currentSet, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)new Integer(1)));
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", currentSet, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)new Integer(3)));
            filterInfo.getFilterItems().add(new FilterItemInfo("bizDate", (Object)new Date(c.getTimeInMillis()), CompareType.GREATER));
            filterInfo.setMaskString("(#0 and #1) or (#2 and  #3) or (#4 and #5) or (#6 and #7 and #8 )  ");
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("person.id"));
            sic.add(new SelectorItemInfo("person.name"));
            sic.add(new SelectorItemInfo("person.number"));
            sic.add(new SelectorItemInfo("oldposition.id"));
            sic.add(new SelectorItemInfo("oldposition.name"));
            sic.add(new SelectorItemInfo("oldAdminOrg.id"));
            sic.add(new SelectorItemInfo("oldAdminOrg.name"));
            sic.add(new SelectorItemInfo("oldAdminOrg.displayname"));
            sic.add(new SelectorItemInfo("position.id"));
            sic.add(new SelectorItemInfo("position.name"));
            sic.add(new SelectorItemInfo("adminOrg.id"));
            sic.add(new SelectorItemInfo("adminOrg.name"));
            sic.add(new SelectorItemInfo("adminOrg.displayname"));
            sic.add(new SelectorItemInfo("bill.number"));
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(sic);
            view.setFilter(filterInfo);
            EmpHireBizBillEntryCollection fbbColl = EmpHireBizBillEntryFactory.getLocalInstance(ctx).getEmpHireBizBillEntryCollection(view);
            EmpHireBizBillEntryInfo entryInfo = null;
            PersonVerAdjRecInfo pvRecInfo = null;
            if (fbbColl == null || fbbColl.size() == 0) {
                return;
            }
            for (int i = 0; i < fbbColl.size(); ++i) {
                entryInfo = fbbColl.get(i);
                pvRecInfo = (PersonVerAdjRecInfo)personMap.get(entryInfo.getPerson().getId().toString());
                if (OrgVerAdjUtil.objectIsEquals((ObjectBaseInfo)entryInfo.getOldPosition(), (String)pvRecInfo.getAfterAdjPos()) && OrgVerAdjUtil.objectIsEquals((ObjectBaseInfo)entryInfo.getOldAdminOrg(), (String)pvRecInfo.getAfterAdjOrg())) {
                    oldPositionSameNewPosition.put(pvRecInfo, entryInfo);
                    continue;
                }
                if (OrgVerAdjUtil.objectIsEquals((ObjectBaseInfo)entryInfo.getPosition(), (String)pvRecInfo.getAfterAdjPos()) && OrgVerAdjUtil.objectIsEquals((ObjectBaseInfo)entryInfo.getAdminOrg(), (String)pvRecInfo.getAfterAdjOrg())) {
                    newPositionSamePosition.put(pvRecInfo, entryInfo);
                    continue;
                }
                newPositionNotEqualsNewPosition.put(pvRecInfo, entryInfo);
            }
        }
    }

    private void flucInBizBillFluctuation(Context ctx, HashSet personSet, HashMap personMap, HashMap newPositionSamePosition, HashMap oldPositionSameNewPosition, HashMap newPositionNotEqualsNewPosition) throws BOSException {
        int count = personSet.size() / 100;
        if (personSet.size() % 100 > 0) {
            ++count;
        }
        Calendar c = Calendar.getInstance();
        HashSet currentSet = null;
        int totalCount = 1;
        Iterator personIterator = personSet.iterator();
        for (int m = 0; m < count; ++m) {
            currentSet = new HashSet();
            while (totalCount % 100 != 0 && personIterator.hasNext()) {
                currentSet.add(personIterator.next());
                ++totalCount;
            }
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", currentSet, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)new Integer(0)));
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", currentSet, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)new Integer(2)));
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", currentSet, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)new Integer(1)));
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", currentSet, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)new Integer(3)));
            filterInfo.getFilterItems().add(new FilterItemInfo("bizDate", (Object)new Date(c.getTimeInMillis()), CompareType.GREATER));
            filterInfo.setMaskString("(#0 and #1) or (#2 and  #3) or (#4 and #5) or (#6 and #7 and #8 )  ");
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("person.id"));
            sic.add(new SelectorItemInfo("person.name"));
            sic.add(new SelectorItemInfo("person.number"));
            sic.add(new SelectorItemInfo("oldposition.id"));
            sic.add(new SelectorItemInfo("oldposition.name"));
            sic.add(new SelectorItemInfo("oldAdminOrg.id"));
            sic.add(new SelectorItemInfo("oldAdminOrg.name"));
            sic.add(new SelectorItemInfo("oldAdminOrg.displayname"));
            sic.add(new SelectorItemInfo("position.id"));
            sic.add(new SelectorItemInfo("position.name"));
            sic.add(new SelectorItemInfo("adminOrg.id"));
            sic.add(new SelectorItemInfo("adminOrg.name"));
            sic.add(new SelectorItemInfo("adminOrg.displayname"));
            sic.add(new SelectorItemInfo("bill.number"));
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(sic);
            view.setFilter(filterInfo);
            FlucInBizBillEntryCollection fbbColl = FlucInBizBillEntryFactory.getLocalInstance(ctx).getFlucInBizBillEntryCollection(view);
            FlucInBizBillEntryInfo entryInfo = null;
            PersonVerAdjRecInfo pvRecInfo = null;
            if (fbbColl == null || fbbColl.size() == 0) {
                return;
            }
            for (int i = 0; i < fbbColl.size(); ++i) {
                entryInfo = fbbColl.get(i);
                pvRecInfo = (PersonVerAdjRecInfo)personMap.get(entryInfo.getPerson().getId().toString());
                if (OrgVerAdjUtil.objectIsEquals((ObjectBaseInfo)entryInfo.getOldPosition(), (String)pvRecInfo.getAfterAdjPos()) && OrgVerAdjUtil.objectIsEquals((ObjectBaseInfo)entryInfo.getOldAdminOrg(), (String)pvRecInfo.getAfterAdjOrg())) {
                    oldPositionSameNewPosition.put(pvRecInfo, entryInfo);
                    continue;
                }
                if (OrgVerAdjUtil.objectIsEquals((ObjectBaseInfo)entryInfo.getPosition(), (String)pvRecInfo.getAfterAdjPos()) && OrgVerAdjUtil.objectIsEquals((ObjectBaseInfo)entryInfo.getAdminOrg(), (String)pvRecInfo.getAfterAdjOrg())) {
                    newPositionSamePosition.put(pvRecInfo, entryInfo);
                    continue;
                }
                newPositionNotEqualsNewPosition.put(pvRecInfo, entryInfo);
            }
        }
    }

    private void onPositionBizBillFluctuation(Context ctx, HashSet personSet, HashMap personMap, HashMap newPositionSamePosition, HashMap oldPositionSameNewPosition, HashMap newPositionNotEqualsNewPosition) throws BOSException {
        int count = personSet.size() / 100;
        if (personSet.size() % 100 > 0) {
            ++count;
        }
        Calendar c = Calendar.getInstance();
        HashSet currentSet = null;
        int totalCount = 1;
        Iterator personIterator = personSet.iterator();
        for (int m = 0; m < count; ++m) {
            currentSet = new HashSet();
            while (totalCount % 100 != 0 && personIterator.hasNext()) {
                currentSet.add(personIterator.next());
                ++totalCount;
            }
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", currentSet, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)new Integer(0)));
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", currentSet, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)new Integer(2)));
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", currentSet, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)new Integer(1)));
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", currentSet, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)new Integer(3)));
            filterInfo.getFilterItems().add(new FilterItemInfo("bizDate", (Object)new Date(c.getTimeInMillis()), CompareType.GREATER));
            filterInfo.setMaskString("(#0 and #1) or (#2 and  #3) or (#4 and #5) or (#6 and #7 and #8 )  ");
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("person.id"));
            sic.add(new SelectorItemInfo("person.name"));
            sic.add(new SelectorItemInfo("person.number"));
            sic.add(new SelectorItemInfo("oldposition.id"));
            sic.add(new SelectorItemInfo("oldposition.name"));
            sic.add(new SelectorItemInfo("oldAdminOrg.id"));
            sic.add(new SelectorItemInfo("oldAdminOrg.name"));
            sic.add(new SelectorItemInfo("oldAdminOrg.displayname"));
            sic.add(new SelectorItemInfo("position.id"));
            sic.add(new SelectorItemInfo("position.name"));
            sic.add(new SelectorItemInfo("adminOrg.id"));
            sic.add(new SelectorItemInfo("adminOrg.name"));
            sic.add(new SelectorItemInfo("adminOrg.displayname"));
            sic.add(new SelectorItemInfo("bill.number"));
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(sic);
            view.setFilter(filterInfo);
            OnPositionBizBillEntryCollection fbbColl = OnPositionBizBillEntryFactory.getLocalInstance(ctx).getOnPositionBizBillEntryCollection(view);
            OnPositionBizBillEntryInfo entryInfo = null;
            PersonVerAdjRecInfo pvRecInfo = null;
            if (fbbColl == null || fbbColl.size() == 0) {
                return;
            }
            for (int i = 0; i < fbbColl.size(); ++i) {
                entryInfo = fbbColl.get(i);
                pvRecInfo = (PersonVerAdjRecInfo)personMap.get(entryInfo.getPerson().getId().toString());
                if (OrgVerAdjUtil.objectIsEquals((ObjectBaseInfo)entryInfo.getOldPosition(), (String)pvRecInfo.getAfterAdjPos()) && OrgVerAdjUtil.objectIsEquals((ObjectBaseInfo)entryInfo.getOldAdminOrg(), (String)pvRecInfo.getAfterAdjOrg())) {
                    oldPositionSameNewPosition.put(pvRecInfo, entryInfo);
                    continue;
                }
                if (OrgVerAdjUtil.objectIsEquals((ObjectBaseInfo)entryInfo.getPosition(), (String)pvRecInfo.getAfterAdjPos()) && OrgVerAdjUtil.objectIsEquals((ObjectBaseInfo)entryInfo.getAdminOrg(), (String)pvRecInfo.getAfterAdjOrg())) {
                    newPositionSamePosition.put(pvRecInfo, entryInfo);
                    continue;
                }
                newPositionNotEqualsNewPosition.put(pvRecInfo, entryInfo);
            }
        }
    }

    private void operatePersonAffairOldPositionSameAsNewPosition(Context ctx, OrgVerEffectInfo checkResultInfo, HashMap map) throws BOSException, EASBizException, SQLException {
        if (map.size() == 0) {
            return;
        }
        this.updateRecState(ctx, checkResultInfo, map);
    }

    private void operatePersonAffairNewPositionSameAsNewPosition(Context ctx, OrgVerEffectInfo checkResultInfo, HashMap map) throws BOSException, EASBizException, SQLException {
        if (map.size() == 0) {
            return;
        }
        Iterator it = map.entrySet().iterator();
        Map.Entry entry = null;
        PersonVerAdjRecInfo pvRecInfo = null;
        EmpTypeConvertHisInfo empTypeConvertHisInfo = null;
        StringBuffer sb = null;
        String hasExistOrderNo = SHRServerResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"HasExistOrderNo", (Locale)ctx.getLocale());
        String changePerson = SHRServerResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"ChangePerson", (Locale)ctx.getLocale());
        String flucIn = SHRServerResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"FlucIn", (Locale)ctx.getLocale());
        String currentSchmNotDone = SHRServerResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"CurrentSchmNotDone", (Locale)ctx.getLocale());
        String employeTypeConvertOrder = SHRServerResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"EmployeTypeConvertOrder", (Locale)ctx.getLocale());
        String positionNotConsistentNotNeedAdjust = SHRServerResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"PositionNotConsistentNotNeedAdjust", (Locale)ctx.getLocale());
        while (it.hasNext()) {
            HRAffairBizBillEntryInfo entryInfo;
            entry = it.next();
            pvRecInfo = (PersonVerAdjRecInfo)entry.getKey();
            sb = new StringBuffer();
            if (entry.getValue() instanceof FluctuationBizBillEntryInfo) {
                entryInfo = (FluctuationBizBillEntryInfo)entry.getValue();
                sb.append(hasExistOrderNo).append(((AbstractFluctuationBizBillEntryInfo)entryInfo).getBill().getNumber()).append(changePerson).append(pvRecInfo.getPersonVer().getName()).append(flucIn).append(entryInfo.getAdminOrg().getDisplayName()).append("(").append(entryInfo.getPosition().getName()).append("),").append(currentSchmNotDone);
            } else if (entry.getValue() instanceof EmpHireBizBillEntryInfo) {
                entryInfo = (EmpHireBizBillEntryInfo)entry.getValue();
                sb.append(hasExistOrderNo).append(((AbstractEmpHireBizBillEntryInfo)entryInfo).getBill().getNumber()).append(changePerson).append(pvRecInfo.getPersonVer().getName()).append(flucIn).append(entryInfo.getAdminOrg().getDisplayName()).append("(").append(entryInfo.getPosition().getName()).append("),").append(currentSchmNotDone);
            } else if (entry.getValue() instanceof OnPositionBizBillEntryInfo) {
                entryInfo = (OnPositionBizBillEntryInfo)entry.getValue();
                sb.append(hasExistOrderNo).append(((AbstractOnPositionBizBillEntryInfo)entryInfo).getBill().getNumber()).append(changePerson).append(pvRecInfo.getPersonVer().getName()).append(flucIn).append(entryInfo.getAdminOrg().getDisplayName()).append("(").append(entryInfo.getPosition().getName()).append("),").append(currentSchmNotDone);
            } else if (entry.getValue() instanceof FlucInBizBillEntryInfo) {
                entryInfo = (FlucInBizBillEntryInfo)entry.getValue();
                sb.append(hasExistOrderNo).append(((AbstractFlucInBizBillEntryInfo)entryInfo).getBill().getNumber()).append(changePerson).append(pvRecInfo.getPersonVer().getName()).append(flucIn).append(entryInfo.getAdminOrg().getDisplayName()).append("(").append(entryInfo.getPosition().getName()).append("),").append(currentSchmNotDone);
            } else {
                empTypeConvertHisInfo = (EmpTypeConvertHisInfo)entry.getValue();
                sb.append(empTypeConvertHisInfo.getToUnit().getDisplayName()).append(pvRecInfo.getPersonVer().getName()).append(employeTypeConvertOrder).append(positionNotConsistentNotNeedAdjust);
            }
            checkResultInfo.appendWarningMsg(sb.toString());
        }
        this.updateRecState(ctx, checkResultInfo, map);
    }

    private void operatePersonAffairNewPositionNotEqualsNewPosition(Context ctx, OrgVerEffectInfo checkResultInfo, HashMap map) throws BOSException, EASBizException, SQLException {
        if (map.size() == 0) {
            return;
        }
        Iterator it = map.entrySet().iterator();
        Map.Entry entry = null;
        PersonVerAdjRecInfo pvRecInfo = null;
        EmpTypeConvertHisInfo empTypeConvertHisInfo = null;
        StringBuffer sb = null;
        String hasExistOrderNo = SHRServerResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"HasExistOrderNo", (Locale)ctx.getLocale());
        String changePerson = SHRServerResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"ChangePerson", (Locale)ctx.getLocale());
        String flucIn = SHRServerResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"FlucIn", (Locale)ctx.getLocale());
        String currentSchmNotDone = SHRServerResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"CurrentSchmNotDone", (Locale)ctx.getLocale());
        while (it.hasNext()) {
            HRAffairBizBillEntryInfo entryInfo;
            entry = it.next();
            pvRecInfo = (PersonVerAdjRecInfo)entry.getKey();
            sb = new StringBuffer();
            if (entry.getValue() instanceof FluctuationBizBillEntryInfo) {
                entryInfo = (FluctuationBizBillEntryInfo)entry.getValue();
                sb.append(hasExistOrderNo).append(((AbstractFluctuationBizBillEntryInfo)entryInfo).getBill().getNumber()).append(changePerson).append(pvRecInfo.getPersonVer().getName()).append(flucIn).append(entryInfo.getAdminOrg().getDisplayName()).append("(").append(entryInfo.getPosition().getName()).append(")").append("),").append(currentSchmNotDone);
            } else if (entry.getValue() instanceof EmpHireBizBillEntryInfo) {
                entryInfo = (EmpHireBizBillEntryInfo)entry.getValue();
                sb.append(hasExistOrderNo).append(((AbstractEmpHireBizBillEntryInfo)entryInfo).getBill().getNumber()).append(changePerson).append(pvRecInfo.getPersonVer().getName()).append(flucIn).append(entryInfo.getAdminOrg().getDisplayName()).append("(").append(entryInfo.getPosition().getName()).append(")").append("),").append(currentSchmNotDone);
            } else if (entry.getValue() instanceof OnPositionBizBillEntryInfo) {
                entryInfo = (OnPositionBizBillEntryInfo)entry.getValue();
                sb.append(hasExistOrderNo).append(((AbstractOnPositionBizBillEntryInfo)entryInfo).getBill().getNumber()).append(changePerson).append(pvRecInfo.getPersonVer().getName()).append(flucIn).append(entryInfo.getAdminOrg().getDisplayName()).append("(").append(entryInfo.getPosition().getName()).append(")").append("),").append(currentSchmNotDone);
            } else if (entry.getValue() instanceof FlucInBizBillEntryInfo) {
                entryInfo = (FlucInBizBillEntryInfo)entry.getValue();
                sb.append(hasExistOrderNo).append(((AbstractFlucInBizBillEntryInfo)entryInfo).getBill().getNumber()).append(changePerson).append(pvRecInfo.getPersonVer().getName()).append(flucIn).append(entryInfo.getAdminOrg().getDisplayName()).append("(").append(entryInfo.getPosition().getName()).append(")").append("),").append(currentSchmNotDone);
            } else {
                empTypeConvertHisInfo = (EmpTypeConvertHisInfo)entry.getValue();
                sb.append(hasExistOrderNo).append(changePerson).append(pvRecInfo.getPersonVer().getName()).append(flucIn).append(empTypeConvertHisInfo.getToUnit().getDisplayName()).append("(").append(empTypeConvertHisInfo.getToPosition().getName()).append(")").append("),").append(currentSchmNotDone);
            }
            checkResultInfo.appendWarningMsg(sb.toString());
        }
        this.updateRecState(ctx, checkResultInfo, map);
    }

    private void updateRecState(Context ctx, OrgVerEffectInfo checkResultInfo, HashMap map) throws BOSException {
        if (map.size() == 0) {
            return;
        }
        String updateSql = "update T_HR_PersonVerAdjRec set fEnableStatus = 2 where fid = ? ";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Iterator it = map.entrySet().iterator();
        Map.Entry entry = null;
        PersonVerAdjRecInfo pvRecInfo = null;
        while (it.hasNext()) {
            entry = it.next();
            pvRecInfo = (PersonVerAdjRecInfo)entry.getKey();
            paramList.add(new Object[]{pvRecInfo.getId().toString()});
        }
        DbUtil.executeBatch((Context)ctx, (String)updateSql, paramList);
    }
}

