/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.HRAffairBaseInfo;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.affair.HRAffairPersonPreProcessFacadeFactory;
import com.kingdee.eas.hr.affair.ResignBillEntryCollection;
import com.kingdee.eas.hr.affair.ResignBillEntryInfo;
import com.kingdee.eas.hr.affair.ResignBillFactory;
import com.kingdee.eas.hr.affair.ResignBillInfo;
import com.kingdee.eas.hr.affair.app.AbstractResignBillControllerBean;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.hr.base.batch.BatchProcessedResult;
import com.kingdee.eas.util.ResourceBase;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public class ResignBillControllerBean
extends AbstractResignBillControllerBean {
    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ResignBillInfo info = (ResignBillInfo)model;
        ResignBillEntryCollection c = info.getEntries();
        ResignBillEntryInfo eInfo = null;
        int size = c.size();
        for (int i = 0; i < size; ++i) {
            eInfo = c.get(i);
            if (eInfo.getEffectDate() != null) continue;
            eInfo.setEffectDate(eInfo.getDesireDate());
        }
        return super._addnew(ctx, (IObjectValue)info);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ResignBillInfo info = (ResignBillInfo)model;
        ResignBillEntryCollection c = info.getEntries();
        ResignBillEntryInfo eInfo = null;
        int size = c.size();
        for (int i = 0; i < size; ++i) {
            eInfo = c.get(i);
            if (eInfo.getEffectDate() != null) continue;
            eInfo.setEffectDate(eInfo.getDesireDate());
        }
        super._update(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected void checkBillEntry(Context ctx, HRAffairBaseInfo model) throws BOSException, EASBizException {
        BatchProcessedResult result;
        super.checkBillEntry(ctx, model);
        ArrayList<PersonInfo> persons = new ArrayList<PersonInfo>();
        ResignBillInfo info = (ResignBillInfo)model;
        ResignBillEntryCollection c = info.getEntries();
        ResignBillEntryInfo eInfo = null;
        int size = c.size();
        for (int i = 0; i < size; ++i) {
            eInfo = c.get(i);
            persons.add(eInfo.getPerson());
        }
        String billId = null;
        if (info.getId() != null) {
            billId = info.getId().toString();
        }
        if ((result = HRAffairPersonPreProcessFacadeFactory.getLocalInstance(ctx).preProcessResignPerson(persons, billId)) == null) {
            return;
        }
        if (result.isHasValidInfo()) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Object[])new String[]{result.getInvalidInfo()});
        }
    }

    protected String getPermItemNameDelete() {
        return "ResignBill_Delete";
    }

    protected String getPermItemNameAddnew() {
        return "ResignBill_AddNew";
    }

    protected String getPermItemNameEdit() {
        return "ResignBill_Edit";
    }

    @Override
    protected String getResource(Context ctx) {
        return ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"28_HRAffairBaseControllerBean", (Locale)ctx.getOriginLocale());
    }

    @Override
    protected void checkEffectData(Context ctx, String billID) throws BOSException, EASBizException {
        ResignBillInfo billInfo = ResignBillFactory.getLocalInstance(ctx).getResignBillInfo((IObjectPK)new ObjectUuidPK(billID));
        ResignBillEntryCollection entryCol = billInfo.getEntries();
        Date now = new Date();
        boolean result = false;
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            ResignBillEntryInfo entryInfo = entryCol.get(i);
            if (!now.after(entryInfo.getDesireDate())) continue;
            result = true;
            break;
        }
        if (result) {
            throw new HRAffairException(HRAffairException.CAN_NOT_UNAUDIT);
        }
    }

    @Override
    protected String getEntryIdStr(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        ResignBillInfo billInfo = ResignBillFactory.getLocalInstance(ctx).getResignBillInfo(pk);
        ResignBillEntryCollection billEntryCol = billInfo.getEntries();
        StringBuffer billEntryIdStr = new StringBuffer();
        int size = billEntryCol.size();
        for (int i = 0; i < size; ++i) {
            billEntryIdStr.append("'");
            billEntryIdStr.append(billEntryCol.get(i).getId().toString());
            if (i == size - 1) {
                billEntryIdStr.append("'");
                continue;
            }
            billEntryIdStr.append("',");
        }
        return billEntryIdStr.toString();
    }
}

