/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.hr.affair.AffairUtilFacadeFactory;
import com.kingdee.eas.hr.affair.IAffairUtilFacade;
import com.kingdee.eas.hr.affair.ResignBillEntryInfo;
import com.kingdee.eas.hr.affair.ResignBillInfo;
import com.kingdee.eas.hr.affair.app.AbstractResignBillEditUIHandler;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.base.HROrgContextManagerFacadeFactory;
import com.kingdee.eas.hr.base.IHRInit;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;

public class ResignBillEditUIHandler
extends AbstractResignBillEditUIHandler {
    @Override
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
        this.getPermissionItemByStatus(request, context);
        this.getAdminForHRandUserOrgRange(request, context);
        this.getCurrentClientName(context);
        this.getCodeingRuleData(request, context);
        this.getCtrlUnitInfo(request, context);
        this.getParamValueIgnoreGroupControl(context, "Res001");
    }

    private void getCurrentClientName(Context context) throws BOSException, EASBizException {
        IAffairUtilFacade iAffairUtilFacade = AffairUtilFacadeFactory.getLocalInstance(context);
        iAffairUtilFacade.getCurrentClientName();
    }

    private void getPermissionItemByStatus(RequestContext request, Context context) throws BOSException, EASBizException {
        String actionName = null;
        String status = request.getState();
        if ("ADDNEW".equals(status)) {
            actionName = "ActionAddNew";
        } else if ("EDIT".equals(status)) {
            actionName = "ActionEdit";
        } else if ("VIEW".equals(status)) {
            actionName = "ActionView";
        }
        if (null != actionName && null != request.getMetaDataPK()) {
            HROrgContextManagerFacadeFactory.getLocalInstance((Context)context).getUIPermissiionItem(request.getMetaDataPK(), (IMetaDataPK)new MetaDataPK(actionName));
        }
    }

    @Override
    protected void _handleactionAddPerson(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleactionDelPerson(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleactionAffairReg(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionSave(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionSave(request, response, context);
        this.checkPermission(request, context);
    }

    protected void verifyInput(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.checkIsPersonInProcessForResign(request, context);
        super.verifyInput(request, response, context);
    }

    @Override
    protected void _handleActionSubmit(RequestContext request, ResponseContext response, Context context) throws Exception {
        BOSObjectType billBosType = new ResignBillInfo().getBOSType();
        MetaDataLoaderFactory.getLocalMetaDataLoader((Context)context).getEntity(billBosType);
        this.checkPermission(request, context);
        super._handleActionSubmit(request, response, context);
        this.appLogWriteAndUpdate(request, context);
    }

    protected IObjectPK runSave(RequestContext request, Context context) throws Exception {
        return super.runSave(request, context);
    }

    private void checkIsPersonInProcessForResign(RequestContext request, Context context) throws BOSException, EASBizException {
        PersonInfo pInfo = null;
        ResignBillInfo billInfo = (ResignBillInfo)request.getValue();
        if (null != billInfo.getEntries()) {
            int size = billInfo.getEntries().size();
            for (int i = 0; i < size; ++i) {
                IObjectValue baseInfo;
                pInfo = billInfo.getEntries().get(i).getPerson();
                if (pInfo == null || (baseInfo = this.createNewData()) == null) continue;
                String id = "";
                if (null != request.getId()) {
                    id = request.getId().toString();
                }
                this.checkIsPersonInProcess(request, context, baseInfo.getBOSType(), this.createbillBosType(), pInfo, id);
            }
        }
    }

    @Override
    protected BOSObjectType createbillBosType() {
        return new ResignBillEntryInfo().getBOSType();
    }

    @Override
    protected IObjectValue createNewData() {
        ResignBillInfo info = new ResignBillInfo();
        info.setIsMultiEntry(true);
        info.setApplyDate(DateTimeUtils.truncateDate((Date)new Date()));
        return info;
    }

    private void getCodeingRuleData(RequestContext request, Context context) throws BOSException, EASBizException {
        IHRInit iHRInit = HRInitFactory.getLocalInstance((Context)context);
        ResignBillInfo info = new ResignBillInfo();
        info.setIsMultiEntry(true);
        info.setApplyDate(DateTimeUtils.truncateDate((Date)new Date()));
        iHRInit.getCodingRuleData((IObjectValue)info);
    }
}

