/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.HRAffairBaseInfo;
import com.kingdee.eas.hr.affair.HRAffairException;
import com.kingdee.eas.hr.affair.HRAffairPersonPreProcessFacadeFactory;
import com.kingdee.eas.hr.affair.RetireBillEntryCollection;
import com.kingdee.eas.hr.affair.RetireBillEntryInfo;
import com.kingdee.eas.hr.affair.RetireBillFactory;
import com.kingdee.eas.hr.affair.RetireBillInfo;
import com.kingdee.eas.hr.affair.app.AbstractRetireBillControllerBean;
import com.kingdee.eas.hr.base.HRCommonException;
import com.kingdee.eas.hr.base.batch.BatchProcessedResult;
import com.kingdee.eas.util.ResourceBase;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public class RetireBillControllerBean
extends AbstractRetireBillControllerBean {
    protected String getPermItemNameDelete() {
        return "RetireBill_Delete";
    }

    protected String getPermItemNameAddnew() {
        return "RetireBill_AddNew";
    }

    protected String getPermItemNameEdit() {
        return "RetireBill_Edit";
    }

    @Override
    protected void checkBillEntry(Context ctx, HRAffairBaseInfo model) throws BOSException, EASBizException {
        BatchProcessedResult result;
        super.checkBillEntry(ctx, model);
        ArrayList<PersonInfo> persons = new ArrayList<PersonInfo>();
        RetireBillInfo info = (RetireBillInfo)model;
        RetireBillEntryCollection c = info.getEntries();
        RetireBillEntryInfo eInfo = null;
        int size = c.size();
        for (int i = 0; i < size; ++i) {
            eInfo = c.get(i);
            persons.add(eInfo.getPerson());
        }
        String billId = null;
        if (info.getId() != null) {
            billId = info.getId().toString();
        }
        if ((result = HRAffairPersonPreProcessFacadeFactory.getLocalInstance(ctx).preProcessRetirePerson(persons, billId)) == null) {
            return;
        }
        if (result.isHasValidInfo()) {
            throw new HRCommonException(HRCommonException.EXCEPTION_MSG, (Object[])new String[]{result.getInvalidInfo()});
        }
    }

    @Override
    protected String getResource(Context ctx) {
        return ResourceBase.getString((String)"com.kingdee.eas.hr.affair.AFFAIRAutoGenerateResource", (String)"29_HRAffairBaseControllerBean", (Locale)ctx.getOriginLocale());
    }

    @Override
    protected void checkEffectData(Context ctx, String billID) throws BOSException, EASBizException {
        RetireBillInfo billInfo = RetireBillFactory.getLocalInstance(ctx).getRetireBillInfo((IObjectPK)new ObjectUuidPK(billID));
        RetireBillEntryCollection entryCol = billInfo.getEntries();
        Date now = new Date();
        boolean result = false;
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            RetireBillEntryInfo entryInfo = entryCol.get(i);
            if (!now.after(entryInfo.getRetireDate())) continue;
            result = true;
            break;
        }
        if (result) {
            throw new HRAffairException(HRAffairException.CAN_NOT_UNAUDIT);
        }
    }

    @Override
    protected String getEntryIdStr(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        RetireBillInfo billInfo = RetireBillFactory.getLocalInstance(ctx).getRetireBillInfo(pk);
        RetireBillEntryCollection billEntryCol = billInfo.getEntries();
        StringBuffer billEntryIdStr = new StringBuffer();
        int size = billEntryCol.size();
        for (int i = 0; i < size; ++i) {
            billEntryIdStr.append("'");
            billEntryIdStr.append(billEntryCol.get(i).getId().toString());
            if (i == size - 1) {
                billEntryIdStr.append("'");
                continue;
            }
            billEntryIdStr.append("',");
        }
        return billEntryIdStr.toString();
    }
}

