/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.affair.AffairBizException;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.affair.RetireBizBillEntryCollection;
import com.kingdee.eas.hr.affair.RetireBizBillEntryFactory;
import com.kingdee.eas.hr.affair.RetireBizBillEntryInfo;
import com.kingdee.eas.hr.affair.RetireBizBillFactory;
import com.kingdee.eas.hr.affair.RetireBizBillInfo;
import com.kingdee.eas.hr.affair.app.AbstractRetireBizBillControllerBean;
import com.kingdee.eas.hr.affair.app.RetireBizBillBizBean;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.IHRBillBaseEntry;
import com.kingdee.eas.hr.base.app.HRBillAppUtils;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.base.app.util.AffairUnAuditAppUtils;
import com.kingdee.eas.hr.base.app.util.SHRSameDatePersonChangeUtil;
import com.kingdee.eas.hr.base.util.EmpPosOrgRelationUtil;
import com.kingdee.eas.hr.base.util.SHRMathUtils;
import com.kingdee.eas.hr.emp.PersonOtherInfoFactory;
import com.kingdee.eas.hr.emp.PersonOtherInfoInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.DateTimeUtils;
import java.sql.Date;

public class RetireBizBillControllerBean
extends AbstractRetireBizBillControllerBean {
    protected String getEffectFunction() {
        return "com.kingdee.eas.hr.affair.app.RetireBizBillEffectFunction";
    }

    @Override
    protected IHRBillBaseEntry getEntryInterface(Context ctx) throws BOSException, EASBizException {
        return RetireBizBillEntryFactory.getLocalInstance(ctx);
    }

    @Override
    protected IHRBillBizBean getBizBean() {
        return new RetireBizBillBizBean();
    }

    @Override
    protected void _doWithOtherChangeEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        super._doWithOtherChangeEffect(ctx, entry);
        RetireBizBillEntryInfo affairEntry = (RetireBizBillEntryInfo)entry;
        PersonInfo person = affairEntry.getPerson();
        if (person == null) {
            return;
        }
    }

    @Override
    protected void _doWithSpecialFiledsEffect(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        super._doWithSpecialFiledsEffect(ctx, entry);
        RetireBizBillEntryInfo affairEntry = (RetireBizBillEntryInfo)entry;
        HRBillAppUtils.updateAffairBizHistory((Context)ctx, (String)affairEntry.getOldEmpType().getId().toString(), (String)affairEntry.getId().toString());
        PersonInfo personInfo = affairEntry.getPerson();
        PersonOtherInfoInfo otherInfo = PersonOtherInfoFactory.getLocalInstance((Context)ctx).getPersonOtherInfoInfo("where person.id = '" + personInfo.getId() + "'");
        double workTime = this.calculateSocialServiceYears(ctx, otherInfo, affairEntry);
        otherInfo.setSocialServiceYears(workTime);
        AffairUnAuditAppUtils.updatePersonSinglePagePartial((ICoreBase)PersonOtherInfoFactory.getLocalInstance((Context)ctx), (CoreBaseInfo)otherInfo, (String)"retireDate,socialServiceYears");
    }

    @Override
    public void _unAuditEachEntrySpecialPropertyRecovery(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        RetireBizBillEntryInfo entryInfo = (RetireBizBillEntryInfo)entry;
        PersonInfo personInfo = entryInfo.getPerson();
        PersonOtherInfoInfo personOtherInfo = PersonOtherInfoFactory.getLocalInstance((Context)ctx).getPersonOtherInfoInfo("where person.id = '" + personInfo.getId() + "'");
        personOtherInfo.setRetireDate(null);
        double workTime = this.calculateSocialServiceYears(ctx, personOtherInfo, entryInfo);
        personOtherInfo.setSocialServiceYears(workTime);
        AffairUnAuditAppUtils.updatePersonSinglePagePartial((ICoreBase)PersonOtherInfoFactory.getLocalInstance((Context)ctx), (CoreBaseInfo)personOtherInfo, (String)"retireDate,socialServiceYears");
        if (this.isCreateUserJob(entry)) {
            this.dropJobProcess(ctx, "'" + entry.getId().toString() + "'");
        } else {
            HRBillAppUtils.callBackUser((Context)ctx, (String)entryInfo.getPerson().getId().toString());
        }
    }

    public void setIsSameDatePersonChange(Context ctx, SHRSameDatePersonChangeUtil util, HRBillBaseEntryInfo entry) throws BOSException {
        RetireBizBillEntryInfo billentryInfo = (RetireBizBillEntryInfo)entry;
        boolean isSameDatePersonChange = false;
        if (null != billentryInfo.getPerson() && null != billentryInfo.getBizDate()) {
            isSameDatePersonChange = util.isSameDatePersonChange(ctx, billentryInfo.getPerson().getId().toString(), billentryInfo.getBizDate(), 1);
        }
        billentryInfo.put("isSameDatePersonChange", isSameDatePersonChange);
    }

    protected void setUnauditIsSameDatePersonChange(Context ctx, HRBillBaseEntryInfo entry) throws BOSException {
        HRAffairBizBillEntryInfo billentryInfo = (HRAffairBizBillEntryInfo)entry;
        billentryInfo.put("isSameDatePersonChange", EmpPosOrgRelationUtil.isUnauditSameDatePersonChange((Context)ctx, (HRAffairBizBillEntryInfo)billentryInfo));
    }

    @Override
    protected IObjectPK _forbidUser(Context ctx, BOSUuid entryID) throws BOSException, EASBizException {
        if (entryID != null) {
            HRBillBaseEntryInfo entry = this.getEntryInterface(ctx).getHRBillBaseEntryInfo((IObjectPK)new ObjectUuidPK(entryID));
            HROrgUnitInfo hro = this.getHROrgUnit(ctx, new ObjectUuidPK(entryID));
            if (ContextUtil.getCurrentUserInfo((Context)ctx) == null) {
                UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUser("administrator");
                ContextUtil.setCurrentUserInfo((Context)ctx, (UserInfo)user);
            }
            if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
                ContextUtil.setCurrentHRUnit((Context)ctx, (HROrgUnitInfo)hro);
            }
            this.doForbidUser(ctx, entry);
        }
        return null;
    }

    protected void _entryEffectOthers(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        String oql;
        HRAffairBizBillEntryInfo affairEntry = (HRAffairBizBillEntryInfo)entry;
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        if (!iUser.exists(oql = "where person.id='" + affairEntry.getPerson().getId() + "'")) {
            return;
        }
        if (this.isCreateUserJob(affairEntry)) {
            this.createUserBackGroundJob(ctx, (IObjectValue)entry, "entryID");
        } else {
            this.doForbidUser(ctx, entry);
        }
    }

    private boolean isCreateUserJob(HRAffairBizBillEntryInfo entryInfo) {
        boolean isCreateUserJob = false;
        java.util.Date now = new java.util.Date();
        Date forbidUserDate = entryInfo.getDate("forbidUserDate");
        if (forbidUserDate != null && now.before(forbidUserDate)) {
            isCreateUserJob = true;
        }
        return isCreateUserJob;
    }

    private double calculateSocialServiceYears(Context ctx, PersonOtherInfoInfo otherInfo, RetireBizBillEntryInfo entryInfo) throws EASBizException, BOSException {
        double workTime = 0.0;
        if (otherInfo.getJobStartDate() != null) {
            int dayValue;
            int monthValue;
            int yearValue;
            java.util.Date beginDate = otherInfo.getJobStartDate();
            java.util.Date endDate = otherInfo.getRetireDate();
            double adjustValue = otherInfo.getAdjustSerVal();
            if (endDate == null) {
                endDate = DateTimeUtils.truncateDate((java.util.Date)new java.util.Date());
            }
            if ((workTime = (double)(yearValue = DateTimeUtils.getYear((java.util.Date)endDate) - DateTimeUtils.getYear((java.util.Date)beginDate)) + (double)(monthValue = DateTimeUtils.getMonth((java.util.Date)endDate) - DateTimeUtils.getMonth((java.util.Date)beginDate)) / 12.0 + (double)((float)(dayValue = DateTimeUtils.getDay((java.util.Date)endDate) - DateTimeUtils.getDay((java.util.Date)beginDate)) / 365.0f) - adjustValue) < 0.0) {
                workTime = 0.0;
            }
            workTime = SHRMathUtils.getRoundValueBySysParam((Context)ctx, (double)workTime);
        }
        return workTime;
    }

    protected String getEntryIdStr(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        RetireBizBillInfo BillInfo = RetireBizBillFactory.getLocalInstance(ctx).getRetireBizBillInfo(pk);
        RetireBizBillEntryCollection billEntryCol = BillInfo.getEntrys();
        StringBuffer billEntryIdStr = new StringBuffer();
        int size = billEntryCol.size();
        for (int i = 0; i < size; ++i) {
            billEntryIdStr.append("'");
            billEntryIdStr.append(billEntryCol.get(i).getId().toString());
            if (i == size - 1) {
                billEntryIdStr.append("'");
                continue;
            }
            billEntryIdStr.append("',");
        }
        return billEntryIdStr.toString();
    }

    protected void _entryEffectCommon(Context ctx, BOSUuid entryID) throws BOSException, EASBizException {
        if (entryID == null) {
            throw new AffairBizException(AffairBizException.ENTRY_ID_IS_NULL);
        }
        EmpPosOrgRelationCollection relColl = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection("select id where FlowInAffairID ='" + entryID.toString() + "'");
        if (relColl != null && relColl.size() > 0) {
            return;
        }
        super._entryEffectCommon(ctx, entryID);
    }
}

