/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryCollection;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryFactory;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryInfo;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillInfo;
import com.kingdee.eas.hr.affair.HREmpEnrollBizBillException;
import com.kingdee.eas.hr.affair.app.AbstractVerifyEmpEnrollBizBillFacadeControllerBean;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.util.FileImportHelper;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.base.util.IDCardCommonUtil;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class VerifyEmpEnrollBizBillFacadeControllerBean
extends AbstractVerifyEmpEnrollBizBillFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.affair.app.HRVerifyEmpEnrollBizBillFacadeControllerBean");
    private Boolean isIDCardVerify;

    @Override
    protected void _checkIdCardNoIsDuplicate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EmpEnrollBizBillInfo billInfo = (EmpEnrollBizBillInfo)model;
        String hrOrgUnitId = "";
        hrOrgUnitId = billInfo.getHrOrgUnit() != null ? (billInfo.getHrOrgUnit().getId() == null ? null : billInfo.getHrOrgUnit().getId().toString()) : null;
        this.isIDCardVerify = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_IDCARD_VERIFY", (String)hrOrgUnitId);
        EmpEnrollBizBillEntryCollection entryColl = billInfo.getEntrys();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            EmpEnrollBizBillEntryInfo entryInfo = entryColl.get(i);
            this._checkEntryIdCardNoIsDuplicate(ctx, (IObjectValue)entryInfo);
        }
    }

    @Override
    protected void _checkEntryIdCardNoIsDuplicate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EmpEnrollBizBillEntryInfo entryInfo = (EmpEnrollBizBillEntryInfo)model;
        if (entryInfo != null) {
            String idCardNo = entryInfo.getIDCardNo();
            if (!StringUtils.isEmpty((String)entryInfo.getIDCardNo()) && entryInfo.getIDCardNo().length() == 15) {
                String newIdCardNo = "";
                IDCardCommonUtil iDCardCommonUtil = null;
                try {
                    iDCardCommonUtil = new IDCardCommonUtil(idCardNo, this.isIDCardVerify.booleanValue());
                    newIdCardNo = IDCardCommonUtil.IDCardNO15To18((String)idCardNo);
                    StringBuffer sql = new StringBuffer();
                    sql.append(" select fid from t_bd_person where fidcardno='").append(newIdCardNo).append("'");
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    if (rs.size() != 0) {
                        throw new HREmpEnrollBizBillException(HREmpEnrollBizBillException.ERROR_IDCARDNOISDUPLICATE);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    throw new BOSException(e.getMessage());
                }
            }
        }
    }

    @Override
    protected void _checkEmpNumberExist(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PersonInfo person = new PersonInfo();
        String mainOrgID = this.getMainOrgByCu(ctx);
        boolean hasCodingRule = this.hasCodingRule(ctx, (IObjectValue)person, mainOrgID);
        if (hasCodingRule) {
            return;
        }
        EmpEnrollBizBillInfo billInfo = (EmpEnrollBizBillInfo)model;
        try {
            if (billInfo != null) {
                EmpEnrollBizBillEntryCollection entryColl = billInfo.getEntrys();
                int size = entryColl.size();
                for (int i = 0; i < size; ++i) {
                    EmpEnrollBizBillEntryInfo entryInfo = entryColl.get(i);
                    if (entryInfo.getBill() == null) {
                        entryInfo.setBill(billInfo);
                    }
                    this._checkEntryEmpNumberExist(ctx, (IObjectValue)entryInfo);
                }
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _checkEntryEmpNumberExist(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EmpEnrollBizBillEntryInfo entryInfo = (EmpEnrollBizBillEntryInfo)model;
        if (entryInfo != null) {
            this._checkEmpNumberExistEntry(ctx, (IObjectValue)entryInfo);
            this._checkEmpNumberIsOccupy(ctx, (IObjectValue)entryInfo);
        }
    }

    @Override
    protected void _checkEmpNumberExistEntry(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EmpEnrollBizBillEntryInfo entryInfo = (EmpEnrollBizBillEntryInfo)model;
        if (entryInfo == null) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        FilterInfo filter = new FilterInfo();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("empNumber"));
        filter.getFilterItems().add(new FilterItemInfo("empNumber", (Object)entryInfo.getEmpNumber()));
        filter.getFilterItems().add(new FilterItemInfo("bizDate", (Object)entryInfo.getBizDate(), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bill.billState", (Object)4, CompareType.NOTEQUALS));
        if (entryInfo.getBill() != null && entryInfo.getBill().getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("bill.id", (Object)entryInfo.getBill().getId().toString(), CompareType.NOTEQUALS));
        }
        viewInfo.setSelector(sic);
        viewInfo.setFilter(filter);
        EmpEnrollBizBillEntryCollection col = EmpEnrollBizBillEntryFactory.getLocalInstance(ctx).getEmpEnrollBizBillEntryCollection(viewInfo);
        if (col.size() > 0) {
            throw new HREmpEnrollBizBillException(HREmpEnrollBizBillException.ERROR_EMPNUMBEREXISTENTRY);
        }
    }

    @Override
    protected void _checkEmpNumberIsOccupy(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EmpEnrollBizBillEntryInfo entryInfo = (EmpEnrollBizBillEntryInfo)model;
        boolean isCheckEnrollAgain = true;
        boolean isEnrollAgain = false;
        if (entryInfo.get("enrollagain") != null && entryInfo.getBoolean("enrollagain")) {
            isEnrollAgain = true;
            if (entryInfo.get("useoldnumber") != null && entryInfo.getBoolean("useoldnumber")) {
                isCheckEnrollAgain = false;
            }
        }
        if (entryInfo != null && !entryInfo.getHrBizDefine().isIsQuickAddNew() && isCheckEnrollAgain) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            FilterInfo filter = new FilterInfo();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)entryInfo.getEmpNumber()));
            if (isEnrollAgain) {
                FileImportHelper fiHelp = new FileImportHelper();
                EmpPosOrgRelationInfo empInfo = fiHelp.getPersonEmpPosOrgRelation(ctx, entryInfo.getPassportNo(), entryInfo.getIDCardNo());
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)empInfo.getPerson().getId().toString(), CompareType.NOTEQUALS));
            }
            viewInfo.setSelector(sic);
            viewInfo.setFilter(filter);
            PersonCollection col = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(viewInfo);
            if (col.size() > 0) {
                throw new HREmpEnrollBizBillException(HREmpEnrollBizBillException.ERROR_EMPNUMBERISOCCUPY);
            }
        }
    }

    private String getMainOrgByCu(Context ctx) {
        String orgId;
        OrgUnitInfo mainOrg = (OrgUnitInfo)ctx.get((Object)OrgType.ControlUnit);
        String string = orgId = mainOrg == null ? "" : mainOrg.getString("id");
        if (orgId == null || orgId.trim().length() == 0) {
            orgId = "00000000-0000-0000-0000-000000000000CCE7AED4";
        }
        return orgId;
    }

    private boolean hasCodingRule(Context ctx, IObjectValue model, String orgId) {
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (orgId != null && orgId.trim().length() > 0 && iCodingRuleManager.isExist(model, orgId)) {
                return true;
            }
            String companyId = this.getNextCompanyId(ctx);
            return companyId != null && companyId.trim().length() > 0 && iCodingRuleManager.isExist(model, companyId);
        }
        catch (Exception err) {
            err.printStackTrace();
            return false;
        }
    }

    private String getNextCompanyId(Context ctx) throws Exception {
        ObjectUuidPK pk;
        ICtrlUnit iCtrlUnit = CtrlUnitFactory.getLocalInstance((Context)ctx);
        CtrlUnitInfo rootCU = iCtrlUnit.getCtrlUnitInfo((IObjectPK)(pk = new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4")));
        if (rootCU != null) {
            return rootCU.getId().toString();
        }
        return null;
    }

    @Override
    protected void _checkPersonMobileDuplicate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EmpEnrollBizBillInfo billInfo = (EmpEnrollBizBillInfo)model;
        if (billInfo != null) {
            EmpEnrollBizBillEntryCollection entryColl = billInfo.getEntrys();
            int size = entryColl.size();
            for (int i = 0; i < size; ++i) {
                EmpEnrollBizBillEntryInfo entryInfo = entryColl.get(i);
                this._checkEntryPersonMobileDuplicate(ctx, (IObjectValue)entryInfo);
            }
        }
    }

    @Override
    protected void _checkEntryPersonMobileDuplicate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EmpEnrollBizBillEntryInfo entryInfo = (EmpEnrollBizBillEntryInfo)model;
        if (entryInfo != null) {
            String telNum = entryInfo.getTelNum();
            HRUtilExtend.verifyCellPhoneNumber((Context)ctx, (String)telNum);
            if (!StringUtils.isEmpty((String)telNum)) {
                this.judgePersonInfo(ctx, telNum, entryInfo);
                this.judgeBizBillInfo(ctx, telNum, entryInfo);
            }
        }
    }

    private void judgePersonInfo(Context ctx, String telNum, EmpEnrollBizBillEntryInfo entryInfo) throws BOSException, EmployeeException {
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuffer oql = new StringBuffer();
        oql.append("select person.fname_" + l + " as name from t_bd_person person");
        oql.append(" left join  T_HR_PersonContactMethod pcm on pcm.fpersonid = person.fid");
        oql.append(" where pcm.fmobile ='");
        oql.append(telNum).append("'");
        if (entryInfo.get("enrollagain") != null && entryInfo.getBoolean("enrollagain")) {
            FileImportHelper fiHelp = new FileImportHelper();
            EmpPosOrgRelationInfo empInfo = fiHelp.getPersonEmpPosOrgRelation(ctx, entryInfo.getPassportNo(), entryInfo.getIDCardNo());
            oql.append(" and person.fid <> '").append(empInfo.getPerson().getId().toString()).append("'");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        String expNameIfno = "";
        boolean j = false;
        try {
            while (rs.next()) {
                String personName = rs.getString("name");
                if (!j) {
                    expNameIfno = personName;
                    continue;
                }
                expNameIfno = expNameIfno + "," + personName;
            }
            if (!StringUtils.isEmpty((String)expNameIfno)) {
                Object[] params = new String[]{expNameIfno};
                throw new EmployeeException(EmployeeException.PERSON_MOBILE_ISDUPLICATE, params);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void judgeBizBillInfo(Context ctx, String telNum, EmpEnrollBizBillEntryInfo entryInfo) throws BOSException, EmployeeException {
        StringBuffer oql = new StringBuffer();
        oql.append(" select bill.Fnumber as billnumber from T_HR_EmpEnrollBizBillEntry entry ");
        oql.append(" left join T_HR_EmpEnrollBizBill bill on entry.fbillid=bill.fid ");
        oql.append(" where bill.fbillstate in (1,2) and entry.ftelnum='");
        oql.append(telNum).append("'");
        if (entryInfo.getId() != null) {
            oql.append(" and entry.fid<>'").append(entryInfo.getId().toString()).append("'");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        String expNameIfno = "";
        boolean j = false;
        try {
            while (rs.next()) {
                String billNumber = rs.getString("billnumber");
                if (!j) {
                    expNameIfno = billNumber;
                    continue;
                }
                expNameIfno = expNameIfno + "," + billNumber;
            }
            if (!StringUtils.isEmpty((String)expNameIfno)) {
                Object[] params = new String[]{expNameIfno};
                throw new EmployeeException(EmployeeException.PERSON_MOBILE_ISDUPLICATE_INPROC, params);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void judgePersonEmailInfo(Context ctx, String email, EmpEnrollBizBillEntryInfo entryInfo) throws BOSException, EmployeeException {
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuffer oql = new StringBuffer();
        oql.append("select person.fname_" + l + " as name from t_bd_person person");
        oql.append(" left join  T_HR_PersonContactMethod pcm on pcm.fpersonid = person.fid");
        oql.append(" where pcm.femail ='");
        oql.append(email).append("'");
        if (entryInfo.get("enrollagain") != null && entryInfo.getBoolean("enrollagain")) {
            FileImportHelper fiHelp = new FileImportHelper();
            EmpPosOrgRelationInfo empInfo = fiHelp.getPersonEmpPosOrgRelation(ctx, entryInfo.getPassportNo(), entryInfo.getIDCardNo());
            oql.append(" and person.fid <> '").append(empInfo.getPerson().getId().toString()).append("'");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        String expNameIfno = "";
        int j = 0;
        try {
            while (rs.next()) {
                String personName = rs.getString("name");
                if (j == 0) {
                    expNameIfno = personName;
                    ++j;
                    continue;
                }
                expNameIfno = expNameIfno + "," + personName;
            }
            if (!StringUtils.isEmpty((String)expNameIfno)) {
                Object[] params = new String[]{expNameIfno};
                throw new EmployeeException(EmployeeException.PERSON_EMAIL_ISDUPLICATE, params);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void judgeBizBillEmailInfo(Context ctx, String email, EmpEnrollBizBillEntryInfo entryInfo) throws BOSException, EmployeeException {
        StringBuffer oql = new StringBuffer();
        oql.append(" select bill.fnumber as billnumber from T_HR_EmpEnrollBizBillEntry entry ");
        oql.append(" left join T_HR_EmpEnrollBizBill bill on entry.fbillid=bill.fid ");
        oql.append(" where bill.fbillstate in (1,2) and entry.femail='");
        oql.append(email).append("'");
        if (entryInfo.getId() != null) {
            oql.append(" and entry.fid<>'").append(entryInfo.getId().toString()).append("'");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)oql.toString());
        String expNameIfno = "";
        int j = 0;
        try {
            while (rs.next()) {
                String billNumber = rs.getString("billnumber");
                if (j == 0) {
                    expNameIfno = billNumber;
                    ++j;
                    continue;
                }
                expNameIfno = expNameIfno + "," + billNumber;
            }
            if (!StringUtils.isEmpty((String)expNameIfno)) {
                Object[] params = new String[]{expNameIfno};
                throw new EmployeeException(EmployeeException.PERSON_EMAIL_ISDUPLICATE_INPROC, params);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _checkEntryIsDuplicate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EmpEnrollBizBillInfo billInfo = (EmpEnrollBizBillInfo)model;
        if (billInfo != null) {
            HashMap<String, String> numberMap = new HashMap<String, String>();
            HashMap<String, String> telNumMap = new HashMap<String, String>();
            HashMap<String, String> idCardNoMap = new HashMap<String, String>();
            HashMap<String, String> passportNoMap = new HashMap<String, String>();
            HashMap<String, String> emailMap = new HashMap<String, String>();
            HashMap<String, String> accountNumMap = new HashMap<String, String>();
            EmpEnrollBizBillEntryCollection entryColl = billInfo.getEntrys();
            int size = entryColl.size();
            for (int i = 0; i < size; ++i) {
                String accountNum;
                String passportNo;
                String idCardNo;
                String email;
                String telNum;
                EmpEnrollBizBillEntryInfo entryInfo = entryColl.get(i);
                HRUtilExtend.assableCell((CoreBaseInfo)entryInfo, (String)"telNum");
                String empName = entryInfo.getEmpName();
                String empNumber = entryInfo.getEmpNumber();
                if (!StringUtils.isEmpty((String)empNumber)) {
                    if (numberMap.containsKey(empNumber)) {
                        Object[] params = new String[]{empName, (String)numberMap.get(empNumber)};
                        throw new HREmpEnrollBizBillException(HREmpEnrollBizBillException.ERROR_ENTRYEMPNUMBERDUPLICATE, params);
                    }
                    numberMap.put(empNumber, empName);
                }
                if (!StringUtils.isEmpty((String)(telNum = entryInfo.getTelNum()))) {
                    if (telNumMap.containsKey(telNum)) {
                        Object[] params = new String[]{empName, (String)telNumMap.get(telNum)};
                        throw new HREmpEnrollBizBillException(HREmpEnrollBizBillException.ERROR_ENTRYMOBILEDUPLICATE, params);
                    }
                    telNumMap.put(telNum, empName);
                }
                if (!StringUtils.isEmpty((String)(email = entryInfo.getEmail()))) {
                    if (emailMap.containsKey(email)) {
                        Object[] params = new String[]{empName, (String)emailMap.get(email)};
                        throw new HREmpEnrollBizBillException(HREmpEnrollBizBillException.ERROR_ENTRYEAMILDUPLICATE, params);
                    }
                    emailMap.put(email, empName);
                }
                if (!StringUtils.isEmpty((String)(idCardNo = entryInfo.getIDCardNo()))) {
                    if (idCardNoMap.containsKey(idCardNo)) {
                        Object[] params = new String[]{empName, (String)idCardNoMap.get(idCardNo)};
                        throw new HREmpEnrollBizBillException(HREmpEnrollBizBillException.ERROR_ENTRYIDCARDNODUPLICATE, params);
                    }
                    idCardNoMap.put(idCardNo, empName);
                }
                if (!StringUtils.isEmpty((String)(passportNo = entryInfo.getPassportNo()))) {
                    if (passportNoMap.containsKey(passportNo)) {
                        Object[] params = new String[]{empName, (String)passportNoMap.get(passportNo)};
                        throw new HREmpEnrollBizBillException(HREmpEnrollBizBillException.ERROR_ENTRYPASSPORTNODUPLICATE, params);
                    }
                    passportNoMap.put(passportNo, empName);
                }
                if (StringUtils.isEmpty((String)(accountNum = entryInfo.getAccountNum()))) continue;
                if (accountNumMap.containsKey(accountNum)) {
                    Object[] params = new String[]{empName, (String)accountNumMap.get(accountNum)};
                    throw new HREmpEnrollBizBillException(HREmpEnrollBizBillException.ERROR_ENTRYACCOUNTNUMDUPLICATE, params);
                }
                accountNumMap.put(accountNum, empName);
            }
        }
    }

    @Override
    protected void _checkEntryPersonIsExist(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EmpEnrollBizBillEntryInfo entryInfo = (EmpEnrollBizBillEntryInfo)model;
        if (entryInfo != null) {
            PersonCollection personColl;
            PersonInfo personInfo;
            String idCardNo = entryInfo.getIDCardNo();
            String passPortNo = entryInfo.getPassportNo();
            StringBuffer oql = new StringBuffer("select employeeType.*,name where employeeType.isInCount = 1");
            if (StringUtils.isEmpty((String)idCardNo) && StringUtils.isEmpty((String)passPortNo)) {
                return;
            }
            if (!StringUtils.isEmpty((String)idCardNo)) {
                oql.append(" and idCardNO = '").append(idCardNo).append("'");
            }
            if (!StringUtils.isEmpty((String)passPortNo)) {
                oql.append(" and passportNO = '").append(passPortNo).append("'");
            }
            PersonInfo personInfo2 = personInfo = (personColl = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(oql.toString())).size() > 0 ? personColl.get(0) : null;
            if (personInfo != null) {
                String personName = personInfo.getName();
                Object[] params = new String[]{personName};
                throw new HREmpEnrollBizBillException(HREmpEnrollBizBillException.ERROR_ENTRYEMPISEXIST, params);
            }
        }
    }

    @Override
    protected void _checkPersonEmailDuplicate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EmpEnrollBizBillInfo billInfo = (EmpEnrollBizBillInfo)model;
        if (billInfo != null) {
            EmpEnrollBizBillEntryCollection entryColl = billInfo.getEntrys();
            int size = entryColl.size();
            for (int i = 0; i < size; ++i) {
                EmpEnrollBizBillEntryInfo entryInfo = entryColl.get(i);
                this._checkEntryPersonEmailDuplicate(ctx, (IObjectValue)entryInfo);
            }
        }
    }

    @Override
    protected void _checkEntryPersonEmailDuplicate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EmpEnrollBizBillEntryInfo entryInfo = (EmpEnrollBizBillEntryInfo)model;
        if (entryInfo != null) {
            String email = entryInfo.getEmail();
            HRUtilExtend.verifyMail((Context)ctx, (String)email);
            if (!StringUtils.isEmpty((String)email)) {
                this.judgePersonEmailInfo(ctx, email, entryInfo);
                this.judgeBizBillEmailInfo(ctx, email, entryInfo);
            }
        }
    }
}

