/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base;

import com.kingdee.util.StringUtils;
import java.io.Serializable;

public class ExpressionValue
implements Serializable {
    private static final long serialVersionUID = -2974782274576118800L;
    public static final int STRING = 0;
    public static final int DATE = 1;
    public static final int NUMBER = 2;
    public static final String REF_SIGNAL = "$";
    public static final String STR_SIGNAL = "'";
    public static final String DT_SIGNAL = "#";
    private String value = null;
    private String lastValue = null;
    private boolean isEntityRef = false;
    private int valueType = 0;

    public ExpressionValue() {
    }

    public ExpressionValue(String lastValue) {
        this.lastValue = lastValue;
        this.parseLastValue();
    }

    public boolean isEntityRef() {
        return this.isEntityRef;
    }

    public void setEntityRef(boolean isEntityRef) {
        this.isEntityRef = isEntityRef;
    }

    public boolean haveLevel() {
        if (this.isEntityRef && this.value != null) {
            return this.value.indexOf(".") > 0;
        }
        return false;
    }

    public String getFirstLevel() {
        if (this.isEntityRef && this.value != null) {
            return this.value.substring(0, this.value.indexOf("."));
        }
        return null;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int getValueType() {
        if (this.isEntityRef) {
            return -1;
        }
        return this.valueType;
    }

    public void setValueType(int valueType) {
        this.valueType = valueType;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        if (this.lastValue == null) {
            this.getLastValue();
        }
        return this.lastValue;
    }

    public String getLastValue() {
        this.lastValue = this.value;
        if (this.isEntityRef) {
            if (!StringUtils.isEmpty((String)this.value)) {
                this.lastValue = REF_SIGNAL + this.value + REF_SIGNAL;
            }
        } else {
            if (0 == this.valueType && this.value != null) {
                this.lastValue = STR_SIGNAL + this.value + STR_SIGNAL;
            }
            if (1 == this.valueType && this.value != null) {
                this.lastValue = DT_SIGNAL + this.value + DT_SIGNAL;
            }
        }
        return this.lastValue;
    }

    public void setLastValue(String lastValue) {
        this.lastValue = lastValue;
    }

    public void parseLastValue() {
        if (this.lastValue != null) {
            int len;
            this.value = this.lastValue;
            this.isEntityRef = false;
            this.valueType = 2;
            if (this.lastValue.startsWith(REF_SIGNAL) && this.lastValue.endsWith(REF_SIGNAL)) {
                len = REF_SIGNAL.length();
                this.value = this.lastValue.substring(len, this.lastValue.length() - len);
                this.isEntityRef = true;
            }
            if (this.lastValue.startsWith(STR_SIGNAL) && this.lastValue.endsWith(STR_SIGNAL)) {
                len = STR_SIGNAL.length();
                this.value = this.lastValue.substring(len, this.lastValue.length() - len);
                this.isEntityRef = false;
                this.valueType = 0;
            }
            if (this.lastValue.startsWith(DT_SIGNAL) && this.lastValue.endsWith(DT_SIGNAL)) {
                len = DT_SIGNAL.length();
                this.value = this.lastValue.substring(len, this.lastValue.length() - len);
                this.isEntityRef = false;
                this.valueType = 1;
            }
        } else {
            this.value = this.lastValue;
        }
    }

    public int hashCode() {
        return 42;
    }
}

