/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.EmpDynEmpTypeCollection;
import com.kingdee.eas.hr.base.EmpDynamicCollectionFacadeFactory;
import com.kingdee.eas.hr.base.EmpDynamicFilterInfo;
import com.kingdee.eas.hr.base.EmpDynamicShowSetCollection;
import com.kingdee.eas.hr.base.EmpDynamicShowSetFactory;
import com.kingdee.eas.hr.base.EmpDynamicShowSetInfo;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class HRBaseDataUtils {
    public static final String EMPTYPEID_FORMAL = "00000000-0000-0000-0000-000000000001A29E85B3";
    public static final String EMPTYPEID_TRYOUT = "00000000-0000-0000-0000-000000000002A29E85B3";
    public static final String EMPTYPEID_PRACTICE = "00000000-0000-0000-0000-000000000003A29E85B3";
    public static final String EMPTYPEID_CONTRACT = "00000000-0000-0000-0000-000000000004A29E85B3";
    public static final String EMPTYPEID_CASUAL = "00000000-0000-0000-0000-000000000005A29E85B3";
    public static final String EMPTYPEID_FIRE = "00000000-0000-0000-0000-000000000006A29E85B3";
    public static final String EMPTYPEID_RESIGN = "00000000-0000-0000-0000-000000000007A29E85B3";
    public static final String EMPTYPEID_RETIRE = "00000000-0000-0000-0000-000000000008A29E85B3";
    public static final String EMPTYPEID_RETIRE2 = "00000000-0000-0000-0000-000000000014A29E85B3";
    public static final String EMPTYPEID_RETIRE3 = "00000000-0000-0000-0000-000000000012A29E85B3";
    public static final String EMPTYPEID_RETIRE4 = "00000000-0000-0000-0000-000000000011A29E85B";
    public static final String EMPTYPEID_RETIRE5 = "00000000-0000-0000-0000-000000000013A29E85B3";
    public static final String EMPTYPEID_RETIRE6 = "00000000-0000-0000-0000-000000000009A29E85B3";
    public static final String EMPTYPEID_RETIRE7 = "00000000-0000-0000-0000-000000000010A29E85B3";
    public static final String EMPTYPEID_RERETAIN = "00000000-0000-0000-0000-000000000015A29E85B3";
    public static final String strResource = "com.kingdee.eas.hr.base.HRBasedataResource.";
    public static final String RES = "com.kingdee.eas.hr.base.HRBasedataResource";

    public static String getParamValueByNumber(String number, Context ctx) throws Exception {
        String HRO_ID;
        IParamControl iParam;
        String empTypeStr = null;
        if (ctx == null) {
            iParam = ParamControlFactory.getRemoteInstance();
            HRO_ID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        } else {
            iParam = ParamControlFactory.getLocalInstance((Context)ctx);
            HRO_ID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        }
        empTypeStr = iParam.getParamValue((IObjectPK)new ObjectUuidPK(HRO_ID), number);
        return empTypeStr;
    }

    public static void MergeFilter(FilterInfo filterInfo, Context ctx) {
        String empTypeStr = null;
        try {
            empTypeStr = HRBaseDataUtils.getEmpTypeStr(ctx);
            FilterInfo retFilter = null;
            if (!StringUtils.isEmpty((String)empTypeStr)) {
                for (String empType : empTypeStr.split(",")) {
                    FilterInfo filterTmp = new FilterInfo();
                    filterTmp.getFilterItems().add(new FilterItemInfo("employeeType.number", (Object)empType));
                    if (retFilter != null) {
                        retFilter.mergeFilter(filterTmp, "or");
                        continue;
                    }
                    retFilter = filterTmp;
                }
            } else {
                retFilter = new FilterInfo();
                retFilter.getFilterItems().add(new FilterItemInfo("employeeType.id", (Object)EMPTYPEID_TRYOUT));
                FilterInfo filterTmp = new FilterInfo();
                filterTmp.getFilterItems().add(new FilterItemInfo("employeeType.id", (Object)EMPTYPEID_FORMAL));
                retFilter.mergeFilter(filterTmp, "or");
            }
            filterInfo.mergeFilter(retFilter, "AND");
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static String getEmpTypeStr(Context ctx) throws BOSException {
        StringBuffer sb = new StringBuffer();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isEnable", (Object)1));
        evi.setFilter(filterInfo);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("empType.employeeType.id"));
        evi.getSelector().add(new SelectorItemInfo("empType.employeeType.name"));
        evi.getSelector().add(new SelectorItemInfo("empType.employeeType.number"));
        EmpDynamicShowSetCollection empShowSetCol = ctx == null ? EmpDynamicShowSetFactory.getRemoteInstance().getEmpDynamicShowSetCollection(evi) : EmpDynamicShowSetFactory.getLocalInstance(ctx).getEmpDynamicShowSetCollection(evi);
        if (empShowSetCol.size() > 0) {
            EmpDynamicShowSetInfo info = empShowSetCol.get(0);
            EmpDynEmpTypeCollection typeCol = info.getEmpType();
            if (typeCol.size() < 1) {
                return "001,002";
            }
            int j = typeCol.size();
            for (int i = 0; i < j; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(typeCol.get(i).getEmployeeType().getNumber());
            }
        } else {
            return "001,002";
        }
        return sb.toString();
    }

    public static void MergCommFilter(FilterInfo commonFilterInfo, FilterInfo filterInfo, Date startTime, Date endTime) {
        String empComPersonIDSQL = null;
        EmpDynamicFilterInfo empDynamicFilterInfo = new EmpDynamicFilterInfo();
        empDynamicFilterInfo.setStartTime(startTime);
        empDynamicFilterInfo.setEndTime(endTime);
        empDynamicFilterInfo.setTimePoint(false);
        empDynamicFilterInfo.setCommonFilterInfo(commonFilterInfo);
        try {
            empComPersonIDSQL = EmpDynamicCollectionFacadeFactory.getRemoteInstance().getEmpComPersonIDSQL(empDynamicFilterInfo);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (!StringUtils.isEmpty((String)empComPersonIDSQL)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)empComPersonIDSQL, CompareType.INNER));
        }
    }

    public static void MergCommFilter(FilterInfo commonFilterInfo, FilterInfo filterInfo, Context ctx) {
        String empComPersonIDSQL = null;
        EmpDynamicFilterInfo empDynamicFilterInfo = new EmpDynamicFilterInfo();
        empDynamicFilterInfo.setTimePoint(false);
        empDynamicFilterInfo.setCommonFilterInfo(commonFilterInfo);
        try {
            empComPersonIDSQL = EmpDynamicCollectionFacadeFactory.getLocalInstance(ctx).getEmpComPersonIDSQL(empDynamicFilterInfo);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (!StringUtils.isEmpty((String)empComPersonIDSQL)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)empComPersonIDSQL, CompareType.INNER));
        }
    }

    public static void MergCommFilterTimePoint(FilterInfo commonFilterInfo, FilterInfo filterInfo, Date startTime) {
        String empComPersonIDSQL = null;
        EmpDynamicFilterInfo empDynamicFilterInfo = new EmpDynamicFilterInfo();
        empDynamicFilterInfo.setStartTime(startTime);
        empDynamicFilterInfo.setTimePoint(true);
        empDynamicFilterInfo.setCommonFilterInfo(commonFilterInfo);
        try {
            empComPersonIDSQL = EmpDynamicCollectionFacadeFactory.getRemoteInstance().getEmpComPersonIDSQL(empDynamicFilterInfo);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (!StringUtils.isEmpty((String)empComPersonIDSQL)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)empComPersonIDSQL, CompareType.INNER));
        }
    }

    public static void MergCommFilterTimePoint(FilterInfo commonFilterInfo, FilterInfo filterInfo, Date startTime, Context ctx) {
        String empComPersonIDSQL = null;
        EmpDynamicFilterInfo empDynamicFilterInfo = new EmpDynamicFilterInfo();
        empDynamicFilterInfo.setStartTime(startTime);
        empDynamicFilterInfo.setTimePoint(true);
        empDynamicFilterInfo.setCommonFilterInfo(commonFilterInfo);
        try {
            empComPersonIDSQL = EmpDynamicCollectionFacadeFactory.getLocalInstance(ctx).getEmpComPersonIDSQL(empDynamicFilterInfo);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (!StringUtils.isEmpty((String)empComPersonIDSQL)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)empComPersonIDSQL, CompareType.INNER));
        }
    }

    public static Map getTimePointHeadMap(Context ctx) {
        HashMap<Integer, String> timePointMap = new HashMap<Integer, String>();
        timePointMap.put(0, SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label33", (Context)ctx));
        timePointMap.put(1, SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label35", (Context)ctx));
        timePointMap.put(2, SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label37", (Context)ctx));
        timePointMap.put(3, SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label39", (Context)ctx));
        timePointMap.put(4, SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label28", (Context)ctx));
        timePointMap.put(5, SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label30", (Context)ctx));
        timePointMap.put(6, SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label32", (Context)ctx));
        timePointMap.put(7, SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label34", (Context)ctx));
        timePointMap.put(8, SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label36", (Context)ctx));
        timePointMap.put(9, SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label38", (Context)ctx));
        timePointMap.put(10, SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label40", (Context)ctx));
        timePointMap.put(11, SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label26", (Context)ctx));
        timePointMap.put(12, SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label27", (Context)ctx));
        timePointMap.put(13, SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label25", (Context)ctx));
        return timePointMap;
    }

    public static Map getTimePointTableMap() {
        HashMap<Integer, String> timePointMap = new HashMap<Integer, String>();
        timePointMap.put(0, "hrBizDefine.name");
        timePointMap.put(1, "person.name");
        timePointMap.put(2, "person.number");
        timePointMap.put(3, "person.gender");
        timePointMap.put(4, "adminOrg.name");
        timePointMap.put(5, "position.name");
        timePointMap.put(6, "personPosition.enterDate");
        timePointMap.put(7, "personPosition.jobStartDate");
        timePointMap.put(8, "person.birthday");
        timePointMap.put(9, "wed.name");
        timePointMap.put(10, "person.idCardNO");
        timePointMap.put(11, "diploma.name");
        timePointMap.put(12, "personContactMethod.workplace");
        timePointMap.put(13, "person.isStandbyCadre");
        return timePointMap;
    }

    public static void verifyEmpty(CoreUIObject ui, KDTextField txtNumber) {
        HRBaseDataUtils.verifyEmpty(ui, null, txtNumber, null);
    }

    public static void verifyEmpty(CoreUIObject ui, KDBizPromptBox bizBox) {
        HRBaseDataUtils.verifyEmpty(ui, null, bizBox, null);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDTextField txtNumber, String msg) {
        if (!txtNumber.isEnabled()) {
            return;
        }
        String txt = txtNumber.getText();
        if (txt == null || txt.trim().equals("")) {
            txtNumber.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath == null || msg == null ? HRBaseDataUtils.getMessage((Component)txtNumber) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDBizPromptBox bizBox, String msg) {
        Object content = bizBox.getData();
        if (content == null) {
            bizBox.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath == null || msg == null ? HRBaseDataUtils.getMessage((Component)bizBox) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static String getMessage(Component component) {
        String text = HRBaseDataUtils.getBoundLabelText(component);
        text = text.replaceFirst(":", "").trim();
        return text + EASResource.getString((String)RES, (String)"CanNotBeNull");
    }

    private static String getBoundLabelText(Component component) {
        String text = "";
        if (component.getParent() instanceof KDLabelContainer) {
            text = ((KDLabelContainer)component.getParent()).getBoundLabelText();
        }
        return text;
    }

    public static void verifyInput(CoreUIObject ui, KDTable kdtEntries, String key) {
        IRow row = null;
        for (int j = 0; j < kdtEntries.getRowCount(); ++j) {
            row = kdtEntries.getRow(j);
            HRBaseDataUtils.verifyInput(ui, kdtEntries, row, key);
        }
    }

    public static void verifyInput(CoreUIObject ui, KDTable kdtEntries, IRow row, String key) {
        int colIndex = kdtEntries.getColumnIndex(key);
        if (HRBaseDataUtils.isEmpty(row.getCell(key).getValue())) {
            kdtEntries.getEditManager().editCellAt(row.getRowIndex(), colIndex);
            String headValue = (String)kdtEntries.getHeadRow(0).getCell(key).getValue();
            String msg = headValue + " " + EASResource.getString((String)RES, (String)"CanNotBeNull");
            msg = msg.replaceAll("#", " " + headValue + " ");
            MsgBox.showInfo((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public static boolean isEmpty(Object o) {
        return o == null || o.toString().trim().length() == 0;
    }

    public static void verifyRepeatRow(CoreUIObject ui, KDTable table, String columnName, String displayName) {
        if (TrainUtils.isRepeatRowInTable((KDTable)table, (String)columnName)) {
            MessageFormat format = new MessageFormat(EASResource.getString((String)RES, (String)"CannotRepeated"));
            if (displayName == null) {
                displayName = table.getHeadRow(0).getCell(columnName).getValue().toString();
            }
            String msg = format.format(new Object[]{displayName});
            MsgBox.showWarning((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }
}

