/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.BillExtendConfig;
import com.kingdee.eas.hr.base.BillExtendMapping;
import com.kingdee.eas.hr.base.IBillExtendEntry;
import com.kingdee.eas.hr.base.app.IBillExtendBean;
import com.kingdee.eas.hr.base.util.EntityReflectUtil;
import com.kingdee.util.StringUtils;

public class BillExtendBeanFactory {
    private BillExtendBeanFactory() {
    }

    public static IBillExtendBean getInstance(BillExtendConfig config) {
        IBillExtendBean beanInstance = (IBillExtendBean)config.getBeanInstance();
        String bean = config.getBean();
        if (beanInstance == null && !StringUtils.isEmpty((String)bean)) {
            try {
                beanInstance = (IBillExtendBean)Class.forName(bean).newInstance();
                beanInstance.setExtendConfig(config);
                config.setBeanInstance(beanInstance);
            }
            catch (Exception e) {
                beanInstance = null;
            }
        }
        return beanInstance;
    }

    public static IBillExtendEntry getLocalInstance(Context ctx, BillExtendConfig config) throws BOSException, EASBizException {
        IBillExtendEntry extendBase = config.getExtendBase();
        String entity = config.getEntity();
        if (extendBase == null && !StringUtils.isEmpty((String)entity)) {
            String factory = EntityReflectUtil.getFactoryByEntity(entity);
            extendBase = (IBillExtendEntry)EntityReflectUtil.getLocalInstance(ctx, factory);
            config.setExtendBase(extendBase);
        }
        return extendBase;
    }

    public static String getExtendTable(Context ctx, BillExtendConfig config) {
        String table = config.getTable();
        String entity = config.getEntity();
        if (StringUtils.isEmpty((String)table) && !StringUtils.isEmpty((String)entity)) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo bill = loader.getEntity((IMetaDataPK)new MetaDataPK(entity));
            table = bill.getTable().getName();
            config.setTable(table);
        }
        return table;
    }

    public static String getBillEntryTable(Context ctx, BillExtendMapping mapping) {
        String table = mapping.getBillEntryTable();
        String entity = mapping.getBillEntry();
        if (StringUtils.isEmpty((String)table) && !StringUtils.isEmpty((String)entity)) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo bill = loader.getEntity((IMetaDataPK)new MetaDataPK(entity));
            table = bill.getTable().getName();
            mapping.setBillEntryTable(table);
        }
        return table;
    }
}

