/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.EmpDynamicFilterInfo;
import com.kingdee.eas.hr.base.HRBaseDataUtils;
import com.kingdee.eas.hr.base.app.AbstractEmpDynamicCollectionFacadeControllerBean;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class EmpDynamicCollectionFacadeControllerBean
extends AbstractEmpDynamicCollectionFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.base.app.EmpDynamicCollectionFacadeControllerBean");
    private boolean isStart = true;
    private String empTypeStr = null;

    protected IObjectCollection _getOrgUnitCollection(Context ctx, String adminLongNumber, Date startDate, Date endDate, int level) throws BOSException, EASBizException {
        Map noLeafMap;
        StringBuffer sql = new StringBuffer();
        sql.append("select * from T_ORG_Admin where FLongNumber like ");
        sql.append("'");
        sql.append(adminLongNumber + "%");
        sql.append("'");
        sql.append(" and FLevel <= ");
        sql.append(level);
        sql.append(" order by FlongNumber");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        AdminOrgUnitCollection adminCol = new AdminOrgUnitCollection();
        AdminOrgUnitInfo adminInfo = null;
        Locale l = ctx.getLocale();
        String namePosition = "FName_L2";
        if (l.toString().equalsIgnoreCase("l1")) {
            namePosition = "FName_L1";
        } else if (l.toString().equalsIgnoreCase("l2")) {
            namePosition = "FName_L2";
        } else if (l.toString().equalsIgnoreCase("l3")) {
            namePosition = "FName_L3";
        }
        try {
            noLeafMap = this.getNoLeafMap(rs, namePosition);
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        try {
            rs.beforeFirst();
            while (rs.next()) {
                adminInfo = new AdminOrgUnitInfo();
                adminInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                adminInfo.setNumber(rs.getString("FNumber"));
                String tempName = rs.getString(namePosition);
                adminInfo.setName(tempName);
                adminInfo.setLongNumber(rs.getString("FLongNumber"));
                adminInfo.setLevel(rs.getInt("FLevel"));
                adminInfo.setSortCode(rs.getString("FSortCode"));
                this.setParentName(adminInfo, noLeafMap, rs.getString("FLongNumber"));
                adminCol.add(adminInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return adminCol;
    }

    private void setParentName(AdminOrgUnitInfo adminInfo, Map noLeafMap, String longNumber) {
        String[] longNumberArgus = longNumber.split("!");
        HashSet<String> longNumberSet = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < longNumberArgus.length; ++i) {
            if (i != 0) {
                sb.append("!");
            }
            sb.append(longNumberArgus[i]);
            if (sb.toString().equals(longNumber)) continue;
            longNumberSet.add(sb.toString());
        }
        Iterator iterator = longNumberSet.iterator();
        while (iterator.hasNext()) {
            HashMap parntInfoMap = (HashMap)noLeafMap.get(iterator.next());
            if (parntInfoMap == null) continue;
            Integer parntLevel = (Integer)parntInfoMap.get("parntLevel");
            adminInfo.put("parntInfo" + parntLevel, (Object)parntInfoMap);
        }
    }

    private Map getNoLeafMap(IRowSet rs, String namePosition) throws BOSException, EASBizException, SQLException {
        HashMap noLeafMap = new HashMap();
        rs.beforeFirst();
        while (rs.next()) {
            HashMap<String, Object> parntInfoMap = new HashMap<String, Object>();
            parntInfoMap.put("parentName", rs.getString(namePosition));
            parntInfoMap.put("parntLevel", rs.getInt("FLevel"));
            noLeafMap.put(rs.getString("FLongNumber"), parntInfoMap);
        }
        return noLeafMap;
    }

    private String getRetireDataSql(Context ctx, EmpDynamicFilterInfo empDynamicFilterInfo) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select orgRelation.FAdminOrgID as orgId, admin.FlongNumber, count(*) as count from T_HR_EmpOrgRelation orgRelation ");
        sql.append("LEFT JOIN T_HR_AffairActionReason reason on orgRelation.FActionReasonID = reason.FID  ");
        sql.append("LEFT JOIN t_org_admin as admin ON orgRelation.FAdminOrgID = admin.Fid ");
        sql.append("LEFT JOIN T_HR_BDEmployeeType as empType on empType.FID = orgRelation.FEmployeeTypeID ");
        sql.append(this.getFilterSQL(ctx, empDynamicFilterInfo));
        sql.append("and reason.FlongNumber like ");
        sql.append("'");
        sql.append(HRUtil.getActReaLongNumberByID(ctx, "DawAAAApLweWEWnu"));
        sql.append("%");
        sql.append("'");
        sql.append(" group by  orgRelation.FAdminOrgID,admin.FlongNumber ");
        return sql.toString();
    }

    private Object getFilterSQL(Context ctx, EmpDynamicFilterInfo empDynamicFilterInfo) throws BOSException {
        String longNumber = empDynamicFilterInfo.getAdminLongNumber();
        Date startDate = empDynamicFilterInfo.getStartTime();
        Date endDate = empDynamicFilterInfo.getEndTime();
        StringBuffer sql = new StringBuffer();
        sql.append("where ");
        sql.append("orgRelation.FEffectStartDate >= ");
        sql.append("{");
        sql.append(DateTimeUtils.format((Date)startDate));
        sql.append("}");
        sql.append("and orgRelation.FEffectStartDate <= ");
        sql.append("{");
        sql.append(DateTimeUtils.format((Date)endDate));
        sql.append("}");
        sql.append(" and orgRelation.FIsPartTime = 0 ");
        this.setEmpTypeFilterStr(sql);
        String empPersonIDSQL = null;
        empDynamicFilterInfo.setTimePoint(false);
        try {
            empPersonIDSQL = this._getEmpComPersonIDSQL(ctx, empDynamicFilterInfo);
        }
        catch (EASBizException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        if (!StringUtils.isEmpty((String)empPersonIDSQL)) {
            sql.append(" and FpersonID in");
            sql.append(" (");
            sql.append(empPersonIDSQL);
            sql.append(") ");
        }
        return sql.toString();
    }

    private String getEmpCommonPersonIDSql(EmpDynamicFilterInfo empDynamicFilterInfo) {
        StringBuffer sb = new StringBuffer();
        if (empDynamicFilterInfo.getComPersonIDSet() != null && empDynamicFilterInfo.getComPersonIDSet().size() > 0) {
            Iterator iterator = empDynamicFilterInfo.getComPersonIDSet().iterator();
            while (iterator.hasNext()) {
                if (sb.length() > 1) {
                    sb.append(",");
                }
                sb.append("'");
                sb.append(iterator.next());
                sb.append("'");
            }
        } else {
            sb.append("'");
            sb.append("none");
            sb.append("'");
        }
        return sb.toString();
    }

    private void setEmpTypeFilterStr(StringBuffer sql) throws BOSException {
        if (StringUtils.isEmpty((String)this.empTypeStr)) {
            sql.append(" and (empType.FID = ");
            sql.append("'");
            sql.append("00000000-0000-0000-0000-000000000001A29E85B3");
            sql.append("'");
            sql.append(" or ");
            sql.append(" empType.FID = ");
            sql.append("'");
            sql.append("00000000-0000-0000-0000-000000000002A29E85B3");
            sql.append("'");
            sql.append("')");
        } else {
            String[] empTypes = this.empTypeStr.split(",");
            sql.append(" and (empType.Fnumber = ");
            int j = empTypes.length;
            for (int i = 0; i < j; ++i) {
                if (i > 0) {
                    sql.append("or empType.Fnumber = ");
                }
                sql.append("'");
                sql.append(empTypes[i]);
                sql.append("'");
            }
            sql.append(")");
        }
    }

    private String getResignDataSql(Context ctx, EmpDynamicFilterInfo empDynamicFilterInfo) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select orgRelation.FAdminOrgID as orgId, admin.FlongNumber, count(*) as count from T_HR_EmpOrgRelation orgRelation ");
        sql.append("LEFT JOIN T_HR_AffairActionReason reason on orgRelation.FActionReasonID = reason.FID  ");
        sql.append("LEFT JOIN t_org_admin as admin ON orgRelation.FAdminOrgID = admin.Fid ");
        sql.append("LEFT JOIN T_HR_BDEmployeeType as empType on empType.FID = orgRelation.FEmployeeTypeID ");
        sql.append(this.getFilterSQL(ctx, empDynamicFilterInfo));
        sql.append("and reason.FlongNumber like ");
        sql.append("'");
        sql.append(HRUtil.getActReaLongNumberByID(ctx, "DawAAAApLwaWEWnu"));
        sql.append("%");
        sql.append("'");
        sql.append(" group by  orgRelation.FAdminOrgID,admin.FlongNumber ");
        return sql.toString();
    }

    private String getEnrollDataSql(Context ctx, EmpDynamicFilterInfo empDynamicFilterInfo) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select orgRelation.FAdminOrgID as orgId, admin.FlongNumber, count(*) as count from T_HR_EmpOrgRelation orgRelation ");
        sql.append("LEFT JOIN T_HR_AffairActionReason reason on orgRelation.FActionReasonID = reason.FID  ");
        sql.append("LEFT JOIN t_org_admin as admin ON orgRelation.FAdminOrgID = admin.Fid ");
        sql.append("LEFT JOIN T_HR_BDEmployeeType as empType on empType.FID = orgRelation.FEmployeeTypeID ");
        sql.append(this.getFilterSQL(ctx, empDynamicFilterInfo));
        sql.append("and reason.FlongNumber like ");
        sql.append("'");
        sql.append(HRUtil.getActReaLongNumberByID(ctx, "DawAAAApLwKWEWnu"));
        sql.append("%");
        sql.append("'");
        sql.append(" group by  orgRelation.FAdminOrgID,admin.FlongNumber ");
        return sql.toString();
    }

    private Object getEmpAffairDataList(Context ctx, String startDataSql) throws BOSException {
        ArrayList list = new ArrayList();
        if (startDataSql == null) {
            return null;
        }
        String totalDataSql = this.getTotalDataSql(ctx, startDataSql);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)totalDataSql);
        HashMap<String, String> row = null;
        try {
            while (rowSet.next()) {
                row = new HashMap<String, String>();
                row.put("orgId", rowSet.getString("fid"));
                row.put("count", rowSet.getString("count"));
                list.add(row);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    private Object getFluctDataList(Context ctx, String startDataSql) throws BOSException {
        ArrayList list = new ArrayList();
        if (startDataSql == null) {
            return null;
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)startDataSql);
        HashMap<String, String> row = null;
        try {
            while (rowSet.next()) {
                row = new HashMap<String, String>();
                row.put("orgId", rowSet.getString("fid"));
                row.put("count", rowSet.getString("count"));
                list.add(row);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    private String getTotalDataSql(Context ctx, String startDataSql) {
        String l = LocaleUtils.getShortCode((Context)ctx);
        StringBuffer sb = new StringBuffer();
        sb.append("select adminOrg.fid fid,adminOrg.flongnumber flongnumber,adminOrg.fname_" + l + " fname_" + l + ",sum(adcount.count) count from");
        sb.append("(");
        sb.append(startDataSql);
        sb.append(")");
        sb.append("adcount ");
        sb.append("inner join t_org_admin adminOrg ");
        sb.append("on (CHARINDEX(concat(adminOrg.flongnumber,'!'),adcount.flongnumber) = 1 or adminOrg.flongnumber = adcount.flongnumber) ");
        sb.append("group by adminOrg.flongnumber,adminOrg.fid,adminOrg.fname_" + l + " order by  adminOrg.flongnumber ");
        return sb.toString();
    }

    private String getFlucOutDataSql(Context ctx, EmpDynamicFilterInfo empDynamicFilterInfo, boolean isFlowIn) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select t1.orgId fid, count(*) count from ");
        sql.append("( ");
        sql.append("select org.fid orgId from t_org_admin org inner join ( ");
        sql.append("select oldOrg.fid oldId, oldOrg.flongNumber oldLongNumber, newOrg.fid newOrgId, newOrg.flongNumber newLongNumber from  T_HR_EmpOrgRelation orgRelation ");
        sql.append("inner join t_org_admin oldOrg on oldOrg.fid = orgRelation.FRelateAdminID ");
        sql.append("inner join t_org_admin newOrg on newOrg.fid = orgRelation.fadminorgID ");
        sql.append("LEFT JOIN T_HR_BDEmployeeType as empType on empType.FID = orgRelation.FEmployeeTypeID ");
        sql.append("LEFT JOIN T_HR_AffairActionReason reason on orgRelation.FActionReasonID = reason.FID  ");
        sql.append(this.getFilterSQL(ctx, empDynamicFilterInfo));
        sql.append("and reason.FlongNumber like ");
        sql.append("'");
        sql.append(HRUtil.getActReaLongNumberByID(ctx, "DawAAAApLwWWEWnu"));
        sql.append("%");
        sql.append("'");
        sql.append(") t on (CHARINDEX(concat(org.flongNumber,'!'), t.oldLongNumber) = 0 and org.flongNumber <> t.oldLongNumber) and (CHARINDEX(concat(org.flongNumber,'!'),  ");
        sql.append("t.newLongNumber) = 1 or org.flongNumber = t.newLongNumber)");
        sql.append(") t1 ");
        sql.append("group by t1.orgId ");
        return sql.toString();
    }

    private String getFlucInDataSql(Context ctx, EmpDynamicFilterInfo empDynamicFilterInfo, boolean isFlowIn) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select t1.orgId fid, count(*) count from ");
        sql.append("( ");
        sql.append("select org.fid orgId from t_org_admin org inner join ( ");
        sql.append("select oldOrg.fid oldId, oldOrg.flongNumber oldLongNumber, newOrg.fid newOrgId, newOrg.flongNumber newLongNumber from  T_HR_EmpOrgRelation orgRelation ");
        sql.append("inner join t_org_admin oldOrg on oldOrg.fid = orgRelation.FRelateAdminID ");
        sql.append("inner join t_org_admin newOrg on newOrg.fid = orgRelation.fadminorgID ");
        sql.append("LEFT JOIN T_HR_BDEmployeeType as empType on empType.FID = orgRelation.FEmployeeTypeID ");
        sql.append("LEFT JOIN T_HR_AffairActionReason reason on orgRelation.FActionReasonID = reason.FID  ");
        sql.append(this.getFilterSQL(ctx, empDynamicFilterInfo));
        sql.append("and reason.FlongNumber like ");
        sql.append("'");
        sql.append(HRUtil.getActReaLongNumberByID(ctx, "DawAAAApLwOWEWnu"));
        sql.append("%");
        sql.append("'");
        sql.append(") t on (CHARINDEX(concat(org.flongNumber,'!'), t.oldLongNumber) = 0 and org.flongNumber <> t.oldLongNumber) and (CHARINDEX(concat(org.flongNumber,'!'),  ");
        sql.append("t.newLongNumber) = 1 or org.flongNumber = t.newLongNumber)");
        sql.append(") t1 ");
        sql.append("group by t1.orgId ");
        return sql.toString();
    }

    private String getFluctuaDataSql(Context ctx, EmpDynamicFilterInfo empDynamicFilterInfo, boolean isFlowIn) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select t1.orgId fid, count(*) count from ");
        sql.append("( ");
        sql.append("select org.fid orgId from t_org_admin org inner join ( ");
        sql.append("select oldOrg.fid oldId, oldOrg.flongNumber oldLongNumber, newOrg.fid newOrgId, newOrg.flongNumber newLongNumber from  T_HR_EmpOrgRelation orgRelation ");
        sql.append("inner join t_org_admin oldOrg on oldOrg.fid = orgRelation.FRelateAdminID ");
        sql.append("inner join t_org_admin newOrg on newOrg.fid = orgRelation.fadminorgID ");
        sql.append("LEFT JOIN T_HR_BDEmployeeType as empType on empType.FID = orgRelation.FEmployeeTypeID ");
        sql.append("LEFT JOIN T_HR_AffairActionReason reason on orgRelation.FActionReasonID = reason.FID  ");
        sql.append(this.getFilterSQL(ctx, empDynamicFilterInfo));
        sql.append("and reason.FlongNumber like ");
        sql.append("'");
        sql.append(HRUtil.getActReaLongNumberByID(ctx, "DawAAAApLwOWEWnu"));
        sql.append("%");
        sql.append("'");
        sql.append(") t on (CHARINDEX(concat(org.flongNumber,'!'), t.oldLongNumber) = 1  or org.flongNumber = t.oldLongNumber) and (CHARINDEX(concat(org.flongNumber,'!'),  ");
        sql.append("t.newLongNumber) = 1 or org.flongNumber = t.newLongNumber) ");
        sql.append(") t1 ");
        sql.append("group by t1.orgId ");
        return sql.toString();
    }

    private List getEmpSection(Context ctx, EmpDynamicFilterInfo empDynamicFilterInfo) {
        Date startDate = empDynamicFilterInfo.getStartTime();
        Date endDate = empDynamicFilterInfo.getEndTime();
        int startYear = startDate.getYear();
        int endYear = endDate.getYear();
        ArrayList empList = new ArrayList();
        if (startYear < endYear) {
            this.dealNoEqualsSection(empDynamicFilterInfo, empList);
        } else if (startYear == endYear) {
            this.dealEqualsSection(empDynamicFilterInfo, empList);
        }
        return empList;
    }

    private void dealEqualsSection(EmpDynamicFilterInfo empDynamicFilterInfo, List empList) {
        Date startDate = empDynamicFilterInfo.getStartTime();
        Date endDate = empDynamicFilterInfo.getEndTime();
        int startYear = startDate.getYear();
        int endYear = endDate.getYear();
        int startMonth = startDate.getMonth();
        int endMonth = endDate.getMonth();
        int beginQuarter = DateTimeUtils.getQuarter((Date)startDate);
        int endQuarter = DateTimeUtils.getQuarter((Date)endDate);
        int beginHalfYear = this.getHalfYear(beginQuarter);
        int endHalfYear = this.getHalfYear(endQuarter);
        int year_Tmp = startYear;
        if ("YEAR".equals(empDynamicFilterInfo.getIntervalType())) {
            Date[] empSectionData = new Date[]{new Date(year_Tmp, 0, 1), this.getMonthEndDate(year_Tmp, 11)};
            empList.add(empSectionData);
        } else if ("QUARTER".equals(empDynamicFilterInfo.getIntervalType())) {
            int n = endQuarter - beginQuarter;
            for (int m = 0; m <= n; ++m) {
                Date[] empSectionData = new Date[2];
                startMonth = (beginQuarter + m) * 3 - 3;
                endMonth = (beginQuarter + m) * 3 - 1;
                empSectionData[0] = new Date(year_Tmp, startMonth, 1);
                empSectionData[1] = this.getMonthEndDate(year_Tmp, endMonth);
                empList.add(empSectionData);
            }
        } else if ("HALFYEAR".equals(empDynamicFilterInfo.getIntervalType())) {
            int n = endHalfYear - beginHalfYear;
            for (int m = 0; m <= n; ++m) {
                Date[] empSectionData = new Date[2];
                startMonth = (beginHalfYear + m) * 6 - 6;
                endMonth = (beginHalfYear + m) * 6 - 1;
                empSectionData[0] = new Date(year_Tmp, startMonth, 1);
                empSectionData[1] = this.getMonthEndDate(year_Tmp, endMonth);
                empList.add(empSectionData);
            }
        } else {
            int j = endMonth - startMonth;
            for (int i = 0; i <= j; ++i) {
                Date[] empSectionData = new Date[2];
                int section_Tmp = startMonth + i;
                empSectionData[0] = new Date(year_Tmp, section_Tmp, 1);
                empSectionData[1] = this.getMonthEndDate(year_Tmp, section_Tmp);
                empList.add(empSectionData);
            }
        }
    }

    private void dealNoEqualsSection(EmpDynamicFilterInfo empDynamicFilterInfo, List empList) {
        Date startDate = empDynamicFilterInfo.getStartTime();
        Date endDate = empDynamicFilterInfo.getEndTime();
        int startYear = startDate.getYear();
        int endYear = endDate.getYear();
        int startMonth = startDate.getMonth();
        int endMonth = endDate.getMonth();
        int beginQuarter = DateTimeUtils.getQuarter((Date)startDate);
        int endQuarter = DateTimeUtils.getQuarter((Date)endDate);
        int beginHalfYear = this.getHalfYear(beginQuarter);
        int endHalfYear = this.getHalfYear(endQuarter);
        int j = endYear - startYear;
        for (int i = 0; i < j; ++i) {
            int section_Tmp;
            int m;
            int n;
            Date[] empSectionData;
            int year_Tmp = startYear + i;
            if ("YEAR".equals(empDynamicFilterInfo.getIntervalType())) {
                empSectionData = new Date[]{new Date(year_Tmp, 0, 1), this.getMonthEndDate(year_Tmp, 11)};
                empList.add(empSectionData);
            } else if ("QUARTER".equals(empDynamicFilterInfo.getIntervalType())) {
                n = 4 - beginQuarter;
                for (m = 0; m <= n; ++m) {
                    empSectionData = new Date[2];
                    startMonth = (beginQuarter + m) * 3 - 3;
                    endMonth = (beginQuarter + m) * 3 - 1;
                    empSectionData[0] = new Date(year_Tmp, startMonth, 1);
                    empSectionData[1] = this.getMonthEndDate(year_Tmp, endMonth);
                    empList.add(empSectionData);
                }
                beginQuarter = 1;
            } else if ("HALFYEAR".equals(empDynamicFilterInfo.getIntervalType())) {
                n = 2 - beginHalfYear;
                for (m = 0; m <= n; ++m) {
                    empSectionData = new Date[2];
                    startMonth = (beginHalfYear + m) * 6 - 6;
                    endMonth = (beginHalfYear + m) * 6 - 1;
                    empSectionData[0] = new Date(year_Tmp, startMonth, 1);
                    empSectionData[1] = this.getMonthEndDate(year_Tmp, endMonth);
                    empList.add(empSectionData);
                }
                beginHalfYear = 1;
            } else {
                n = 12 - startMonth;
                for (m = 0; m < n; ++m) {
                    empSectionData = new Date[2];
                    section_Tmp = startMonth + m;
                    empSectionData[0] = new Date(year_Tmp, section_Tmp, 1);
                    empSectionData[1] = this.getMonthEndDate(year_Tmp, section_Tmp);
                    empList.add(empSectionData);
                }
                startMonth = 1;
            }
            if (++year_Tmp != endYear) continue;
            if ("YEAR".equals(empDynamicFilterInfo.getIntervalType())) {
                empSectionData = new Date[]{new Date(year_Tmp, 0, 1), this.getMonthEndDate(year_Tmp, 11)};
                empList.add(empSectionData);
                break;
            }
            if ("QUARTER".equals(empDynamicFilterInfo.getIntervalType())) {
                n = endQuarter;
                for (m = 0; m < n; ++m) {
                    empSectionData = new Date[2];
                    startMonth = m * 3;
                    endMonth = m * 3 + 2;
                    empSectionData[0] = new Date(year_Tmp, startMonth, 1);
                    empSectionData[1] = this.getMonthEndDate(year_Tmp, endMonth);
                    empList.add(empSectionData);
                }
            } else {
                if ("HALFYEAR".equals(empDynamicFilterInfo.getIntervalType())) {
                    n = endHalfYear;
                    for (m = 0; m < n; ++m) {
                        empSectionData = new Date[2];
                        startMonth = m * 6;
                        endMonth = m * 6 + 5;
                        empSectionData[0] = new Date(year_Tmp, startMonth, 1);
                        empSectionData[1] = this.getMonthEndDate(year_Tmp, endMonth);
                        empList.add(empSectionData);
                    }
                    beginHalfYear = 1;
                    break;
                }
                int r = 0;
                int s = endMonth;
                while (r < s) {
                    empSectionData = new Date[2];
                    section_Tmp = r++;
                    empSectionData[0] = new Date(year_Tmp, section_Tmp, 1);
                    empSectionData[1] = this.getMonthEndDate(year_Tmp, section_Tmp);
                    empList.add(empSectionData);
                }
            }
            break;
        }
    }

    public int getHalfYear(int quarter) {
        if (quarter > 2) {
            return 2;
        }
        return 1;
    }

    private Date getMonthEndDate(int year, int month_Tmp) {
        Date monthEndDate = new Date();
        monthEndDate = DateTimeUtils.addDay((Date)new Date(year, month_Tmp + 1, 1), (long)-1L);
        monthEndDate = DateTimeUtils.addSecond((Date)DateTimeUtils.addDay((Date)monthEndDate, (long)1L), (long)-1L);
        return monthEndDate;
    }

    private String getStartEndDateSql(Context ctx, EmpDynamicFilterInfo empDynamicFilterInfo, Date date, boolean isStartTime) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select orgRelation.FAdminOrgID as orgId,count(*) as count,admin.FLongNumber  from T_HR_EmpOrgRelation  AS orgRelation ");
        sql.append("LEFT JOIN t_org_admin as admin ON orgRelation.FAdminOrgID = admin.Fid ");
        sql.append("LEFT JOIN T_HR_BDEmployeeType as empType on empType.FID = orgRelation.FEmployeeTypeID ");
        sql.append("LEFT JOIN T_HR_PositionState as state on state.FID = orgRelation.FPositionstateID ");
        sql.append(this.getFilterSQL(ctx, empDynamicFilterInfo, date, isStartTime));
        sql.append(" group by orgRelation.FAdminOrgID,admin.FLongNumber");
        return sql.toString();
    }

    private Object getFilterSQL(Context ctx, EmpDynamicFilterInfo empDynamicFilterInfo, Date date, boolean isStartTime) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("where ");
        if (isStartTime) {
            sql.append("orgRelation.FEffectStartDate < ");
            sql.append("{");
            sql.append(DateTimeUtils.format((Date)date));
            sql.append("}");
            sql.append(" and orgRelation.FEffectEndDate >=");
            sql.append("{");
            sql.append(DateTimeUtils.format((Date)date));
            sql.append("}");
        } else {
            sql.append("orgRelation.FEffectStartDate <= ");
            sql.append("{");
            sql.append(DateTimeUtils.format((Date)date));
            sql.append("}");
            sql.append(" and orgRelation.FEffectEndDate >");
            sql.append("{");
            sql.append(DateTimeUtils.format((Date)date));
            sql.append("}");
        }
        sql.append(" and orgRelation.FIsPartTime = 0 ");
        this.setEmpTypeFilterStr(sql);
        String empPersonIDSQL = null;
        EmpDynamicFilterInfo empDynamicFilterInfo_tmp = new EmpDynamicFilterInfo();
        empDynamicFilterInfo_tmp.setStartTime(date);
        empDynamicFilterInfo_tmp.setTimePoint(true);
        empDynamicFilterInfo_tmp.setStartTimePoint(isStartTime);
        empDynamicFilterInfo_tmp.setCommonFilterInfo(empDynamicFilterInfo.getCommonFilterInfo());
        try {
            empPersonIDSQL = this._getEmpComPersonIDSQL(ctx, empDynamicFilterInfo_tmp);
        }
        catch (EASBizException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        if (!StringUtils.isEmpty((String)empPersonIDSQL)) {
            sql.append(" and FpersonID in");
            sql.append(" (");
            sql.append(empPersonIDSQL);
            sql.append(") ");
        }
        sql.append(" and state.fid = ");
        sql.append("'");
        sql.append("'");
        return sql.toString();
    }

    @Override
    protected Collection _getEmpChangeCollection(Context ctx, EmpDynamicFilterInfo empDynamicFilterInfo) throws BOSException, EASBizException {
        ArrayList result = new ArrayList();
        this.empTypeStr = HRBaseDataUtils.getEmpTypeStr(ctx);
        if (empDynamicFilterInfo.isShowDuringData()) {
            this.dealEmpSection(ctx, empDynamicFilterInfo, result);
        }
        this.dealTotalData(ctx, empDynamicFilterInfo, result);
        return result;
    }

    private void dealTotalData(Context ctx, EmpDynamicFilterInfo empDynamicFilterInfo, List result) throws BOSException, EASBizException {
        boolean isFlowIn = true;
        HashMap<String, Object> dataBlockMap = new HashMap<String, Object>();
        if (empDynamicFilterInfo.getEndTime().after(new Date())) {
            empDynamicFilterInfo.setEndTime(new Date());
        }
        dataBlockMap.put("dataLevel", "0");
        dataBlockMap.put("resignList", this.getEmpAffairDataList(ctx, this.getResignDataSql(ctx, empDynamicFilterInfo)));
        dataBlockMap.put("retireList", this.getEmpAffairDataList(ctx, this.getRetireDataSql(ctx, empDynamicFilterInfo)));
        dataBlockMap.put("flucInList", this.getFluctDataList(ctx, this.getFlucInDataSql(ctx, empDynamicFilterInfo, isFlowIn)));
        dataBlockMap.put("fluctuaList", this.getFluctDataList(ctx, this.getFluctuaDataSql(ctx, empDynamicFilterInfo, isFlowIn)));
        dataBlockMap.put("flucOutList", this.getFluctDataList(ctx, this.getFlucOutDataSql(ctx, empDynamicFilterInfo, !isFlowIn)));
        dataBlockMap.put("enrollList", this.getEmpAffairDataList(ctx, this.getEnrollDataSql(ctx, empDynamicFilterInfo)));
        dataBlockMap.put("nowDataList", this.getEmpAffairDataList(ctx, this.getStartEndDateSql(ctx, empDynamicFilterInfo, new Date(), !this.isStart)));
        dataBlockMap.put("endList", this.getEmpAffairDataList(ctx, this.getStartEndDateSql(ctx, empDynamicFilterInfo, empDynamicFilterInfo.getEndTime(), !this.isStart)));
        dataBlockMap.put("startDataList", this.getEmpAffairDataList(ctx, this.getStartEndDateSql(ctx, empDynamicFilterInfo, empDynamicFilterInfo.getStartTime(), this.isStart)));
        dataBlockMap.put("otherAddList", this.getEmpAffairDataList(ctx, this.getOtherAddDataSql(ctx, empDynamicFilterInfo, isFlowIn)));
        dataBlockMap.put("otherDelList", this.getEmpAffairDataList(ctx, this.getOtherDelDataSql(ctx, empDynamicFilterInfo, !isFlowIn)));
        result.add(dataBlockMap);
    }

    private String getOtherDelDataSql(Context ctx, EmpDynamicFilterInfo empDynamicFilterInfo, boolean isFlowIn) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select orgRelation.FAdminOrgID as orgId, admin.FlongNumber, count(*) as count from T_HR_EmpOrgRelation orgRelation ");
        sql.append("LEFT JOIN T_HR_AffairActionReason reason on orgRelation.FActionReasonID = reason.FID  ");
        sql.append("LEFT JOIN t_org_admin as admin ON orgRelation.FAdminOrgID = admin.Fid ");
        sql.append("LEFT JOIN T_HR_BDEmployeeType as empType on empType.FID = orgRelation.FEmployeeTypeID ");
        sql.append(this.getFilterSQL(ctx, empDynamicFilterInfo));
        sql.append("and reason.FlongNumber like ");
        sql.append("'");
        sql.append(HRUtil.getActReaLongNumberByID(ctx, "DawAAAApLwiWEWnu"));
        sql.append("%");
        sql.append("'");
        sql.append(" group by  orgRelation.FAdminOrgID,admin.FlongNumber ");
        return sql.toString();
    }

    private String getOtherAddDataSql(Context ctx, EmpDynamicFilterInfo empDynamicFilterInfo, boolean isFlowIn) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select orgRelation.FAdminOrgID as orgId, admin.FlongNumber, count(*) as count from T_HR_EmpOrgRelation orgRelation ");
        sql.append("LEFT JOIN T_HR_AffairActionReason reason on orgRelation.FActionReasonID = reason.FID  ");
        sql.append("LEFT JOIN t_org_admin as admin ON orgRelation.FAdminOrgID = admin.Fid ");
        sql.append("LEFT JOIN T_HR_BDEmployeeType as empType on empType.FID = orgRelation.FEmployeeTypeID ");
        sql.append(this.getFilterSQL(ctx, empDynamicFilterInfo));
        sql.append("and reason.FlongNumber like ");
        sql.append("'");
        sql.append(HRUtil.getActReaLongNumberByID(ctx, "DawAAAApLwSWEWnu"));
        sql.append("%");
        sql.append("'");
        sql.append(" group by  orgRelation.FAdminOrgID,admin.FlongNumber ");
        return sql.toString();
    }

    private void dealEmpSection(Context ctx, EmpDynamicFilterInfo empDynamicFilterInfo, List result) throws BOSException, EASBizException {
        List empSection = this.getEmpSection(ctx, empDynamicFilterInfo);
        String adminLongNumber = empDynamicFilterInfo.getAdminLongNumber();
        boolean isShowDuringData = empDynamicFilterInfo.isShowDuringData();
        boolean isShowSealUpOrg = empDynamicFilterInfo.isShowSealUpOrg();
        boolean isShowVirtualOrg = empDynamicFilterInfo.isShowVirtualOrg();
        boolean isFlowIn = true;
        int size = empSection.size();
        for (int i = 0; i < size; ++i) {
            HashMap<String, Object> dataBlockMap = new HashMap<String, Object>();
            Date[] empArray = (Date[])empSection.get(i);
            int month = empArray[0].getMonth() + 1;
            empDynamicFilterInfo = new EmpDynamicFilterInfo();
            empDynamicFilterInfo.setStartTime(empArray[0]);
            if (empArray[1].after(new Date())) {
                empArray[1] = new Date();
            }
            empDynamicFilterInfo.setEndTime(empArray[1]);
            empDynamicFilterInfo.setAdminLongNumber(adminLongNumber);
            empDynamicFilterInfo.setShowDuringData(isShowDuringData);
            empDynamicFilterInfo.setShowSealUpOrg(isShowSealUpOrg);
            empDynamicFilterInfo.setShowVirtualOrg(isShowVirtualOrg);
            dataBlockMap.put("dataLevel", empArray[0].getYear() + 1900 + "_" + month);
            dataBlockMap.put("startDataList", this.getEmpAffairDataList(ctx, this.getStartEndDateSql(ctx, empDynamicFilterInfo, empArray[0], this.isStart)));
            dataBlockMap.put("endList", this.getEmpAffairDataList(ctx, this.getStartEndDateSql(ctx, empDynamicFilterInfo, empArray[1], !this.isStart)));
            dataBlockMap.put("resignList", this.getEmpAffairDataList(ctx, this.getResignDataSql(ctx, empDynamicFilterInfo)));
            dataBlockMap.put("retireList", this.getEmpAffairDataList(ctx, this.getRetireDataSql(ctx, empDynamicFilterInfo)));
            dataBlockMap.put("enrollList", this.getEmpAffairDataList(ctx, this.getEnrollDataSql(ctx, empDynamicFilterInfo)));
            dataBlockMap.put("flucInList", this.getFluctDataList(ctx, this.getFlucInDataSql(ctx, empDynamicFilterInfo, isFlowIn)));
            dataBlockMap.put("fluctuaList", this.getFluctDataList(ctx, this.getFluctuaDataSql(ctx, empDynamicFilterInfo, isFlowIn)));
            dataBlockMap.put("flucOutList", this.getFluctDataList(ctx, this.getFlucOutDataSql(ctx, empDynamicFilterInfo, !isFlowIn)));
            dataBlockMap.put("otherAddList", this.getEmpAffairDataList(ctx, this.getOtherAddDataSql(ctx, empDynamicFilterInfo, isFlowIn)));
            dataBlockMap.put("otherDelList", this.getEmpAffairDataList(ctx, this.getOtherDelDataSql(ctx, empDynamicFilterInfo, !isFlowIn)));
            result.add(dataBlockMap);
        }
    }

    @Override
    protected IObjectCollection _getOrgUnitCollection(Context ctx, EmpDynamicFilterInfo empDynamicFilterInfo) throws BOSException, EASBizException {
        Map noLeafMap;
        String adminLongNumber = empDynamicFilterInfo.getAdminLongNumber();
        int level = empDynamicFilterInfo.getAdminLevel();
        boolean isShowSealUpOrg = empDynamicFilterInfo.isShowSealUpOrg();
        boolean isShowVirtualOrg = empDynamicFilterInfo.isShowVirtualOrg();
        StringBuffer sql = new StringBuffer();
        sql.append("select * from T_ORG_Admin where FLongNumber like ");
        sql.append("'");
        sql.append(adminLongNumber + "%");
        sql.append("'");
        sql.append(" and FLevel <= ");
        sql.append(level);
        if (!isShowSealUpOrg) {
            sql.append(" and FIsSealUp = 0");
        }
        if (!isShowVirtualOrg) {
            sql.append(" and FIsVirtual = 0");
        }
        sql.append(" order by FlongNumber");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        AdminOrgUnitCollection adminCol = new AdminOrgUnitCollection();
        AdminOrgUnitInfo adminInfo = null;
        Locale l = ctx.getLocale();
        String namePosition = "FName_L2";
        if (l.toString().equalsIgnoreCase("l1")) {
            namePosition = "FName_L1";
        } else if (l.toString().equalsIgnoreCase("l2")) {
            namePosition = "FName_L2";
        } else if (l.toString().equalsIgnoreCase("l3")) {
            namePosition = "FName_L3";
        }
        try {
            noLeafMap = this.getNoLeafMap(rs, namePosition);
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        try {
            rs.beforeFirst();
            while (rs.next()) {
                adminInfo = new AdminOrgUnitInfo();
                adminInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                adminInfo.setNumber(rs.getString("FNumber"));
                String tempName = rs.getString(namePosition);
                adminInfo.setName(tempName);
                adminInfo.setLongNumber(rs.getString("FLongNumber"));
                adminInfo.setLevel(rs.getInt("FLevel"));
                adminInfo.setSortCode(rs.getString("FSortCode"));
                this.setParentName(adminInfo, noLeafMap, rs.getString("FLongNumber"));
                adminCol.add(adminInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return adminCol;
    }

    @Override
    protected String _getEmpComPersonIDSQL(Context ctx, EmpDynamicFilterInfo empDynamicFilterInfo) throws BOSException, EASBizException {
        if (empDynamicFilterInfo.getCommonFilterInfo() != null && empDynamicFilterInfo.getCommonFilterInfo().getFilterItems().size() > 0) {
            HashSet personIDSet = new HashSet();
            FilterInfo commonFilterInfo = new FilterInfo();
            boolean isGradeFilter = false;
            int j = empDynamicFilterInfo.getCommonFilterInfo().getFilterItems().size();
            for (int i = 0; i < j; ++i) {
                if (!empDynamicFilterInfo.getCommonFilterInfo().getFilterItems().get(i).getPropertyName().equals("jobGrade.id")) continue;
                isGradeFilter = true;
                break;
            }
            if (isGradeFilter) {
                if (empDynamicFilterInfo.isTimePoint()) {
                    commonFilterInfo.getFilterItems().add(new FilterItemInfo("empJobGrade.effectStartDate", (Object)empDynamicFilterInfo.getStartTime(), CompareType.LESS));
                    commonFilterInfo.getFilterItems().add(new FilterItemInfo("empJobGrade.effectEndDate", (Object)empDynamicFilterInfo.getStartTime(), CompareType.GREATER_EQUALS));
                } else {
                    commonFilterInfo.getFilterItems().add(new FilterItemInfo("empJobGrade.effectStartDate", (Object)empDynamicFilterInfo.getStartTime(), CompareType.GREATER_EQUALS));
                    commonFilterInfo.getFilterItems().add(new FilterItemInfo("empJobGrade.effectStartDate", (Object)empDynamicFilterInfo.getEndTime(), CompareType.LESS_EQUALS));
                }
                commonFilterInfo.mergeFilter(empDynamicFilterInfo.getCommonFilterInfo(), "AND");
            } else {
                commonFilterInfo = empDynamicFilterInfo.getCommonFilterInfo();
            }
            Object rs = null;
            IQueryExecutor queryExcu = null;
            EntityViewInfo billInfo = new EntityViewInfo();
            MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.base.app", "EmpDynFieldFilterQuery");
            billInfo.setFilter(commonFilterInfo);
            queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
            queryExcu.setObjectView(billInfo);
            return queryExcu.getSQL();
        }
        return null;
    }
}

