/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.view.BusinessObjectBriefView;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.subsystemhelper.UserCustomSubSystem;
import com.kingdee.eas.hr.base.HRBillConfigInfo;
import com.kingdee.eas.hr.base.HRBillDefConfigCollection;
import com.kingdee.eas.hr.base.HRBizDefineException;
import com.kingdee.eas.hr.base.app.AbstractHRBillConfigControllerBean;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class HRBillConfigControllerBean
extends AbstractHRBillConfigControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.base.app.HRBillConfigControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.verifyEntrys(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.verifyEntrys(ctx, model);
        super._update(ctx, pk, model);
    }

    protected IBriefViewTreeNode _getHRBillSubsystem(Context ctx) throws BOSException, EASBizException {
        String mdbViewName = "com_kingdee_eas_base_subsystemEntity";
        BusinessObjectBriefView retView = null;
        if (UserCustomSubSystem.startUserCustom((Context)ctx, (String)mdbViewName)) {
            retView = UserCustomSubSystem.getSubSystemByName((Context)ctx, (String)mdbViewName);
        }
        if (retView == null) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            retView = loader.getBusinessObjectBriefView((IMetaDataPK)new MetaDataPK(null, mdbViewName));
        }
        IBriefViewTreeNode treeNode = retView.getViewRoot();
        this.removeNoHrBillChildEntity(treeNode);
        return treeNode;
    }

    private void removeNoHrBillChildEntity(IBriefViewTreeNode treeNode) {
        if (treeNode.isPackage()) {
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                this.removeNoHrBillChildEntity((IBriefViewTreeNode)treeNode.getChildAt(i));
            }
        } else {
            String entityName = treeNode.getName();
            if (!StringUtils.isEmpty((String)entityName) && !this.isHrBillChildEntity(entityName)) {
                treeNode.removeFromParent();
            }
        }
    }

    private boolean isHrBillChildEntity(String entityName) {
        boolean isHrBillChildEntity = false;
        EntityObjectInfo entityInfo = null;
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        entityInfo = loader.getEntity((IMetaDataPK)new MetaDataPK(entityName));
        if (entityInfo != null) {
            BusinessObjectInfo binfo = null;
            for (int i = 0; i < 50 && (binfo = entityInfo.getParent()) != null; ++i) {
                if (!"654B7BED".equals(binfo.getBOSType())) continue;
                isHrBillChildEntity = true;
                break;
            }
        }
        return isHrBillChildEntity;
    }

    private void verifyEntrys(Context ctx, IObjectValue model) throws EASBizException {
        HRBillConfigInfo HRBillConfigInfo2 = (HRBillConfigInfo)model;
        HRBillDefConfigCollection hrBillDefConfig = HRBillConfigInfo2.getHrBillDefConfig();
        if (hrBillDefConfig.size() < 1) {
            throw new HRBizDefineException(HRBizDefineException.HRBILLDEFCONGIF_IS_NOT_NULL);
        }
    }
}

