/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.service.AbstractServiceAdapter;
import com.kingdee.bos.service.IServiceAdapter;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.PlugInApplyMethod;
import com.kingdee.eas.hr.base.app.PlugInBeanFactory;
import com.kingdee.eas.hr.base.app.PlugInBeanParam;
import com.kingdee.eas.hr.base.app.PlugInBeanProxy;
import com.kingdee.util.LowTimer;
import org.apache.log4j.Logger;

public class PlugInServiceAdaptor
extends AbstractServiceAdapter
implements IServiceAdapter {
    private static Logger logger = Logger.getLogger(PlugInServiceAdaptor.class);
    public static final String PLUGIN_SERVICE = "PLUGIN_SERVICE";
    private static final int PLUGIN_PRIORITY = 200;

    public void execute(IServiceContext serviceContext) throws BOSException {
        if (serviceContext == null) {
            return;
        }
        LowTimer lowTimer = new LowTimer();
        float beginTime = lowTimer.msValue();
        float endTime = lowTimer.msValue();
        try {
            String prefix = null;
            prefix = serviceContext.getExecutionMode() == 0 ? "before" : "after";
            this.handleService(serviceContext, prefix);
        }
        catch (EASBizException e) {
            logger.error((Object)"PlugIn Execute Exceptoin:", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        if (logger.isDebugEnabled()) {
            endTime = lowTimer.msValue();
            logger.debug((Object)("PlugIn execute():  " + (endTime - beginTime)));
        }
    }

    private void handleService(IServiceContext serviceContext, String prefix) throws EASBizException, BOSException {
        Context ctx = serviceContext.getContext();
        BOSObjectType metaType = serviceContext.getMetaType();
        BOSObjectType boType = serviceContext.getBoType();
        IMetaDataPK operationPK = serviceContext.getOperationPK();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        MethodInfo method = null;
        String meta = null;
        if (MetaDataTypeList.ENTITY.equals((Object)metaType)) {
            EntityObjectInfo entity = loader.getEntity(boType);
            method = this.getMethod((BusinessObjectInfo)entity, operationPK);
            meta = entity.getFullName();
        } else if (MetaDataTypeList.FACADE.equals((Object)metaType)) {
            FacadeInfo facade = loader.getFacade(boType);
            method = this.getMethod((BusinessObjectInfo)facade, operationPK);
            meta = facade.getFullName();
        }
        if (meta == null || method == null) {
            return;
        }
        PlugInBeanProxy proxy = null;
        try {
            proxy = PlugInBeanFactory.getPlugIn(ctx, meta);
            if (proxy != null) {
                PlugInBeanParam param = new PlugInBeanParam();
                param.setContext(ctx);
                PlugInApplyMethod am = new PlugInApplyMethod();
                am.setName(method.getName());
                am.setParams(serviceContext.getOperationParameters());
                am.setReturnValue(serviceContext.getMethodReturnValue());
                param.setCurrentMethod(am);
                proxy.setPlugInParam(param);
                proxy.callMethod(param, prefix);
            }
        }
        catch (Exception e) {
            logger.error((Object)"PlugIn Execute Exceptoin:", (Throwable)e);
            throw new BOSException(e.getMessage(), e.getCause());
        }
        finally {
            if (proxy != null) {
                proxy.setPlugInParam(null);
            }
        }
    }

    private MethodInfo getMethod(BusinessObjectInfo bo, IMetaDataPK operationPK) {
        if (bo == null) {
            return null;
        }
        MethodCollection methods = bo.getAllMethods();
        for (int i = 0; i < methods.size(); ++i) {
            if (!methods.get(i).getInnerID().equalsIgnoreCase(operationPK.toString())) continue;
            return methods.get(i);
        }
        return null;
    }

    public String getName() {
        return PLUGIN_SERVICE;
    }

    public int getPriority() {
        return 200;
    }
}

