/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.DimissionReasonCollection;
import com.kingdee.eas.hr.base.DimissionReasonFactory;
import com.kingdee.eas.hr.base.EmpLaborRelationCollection;
import com.kingdee.eas.hr.base.EmpLaborRelationDomainFacadeFactory;
import com.kingdee.eas.hr.base.EmpLaborRelationFactory;
import com.kingdee.eas.hr.base.EmpLaborRelationInfo;
import com.kingdee.eas.hr.base.EnrollSourceCollection;
import com.kingdee.eas.hr.base.EnrollSourceFactory;
import com.kingdee.eas.hr.base.EnrollSourceInfo;
import com.kingdee.eas.hr.base.HRBizData;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.HRBizDefineTypeEnum;
import com.kingdee.eas.hr.base.VariationReasonCollection;
import com.kingdee.eas.hr.base.VariationReasonFactory;
import com.kingdee.eas.hr.base.VariationReasonInfo;
import com.kingdee.eas.hr.emp.PersonOtherInfoCollection;
import com.kingdee.eas.hr.emp.PersonOtherInfoFactory;
import com.kingdee.eas.hr.emp.PersonOtherInfoInfo;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.PersonPositionOptFacadeFactory;
import com.kingdee.eas.hr.emp.app.util.PersonBlackListUtil;
import java.util.Date;

public class BusinessPluginManager {
    HRBizData bizData;
    HRBizDefineInfo hrBizdefineInfo = null;
    Context ctx;
    EmpLaborRelationInfo empLaborRelationInfo;
    PersonPositionInfo ppInfo;
    PersonOtherInfoInfo personOtherInfo;
    Date optDate;
    String personId;
    SelectorItemCollection selectorItemsPP = new SelectorItemCollection();
    SelectorItemCollection selectorItemsEmpType = new SelectorItemCollection();
    SelectorItemCollection selectorItemsPerson = new SelectorItemCollection();
    SelectorItemCollection selectorItemsEmpPostRank = new SelectorItemCollection();

    public BusinessPluginManager(Context ctx, HRBizData bizData) throws BOSException {
        this.ctx = ctx;
        this.bizData = bizData;
        this.hrBizdefineInfo = bizData.getHrbizDefine();
        this.optDate = bizData.getStartDate();
        this.personId = bizData.getOldPosition().getPersonInfo().getId().toString();
    }

    public void runPlugins() throws BOSException, EASBizException {
        HRBizDefineTypeEnum type = this.hrBizdefineInfo.getBizDefineType();
        switch (type.getValue()) {
            case 1: {
                this.empLaborRelationInfo = this.getEmpLaborRelationInfo(this.ctx, this.bizData);
                if (this.bizData.getActionReason() == null) break;
                StringBuffer sb = new StringBuffer("select id, name ,number ");
                sb.append(" where number='").append(this.getVariReasonNumber(this.ctx, this.bizData.getActionReason())).append("'");
                EnrollSourceCollection col = new EnrollSourceCollection();
                col = EnrollSourceFactory.getLocalInstance(this.ctx).getEnrollSourceCollection(sb.toString());
                if (col.size() <= 0) break;
                this.empLaborRelationInfo.setEnrollSource(col.get(0));
                this.selectorItemsEmpType.add(new SelectorItemInfo("enrollSource"));
                break;
            }
            case 16: {
                this.empLaborRelationInfo = this.getEmpLaborRelationInfo(this.ctx, this.bizData);
                if (this.bizData.getActionReason() != null) {
                    StringBuffer sb = new StringBuffer("select id, name ,number ");
                    sb.append(" where number='").append(this.getVariReasonNumber(this.ctx, this.bizData.getActionReason())).append("'");
                    EnrollSourceCollection col = new EnrollSourceCollection();
                    col = EnrollSourceFactory.getLocalInstance(this.ctx).getEnrollSourceCollection(sb.toString());
                    if (col.size() > 0) {
                        this.empLaborRelationInfo.setEnrollSource(col.get(0));
                    } else {
                        this.empLaborRelationInfo.setEnrollSource(new EnrollSourceInfo());
                    }
                } else {
                    this.empLaborRelationInfo.setEnrollSource(new EnrollSourceInfo());
                }
                this.selectorItemsEmpType.add(new SelectorItemInfo("enrollSource"));
                break;
            }
            case 2: {
                this.empLaborRelationInfo = this.getEmpLaborRelationInfo(this.ctx, this.bizData);
                this.empLaborRelationInfo.setActualFormalDate(this.optDate);
                this.selectorItemsEmpType.add("actualFormalDate");
                break;
            }
            case 4: {
                this.ppInfo = this.getPersonPosition(this.ctx, this.bizData);
                if (this.bizData.getActionReason() != null) {
                    StringBuffer sb = new StringBuffer("select id, name ,number ");
                    sb.append(" where number='").append(this.getVariReasonNumber(this.ctx, this.bizData.getActionReason())).append("'");
                    DimissionReasonCollection col = new DimissionReasonCollection();
                    col = DimissionReasonFactory.getLocalInstance(this.ctx).getDimissionReasonCollection(sb.toString());
                    if (col.size() > 0) {
                        this.ppInfo.setDimissionReason(col.get(0));
                        this.selectorItemsPP.add(new SelectorItemInfo("dimissionReason"));
                    }
                }
                PersonBlackListUtil.addToBlackList((Context)this.ctx, (HRBizData)this.bizData);
                break;
            }
            case 6: {
                this.personOtherInfo = this.getPersonOtherInfo(this.ctx, this.bizData);
                if (this.bizData.isLeftConpanyDateFalg() && !this.bizData.isSameDatePersonChange()) {
                    this.personOtherInfo.setRetireDate(DateUtil.getBeforeDay((Date)this.optDate));
                } else {
                    this.personOtherInfo.setRetireDate(this.optDate);
                }
                this.selectorItemsPerson.add(new SelectorItemInfo("retireDate"));
                break;
            }
            case 7: {
                this.empLaborRelationInfo = this.getEmpLaborRelationInfo(this.ctx, this.bizData);
                this.empLaborRelationInfo.setReinviteDate(this.optDate);
                this.selectorItemsEmpType.add(new SelectorItemInfo("reinviteDate"));
                break;
            }
        }
        if ("KTL0IBpET46kKbTTM6T1vuZovtk=".equals(this.hrBizdefineInfo.getId().toString())) {
            this.empLaborRelationInfo = this.getEmpLaborRelationInfo(this.ctx, this.bizData);
            this.empLaborRelationInfo.setActualFormalDate(this.optDate);
            this.selectorItemsEmpType.add("actualFormalDate");
        }
        if (this.selectorItemsPP.size() > 0) {
            PersonPositionOptFacadeFactory.getLocalInstance((Context)this.ctx).updatePartialWithHis(this.ppInfo, this.selectorItemsPP);
        }
        if (this.selectorItemsEmpType.size() > 0) {
            EmpLaborRelationDomainFacadeFactory.getLocalInstance(this.ctx).updatePartialWithHis(this.empLaborRelationInfo, this.selectorItemsEmpType);
        }
        if (this.selectorItemsPerson.size() > 0) {
            PersonOtherInfoFactory.getLocalInstance((Context)this.ctx).updatePartial((CoreBaseInfo)this.personOtherInfo, this.selectorItemsPerson);
        }
    }

    private PersonOtherInfoInfo getPersonOtherInfo(Context ctx, HRBizData bizData) throws BOSException {
        this.personOtherInfo = new PersonOtherInfoInfo();
        if (bizData.getOldPosition().getPersonInfo() != null && bizData.getOldPosition().getPersonInfo().getId() != null) {
            StringBuffer oql = new StringBuffer("select id ,joinGroupDate,joinGroupDateCur, enterDate, retireDate,EFFDT,LEFFDT,person");
            oql.append(" where person ='").append(bizData.getOldPosition().getPersonInfo().getId().toString()).append("'");
            PersonOtherInfoCollection pOtherCollection = new PersonOtherInfoCollection();
            pOtherCollection = PersonOtherInfoFactory.getLocalInstance((Context)ctx).getPersonOtherInfoCollection(oql.toString());
            if (pOtherCollection.size() > 0) {
                this.personOtherInfo = pOtherCollection.get(0);
            }
        }
        return this.personOtherInfo;
    }

    private EmpLaborRelationInfo getEmpLaborRelationInfo(Context ctx, HRBizData bizData) throws BOSException {
        if (bizData.getOldPosition().getPersonInfo() != null && bizData.getOldPosition().getPersonInfo().getId() != null) {
            StringBuffer oql = new StringBuffer("select actualPlanFormalDate,EFFDT,person");
            oql.append(" where person ='").append(bizData.getOldPosition().getPersonInfo().getId().toString()).append("'");
            EmpLaborRelationCollection coll = EmpLaborRelationFactory.getLocalInstance(ctx).getEmpLaborRelationCollection(oql.toString());
            if (coll.size() > 0) {
                this.empLaborRelationInfo = coll.get(0);
            }
        }
        return this.empLaborRelationInfo;
    }

    private PersonPositionInfo getPersonPosition(Context ctx, HRBizData bizData) throws BOSException {
        PersonPositionInfo ppInfo = new PersonPositionInfo();
        if (bizData.getOldPosition().getPersonInfo() != null && bizData.getOldPosition().getPersonInfo().getId() != null) {
            StringBuffer oql = new StringBuffer("select id , enterDate,formalDate,leftDate,retireDate,EFFDT,LEFFDT,person");
            oql.append(" where person ='").append(bizData.getOldPosition().getPersonInfo().getId().toString()).append("'");
            PersonPositionCollection ppCol = new PersonPositionCollection();
            ppCol = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection(oql.toString());
            if (ppCol.size() > 0) {
                ppInfo = ppCol.get(0);
            }
        }
        return ppInfo;
    }

    private String getVariReasonNumber(Context ctx, VariationReasonInfo actionReason) throws BOSException {
        String reasonNum = "";
        StringBuffer sb = new StringBuffer("select id ,number ,name");
        sb.append(" where id='").append(actionReason.getId().toString()).append("'");
        VariationReasonCollection col = new VariationReasonCollection();
        col = VariationReasonFactory.getLocalInstance(ctx).getVariationReasonCollection(sb.toString());
        if (col.size() > 0) {
            reasonNum = col.get(0).getNumber();
        }
        return reasonNum;
    }
}

