/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.framework.ejb.HistoryUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.hr.base.AffairActionReasonInfo;
import com.kingdee.eas.hr.base.AffairActioniOperateException;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.HRBizData;
import com.kingdee.eas.hr.base.HRBizDefEmpTypeCollection;
import com.kingdee.eas.hr.base.HRBizDefOutEmpTypeCollection;
import com.kingdee.eas.hr.base.HRBizDefineCheckUtil;
import com.kingdee.eas.hr.base.HRBizDefineCollection;
import com.kingdee.eas.hr.base.HRBizDefineFactory;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.app.EmpPosOrgRelationQueryHelper;
import com.kingdee.eas.hr.base.app.util.HRBizDefineAppUtils;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;

public class HRBizDefineAffairUtils {
    public static void validateBizData(Context ctx, HRBizData bizData) throws EASBizException, BOSException {
        HRBizDefineInfo hrBizDefineInfo = HRBizDefineAppUtils.getHRBizDefineInfo(ctx, bizData.getHrbizDefine().getId().toString());
        PositionInfo oldPositionInfo = null;
        PositionInfo newPositionInfo = null;
        PersonInfo personInfo = null;
        if (bizData.getStartDate() == null) {
            throw new AffairActioniOperateException(AffairActioniOperateException.EFFECTDATEISNULL);
        }
        personInfo = bizData.getNewPosition().getPersonInfo();
        if (personInfo == null) {
            throw new AffairActioniOperateException(AffairActioniOperateException.PERSONNOTNULL);
        }
        EmpPosOrgRelationQueryHelper helper = new EmpPosOrgRelationQueryHelper();
        String personName = bizData.getNewPosition().getPersonInfo().getName();
        BOSUuid personID = bizData.getNewPosition().getPersonInfo().getId();
        if (StringUtils.isEmpty((String)personName) && personID != null) {
            personName = helper.getNameByID((IDataBase)PersonFactory.getLocalInstance((Context)ctx), personID.toString());
        }
        if (bizData.getActionType() == null) {
            throw new AffairActioniOperateException(AffairActioniOperateException.ACTIONREASONNOTNULL, new Object[]{personName});
        }
        if (HRBizDefineCheckUtil.needSourcePosition(hrBizDefineInfo)) {
            if (bizData.getOldPosition().getPositionInfo() == null) {
                throw new AffairActioniOperateException(AffairActioniOperateException.SOURCEPOSITIONNOTNULL, new Object[]{personName});
            }
            if (bizData.getOldPosition().getAdminInfo() == null) {
                throw new AffairActioniOperateException(AffairActioniOperateException.SOURCEADMINNOTNULL, new Object[]{personName});
            }
            oldPositionInfo = bizData.getOldPosition().getPositionInfo();
        }
        Connection cn = null;
        try {
            AdminOrgUnitInfo newAdminOrg;
            java.util.Date posEffdt;
            cn = EJBFactory.getConnection((Context)ctx);
            if (HRBizDefineCheckUtil.needTargetPosition(hrBizDefineInfo)) {
                EmpPosOrgRelationQueryHelper queryhelper;
                EmpPosOrgRelationCollection afterEmpPosOrgRelationColl;
                newPositionInfo = bizData.getNewPosition().getPositionInfo();
                AdminOrgUnitInfo newAdminOrgUnit = bizData.getNewPosition().getAdminInfo();
                if (newPositionInfo == null) {
                    throw new AffairActioniOperateException(AffairActioniOperateException.TARGETPOSITIONINFONOTNULL, new Object[]{personName});
                }
                PositionInfo positionInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(bizData.getNewPosition().getPositionInfo().getId()));
                if (!HistoryUtil.historyExists((Context)ctx, (BOSObjectType)newPositionInfo.getBOSType(), (String)newPositionInfo.getId().toString(), (java.util.Date)bizData.getStartDate())) {
                    java.util.Date posEffdt2 = HRBizDefineAffairUtils.getPositionMinEffdt(ctx, newPositionInfo);
                    throw new AffairActioniOperateException(AffairActioniOperateException.HISTORYPOSITIONNOTEXIST, new Object[]{HRBizDefineAffairUtils.getDateString(bizData.getStartDate()), positionInfo.getName(), HRBizDefineAffairUtils.getDateString(posEffdt2)});
                }
                if (newAdminOrgUnit == null) {
                    throw new AffairActioniOperateException(AffairActioniOperateException.TARGETADMINNOTNULL, new Object[]{personName});
                }
                AdminOrgUnitInfo adminOrgUnitInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(bizData.getNewPosition().getAdminInfo().getId()));
                if (!HistoryUtil.historyExists((Context)ctx, (BOSObjectType)newAdminOrgUnit.getBOSType(), (String)newAdminOrgUnit.getId().toString(), (java.util.Date)bizData.getStartDate())) {
                    java.util.Date posEffdt3 = HRBizDefineAffairUtils.getAdminOrgMinEffdt(ctx, adminOrgUnitInfo);
                    throw new AffairActioniOperateException(AffairActioniOperateException.EFFECTTOEARLY, new Object[]{HRBizDefineAffairUtils.getDateString(bizData.getStartDate()), adminOrgUnitInfo.getName(), HRBizDefineAffairUtils.getDateString(posEffdt3)});
                }
                if (bizData.getPersonInfo() != null && bizData.getPersonInfo().getId() != null && (afterEmpPosOrgRelationColl = (queryhelper = new EmpPosOrgRelationQueryHelper()).getAppointDateAfterPrimaryPosition(ctx, bizData.getPersonInfo().getId().toString(), bizData.getStartDate())).size() > 0 && !HRUtilExtend.isObjectEquelsByPkValue((CoreBaseInfo)bizData.getHrOrgUnitInfo(), (CoreBaseInfo)afterEmpPosOrgRelationColl.get(0).getHrOrgUnit())) {
                    throw new AffairActioniOperateException(AffairActioniOperateException.CANNOTSUPLI, new Object[]{personName});
                }
            }
            if (hrBizDefineInfo.getInEmpTypes().size() > 0) {
                if (bizData.getOldPosition().getEmployeeType() == null) {
                    throw new AffairActioniOperateException(AffairActioniOperateException.SOURCEEMPLOYEETYPENOTNULL, new Object[]{personName});
                }
                HRBizDefineAffairUtils.checkInEmployeeType(ctx, bizData, hrBizDefineInfo);
            }
            if (hrBizDefineInfo.getOutEmpTypes().size() > 0) {
                if (bizData.getNewPosition().getEmployeeType() == null) {
                    throw new AffairActioniOperateException(AffairActioniOperateException.TARGETEMPLOYEETYPENOTNULL, new Object[]{personName});
                }
                HRBizDefineAffairUtils.checkOutEmployeeType(ctx, bizData, hrBizDefineInfo);
            }
            if (personInfo.getId() != null && !HistoryUtil.historyExists((Context)ctx, (BOSObjectType)personInfo.getBOSType(), (String)personInfo.getId().toString(), (java.util.Date)bizData.getStartDate())) {
                throw new AffairActioniOperateException(AffairActioniOperateException.HISTORYPERSONNOTEXIST, new Object[]{HRBizDefineAffairUtils.getDateString(bizData.getStartDate()), personName});
            }
            if (oldPositionInfo != null && !HistoryUtil.historyExists((Context)ctx, (BOSObjectType)oldPositionInfo.getBOSType(), (String)oldPositionInfo.getId().toString(), (java.util.Date)bizData.getStartDate())) {
                posEffdt = HRBizDefineAffairUtils.getPositionMinEffdt(ctx, oldPositionInfo);
                throw new AffairActioniOperateException(AffairActioniOperateException.HISTORYPOSITIONNOTEXIST, new Object[]{HRBizDefineAffairUtils.getDateString(bizData.getStartDate()), helper.getNameByID((IDataBase)PositionFactory.getLocalInstance((Context)ctx), oldPositionInfo.getId().toString()), HRBizDefineAffairUtils.getDateString(posEffdt)});
            }
            if (newPositionInfo != null && !HistoryUtil.historyExists((Context)ctx, (BOSObjectType)newPositionInfo.getBOSType(), (String)newPositionInfo.getId().toString(), (java.util.Date)bizData.getStartDate())) {
                posEffdt = HRBizDefineAffairUtils.getPositionMinEffdt(ctx, newPositionInfo);
                throw new AffairActioniOperateException(AffairActioniOperateException.HISTORYPOSITIONNOTEXIST, new Object[]{HRBizDefineAffairUtils.getDateString(bizData.getStartDate()), helper.getNameByID((IDataBase)PositionFactory.getLocalInstance((Context)ctx), newPositionInfo.getId().toString()), HRBizDefineAffairUtils.getDateString(posEffdt)});
            }
            if (bizData.getNewPosition() != null && bizData.getNewPosition().getAdminInfo() != null && !HistoryUtil.historyExists((Context)ctx, (BOSObjectType)(newAdminOrg = bizData.getNewPosition().getAdminInfo()).getBOSType(), (String)newAdminOrg.getId().toString(), (java.util.Date)bizData.getStartDate())) {
                throw new AffairActioniOperateException(AffairActioniOperateException.HISTORYADMINORGNOTEXIST, new Object[]{HRBizDefineAffairUtils.getDateString(bizData.getStartDate()), helper.getNameByID((IDataBase)AdminOrgUnitFactory.getLocalInstance((Context)ctx), newAdminOrg.getId().toString())});
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        if (HRBizDefineCheckUtil.needProcessOldPosition(hrBizDefineInfo) && personID != null) {
            EmpPosOrgRelationCollection empCollection;
            String postionID = null;
            if (bizData.getOldPosition().getPositionInfo() != null) {
                postionID = bizData.getOldPosition().getPositionInfo().getId().toString();
            }
            if ((empCollection = helper.getAppointDateUnInActivePosition(ctx, personID.toString(), bizData.getStartDate(), bizData.getOldPosition().getAdminInfo().getId().toString(), postionID)) == null || empCollection.size() == 0) {
                String positionName = "";
                if (bizData.getOldPosition().getPositionInfo() != null && bizData.getOldPosition().getPositionInfo().getId() != null) {
                    positionName = helper.getNameByID((IDataBase)PositionFactory.getLocalInstance((Context)ctx), bizData.getOldPosition().getPositionInfo().getId().toString());
                }
                throw new AffairActioniOperateException(AffairActioniOperateException.EFFECTDATEHASNOTPOSITION, new Object[]{personName, HRBizDefineAffairUtils.getDateString(bizData.getStartDate()), helper.getNameByID((IDataBase)AdminOrgUnitFactory.getLocalInstance((Context)ctx), bizData.getOldPosition().getAdminInfo().getId().toString()) + "-" + positionName});
            }
        }
    }

    private static void checkInEmployeeType(Context ctx, HRBizData bizData, HRBizDefineInfo hrBizDefineInfo) throws BOSException, EASBizException, AffairActioniOperateException {
        HRBizDefEmpTypeCollection inEmpTypeColl = hrBizDefineInfo.getInEmpTypes();
        boolean isMatch = false;
        for (int i = 0; i < inEmpTypeColl.size(); ++i) {
            if (!inEmpTypeColl.get(i).getEmpType().equals((Object)bizData.getOldPosition().getEmployeeType())) continue;
            isMatch = true;
            break;
        }
        if (!isMatch) {
            String employeeTypeName = bizData.getOldPosition().getEmployeeType().getName();
            if (employeeTypeName == null) {
                employeeTypeName = EmployeeTypeFactory.getLocalInstance((Context)ctx).getEmployeeTypeInfo("select name where id = '" + bizData.getOldPosition().getEmployeeType().getId() + "'").getName();
            }
            throw new AffairActioniOperateException(AffairActioniOperateException.SOURCE_EMPLOYEETYPE_NOT_MATCH, new Object[]{employeeTypeName});
        }
    }

    private static void checkOutEmployeeType(Context ctx, HRBizData bizData, HRBizDefineInfo hrBizDefineInfo) throws BOSException, EASBizException, AffairActioniOperateException {
        HRBizDefOutEmpTypeCollection outEmpTypeColl = hrBizDefineInfo.getOutEmpTypes();
        boolean isMatch = false;
        for (int i = 0; i < outEmpTypeColl.size(); ++i) {
            if (!outEmpTypeColl.get(i).getEmpType().equals((Object)bizData.getNewPosition().getEmployeeType())) continue;
            isMatch = true;
            break;
        }
        if (!isMatch) {
            String employeeTypeName = bizData.getNewPosition().getEmployeeType().getName();
            if (employeeTypeName == null) {
                employeeTypeName = EmployeeTypeFactory.getLocalInstance((Context)ctx).getEmployeeTypeInfo("select name where id = '" + bizData.getNewPosition().getEmployeeType().getId() + "'").getName();
            }
            throw new AffairActioniOperateException(AffairActioniOperateException.TARGET_EMPLOYEETYPE_NOT_MATCH, new Object[]{hrBizDefineInfo.getName(), employeeTypeName});
        }
    }

    public static String getDateString(java.util.Date date) {
        return DateTimeUtils.format((java.util.Date)date, (String)"yyyy-MM-dd");
    }

    public static HRBizDefineInfo getHRBizDefineInfoByEmpTypeAndActionReason(Context ctx, String empTypeId, AffairActionReasonInfo affairActionReasonInfo) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String filterEmployeeType = "select FBizDefineID from T_HR_HRBizDefOutEmpType where FEmpTypeID='" + empTypeId + "'";
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)filterEmployeeType, CompareType.INNER));
        String filterActionReason = "select FHrBizDefineID from T_HR_HRBizDefChangeReason where FActionReasonID='" + affairActionReasonInfo.getId() + "'";
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)filterActionReason, CompareType.INNER));
        viewInfo.setFilter(filter);
        viewInfo.setSelector(HRBizDefineAppUtils.getBizDefineSelector());
        SorterItemCollection coll = new SorterItemCollection();
        SorterItemInfo sorter = new SorterItemInfo("number");
        coll.add(sorter);
        viewInfo.setSorter(coll);
        HRBizDefineCollection bizDefineColl = HRBizDefineFactory.getLocalInstance(ctx).getHRBizDefineCollection(viewInfo);
        HRBizDefineInfo hRBizDefineInfo = null;
        if (bizDefineColl.size() > 0) {
            hRBizDefineInfo = bizDefineColl.get(0);
        }
        return hRBizDefineInfo;
    }

    private static boolean isAdminOrgChangeInOneDay(String hrBizDefineId, String curBizDefineId) {
        return "8r0AAAADbujmaL7Z".equals(curBizDefineId) && "cM5s6yPmTba5BXMKa6+h8uZovtk=".equals(hrBizDefineId) || "8r0AAAADbujmaL7Z".equals(hrBizDefineId) && "cM5s6yPmTba5BXMKa6+h8uZovtk=".equals(curBizDefineId);
    }

    public static java.util.Date getPositionMinEffdt(Context ctx, PositionInfo oldPositionInfo) throws BOSException, SQLException {
        String sql = "select min(feffdt) from t_org_positionhis where fHistoryRelateId='" + oldPositionInfo.getId().toString() + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        Date effdt = null;
        if (rs.next()) {
            effdt = rs.getDate(1);
        }
        return effdt;
    }

    public static java.util.Date getAdminOrgMinEffdt(Context ctx, AdminOrgUnitInfo adminOrgUnitInfo) throws BOSException, SQLException {
        String sql = "select min(feffdt) from T_ORG_AdminHIS where fHistoryRelateId='" + adminOrgUnitInfo.getId().toString() + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        Date effdt = null;
        if (rs.next()) {
            effdt = rs.getDate(1);
        }
        return effdt;
    }
}

