/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.timezone;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.param.NantionalServiceFacadeFactory;
import com.kingdee.eas.base.param.NationalPlanFactory;
import com.kingdee.eas.base.param.NationalPlanInfo;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.TimeZoneInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.HRTimeZoneBizException;
import com.kingdee.eas.hr.base.HRTimeZoneCollection;
import com.kingdee.eas.hr.base.HRTimeZoneInfo;
import com.kingdee.eas.hr.base.TimeZoneChangeEventCollection;
import com.kingdee.eas.hr.base.TimeZoneChangeEventFactory;
import com.kingdee.eas.hr.base.TimeZoneChangeEventInfo;
import com.kingdee.eas.hr.base.timezone.Constants;
import com.kingdee.eas.hr.base.timezone.DataFetchModel;
import com.kingdee.eas.hr.base.timezone.Date;
import com.kingdee.eas.hr.base.timezone.TimeZoneDataFetcher;
import com.kingdee.eas.hr.base.timezone.TimeZoneEventEnum;
import com.kingdee.eas.hr.base.timezone.TimeZoneUpdater;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class TimeZoneUtil {
    public static boolean isDigit(Object expression) {
        if (expression instanceof Integer) {
            return true;
        }
        return Constants.PATTERN_DIGIT.matcher(String.valueOf(expression).trim()).matches();
    }

    public static TimeZoneInfo getUserTimeZone(Context ctx) throws EASBizException, BOSException {
        return TimeZoneUtil.getUserTimeZone(ctx, null, null, null);
    }

    public static TimeZoneInfo getUserTimeZone(Context ctx, String userid) throws EASBizException, BOSException {
        return TimeZoneUtil.getUserTimeZone(ctx, userid, null, null);
    }

    public static TimeZoneInfo getUserTimeZone(Context ctx, String userid, String planfororg, String languagename) throws EASBizException, BOSException {
        if (StringUtils.isBlank((String)userid)) {
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            userid = userInfo == null ? "" : userInfo.getString("id");
        }
        HashMap configMap = NantionalServiceFacadeFactory.getLocalInstance((Context)ctx).getNationalConfig(userid, null, null);
        return (TimeZoneInfo)configMap.get("timezoneInfo");
    }

    public static TimeZoneInfo getSysTimeZone(Context ctx) throws EASBizException, BOSException {
        NationalPlanInfo sysPlanInfo = NationalPlanFactory.getLocalInstance((Context)ctx).getSysDefaultPlan();
        return sysPlanInfo.getTimeZoneID();
    }

    public static TimeZoneInfo getTimeZone(Context ctx, Object person) throws EASBizException {
        HRTimeZoneInfo result = TimeZoneUtil.getHrTimeZone(ctx, person);
        return result == null ? null : result.getTimeZone();
    }

    public static TimeZoneInfo getTimeZoneByNum(Context ctx, Object person) throws EASBizException {
        HRTimeZoneInfo result = TimeZoneUtil.getHrTimeZoneByNum(ctx, person);
        return result == null ? null : result.getTimeZone();
    }

    public static TimeZoneInfo getHrTimeZoneByUser(Context ctx, Object user, Object beginTime, Object endTime, boolean userTimeZoneOnNull) throws EASBizException {
        if (user == null) {
            return null;
        }
        PersonInfo person = null;
        if (user instanceof UserInfo) {
            person = ((UserInfo)user).getPerson();
        } else {
            try {
                UserCollection users = UserFactory.getLocalInstance((Context)ctx).getUserCollection("select person.id where id='" + user + "'");
                if (user != null && users.size() > 0) {
                    person = users.get(0).getPerson();
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        if (person == null) {
            return null;
        }
        Map<String, TimeZoneInfo> timeZoneMap = TimeZoneUtil.getLatestTimeZoneMap(ctx, person, beginTime, endTime, userTimeZoneOnNull);
        return timeZoneMap.isEmpty() ? null : timeZoneMap.values().iterator().next();
    }

    public static Map<String, TimeZoneInfo> getLatestTimeZoneMap(Context ctx, Object persons, Object beginTime, Object endTime, boolean userTimeZoneOnNull) throws EASBizException {
        Map HRTimeZoneMap = TimeZoneUtil.getTimeZoneFetcher(ctx, persons, beginTime, endTime).setGetUserTimeZoneOnNull(userTimeZoneOnNull).fetchMapData();
        HashMap<String, TimeZoneInfo> returnData = new HashMap<String, TimeZoneInfo>(HRTimeZoneMap.size());
        for (Map.Entry entry : HRTimeZoneMap.entrySet()) {
            List timeZoneList = entry.getValue();
            if (timeZoneList == null || timeZoneList.size() <= 0) continue;
            returnData.put(entry.getKey(), ((HRTimeZoneInfo)timeZoneList.get(0)).getTimeZone());
        }
        return returnData;
    }

    public static HRTimeZoneInfo getHrTimeZone(Context ctx, Object person) throws EASBizException {
        return (HRTimeZoneInfo)TimeZoneUtil.getTimeZoneFetcher(ctx, person, null, null).fetchOne();
    }

    public static HRTimeZoneInfo getHrTimeZoneByNum(Context ctx, Object person) throws EASBizException {
        return (HRTimeZoneInfo)TimeZoneUtil.getTimeZoneFetcher(ctx, person, null, null).setDataFetchModel(DataFetchModel.NUMBER).fetchOne();
    }

    public static HRTimeZoneCollection getHrTimeZone(Context ctx, Object persons, Object beginTime, Object endTime) throws EASBizException {
        return (HRTimeZoneCollection)TimeZoneUtil.getTimeZoneFetcher(ctx, persons, beginTime, endTime).fetchCollection();
    }

    public static HRTimeZoneCollection getHrTimeZoneByNum(Context ctx, Object persons, Object beginTime, Object endTime) throws EASBizException {
        return (HRTimeZoneCollection)TimeZoneUtil.getTimeZoneFetcher(ctx, persons, beginTime, endTime).setDataFetchModel(DataFetchModel.NUMBER).fetchCollection();
    }

    public static Map<String, List<HRTimeZoneInfo>> getHrTimeZoneMap(Context ctx, Object persons, Object beginTime, Object endTime) throws EASBizException {
        return TimeZoneUtil.getTimeZoneFetcher(ctx, persons, beginTime, endTime).fetchMapData();
    }

    public static Map<String, List<HRTimeZoneInfo>> getHrTimeZoneMapByNum(Context ctx, Object persons, Object beginTime, Object endTime) throws EASBizException {
        return TimeZoneUtil.getTimeZoneFetcher(ctx, persons, beginTime, endTime).setDataFetchModel(DataFetchModel.NUMBER).fetchMapData();
    }

    public static TimeZoneDataFetcher getTimeZoneFetcher(Context ctx, Object persons, Object beginTime, Object endTime) {
        TimeZoneDataFetcher fetcher = new TimeZoneDataFetcher();
        fetcher.setCtx(ctx).addFilterObj(persons).setBeginTime(beginTime).setEndTime(endTime);
        return fetcher;
    }

    public static void updateTimeZone(Context ctx, HRTimeZoneInfo timeZoneInfo) throws EASBizException {
        new TimeZoneUpdater().addToUpdate(timeZoneInfo).setCtx(ctx).update();
    }

    public static void updateTimeZone(Context ctx, Object person, TimeZoneInfo timeZoneInfo, Object event, Object effdt, Object leffdt) throws EASBizException {
        new TimeZoneUpdater().addToUpdate(person, timeZoneInfo, TimeZoneUtil.getTimeZoneChangeEvent(ctx, event), effdt, leffdt).setCtx(ctx).update();
    }

    public static void updateTimeZoneBatch(Context ctx, Object persons, TimeZoneInfo timeZoneInfo, Object event, Object effdt, Object leffdt) throws EASBizException {
        new TimeZoneUpdater().setTimeZoneInfo(timeZoneInfo).setChangeEvent(TimeZoneUtil.getTimeZoneChangeEvent(ctx, event)).addPersons(persons).setCtx(ctx).setBeginTime(Date.getTime(effdt)).setEndTime(Date.getTime(leffdt)).update();
    }

    public static void updateTimeZone(Context ctx, HRTimeZoneCollection collection) throws EASBizException {
        if (collection == null || collection.size() == 0) {
            return;
        }
        TimeZoneUpdater timeZoneUpdater = new TimeZoneUpdater();
        int total = collection.size();
        for (int i = 0; i < total; ++i) {
            timeZoneUpdater.addToUpdate(collection.get(i));
        }
        timeZoneUpdater.update();
    }

    public static TimeZoneChangeEventInfo getTimeZoneChangeEvent(Context ctx, Object event) throws HRTimeZoneBizException {
        if (event instanceof TimeZoneChangeEventInfo || event == null) {
            return (TimeZoneChangeEventInfo)event;
        }
        if (event instanceof TimeZoneEventEnum) {
            event = ((TimeZoneEventEnum)((Object)event)).getEventId();
        }
        String oql = new StringBuffer("where ").append("id='").append(event).append("'").toString();
        try {
            TimeZoneChangeEventCollection coll = TimeZoneChangeEventFactory.getLocalInstance(ctx).getTimeZoneChangeEventCollection(oql);
            if (coll.size() > 0) {
                return coll.get(0);
            }
        }
        catch (BOSException e) {
            throw new HRTimeZoneBizException(HRTimeZoneBizException.EVENT_FETCH_ERROR);
        }
        throw new HRTimeZoneBizException(HRTimeZoneBizException.INVALID_EVENT);
    }
}

