/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.util.DataAuditAdapter;
import com.kingdee.eas.hr.compensation.CmpSchemeCollection;
import com.kingdee.eas.hr.compensation.CmpSchemeFactory;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class CmpSchemeAudit
extends DataAuditAdapter {
    @Override
    public boolean doAudit(Context ctx) throws BOSException, EASBizException {
        CmpSchemeCollection c = CmpSchemeFactory.getLocalInstance((Context)ctx).getCmpSchemeCollection("select id, horTableName, hisTableName, hrOrgUnit.id WHERE FENABLE = 1");
        int size = c.size();
        for (int i = 0; i < size; ++i) {
            if (this.checkCmpScheme(ctx, c.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean checkCmpScheme(Context ctx, CmpSchemeInfo info) throws BOSException, EASBizException {
        String id = info.getId().toString();
        String curTableName = info.getHorTableName();
        String hisTableName = info.getHisTableName();
        StringBuffer sql = null;
        if (hisTableName != null) {
            sql = new StringBuffer();
            sql.append("SELECT FPERSONID FROM ");
            sql.append(hisTableName);
            sql.append(" GROUP BY FPERSONID, FPERIOD  HAVING COUNT(*) > 1 ");
            if (DbUtil.executeQuery((Context)ctx, (String)sql.toString()).size() > 0) {
                return false;
            }
        }
        sql = new StringBuffer();
        sql.append("SELECT FPERSONID FROM ");
        sql.append(curTableName);
        sql.append(" GROUP BY FPERSONID  HAVING COUNT(*) > 1 ");
        if (DbUtil.executeQuery((Context)ctx, (String)sql.toString()).size() > 0) {
            return false;
        }
        sql = new StringBuffer();
        sql.append("SELECT FPERSONID  FROM T_HR_CMPSCHEMEPERSON WHERE FCMPSCHEMEID = ? GROUP BY FPERSONID HAVING COUNT(*) > 1");
        if (DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id}).size() > 0) {
            return false;
        }
        sql = new StringBuffer();
        sql.append("SELECT A.FPERSONID , B.FPERSONID  \n");
        sql.append("FROM (SELECT FPERSONID FROM T_HR_CMPSCHEMEPERSON WHERE FCMPSCHEMEID = ?) A");
        sql.append("FULL JOIN ");
        sql.append(curTableName);
        sql.append(" B ON A.FPERSONID = B.FPERSONID \n");
        sql.append(" WHERE A.FPERSONID IS NULL OR B.FPERSONID IS NULL \n");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id}).size() <= 0;
    }

    public static void deleteTableDupData(Context ctx, String tableName) throws BOSException, EASBizException {
        if (tableName == null) {
            return;
        }
    }

    public static void deleteCmpPersonDupData(Context ctx, String cmpSchemeId) throws BOSException, EASBizException {
    }

    public static void deleteDupData(Context ctx, CmpSchemeInfo info) throws BOSException, EASBizException {
        CmpSchemeAudit.deleteTableDupData(ctx, info.getHorTableName());
        CmpSchemeAudit.deleteTableDupData(ctx, info.getHisTableName());
    }

    public static IRowSet getDataRows(Context ctx, CmpSchemeInfo info) throws BOSException, EASBizException, SQLException {
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)("SHOW COLUMNS FROM " + info.getHorTableName().toUpperCase()));
        ArrayList<String> colList = new ArrayList<String>();
        while (rows.next()) {
            colList.add(rows.getString("COLUMN_NAME"));
        }
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT * FROM ( \n");
        sb.append(CmpSchemeAudit.getSelectSqlByList(ctx, colList, info.getHorTableName()));
        sb.append("UNION ");
        sb.append(" \n ");
        sb.append(CmpSchemeAudit.getSelectSqlByList(ctx, colList, info.getHisTableName()));
        sb.append(" \n ");
        sb.append("ORDER BY E.FBEGINDATE, P.FNUMBER");
        return DbUtil.executeQuery((Context)ctx, (String)sb.toString());
    }

    private static String getSelectSqlByList(Context ctx, ArrayList list, String tableName) {
        String localLanguage = ctx.getLocale().getLanguage();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        sb.append(" P.FNUMBER AS PERSONNUMBER, P.FNAME_" + localLanguage + " AS PERSONNAME, E.FBEGINDATE, E.FNAME_" + localLanguage + " AS PERIOD,  \n");
        sb.append("\tA.FLONGNUMBER AS ADMINLONGNUMBER ,A.FNAME_" + localLanguage + " AS ADMINNAME, S.FNAME_" + localLanguage + " AS POSITIONNAME  \n");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            sb.append(", \n ");
            sb.append(list.get(i).toString());
        }
        sb.append("FROM ");
        sb.append("(SELECT T.*   \n");
        sb.append("\tFROM ");
        sb.append(tableName);
        sb.append(" T  \n");
        sb.append(" \tINNER JOIN (\tSELECT FPERSONID, FPERIOD  \n");
        sb.append(" \t\t\tFROM ");
        sb.append(tableName);
        sb.append("  \n");
        sb.append(" \t\t\tGROUP BY FPERSONID, FPERIOD  \n");
        sb.append(" \t\t\tHAVING COUNT(*) > 1) DUP ON DUP.FPERSONID = T.FPERSONID AND DUP.FPERIOD = T.FPERIOD) T \n");
        sb.append("INNER JOIN T_BD_PERSON P ON P.FID = T.FPERSONID  \n");
        sb.append("INNER JOIN T_HR_CMPPERIOD E ON E.FID = T.FPERIOD  \n");
        sb.append("LEFT OUTER JOIN T_ORG_ADMIN A ON A.FID = T.FADMINORGUNITID  \n");
        sb.append("LEFT OUTER JOIN T_ORG_POSITION S ON S.FID = T.FPOSITIONID  \n");
        return sb.toString();
    }
}

