/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.sql.util.Base64;
import com.kingdee.eas.base.attachment.IObsConfig;
import com.kingdee.eas.base.attachment.ObsConfigCollection;
import com.kingdee.eas.base.attachment.ObsConfigFactory;
import com.kingdee.eas.base.attachment.ObsConfigInfo;
import com.kingdee.eas.base.attachment.obs.BucketObjectOperation;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.emp.PersonPhotoCollection;
import com.kingdee.eas.hr.emp.PersonPhotoFactory;
import com.kingdee.eas.hr.emp.PersonPhotoInfo;

public class File2ObsUtils {
    private static String ATTACHMENTSTORAGE = "ATTACHMENTSTORAGE";
    private static String ATTACHMENT_TYPE_VALUE = "3";
    private static String FOLDER_NAME = "personPhoto/";
    private static String PERSON_PHOTO_TYPE = ".jpg";

    public static boolean isUseOBS(Context ctx) throws EASBizException, BOSException {
        String isUseObs = ParamManager.getParamValueIgnoreGroupControl((Context)ctx, (String)ATTACHMENTSTORAGE, null, (boolean)true);
        return null != isUseObs && ATTACHMENT_TYPE_VALUE.equals(isUseObs);
    }

    public static void uploadPersonPhoto2OBS(Context ctx, String personId, byte[] imageData) throws EASBizException, BOSException {
        if (null == imageData || imageData.length == 0) {
            throw new BOSException("personPhoto is null");
        }
        File2ObsUtils.upload2OBS(ctx, personId, imageData);
    }

    public static String getPersonPhotoFromOSB(Context ctx, String personId) throws BOSException, EASBizException {
        String imageData;
        block2: {
            imageData = null;
            BucketObjectOperation bucket = File2ObsUtils.getObsConfigInfo(ctx);
            String fileName = null;
            try {
                fileName = FOLDER_NAME + personId + PERSON_PHOTO_TYPE;
                imageData = Base64.encodeBytes((byte[])bucket.getFileInputStream(fileName));
            }
            catch (Exception e) {
                PersonPhotoCollection personPhotoList = PersonPhotoFactory.getLocalInstance((Context)ctx).getPersonPhotoCollection("select * where person.id = '" + personId + "'");
                if (null == personPhotoList || personPhotoList.size() <= 0) break block2;
                PersonPhotoInfo personPhoto = personPhotoList.get(0);
                byte[] image = personPhoto.getImageData();
                File2ObsUtils.upload2OBS(ctx, personId, image);
                imageData = Base64.encodeBytes((byte[])image);
                return imageData;
            }
        }
        return imageData;
    }

    public static void deletePersonPhoto(Context ctx, String personId) throws EASBizException, BOSException {
        BucketObjectOperation bucket = File2ObsUtils.getObsConfigInfo(ctx);
        String fileName = FOLDER_NAME + personId + PERSON_PHOTO_TYPE;
        try {
            bucket.deleteObject(fileName);
        }
        catch (Exception e) {
            System.out.println("\u5220\u9664\u5934\u50cf\u51fa\u9519\u4e86\uff1a" + e.toString());
            throw new BOSException((Throwable)e);
        }
    }

    private static void upload2OBS(Context ctx, String personId, byte[] imageData) throws BOSException {
        BucketObjectOperation bucket = File2ObsUtils.getObsConfigInfo(ctx);
        try {
            bucket.createFolder(FOLDER_NAME);
            String fileName = FOLDER_NAME + personId + PERSON_PHOTO_TYPE;
            bucket.deleteObject(fileName);
            bucket.uploadFileByByte(imageData, fileName);
        }
        catch (Exception e) {
            System.out.println("\u4e0a\u4f20\u516c\u6709\u4e91\u5b58\u50a8\u6876\u62a5\u9519\u4e86\uff1a" + e.toString());
            throw new BOSException((Throwable)e);
        }
    }

    private static BucketObjectOperation getObsConfigInfo(Context ctx) throws BOSException {
        IObsConfig iObsConfig = ObsConfigFactory.getLocalInstance((Context)ctx);
        ObsConfigCollection obsConfigInfo = iObsConfig.getObsConfigCollection();
        if (null == obsConfigInfo || 0 == obsConfigInfo.size()) {
            System.out.println("\u6ca1\u6709\u914d\u7f6e\u516c\u6709\u4e91\u5b58\u50a8\u6876,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            throw new BOSException("ObsConfig is Error");
        }
        ObsConfigInfo obsInfo = obsConfigInfo.get(0);
        BucketObjectOperation bucket = new BucketObjectOperation(obsInfo.getEndpoint(), obsInfo.getAccessKeyId(), obsInfo.getAccessKeySecret(), obsInfo.getObsBucketName());
        return bucket;
    }
}

